class Protobuf::Service {
  has $.name;
  has @.endpoints;
}
class Protobuf::Definition {
  has @.services;
  has @.messages;
}
class Protobuf::Endpoint {
  has $.name;
  has $.request is rw;
  has $.response is rw;
}
class Protobuf::Message {
  has $.name;
  has @.fields;
}
class Protobuf::Field {
  has $.name;
  has $.type;
  has Bool $.repeated = False;
}

class Protobuf::Actions {

  method TOP($/) {
    my @things := $<proto>.made.List;
    my @services = @things.grep( * ~~ Protobuf::Service );
    my @messages = @things.grep( * ~~ Protobuf::Message );
    for @services -> $s {
      for $s.endpoints -> $e {
        $e.request = %*messages{ $e.request.name };
        $e.response = %*messages{ $e.response.name };
      }
    }
    $/.make: Protobuf::Definition.new: :@services, :@messages;
  }

  method proto($/) {
    $/.make: $<topLevelDef>.map( *.made ).grep( *.defined )
  }

  method topLevelDef($/) {
    $/.make: $<service>.made // $<message>.made
  }

  method message($/) {
    my $name = ~$<messageName>;
    my @fields = $<messageBody>.made;
    my $msg =  Protobuf::Message.new( :$name, :@fields );
    %*messages{ $name } = $msg;
    $/.make: $msg;
  }

  method messageBody($/) {
    $/.make: $<field>.map: *.made;
  }

  method field($/) {
    my $type = ~$<type>;
    my $repeated = $<repeated>.chars > 0;
    $/.make: Protobuf::Field.new( name => ~$<fieldName>, type => %*messages{ $type } // $type, :$repeated );
  }

  method service($/) {
    $/.make: Protobuf::Service.new: name => ~$<serviceName>, endpoints => ($<rpc>.map(*.made).grep(*.defined))
  }

  method rpc($/) {
    $/.make: Protobuf::Endpoint.new(name => ~$<rpcName>, request => $<request>.?made, response => $<response>.?made )
  }

  method messageType($/) {
    $/.make: Protobuf::Message.new: name => ~$<messageName>
  }
}
