/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public abstract class JPConverter
implements Serializable {
    private static HashMap<Class, JPConverter> map = new HashMap();

    public static JPConverter allocate(Class javaClass, Configuration config) {
        JPConverter c = map.get(javaClass);
        if (c != null) {
            return c;
        }
        if (javaClass.getName().equals("javax.xml.namespace.QName")) {
            return FromQName.INSTANCE;
        }
        if (NodeInfo.class.isAssignableFrom(javaClass)) {
            return new FromValueRepresentation(AnyNodeTest.getInstance(), 24576);
        }
        if (Source.class.isAssignableFrom(javaClass) && !DOMSource.class.isAssignableFrom(javaClass)) {
            return FromSource.INSTANCE;
        }
        for (Map.Entry<Class, JPConverter> e : map.entrySet()) {
            if (!e.getKey().isAssignableFrom(javaClass)) continue;
            return e.getValue();
        }
        List<ExternalObjectModel> externalObjectModels = config.getExternalObjectModels();
        for (int m = 0; m < externalObjectModels.size(); ++m) {
            ExternalObjectModel model = externalObjectModels.get(m);
            JPConverter converter = model.getJPConverter(javaClass);
            if (converter == null) continue;
            return converter;
        }
        if (javaClass.isArray()) {
            Class<?> itemClass = javaClass.getComponentType();
            return new FromObjectArray(JPConverter.allocate(itemClass, config));
        }
        return new WrapExternalObject(new ExternalObjectType(javaClass, config));
    }

    public abstract ValueRepresentation convert(Object var1, XPathContext var2) throws XPathException;

    public abstract ItemType getItemType();

    public int getCardinality() {
        return 16384;
    }

    static {
        map.put(SequenceIterator.class, new FromSequenceIterator());
        map.put(ValueRepresentation.class, FromValueRepresentation.INSTANCE);
        map.put(String.class, FromString.INSTANCE);
        map.put(Boolean.class, FromBoolean.INSTANCE);
        map.put(Boolean.TYPE, FromBoolean.INSTANCE);
        map.put(Double.class, FromDouble.INSTANCE);
        map.put(Double.TYPE, FromDouble.INSTANCE);
        map.put(Float.class, FromFloat.INSTANCE);
        map.put(Float.TYPE, FromFloat.INSTANCE);
        map.put(BigDecimal.class, FromBigDecimal.INSTANCE);
        map.put(BigInteger.class, FromBigInteger.INSTANCE);
        map.put(Long.class, FromLong.INSTANCE);
        map.put(Long.TYPE, FromLong.INSTANCE);
        map.put(Integer.class, FromInt.INSTANCE);
        map.put(Integer.TYPE, FromInt.INSTANCE);
        map.put(Short.class, FromShort.INSTANCE);
        map.put(Short.TYPE, FromShort.INSTANCE);
        map.put(Byte.class, FromByte.INSTANCE);
        map.put(Byte.TYPE, FromByte.INSTANCE);
        map.put(Character.class, FromCharacter.INSTANCE);
        map.put(Character.TYPE, FromCharacter.INSTANCE);
        map.put(URI.class, FromURI.INSTANCE);
        map.put(URL.class, FromURI.INSTANCE);
        map.put(Date.class, FromDate.INSTANCE);
        map.put(long[].class, FromLongArray.INSTANCE);
        map.put(int[].class, FromIntArray.INSTANCE);
        map.put(short[].class, FromShortArray.INSTANCE);
        map.put(byte[].class, FromByteArray.INSTANCE);
        map.put(char[].class, FromCharArray.INSTANCE);
        map.put(double[].class, FromDoubleArray.INSTANCE);
        map.put(float[].class, FromFloatArray.INSTANCE);
        map.put(boolean[].class, FromBooleanArray.INSTANCE);
        map.put(Collection.class, FromCollection.INSTANCE);
    }

    public static class FromObjectArray
    extends JPConverter {
        private JPConverter itemConverter;

        public FromObjectArray(JPConverter itemConverter) {
            this.itemConverter = itemConverter;
        }

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Object[] arrayObject = (Object[])object;
            Item[] newArray = new Item[arrayObject.length];
            int a = 0;
            for (int i = 0; i < arrayObject.length; ++i) {
                try {
                    Item newItem = Value.asItem(this.itemConverter.convert(arrayObject[i], context));
                    if (newItem == null) continue;
                    newArray[a++] = newItem;
                    continue;
                }
                catch (XPathException e) {
                    throw new XPathException("Returned array contains an object that cannot be converted to an Item (" + arrayObject[i].getClass() + "): " + e.getMessage(), "SXJE0051");
                }
            }
            return new SequenceExtent(newArray, 0, a);
        }

        public ItemType getItemType() {
            return this.itemConverter.getItemType();
        }

        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromBooleanArray
    extends JPConverter {
        public static final FromBooleanArray INSTANCE = new FromBooleanArray();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((boolean[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = BooleanValue.get(((boolean[])object)[i]);
            }
            return new SequenceExtent(array);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.BOOLEAN;
        }

        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromFloatArray
    extends JPConverter {
        public static final FromFloatArray INSTANCE = new FromFloatArray();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((float[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = new DoubleValue(((float[])object)[i]);
            }
            return new SequenceExtent(array);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.FLOAT;
        }

        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromDoubleArray
    extends JPConverter {
        public static final FromDoubleArray INSTANCE = new FromDoubleArray();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((double[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = new DoubleValue(((double[])object)[i]);
            }
            return new SequenceExtent(array);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.DOUBLE;
        }

        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromCharArray
    extends JPConverter {
        public static final FromCharArray INSTANCE = new FromCharArray();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return StringValue.makeStringValue(new String((char[])object));
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.STRING;
        }
    }

    public static class FromByteArray
    extends JPConverter {
        public static final FromByteArray INSTANCE = new FromByteArray();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((byte[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Int64Value.makeDerived(0xFF & ((byte[])object)[i], BuiltInAtomicType.BYTE);
            }
            return new SequenceExtent(array);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.BYTE;
        }

        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromShortArray
    extends JPConverter {
        public static final FromShortArray INSTANCE = new FromShortArray();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((short[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Int64Value.makeDerived(((short[])object)[i], BuiltInAtomicType.SHORT);
            }
            return new SequenceExtent(array);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.SHORT;
        }

        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromIntArray
    extends JPConverter {
        public static final FromIntArray INSTANCE = new FromIntArray();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((int[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Int64Value.makeDerived(((int[])object)[i], BuiltInAtomicType.INT);
            }
            return new SequenceExtent(array);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.INT;
        }

        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromLongArray
    extends JPConverter {
        public static final FromLongArray INSTANCE = new FromLongArray();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((long[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Int64Value.makeDerived(((long[])object)[i], BuiltInAtomicType.LONG);
            }
            return new SequenceExtent(array);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.LONG;
        }

        public int getCardinality() {
            return 57344;
        }
    }

    public static class FromSource
    extends JPConverter {
        public static final FromSource INSTANCE = new FromSource();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            ParseOptions options = new ParseOptions();
            Controller controller = context.getController();
            if (controller != null) {
                options.setSchemaValidationMode(controller.getSchemaValidationMode());
            }
            return context.getConfiguration().buildDocument((Source)object, options);
        }

        public ItemType getItemType() {
            return AnyNodeTest.getInstance();
        }
    }

    public static class FromCollection
    extends JPConverter {
        public static final FromCollection INSTANCE = new FromCollection();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            Item[] array = new Item[((Collection)object).size()];
            int a = 0;
            for (Object obj : (Collection)object) {
                JPConverter itemConverter = FromCollection.allocate(obj.getClass(), context.getConfiguration());
                try {
                    Item item = Value.asItem(itemConverter.convert(obj, context));
                    if (item == null) continue;
                    array[a++] = item;
                }
                catch (XPathException e) {
                    throw new XPathException("Returned Collection contains an object that cannot be converted to an Item (" + obj.getClass() + "): " + e.getMessage(), "SXJE0051");
                }
            }
            return new SequenceExtent(array, 0, a);
        }

        public ItemType getItemType() {
            return AnyItemType.getInstance();
        }

        public int getCardinality() {
            return 57344;
        }
    }

    public static class WrapExternalObject
    extends JPConverter {
        public static final WrapExternalObject INSTANCE = new WrapExternalObject(BuiltInAtomicType.ANY_ATOMIC);
        private ItemType resultType;

        public WrapExternalObject(ItemType resultType) {
            this.resultType = resultType;
        }

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new ObjectValue(object);
        }

        public ItemType getItemType() {
            return this.resultType;
        }
    }

    public static class FromDate
    extends JPConverter {
        public static final FromDate INSTANCE = new FromDate();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return DateTimeValue.fromJavaDate((Date)object);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.DATE_TIME;
        }
    }

    public static class FromURI
    extends JPConverter {
        public static final FromURI INSTANCE = new FromURI();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new AnyURIValue(object.toString());
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.ANY_URI;
        }
    }

    public static class FromQName
    extends JPConverter {
        public static final FromQName INSTANCE = new FromQName();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            QName qn = (QName)object;
            return new QNameValue(qn.getPrefix(), qn.getNamespaceURI(), qn.getLocalPart());
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.QNAME;
        }
    }

    public static class FromCharacter
    extends JPConverter {
        public static final FromCharacter INSTANCE = new FromCharacter();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new StringValue(object.toString());
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.STRING;
        }
    }

    public static class FromByte
    extends JPConverter {
        public static final FromByte INSTANCE = new FromByte();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new Int64Value(((Byte)object).intValue());
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FromShort
    extends JPConverter {
        public static final FromShort INSTANCE = new FromShort();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new Int64Value(((Short)object).intValue());
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FromInt
    extends JPConverter {
        public static final FromInt INSTANCE = new FromInt();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new Int64Value(((Integer)object).intValue());
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FromLong
    extends JPConverter {
        public static final FromLong INSTANCE = new FromLong();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new Int64Value((Long)object);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FromBigInteger
    extends JPConverter {
        public static final FromBigInteger INSTANCE = new FromBigInteger();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return IntegerValue.makeIntegerValue((BigInteger)object);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.INTEGER;
        }
    }

    public static class FromBigDecimal
    extends JPConverter {
        public static final FromBigDecimal INSTANCE = new FromBigDecimal();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new DecimalValue((BigDecimal)object);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.DECIMAL;
        }
    }

    public static class FromFloat
    extends JPConverter {
        public static final FromFloat INSTANCE = new FromFloat();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new FloatValue(((Float)object).floatValue());
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.FLOAT;
        }
    }

    public static class FromDouble
    extends JPConverter {
        public static final FromDouble INSTANCE = new FromDouble();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new DoubleValue((Double)object);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.DOUBLE;
        }
    }

    public static class FromBoolean
    extends JPConverter {
        public static final FromBoolean INSTANCE = new FromBoolean();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return BooleanValue.get((Boolean)object);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.BOOLEAN;
        }
    }

    public static class FromString
    extends JPConverter {
        public static final FromString INSTANCE = new FromString();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return new StringValue((String)object);
        }

        public ItemType getItemType() {
            return BuiltInAtomicType.STRING;
        }
    }

    public static class FromValueRepresentation
    extends JPConverter {
        public static final FromValueRepresentation INSTANCE = new FromValueRepresentation(AnyItemType.getInstance(), 57344);
        private ItemType resultType;
        private int cardinality;

        public FromValueRepresentation(ItemType resultType, int cardinality) {
            this.resultType = resultType;
            this.cardinality = cardinality;
        }

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return object instanceof Closure ? Value.asValue(SequenceExtent.makeSequenceExtent(((Closure)object).iterate())) : (Value)object;
        }

        public ItemType getItemType() {
            return this.resultType;
        }

        public int getCardinality() {
            return this.cardinality;
        }
    }

    public static class FromSequenceIterator
    extends JPConverter {
        public static final FromSequenceIterator INSTANCE = new FromSequenceIterator();

        public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
            return SequenceExtent.makeSequenceExtent((SequenceIterator)object);
        }

        public ItemType getItemType() {
            return AnyItemType.getInstance();
        }

        public int getCardinality() {
            return 57344;
        }
    }
}

