#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::DetailLevelCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DetailLevelCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::DetailLevelCodeType

=head1 DESCRIPTION

Specifies standard subsets of data to return for each result
within the set of results in the response payload. If no
detail level is specified, a base set of data is returned.
The base set of data varies per call.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 ReturnAll

(in) Returns all available data.
With GetSellerList and other calls that retrieve large data sets,
please avoid using ReturnAll when possible. For example, if you use
GetSellerList, use a GranularityLevel or use the
GetSellerEvents call instead. If you use ReturnAll with GetSellerList,
use a small EntriesPerPage value and a short
EndTimeFrom/EndTimeTo range for better performance.



=cut


use constant ReturnAll => scalar('ReturnAll');


=head2 ItemReturnDescription

(in) Returns Description, plus the
ListingDesigner node and some additional information if applicable



=cut


use constant ItemReturnDescription => scalar('ItemReturnDescription');


=head2 ItemReturnAttributes

(in) For GetItem, returns Item Specifics and
Pre-filled Item Information, if any.
For GetSearchResults, only returns Item Specifics (if any) that
are applicable to search results, and only under certain conditions.
See the description of Item.AttributeSetArray for details about
the effects for applicable calls. Also see the description of
Item.ProductListingDetails for GetItem.



=cut


use constant ItemReturnAttributes => scalar('ItemReturnAttributes');


=head2 ItemReturnCategories

(in) For the GetSearchResults call, returns the primary category and, if applicable, the secondary category



=cut


use constant ItemReturnCategories => scalar('ItemReturnCategories');


=head2 ReturnSummary

(in) Returns the summary data.
For GetMyMessages, this detail level returns the same data
whether or not you include MessageIDs or AlertIDs in the
request. Returns up to 10 FolderID and FolderName values.
Currently, this detail level is the only way to retrieve
FolderID and FolderName values. See "GetMyMessages" in the
eBay Web Services Guide for a code sample that demonstrates
this.



=cut


use constant ReturnSummary => scalar('ReturnSummary');


=head2 ReturnHeaders

(in) Returns message headers.
For GetMyMessages, if you include MessageIDs or AlertIDs in
the request, this detail level returns header information,
without body text, for the specified message ID or alert ID
values. If you include a FolderID, header information is
returned only for the messages and alerts in the specified
folder.
If you do not include MessageIDs or AlertIDs, this detail
level returns header information for:
- All alerts in priority order with the highest priority
alerts first
- All messages in ascending order by date received with the
oldest messages first.
Note that even when restricted by this detail level to
return only header information, GetMyMessages may return a
high volume of data.



=cut


use constant ReturnHeaders => scalar('ReturnHeaders');


=head2 ReturnMessages

(in) Returns full message information.
For GetMyMessages, if you include MessageIDs or AlertIDs in
the request, this detail level returns message information
for the specified message ID or alert ID values. If you
include a FolderID, message information is returned only for
the messages and alerts in the specified folder.



=cut


use constant ReturnMessages => scalar('ReturnMessages');







1;   
