# Generated by default/object.tt
package Paws::AccessAnalyzer::SqsQueueConfiguration;
  use Moose;
  has QueuePolicy => (is => 'ro', isa => 'Str', request_name => 'queuePolicy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::SqsQueueConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::SqsQueueConfiguration object:

  $service_obj->Method(Att1 => { QueuePolicy => $value, ..., QueuePolicy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::SqsQueueConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->QueuePolicy

=head1 DESCRIPTION

The proposed access control configuration for an SQS queue. You can
propose a configuration for a new SQS queue or an existing SQS queue
that you own by specifying the SQS policy. If the configuration is for
an existing SQS queue and you do not specify the SQS policy, the access
preview uses the existing SQS policy for the queue. If the access
preview is for a new resource and you do not specify the policy, the
access preview assumes an SQS queue without a policy. To propose
deletion of an existing SQS queue policy, you can specify an empty
string for the SQS policy. For more information about SQS policy
limits, see Quotas related to policies
(https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-policies.html).

=head1 ATTRIBUTES


=head2 QueuePolicy => Str

The proposed resource policy for the SQS queue.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

