# Generated by default/object.tt
package Paws::SESv2::ContactList;
  use Moose;
  has ContactListName => (is => 'ro', isa => 'Str');
  has LastUpdatedTimestamp => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SESv2::ContactList

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SESv2::ContactList object:

  $service_obj->Method(Att1 => { ContactListName => $value, ..., LastUpdatedTimestamp => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SESv2::ContactList object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactListName

=head1 DESCRIPTION

A list that contains contacts that have subscribed to a particular
topic or topics.

=head1 ATTRIBUTES


=head2 ContactListName => Str

The name of the contact list.


=head2 LastUpdatedTimestamp => Str

A timestamp noting the last time the contact list was updated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SESv2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

