# Generated by default/object.tt
package Paws::CodePipeline::ActionTypeUrls;
  use Moose;
  has ConfigurationUrl => (is => 'ro', isa => 'Str', request_name => 'configurationUrl', traits => ['NameInRequest']);
  has EntityUrlTemplate => (is => 'ro', isa => 'Str', request_name => 'entityUrlTemplate', traits => ['NameInRequest']);
  has ExecutionUrlTemplate => (is => 'ro', isa => 'Str', request_name => 'executionUrlTemplate', traits => ['NameInRequest']);
  has RevisionUrlTemplate => (is => 'ro', isa => 'Str', request_name => 'revisionUrlTemplate', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodePipeline::ActionTypeUrls

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodePipeline::ActionTypeUrls object:

  $service_obj->Method(Att1 => { ConfigurationUrl => $value, ..., RevisionUrlTemplate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodePipeline::ActionTypeUrls object:

  $result = $service_obj->Method(...);
  $result->Att1->ConfigurationUrl

=head1 DESCRIPTION

Returns information about URLs for web pages that display to customers
as links on the pipeline view, such as an external configuration page
for the action type.

=head1 ATTRIBUTES


=head2 ConfigurationUrl => Str

The URL returned to the CodePipeline console that contains a link to
the page where customers can configure the external action.


=head2 EntityUrlTemplate => Str

The URL returned to the CodePipeline console that provides a deep link
to the resources of the external system, such as a status page. This
link is provided as part of the action display in the pipeline.


=head2 ExecutionUrlTemplate => Str

The link to an execution page for the action type in progress. For
example, for a CodeDeploy action, this link is shown on the pipeline
view page in the CodePipeline console, and it links to a CodeDeploy
status page.


=head2 RevisionUrlTemplate => Str

The URL returned to the CodePipeline console that contains a link to
the page where customers can update or change the configuration of the
external action.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodePipeline>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

