# This file was autogenerated.

=head1 NAME

hydrogen-curry-scalar.t - unit tests for Hydrogen::Curry::Scalar

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

=cut

use 5.008001;
use strict;
use warnings;
use Test2::V0 -target => "Hydrogen::Curry::Scalar";

isa_ok( 'Hydrogen::Curry::Scalar', 'Exporter::Tiny' );

my %EXPORTS = map +( $_ => 1 ), @Hydrogen::Curry::Scalar::EXPORT_OK;

subtest 'curry_make_getter' => sub {
    ok exists(&Hydrogen::Curry::Scalar::curry_make_getter), 'function exists';
    ok $EXPORTS{'curry_make_getter'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Scalar::curry_make_getter( undef );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_make_getter';
};

subtest 'curry_make_setter' => sub {
    ok exists(&Hydrogen::Curry::Scalar::curry_make_setter), 'function exists';
    ok $EXPORTS{'curry_make_setter'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Scalar::curry_make_setter( undef );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_make_setter';
};

done_testing; # :)
