/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;

public class ChromeDriverInfo
implements WebDriverInfo {
    @Override
    public String getDisplayName() {
        return "Chrome";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", "chrome");
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return "chrome".equals(capabilities.getBrowserName()) || capabilities.getCapability("chromeOptions") != null || capabilities.getCapability("goog:chromeOptions") != null;
    }

    @Override
    public boolean isAvailable() {
        try {
            ChromeDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return Runtime.getRuntime().availableProcessors() + 1;
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        ChromeDriver driver = new ChromeDriver(capabilities);
        return Optional.of(driver);
    }
}

