/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class OkHttpClient
implements HttpClient {
    private final okhttp3.OkHttpClient client;
    private final URL baseUrl;

    public OkHttpClient(okhttp3.OkHttpClient client, URL url) {
        this.client = client;
        this.baseUrl = url;
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws IOException {
        Request.Builder builder = new Request.Builder();
        String rawUrl = request.getUri().startsWith("http:") || request.getUri().startsWith("https:") ? request.getUri() : this.baseUrl.toExternalForm().replaceAll("/$", "") + request.getUri();
        HttpUrl parsed = HttpUrl.parse(rawUrl);
        if (parsed == null) {
            throw new IOException("Unable to parse URL: " + this.baseUrl.toString() + request.getUri());
        }
        HttpUrl.Builder url = parsed.newBuilder();
        for (String name2 : request.getQueryParameterNames()) {
            for (String value : request.getQueryParameters(name2)) {
                url.addQueryParameter(name2, value);
            }
        }
        builder.url(url.build());
        for (String name2 : request.getHeaderNames()) {
            for (String value : request.getHeaders(name2)) {
                builder.addHeader(name2, value);
            }
        }
        if (request.getHeader("User-Agent") == null) {
            builder.addHeader("User-Agent", USER_AGENT);
        }
        switch (request.getMethod()) {
            case GET: {
                builder.get();
                break;
            }
            case POST: {
                String rawType = Optional.ofNullable(request.getHeader("Content-Type")).orElse("application/json; charset=utf-8");
                MediaType type = MediaType.parse(rawType);
                RequestBody body = RequestBody.create(type, request.getContent());
                builder.post(body);
                break;
            }
            case DELETE: {
                builder.delete();
            }
        }
        Response response = this.client.newCall(builder.build()).execute();
        HttpResponse toReturn = new HttpResponse();
        toReturn.setContent(response.body().bytes());
        toReturn.setStatus(response.code());
        response.headers().names().forEach(name -> response.headers((String)name).forEach(value -> toReturn.addHeader((String)name, (String)value)));
        return toReturn;
    }

    public static class Factory
    implements HttpClient.Factory {
        private final ConnectionPool pool = new ConnectionPool();

        @Override
        public HttpClient.Builder builder() {
            return new HttpClient.Builder(){

                @Override
                public HttpClient createClient(URL url) {
                    OkHttpClient.Builder client = new OkHttpClient.Builder().connectionPool(pool).followRedirects(true).followSslRedirects(true).proxy(this.proxy).readTimeout(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS).connectTimeout(this.connectionTimeout.toMillis(), TimeUnit.MILLISECONDS);
                    String info = url.getUserInfo();
                    if (!Strings.isNullOrEmpty(info)) {
                        String[] parts = info.split(":", 2);
                        String user = parts[0];
                        String pass = parts.length > 1 ? parts[1] : null;
                        String credentials = Credentials.basic(user, pass);
                        client.authenticator((route, response) -> {
                            if (response.request().header("Authorization") != null) {
                                return null;
                            }
                            return response.request().newBuilder().header("Authorization", credentials).build();
                        });
                    }
                    client.addNetworkInterceptor(chain -> {
                        Request request = chain.request();
                        Response response = chain.proceed(request);
                        return response.code() == 408 ? response.newBuilder().code(500).message("Server-Side Timeout").build() : response;
                    });
                    return new OkHttpClient(client.build(), url);
                }
            };
        }

        @Override
        public void cleanupIdleClients() {
            this.pool.evictAll();
        }
    }
}

