/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.27
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif


/***********************************************************************
 * swigrun.swg
 *
 *     This file contains generic CAPI SWIG runtime support for pointer
 *     type checking.
 *
 ************************************************************************/

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;


/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (int)(*f1 - *f2);
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}

/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}


/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu = 0;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/*
 * $Header: /cvsroot/swig/SWIG/Lib/tcl/swigtcl8.swg,v 1.28 2005/06/17 23:15:51 marcelomatus Exp $
 * 
 * swigtcl8.swg
 */

#include <tcl.h>
#include <errno.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Constant table */

#define SWIG_TCL_INT     1
#define SWIG_TCL_FLOAT   2
#define SWIG_TCL_STRING  3
#define SWIG_TCL_POINTER 4
#define SWIG_TCL_BINARY  5

/* Flags for pointer conversion */
#define SWIG_POINTER_EXCEPTION     0x1
#define SWIG_POINTER_DISOWN        0x2

/* Swig fail macro */

#define SWIG_fail   goto fail

/* Constant information structure */
typedef struct swig_const_info {
    int type;
    char *name;
    long lvalue;
    double dvalue;
    void   *pvalue;
    swig_type_info **ptype;
} swig_const_info;

typedef int   (*swig_wrapper)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
typedef int   (*swig_wrapper_func)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
typedef char *(*swig_variable_func)(ClientData, Tcl_Interp *, char *, char *, int);
typedef void  (*swig_delete_func)(ClientData);

typedef struct swig_method {
  const char     *name;
  swig_wrapper   method;
} swig_method;

typedef struct swig_attribute {
  const char     *name;
  swig_wrapper   getmethod;
  swig_wrapper   setmethod;
} swig_attribute;

typedef struct swig_class {
  const char         *name;
  swig_type_info   **type;
  swig_wrapper       constructor;
  void              (*destructor)(void *);
  swig_method        *methods;
  swig_attribute     *attributes;
  struct swig_class **bases;
  char              **base_names;
  swig_module_info   *module;
} swig_class;

typedef struct swig_instance {
  Tcl_Obj       *thisptr;
  void          *thisvalue;
  swig_class   *classptr;
  int            destroy;
  Tcl_Command    cmdtok;
} swig_instance;

#define SWIG_NewPointerObj(ptr, type, flags) \
  SWIG_Tcl_NewPointerObj(ptr, type, flags)
#define SWIG_ConvertPtr(oc, ptr, ty, flags) \
  SWIG_Tcl_ConvertPtr(interp, oc, ptr, ty, flags)
#define SWIG_ConvertPtrFromString(c, ptr, ty, flags) \
  SWIG_Tcl_ConvertPtrFromString(interp, c, ptr, ty, flags)
#define SWIG_ConvertPacked(obj, ptr, sz, ty, flags) \
  SWIG_Tcl_ConvertPacked(interp, obj, ptr, sz, ty, flags)
#define SWIG_MakePtr(c, ptr, ty, flags) \
  SWIG_Tcl_MakePtr(c, ptr, ty, flags)
#define SWIG_NewPackedObj(ptr, sz, type, flags) \
  SWIG_Tcl_NewPackedObj(ptr, sz, type, flags)
#define SWIG_GetArgs SWIG_Tcl_GetArgs
#define SWIG_PointerTypeFromString(c) \
  SWIG_Tcl_PointerTypeFromString(c)
#define SWIG_Acquire(ptr) \
  SWIG_Tcl_Acquire(ptr)
#define SWIG_Disown(ptr) \
  SWIG_Tcl_Disown(ptr)
#define SWIG_Thisown(ptr) \
  SWIG_Tcl_Thisown(ptr)
#define SWIG_InstallConstants(interp, constants) \
  SWIG_Tcl_InstallConstants(interp, constants)
#define SWIG_GetConstant(key) \
  SWIG_Tcl_GetConstant(key)
#define SWIG_NewInstanceObj(thisvalue, type, flags) \
  SWIG_Tcl_NewInstanceObj(interp, thisvalue, type, flags)
#define SWIG_ObjectConstructor SWIG_Tcl_ObjectConstructor
#define SWIG_MethodCommand SWIG_Tcl_MethodCommand
#define SWIG_ObjectDelete SWIG_Tcl_ObjectDelete

/* Runtime API */
#define SWIG_GetModule(clientdata) SWIG_Tcl_GetModule((Tcl_Interp *) (clientdata))
#define SWIG_SetModule(clientdata, pointer) SWIG_Tcl_SetModule((Tcl_Interp *) (clientdata), pointer)
#define SWIG_MODULE_CLIENTDATA_TYPE Tcl_Interp *

/* Object support */
static Tcl_HashTable  swigobjectTable;
static int            swigobjectTableinit = 0;

/* Acquire ownership of a pointer */
static void
SWIG_Tcl_Acquire(void *ptr) {
  Tcl_HashEntry *entryPtr;
  int newobj;
  if (!swigobjectTableinit) {
    Tcl_InitHashTable(&swigobjectTable, TCL_ONE_WORD_KEYS);
    swigobjectTableinit = 1;
  }
  entryPtr = Tcl_CreateHashEntry(&swigobjectTable, (char *) ptr, &newobj);
}

/* Disown a pointer.  Returns 1 if we owned it to begin with */
static int
SWIG_Tcl_Disown(void *ptr) {
  Tcl_HashEntry *entryPtr;
  if (!swigobjectTableinit) return 0;
  entryPtr = Tcl_FindHashEntry(&swigobjectTable, (char *) ptr);
  if (entryPtr) {
    Tcl_DeleteHashEntry(entryPtr);
    return 1;
  }
  return 0;
}

static int
SWIG_Tcl_Thisown(void *ptr) {
  if (!swigobjectTableinit) return 0;
  if (Tcl_FindHashEntry(&swigobjectTable, (char *) ptr)) {
    return 1;
  }
  return 0;
}

/* Convert a pointer value */
static int
SWIG_Tcl_ConvertPtrFromString(Tcl_Interp *interp, const char *c, void **ptr, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  /* Pointer values must start with leading underscore */
  while (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) return TCL_OK;
    /* Hmmm. It could be an object name. */
    if (Tcl_VarEval(interp,c," cget -this", (char *) NULL) == TCL_OK) {
      Tcl_Obj *result = Tcl_GetObjResult(interp);
      c = Tcl_GetStringFromObj(result, NULL);
      continue;
    }
    Tcl_ResetResult(interp);
    if (flags & SWIG_POINTER_EXCEPTION) 
      Tcl_SetResult(interp, (char *) "Type error. Expected a pointer", TCL_STATIC);
    return TCL_ERROR;
  }
  c++;
  c = SWIG_UnpackData(c,ptr,sizeof(void *));
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if ((!tc) && (flags & SWIG_POINTER_EXCEPTION)) {
      Tcl_SetResult(interp, (char *) "Type error. Expected ", TCL_STATIC);
      Tcl_AppendElement(interp, (char *) ty->name);
      return TCL_ERROR;
    } else if (!tc) {
      Tcl_ResetResult(interp);
      return TCL_ERROR;
    }
    if (flags & SWIG_POINTER_DISOWN) {
      SWIG_Disown((void *) *ptr);
    }
    *ptr = SWIG_TypeCast(tc,(void *) *ptr);
  }
  return TCL_OK;
}

/* Convert a pointer value */
static SWIGINLINE int
SWIG_Tcl_ConvertPtr(Tcl_Interp *interp, Tcl_Obj *oc, void **ptr, swig_type_info *ty, int flags) {
  return SWIG_Tcl_ConvertPtrFromString(interp, Tcl_GetStringFromObj(oc,NULL), ptr, ty, flags);
}

/* Convert a pointer value */
static char *
SWIG_Tcl_PointerTypeFromString(char *c) {
  char d;
  /* Pointer values must start with leading underscore. NULL has no type */
  if (*c != '_') {
    return 0;
  }
  c++;
  /* Extract hex value from pointer */
  while ((d = *c)) {
    if (!(((d >= '0') && (d <= '9')) || ((d >= 'a') && (d <= 'f')))) break;
    c++;
  }
  return c;
}

/* Convert a packed value value */
static int
SWIG_Tcl_ConvertPacked(Tcl_Interp *interp, Tcl_Obj *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_cast_info *tc;
  const char  *c;

  if (!obj) goto type_error;
  c = Tcl_GetStringFromObj(obj,NULL);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) goto type_error;
  }
  return TCL_OK;

type_error:

  if (flags) {
    if (ty) {
      Tcl_SetResult(interp, (char *) "Type error. Expected ", TCL_STATIC);
      Tcl_AppendElement(interp, (char *) ty->name);
      return TCL_ERROR;
    } else {
      Tcl_SetResult(interp, (char *) "Expected packed data.", TCL_STATIC);
      return TCL_ERROR;
    }
  }
  return TCL_ERROR;
}


/* Take a pointer and convert it to a string */
static void
SWIG_Tcl_MakePtr(char *c, void *ptr, swig_type_info *ty, int flags) {
  if (ptr) {
    *(c++) = '_';
    c = SWIG_PackData(c,&ptr,sizeof(void *));
    strcpy(c,ty->name);
  } else {
    strcpy(c,(char *)"NULL");
  }
  flags = 0;
}

/* Create a new pointer object */
static SWIGINLINE Tcl_Obj *
SWIG_Tcl_NewPointerObj(void *ptr, swig_type_info *type, int flags) {
  Tcl_Obj *robj;
  char result[512];
  SWIG_MakePtr(result,ptr,type,flags);
  robj = Tcl_NewStringObj(result,-1);
  return robj;
}

static Tcl_Obj *
SWIG_Tcl_NewPackedObj(void *ptr, int sz, swig_type_info *type, int flags) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  flags = 0;
  return Tcl_NewStringObj(result,-1);
}

static Tcl_HashTable   swigconstTable;
static int             swigconstTableinit = 0;

/* Install Constants */
static void
SWIG_Tcl_InstallConstants(Tcl_Interp *interp, swig_const_info constants[]) {
  int i;
  Tcl_Obj *obj;
  Tcl_HashEntry *entryPtr;
  int            newobj;

  if (!swigconstTableinit) {
    Tcl_InitHashTable(&swigconstTable, TCL_STRING_KEYS);
    swigconstTableinit = 1;
  }
  for (i = 0; constants[i].type; i++) {
    switch(constants[i].type) {
    case SWIG_TCL_INT:
      obj = Tcl_NewIntObj(constants[i].lvalue);
      break;
    case SWIG_TCL_FLOAT:
      obj = Tcl_NewDoubleObj(constants[i].dvalue);
      break;
    case SWIG_TCL_STRING:
      obj = Tcl_NewStringObj((char *) constants[i].pvalue,-1);
      break;
    case SWIG_TCL_POINTER:
      obj = SWIG_NewPointerObj(constants[i].pvalue, *(constants[i]).ptype,0);
      break;
    case SWIG_TCL_BINARY:
      obj = SWIG_NewPackedObj(constants[i].pvalue, constants[i].lvalue, *(constants[i].ptype),0);
      break;
    default:
      obj = 0;
      break;
    }
    if (obj) {
      Tcl_ObjSetVar2(interp,Tcl_NewStringObj(constants[i].name,-1), NULL, obj, TCL_GLOBAL_ONLY);
      entryPtr = Tcl_CreateHashEntry(&swigconstTable, constants[i].name, &newobj);
      Tcl_SetHashValue(entryPtr, (ClientData) obj);
    }
  }
}

static Tcl_Obj *
SWIG_Tcl_GetConstant(const char *key) {
  Tcl_HashEntry *entryPtr;
  if (!swigconstTableinit) return 0;
  entryPtr = Tcl_FindHashEntry(&swigconstTable, key);
  if (entryPtr) {
    return (Tcl_Obj *) Tcl_GetHashValue(entryPtr);
  }
  return 0;
}

/* Get arguments */
static int
SWIG_Tcl_GetArgs(Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[], const char *fmt, ...) {
  int        argno = 0, opt = 0;
  long       tempi;
  double     tempd;
  const char *c;
  va_list    ap;
  void      *vptr;
  Tcl_Obj   *obj = 0;
  swig_type_info *ty;

  va_start(ap,fmt);
  for (c = fmt; (*c && (*c != ':') && (*c != ';')); c++,argno++) {
    if (*c == '|') {
      opt = 1;
      c++;
    }
    if (argno >= (objc-1)) {
      if (!opt) {
        Tcl_SetResult(interp, (char *) "Wrong # args. ", TCL_STATIC);
        goto argerror;
      } else {
        va_end(ap);
        return TCL_OK;
      }
    }

    vptr = va_arg(ap,void *);
    if (vptr) {
      if (isupper(*c)) {
        obj = SWIG_GetConstant(Tcl_GetStringFromObj(objv[argno+1],0));
        if (!obj) obj = objv[argno+1];
      } else {
        obj = objv[argno+1];
      }
      switch(*c) {
      case 'i': case 'I':
      case 'l': case 'L':
      case 'h': case 'H':
      case 'b': case 'B':
        if (Tcl_GetLongFromObj(interp,obj,&tempi) != TCL_OK) goto argerror;
        if ((*c == 'i') || (*c == 'I')) *((int *)vptr) = (int)tempi;
        else if ((*c == 'l') || (*c == 'L')) *((long *)vptr) = (long)tempi;
        else if ((*c == 'h') || (*c == 'H')) *((short*)vptr) = (short)tempi;
        else if ((*c == 'b') || (*c == 'B')) *((unsigned char *)vptr) = (unsigned char)tempi;
        break;
      case 'f': case 'F':
      case 'd': case 'D':
        if (Tcl_GetDoubleFromObj(interp,obj,&tempd) != TCL_OK) goto argerror;
        if ((*c == 'f') || (*c == 'F')) *((float *) vptr) = (float)tempd;
        else if ((*c == 'd') || (*c == 'D')) *((double*) vptr) = tempd;
        break;
      case 's': case 'S':
        if (*(c+1) == '#') {
          int *vlptr = (int *) va_arg(ap, void *);
          *((char **) vptr) = Tcl_GetStringFromObj(obj, vlptr);
          c++;
        } else {
          *((char **)vptr) = Tcl_GetStringFromObj(obj,NULL);
        }
        break;
      case 'c': case 'C':
        *((char *)vptr) = *(Tcl_GetStringFromObj(obj,NULL));
        break;
      case 'p': case 'P':
        ty = (swig_type_info *) va_arg(ap, void *);
        if (SWIG_Tcl_ConvertPtr(interp, obj, (void **) vptr, ty, SWIG_POINTER_EXCEPTION) == TCL_ERROR) goto argerror;
        break;
      case 'o': case 'O':
        *((Tcl_Obj **)vptr) = objv[argno+1];
        break;
      default:
        break;
      }
    }
  }

  if ((*c != ';') && ((objc-1) > argno)) {
    Tcl_SetResult(interp, (char *) "Wrong # args.", TCL_STATIC);
    goto argerror;
  }
  va_end(ap);
  return TCL_OK;

 argerror:
  {
    char temp[32];
    sprintf(temp,"%d", argno+1);
    c = strchr(fmt,':');
    if (!c) c = strchr(fmt,';');
    if (!c) c = (char *)"";
    Tcl_AppendResult(interp,c," argument ", temp, NULL);
    va_end(ap);
    return TCL_ERROR;
  }
}

static void
SWIG_Tcl_ObjectDelete(ClientData clientData) {
  swig_instance *si = (swig_instance *) clientData;
  if ((si) && (si->destroy) && (SWIG_Disown(si->thisvalue))) {
    if (si->classptr->destructor) {
      (si->classptr->destructor)(si->thisvalue);
    }
  }
  Tcl_DecrRefCount(si->thisptr);
  free(si);
}

/* Function to invoke object methods given an instance */
static int
SWIG_Tcl_MethodCommand(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST _objv[]) {
  char *method,   *attrname;
  swig_instance   *inst = (swig_instance *) clientData;
  swig_method     *meth;
  swig_attribute  *attr;
  Tcl_Obj         *oldarg;
  Tcl_Obj         **objv;
  int              rcode;
  swig_class      *cls;
  swig_class      *cls_stack[64];
  int              cls_stack_bi[64];
  int              cls_stack_top = 0;
  int              numconf = 2;
  int              bi;

  objv = (Tcl_Obj **) _objv;
  if (objc < 2) {
    Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
    return TCL_ERROR;
  }
  method = Tcl_GetStringFromObj(objv[1],NULL);
  if (strcmp(method,"-acquire") == 0) {
    inst->destroy = 1;
    SWIG_Acquire(inst->thisvalue);
    return TCL_OK;
  }
  if (strcmp(method,"-disown") == 0) {
    if (inst->destroy) {
      SWIG_Disown(inst->thisvalue);
    }
    inst->destroy = 0;
    return TCL_OK;
  }
  if (strcmp(method,"-delete") == 0) {
    Tcl_DeleteCommandFromToken(interp,inst->cmdtok);
    return TCL_OK;
  }
  cls_stack[cls_stack_top] = inst->classptr;
  cls_stack_bi[cls_stack_top] = -1;
  cls = inst->classptr;
  while (1) {
    bi = cls_stack_bi[cls_stack_top];
    cls = cls_stack[cls_stack_top];
    if (bi != -1) {
      if (!cls->bases[bi] && cls->base_names[bi]) {
        /* lookup and cache the base class */
	swig_type_info *info = SWIG_TypeQueryModule(cls->module, cls->module, cls->base_names[bi]);
	if (info) cls->bases[bi] = (swig_class *) info->clientdata;
      }
      cls = cls->bases[bi];
      if (cls) {
        cls_stack_bi[cls_stack_top]++;
        cls_stack_top++;
        cls_stack[cls_stack_top] = cls;
        cls_stack_bi[cls_stack_top] = -1;
        continue;
      }
    }
    if (!cls) {
      cls_stack_top--;
      if (cls_stack_top < 0) break;
      else continue;
    }
    cls_stack_bi[cls_stack_top]++;

    meth = cls->methods;
    /* Check for methods */
    while (meth && meth->name) {
      if (strcmp(meth->name,method) == 0) {
        oldarg = objv[1];
        objv[1] = inst->thisptr;
        Tcl_IncrRefCount(inst->thisptr);
        rcode = (*meth->method)(clientData,interp,objc,objv);
        objv[1] = oldarg;
        Tcl_DecrRefCount(inst->thisptr);
        return rcode;
      }
      meth++;
    }
    /* Check class methods for a match */
    if (strcmp(method,"cget") == 0) {
      if (objc < 3) {
        Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
        return TCL_ERROR;
      }
      attrname = Tcl_GetStringFromObj(objv[2],NULL);
      attr = cls->attributes;
      while (attr && attr->name) {
        if ((strcmp(attr->name, attrname) == 0) && (attr->getmethod)) {
          oldarg = objv[1];
          objv[1] = inst->thisptr;
          Tcl_IncrRefCount(inst->thisptr);
          rcode = (*attr->getmethod)(clientData,interp,2, objv);
          objv[1] = oldarg;
          Tcl_DecrRefCount(inst->thisptr);
          return rcode;
        }
        attr++;
      }
      if (strcmp(attrname, "-this") == 0) {
        Tcl_SetObjResult(interp, Tcl_DuplicateObj(inst->thisptr));
        return TCL_OK;
      }
      if (strcmp(attrname, "-thisown") == 0) {
        if (SWIG_Thisown(inst->thisvalue)) {
          Tcl_SetResult(interp,(char*)"1",TCL_STATIC);
        } else {
          Tcl_SetResult(interp,(char*)"0",TCL_STATIC);
        }
        return TCL_OK;
      }
    } else if (strcmp(method, "configure") == 0) {
      int i;
      if (objc < 4) {
        Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
        return TCL_ERROR;
      }
      i = 2;
      while (i < objc) {
        attrname = Tcl_GetStringFromObj(objv[i],NULL);
        attr = cls->attributes;
        while (attr && attr->name) {
          if ((strcmp(attr->name, attrname) == 0) && (attr->setmethod)) {
            oldarg = objv[i];
            objv[i] = inst->thisptr;
            Tcl_IncrRefCount(inst->thisptr);
            rcode = (*attr->setmethod)(clientData,interp,3, &objv[i-1]);
            objv[i] = oldarg;
            Tcl_DecrRefCount(inst->thisptr);
            if (rcode != TCL_OK) return rcode;
            numconf += 2;
          }
          attr++;
        }
        i+=2;
      }
    }
  }
  if (strcmp(method,"configure") == 0) {
    if (numconf >= objc) {
      return TCL_OK;
    } else {
      Tcl_SetResult(interp,(char *) "Invalid attribute name.", TCL_STATIC);
      return TCL_ERROR;
    }
  }
  if (strcmp(method,"cget") == 0) {
      Tcl_SetResult(interp,(char *) "Invalid attribute name.", TCL_STATIC);
      return TCL_ERROR;
  }

  Tcl_SetResult(interp, (char *) "Invalid method. Must be one of: configure cget -acquire -disown -delete", TCL_STATIC);
  cls = inst->classptr;
  bi = 0;
  while (cls) {
    meth = cls->methods;
    while (meth && meth->name) {
      char *cr = (char *) Tcl_GetStringResult(interp);
      int meth_len = strlen(meth->name);
      char* where = strchr(cr,':');
      while(where) {
        where = strstr(where, meth->name);
        if(where) {
          if(where[-1] == ' ' && (where[meth_len] == ' ' || where[meth_len]==0)) {
            break;
          } else {
            where++;
          }
        }
      }

      if (!where)
        Tcl_AppendElement(interp, (char *) meth->name);
      meth++;
    }
    cls = inst->classptr->bases[bi++];
  }
  return TCL_ERROR;
}

/* Function to create objects */
static int
SWIG_Tcl_ObjectConstructor(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    Tcl_Obj          *newObj = 0;
    void             *thisvalue = 0;
    swig_instance   *newinst = 0;
    swig_class      *classptr = (swig_class *) clientData;
    swig_wrapper     cons = 0;
    char             *name = 0;
    int               firstarg = 0;
    int               thisarg = 0;
    int               destroy = 1;

    if (!classptr) {
      Tcl_SetResult(interp, (char *) "swig: internal runtime error. No class object defined.", TCL_STATIC);
      return TCL_ERROR;
    }
    cons = classptr->constructor;
    if (objc > 1) {
      char *s = Tcl_GetStringFromObj(objv[1],NULL);
      if (strcmp(s,"-this") == 0) {
        thisarg = 2;
        cons = 0;
      } else if (strcmp(s,"-args") == 0) {
        firstarg = 1;
      } else if (objc == 2) {
        firstarg = 1;
        name = s;
      } else if (objc >= 3) {
        char *s1;
        name = s;
        s1 = Tcl_GetStringFromObj(objv[2],NULL);
        if (strcmp(s1,"-this") == 0) {
          thisarg = 3;
          cons = 0;
        } else {
          firstarg = 1;
        }
      }
    }
    if (cons) {
      int result;
      result = (*cons)(0, interp, objc-firstarg, &objv[firstarg]);
      if (result != TCL_OK) {
        return result;
      }
      newObj = Tcl_DuplicateObj(Tcl_GetObjResult(interp));
      if (!name) name = Tcl_GetStringFromObj(newObj,NULL);
    } else if (thisarg > 0) {
      if (thisarg < objc) {
        destroy = 0;
        newObj = Tcl_DuplicateObj(objv[thisarg]);
        if (!name) name = Tcl_GetStringFromObj(newObj,NULL);
      } else {
        Tcl_SetResult(interp, (char *) "wrong # args.", TCL_STATIC);
        return TCL_ERROR;
      }
    } else {
      Tcl_SetResult(interp, (char *) "No constructor available.", TCL_STATIC);
      return TCL_ERROR;
    }
    if (SWIG_Tcl_ConvertPtr(interp,newObj, (void **) &thisvalue, *(classptr->type), SWIG_POINTER_EXCEPTION) == TCL_ERROR) {
      Tcl_DecrRefCount(newObj);
      return TCL_ERROR;
    }
    newinst = (swig_instance *) malloc(sizeof(swig_instance));
    newinst->thisptr = newObj;
    Tcl_IncrRefCount(newObj);
    newinst->thisvalue = thisvalue;
    newinst->classptr = classptr;
    newinst->destroy = destroy;
    if (destroy) {
      SWIG_Acquire(thisvalue);
    }
    newinst->cmdtok = Tcl_CreateObjCommand(interp,name, (swig_wrapper) SWIG_MethodCommand, (ClientData) newinst, (swig_delete_func) SWIG_ObjectDelete);
    return TCL_OK;
}


/* This function takes the current result and turns it into an object command */
static Tcl_Obj *
SWIG_Tcl_NewInstanceObj(Tcl_Interp *interp, void *thisvalue, swig_type_info *type, int flags) {
  Tcl_Obj *robj = SWIG_NewPointerObj(thisvalue, type,0);
  /* Check to see if this pointer belongs to a class or not */
  if ((type->clientdata) && (interp)) {
    Tcl_CmdInfo    ci;
    char          *name;
    name = Tcl_GetStringFromObj(robj,NULL);
    if (!Tcl_GetCommandInfo(interp,name, &ci) || (flags)) {
      swig_instance *newinst = (swig_instance *) malloc(sizeof(swig_instance));
      newinst->thisptr = Tcl_DuplicateObj(robj);
      Tcl_IncrRefCount(newinst->thisptr);
      newinst->thisvalue = thisvalue;
      newinst->classptr = (swig_class *) type->clientdata;
      newinst->destroy = flags;
      newinst->cmdtok = Tcl_CreateObjCommand(interp, Tcl_GetStringFromObj(robj,NULL), (swig_wrapper_func) SWIG_MethodCommand, (ClientData) newinst, (swig_delete_func) SWIG_ObjectDelete);
      if (flags) {
        SWIG_Acquire(thisvalue);
      }
    }
  }
  return robj;
}

/* Structure for command table */
typedef struct {
  const char *name;
  int       (*wrapper)(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
  ClientData  clientdata;
} swig_command_info;

/* Structure for variable linking table */
typedef struct {
  const char *name;
  void *addr;
  char * (*get)(ClientData, Tcl_Interp *, char *, char *, int);
  char * (*set)(ClientData, Tcl_Interp *, char *, char *, int);
} swig_var_info;


/* Contract support */

#define SWIG_contract_assert(expr, msg)  if (!(expr)) { Tcl_SetResult(interp, (char *) msg, TCL_STATIC ); goto fail; } else

static swig_module_info * 
SWIG_Tcl_GetModule(Tcl_Interp *interp) {
  char *data;
  swig_module_info *ret = 0;
  
  /* first check if pointer already created */
  data = (char *) Tcl_GetVar(interp, "swig_runtime_data_type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, TCL_GLOBAL_ONLY);
  if (data) {
    SWIG_UnpackData(data, &ret, sizeof(swig_type_info **));
  }

  return ret;
}

static void
SWIG_Tcl_SetModule(Tcl_Interp *interp, swig_module_info *module) {
  char buf[512];
  char *data;

  /* create a new pointer */
  data = SWIG_PackData(buf, &module, sizeof(swig_type_info **));
  *data = 0;
  Tcl_SetVar(interp, "swig_runtime_data_type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, buf, 0);
}

#ifdef __cplusplus
}
#endif






/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_unsigned_char swig_types[0]
#define SWIGTYPE_p_unsigned_long swig_types[1]
#define SWIGTYPE_p_unsigned_short swig_types[2]
#define SWIGTYPE_p_wchar_t swig_types[3]
#define SWIGTYPE_ptrdiff_t swig_types[4]
#define SWIGTYPE_size_t swig_types[5]
static swig_type_info *swig_types[7];
static swig_module_info swig_module = {swig_types, 6, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Uninum_Init
#define SWIG_name    "uninum"
#define SWIG_prefix  ""
#define SWIG_version "2.8"


#ifdef __cplusplus
extern "C" {
#endif
#ifdef MAC_TCL
#pragma export on
#endif
SWIGEXPORT int SWIG_init(Tcl_Interp *);
#ifdef MAC_TCL
#pragma export off
#endif
#ifdef __cplusplus
}
#endif



/* Includes the header in the wrapper code */
#include "config.h"
#include "unicode.h"
#include "nsdefs.h"
extern char *UNStrToWNStr(wchar_t *,char *);
extern UCS2 *WNStrToUNStr(char *,char *);
extern char *StrGuessNumberSystem(wchar_t *);
extern char *Tcl_ListNumberSystems (int);
extern char *UninumNumberSystemMaximumValue(char *);
extern char *uninum_version(void);


extern int uninum_err;
extern short uninum_ns_type;
extern UCS2 tcl_uninum_badchar;
extern int Uninum_Input_Base;
extern int Uninum_Output_Base;
extern int Uninum_Output_General_Group_Size;
extern int Uninum_Output_First_Group_Size;
extern int Uninum_Generate_Roman_With_Bar_P;
extern UCS2 Uninum_Output_Group_Separator;

#ifdef __cplusplus
extern "C" {
#endif
static int
_wrap_UNStrToWNStr(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    wchar_t *arg1 = (wchar_t *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"os:UNStrToWNStr wchar_t * char * ",(void *)0,&arg2) == TCL_ERROR) SWIG_fail;
    
    arg1 = Tcl_GetUnicode(objv[1]);
    
    result = (char *)UNStrToWNStr(arg1,arg2);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    free(result);
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_WNStrToUNStr(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *arg1 = (char *) 0 ;
    char *arg2 = (char *) 0 ;
    UCS2 *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"ss:WNStrToUNStr char * char * ",&arg1,&arg2) == TCL_ERROR) SWIG_fail;
    result = (UCS2 *)WNStrToUNStr(arg1,arg2);
    
    
    if(result == NULL) result = "";
    Tcl_SetObjResult(interp,Tcl_NewUnicodeObj(result,uninum_utf16len(result)));
    
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_StrGuessNumberSystem(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    wchar_t *arg1 = (wchar_t *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"o:StrGuessNumberSystem wchar_t * ",(void *)0) == TCL_ERROR) SWIG_fail;
    
    arg1 = Tcl_GetUnicode(objv[1]);
    
    result = (char *)StrGuessNumberSystem(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_Tcl_ListNumberSystems(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    int arg1 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"i:Tcl_ListNumberSystems int ",&arg1) == TCL_ERROR) SWIG_fail;
    result = (char *)Tcl_ListNumberSystems(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    free(result);
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_uninum_version(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,":uninum_version ") == TCL_ERROR) SWIG_fail;
    result = (char *)uninum_version();
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static int
_wrap_UninumNumberSystemMaximumValue(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {
    char *arg1 = (char *) 0 ;
    char *result;
    
    if (SWIG_GetArgs(interp, objc, objv,"s:UninumNumberSystemMaximumValue char * ",&arg1) == TCL_ERROR) SWIG_fail;
    result = (char *)UninumNumberSystemMaximumValue(arg1);
    
    Tcl_SetObjResult(interp,Tcl_NewStringObj(result,-1));
    free(result);
    return TCL_OK;
    fail:
    return TCL_ERROR;
}


static char *_wrap_uninum_err_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) uninum_err);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_uninum_err_set(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    Tcl_Obj *name1o = 0;
    
    name1o = Tcl_NewStringObj(name1,-1);
    value = Tcl_ObjGetVar2(interp, name1o, 0, flags);
    Tcl_DecrRefCount(name1o);
    if (!value) return NULL;
    {
        long temp;
        if (Tcl_GetLongFromObj(interp, value, &temp) != TCL_OK) {
            return (char*) "Type error. expected an integer";
        }
        uninum_err = (int) temp;
    }
    return NULL;
}


static char *_wrap_uninum_ns_type_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) uninum_ns_type);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_uninum_ns_type_set(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    Tcl_Obj *name1o = 0;
    
    name1o = Tcl_NewStringObj(name1,-1);
    value = Tcl_ObjGetVar2(interp, name1o, 0, flags);
    Tcl_DecrRefCount(name1o);
    if (!value) return NULL;
    {
        long temp;
        if (Tcl_GetLongFromObj(interp, value, &temp) != TCL_OK) {
            return (char*) "Type error. expected an integer";
        }
        uninum_ns_type = (short) temp;
    }
    return NULL;
}


static char *_wrap_tcl_uninum_badchar_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) tcl_uninum_badchar);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_tcl_uninum_badchar_set(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    Tcl_Obj *name1o = 0;
    
    name1o = Tcl_NewStringObj(name1,-1);
    value = Tcl_ObjGetVar2(interp, name1o, 0, flags);
    Tcl_DecrRefCount(name1o);
    if (!value) return NULL;
    {
        long temp;
        if (Tcl_GetLongFromObj(interp, value, &temp) != TCL_OK) {
            return (char*) "Type error. expected an integer";
        }
        tcl_uninum_badchar = (UCS2) temp;
    }
    return NULL;
}


static char *_wrap_Uninum_Input_Base_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) Uninum_Input_Base);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_Uninum_Input_Base_set(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    Tcl_Obj *name1o = 0;
    
    name1o = Tcl_NewStringObj(name1,-1);
    value = Tcl_ObjGetVar2(interp, name1o, 0, flags);
    Tcl_DecrRefCount(name1o);
    if (!value) return NULL;
    {
        long temp;
        if (Tcl_GetLongFromObj(interp, value, &temp) != TCL_OK) {
            return (char*) "Type error. expected an integer";
        }
        Uninum_Input_Base = (int) temp;
    }
    return NULL;
}


static char *_wrap_Uninum_Output_Base_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) Uninum_Output_Base);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_Uninum_Output_Base_set(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    Tcl_Obj *name1o = 0;
    
    name1o = Tcl_NewStringObj(name1,-1);
    value = Tcl_ObjGetVar2(interp, name1o, 0, flags);
    Tcl_DecrRefCount(name1o);
    if (!value) return NULL;
    {
        long temp;
        if (Tcl_GetLongFromObj(interp, value, &temp) != TCL_OK) {
            return (char*) "Type error. expected an integer";
        }
        Uninum_Output_Base = (int) temp;
    }
    return NULL;
}


static char *_wrap_Uninum_Output_General_Group_Size_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) Uninum_Output_General_Group_Size);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_Uninum_Output_General_Group_Size_set(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    Tcl_Obj *name1o = 0;
    
    name1o = Tcl_NewStringObj(name1,-1);
    value = Tcl_ObjGetVar2(interp, name1o, 0, flags);
    Tcl_DecrRefCount(name1o);
    if (!value) return NULL;
    {
        long temp;
        if (Tcl_GetLongFromObj(interp, value, &temp) != TCL_OK) {
            return (char*) "Type error. expected an integer";
        }
        Uninum_Output_General_Group_Size = (int) temp;
    }
    return NULL;
}


static char *_wrap_Uninum_Output_First_Group_Size_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) Uninum_Output_First_Group_Size);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_Uninum_Output_First_Group_Size_set(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    Tcl_Obj *name1o = 0;
    
    name1o = Tcl_NewStringObj(name1,-1);
    value = Tcl_ObjGetVar2(interp, name1o, 0, flags);
    Tcl_DecrRefCount(name1o);
    if (!value) return NULL;
    {
        long temp;
        if (Tcl_GetLongFromObj(interp, value, &temp) != TCL_OK) {
            return (char*) "Type error. expected an integer";
        }
        Uninum_Output_First_Group_Size = (int) temp;
    }
    return NULL;
}


static char *_wrap_Uninum_Generate_Roman_With_Bar_P_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) Uninum_Generate_Roman_With_Bar_P);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_Uninum_Generate_Roman_With_Bar_P_set(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    Tcl_Obj *name1o = 0;
    
    name1o = Tcl_NewStringObj(name1,-1);
    value = Tcl_ObjGetVar2(interp, name1o, 0, flags);
    Tcl_DecrRefCount(name1o);
    if (!value) return NULL;
    {
        long temp;
        if (Tcl_GetLongFromObj(interp, value, &temp) != TCL_OK) {
            return (char*) "Type error. expected an integer";
        }
        Uninum_Generate_Roman_With_Bar_P = (int) temp;
    }
    return NULL;
}


static char *_wrap_Uninum_Output_Group_Separator_get(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    
    value = Tcl_NewIntObj((long) Uninum_Output_Group_Separator);
    if (value) {
        Tcl_SetVar2(interp,name1,name2,Tcl_GetStringFromObj(value,NULL), flags);
        Tcl_DecrRefCount(value);
    }
    return NULL;
}


static char *_wrap_Uninum_Output_Group_Separator_set(ClientData clientData, Tcl_Interp *interp, char *name1, char *name2, int flags) {
    Tcl_Obj *value = 0;
    Tcl_Obj *name1o = 0;
    
    name1o = Tcl_NewStringObj(name1,-1);
    value = Tcl_ObjGetVar2(interp, name1o, 0, flags);
    Tcl_DecrRefCount(name1o);
    if (!value) return NULL;
    {
        long temp;
        if (Tcl_GetLongFromObj(interp, value, &temp) != TCL_OK) {
            return (char*) "Type error. expected an integer";
        }
        Uninum_Output_Group_Separator = (UCS2) temp;
    }
    return NULL;
}



static swig_command_info swig_commands[] = {
    { SWIG_prefix "UNStrToWNStr", (swig_wrapper_func) _wrap_UNStrToWNStr, NULL},
    { SWIG_prefix "WNStrToUNStr", (swig_wrapper_func) _wrap_WNStrToUNStr, NULL},
    { SWIG_prefix "StrGuessNumberSystem", (swig_wrapper_func) _wrap_StrGuessNumberSystem, NULL},
    { SWIG_prefix "Tcl_ListNumberSystems", (swig_wrapper_func) _wrap_Tcl_ListNumberSystems, NULL},
    { SWIG_prefix "uninum_version", (swig_wrapper_func) _wrap_uninum_version, NULL},
    { SWIG_prefix "UninumNumberSystemMaximumValue", (swig_wrapper_func) _wrap_UninumNumberSystemMaximumValue, NULL},
    {0, 0, 0}
};

static swig_var_info swig_variables[] = {
    { SWIG_prefix "uninum_err", 0, (swig_variable_func) _wrap_uninum_err_get,(swig_variable_func) _wrap_uninum_err_set},
    { SWIG_prefix "uninum_ns_type", 0, (swig_variable_func) _wrap_uninum_ns_type_get,(swig_variable_func) _wrap_uninum_ns_type_set},
    { SWIG_prefix "tcl_uninum_badchar", 0, (swig_variable_func) _wrap_tcl_uninum_badchar_get,(swig_variable_func) _wrap_tcl_uninum_badchar_set},
    { SWIG_prefix "Uninum_Input_Base", 0, (swig_variable_func) _wrap_Uninum_Input_Base_get,(swig_variable_func) _wrap_Uninum_Input_Base_set},
    { SWIG_prefix "Uninum_Output_Base", 0, (swig_variable_func) _wrap_Uninum_Output_Base_get,(swig_variable_func) _wrap_Uninum_Output_Base_set},
    { SWIG_prefix "Uninum_Output_General_Group_Size", 0, (swig_variable_func) _wrap_Uninum_Output_General_Group_Size_get,(swig_variable_func) _wrap_Uninum_Output_General_Group_Size_set},
    { SWIG_prefix "Uninum_Output_First_Group_Size", 0, (swig_variable_func) _wrap_Uninum_Output_First_Group_Size_get,(swig_variable_func) _wrap_Uninum_Output_First_Group_Size_set},
    { SWIG_prefix "Uninum_Generate_Roman_With_Bar_P", 0, (swig_variable_func) _wrap_Uninum_Generate_Roman_With_Bar_P_get,(swig_variable_func) _wrap_Uninum_Generate_Roman_With_Bar_P_set},
    { SWIG_prefix "Uninum_Output_Group_Separator", 0, (swig_variable_func) _wrap_Uninum_Output_Group_Separator_get,(swig_variable_func) _wrap_Uninum_Output_Group_Separator_set},
    {0,0,0,0}
};

static swig_const_info swig_constants[] = {
{ SWIG_TCL_INT,     (char *)"NS_TYPE_ULONG", (long) 0, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TYPE_STRING", (long) 1, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TYPE_MPZT", (long) 2, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TYPE_GUESS", (long) 0, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TYPE_SAFE", (long) 1, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TYPE_COVER", (long) 2, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TYPE_SPECIAL", (long) 3, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ALLZERO", (long) (-2), 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_UNKNOWN", (long) (-1), 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_AEGEAN", (long) 1, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ARABIC_WESTERN", (long) 3, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ARABIC_ALPHABETIC", (long) 5, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ARMENIAN_ALPHABETIC", (long) 7, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_BALINESE", (long) 9, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_BENGALI", (long) 11, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_BURMESE", (long) 13, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_GENERIC", (long) 14, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_SUZHOU", (long) 15, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_REGULAR_TRADITIONAL", (long) 17, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_MANDARIN_REGULAR_TRADITIONAL", (long) 18, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_REGULAR_PLACE", (long) 19, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_REGULAR_SIMPLIFIED", (long) 21, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_MANDARIN_REGULAR_SIMPLIFIED", (long) 22, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_LEGAL_TRADITIONAL", (long) 25, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_MANDARIN_LEGAL_TRADITIONAL", (long) 26, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_LEGAL_SIMPLIFIED", (long) 27, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_MANDARIN_LEGAL_SIMPLIFIED", (long) 28, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_JAPANESE_REGULAR_SIMPLIFIED", (long) 29, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_JAPANESE_REGULAR_TRADITIONAL", (long) 30, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_JAPANESE_REGULAR_PLACE", (long) 31, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_JAPANESE_WESTERN_MIX", (long) 33, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_JAPANESE_LEGAL_SIMPLIFIED", (long) 35, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_JAPANESE_LEGAL_TRADITIONAL", (long) 36, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_COMMON_BRAILLE", (long) 37, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CYRILLIC_ALPHABETIC", (long) 39, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_DEVANAGARI", (long) 41, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_EGYPTIAN", (long) 43, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ETHIOPIC", (long) 45, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_EWELLIC_DECIMAL", (long) 4, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_EWELLIC_HEX", (long) 6, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_FRENCH_BRAILLE", (long) 46, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_GLAGOLITIC_ALPHABETIC", (long) 47, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_GREEK_ACROPHONIC", (long) 49, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_GREEK_ALPHABETIC_UPPER", (long) 51, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_GREEK_ALPHABETIC_LOWER", (long) 52, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_GUJARATI", (long) 53, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_GURMUKHI", (long) 55, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_HEBREW_GENERIC", (long) 56, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_HEBREW_EARLY", (long) 57, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_HEBREW_LATE", (long) 59, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_HUNGARIAN", (long) 137, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_KANNADA", (long) 61, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_KAYAH_LI", (long) 132, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_KHAROSHTHI", (long) 63, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_KHMER", (long) 65, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_KLINGON", (long) 67, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_LAO", (long) 69, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_LEPCHA", (long) 133, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_LIMBU", (long) 71, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_MALAYALAM", (long) 73, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_MAYAN", (long) 75, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_MONGOLIAN", (long) 77, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_MXEDRULI", (long) 78, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_NEW_TAI_LUE", (long) 79, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_NKO", (long) 81, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_OL_CHIKI", (long) 134, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_OLD_ITALIC", (long) 83, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_OLD_PERSIAN", (long) 85, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ORIYA", (long) 87, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_OSMANYA", (long) 89, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_PERSO_ARABIC", (long) 91, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_PHOENICIAN", (long) 93, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ROMAN_GENERIC", (long) 94, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ROMAN_UPPER", (long) 95, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ROMAN_LOWER", (long) 96, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_RUSSIAN_BRAILLE", (long) 2, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_SAURASHTRA", (long) 135, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_SHAN", (long) 131, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_SINHALA", (long) 97, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_SUNDANESE", (long) 136, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TAMIL_GENERIC", (long) 100, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TAMIL_PLACE", (long) 101, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TAMIL_TRADITIONAL", (long) 103, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TELUGU", (long) 105, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TENGWAR_DECIMAL", (long) 107, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TENGWAR_DUODECIMAL", (long) 108, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_THAI", (long) 109, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_TIBETAN", (long) 111, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_XUCURI_LOWER", (long) 112, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_XUCURI_UPPER", (long) 114, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ALL", (long) 115, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ANY", (long) 117, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_HEX", (long) 129, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_HEX_LOWER", (long) 118, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_HEX_UPPER", (long) 119, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_WESTERN", (long) 120, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_WESTERN_GENERIC", (long) 120, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_WESTERN_LOWER", (long) 121, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_WESTERN_UPPER", (long) 122, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_COUNTING_ROD_GENERIC", (long) 123, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_COUNTING_ROD_EARLY_WITH_ZERO", (long) 124, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_COUNTING_ROD_LATE_WITH_ZERO", (long) 125, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_COUNTING_ROD_EARLY_WITHOUT_ZERO", (long) 126, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_CHINESE_COUNTING_ROD_LATE_WITHOUT_ZERO", (long) 127, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_VAI", (long) 130, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_VERDURIAN", (long) 128, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_OKAY", (long) 0, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_BADCHARACTER", (long) 128, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_BADCHARACTER", (long) 128, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_DOESNOTFIT", (long) 129, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_DOESNOTFIT", (long) 129, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_NUMBER_SYSTEM_UNKNOWN", (long) 130, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_UNKNOWN", (long) 130, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_BADBASE", (long) 131, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_NOTCONSISTENTWITHBASE", (long) 132, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_OUTOFMEMORY", (long) 133, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_RANGE", (long) 134, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_OUTSIDE_BMP", (long) 135, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_NOZERO", (long) 136, 0, 0, 0},
{ SWIG_TCL_INT,     (char *)"NS_ERROR_ILLFORMED", (long) 137, 0, 0, 0},
    {0,0,0,0,0,0}
};

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_unsigned_char = {"_p_unsigned_char", "unsigned char *|Boolean *", 0, 0, 0};
static swig_type_info _swigt__p_unsigned_long = {"_p_unsigned_long", "unsigned long *|UTF32 *", 0, 0, 0};
static swig_type_info _swigt__p_unsigned_short = {"_p_unsigned_short", "unsigned short *|UCS2 *", 0, 0, 0};
static swig_type_info _swigt__p_wchar_t = {"_p_wchar_t", "wchar_t *", 0, 0, 0};
static swig_type_info _swigt__ptrdiff_t = {"_ptrdiff_t", "ptrdiff_t", 0, 0, 0};
static swig_type_info _swigt__size_t = {"_size_t", "size_t", 0, 0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_unsigned_char,
  &_swigt__p_unsigned_long,
  &_swigt__p_unsigned_short,
  &_swigt__p_wchar_t,
  &_swigt__ptrdiff_t,
  &_swigt__size_t,
};

static swig_cast_info _swigc__p_unsigned_char[] = {  {&_swigt__p_unsigned_char, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_unsigned_long[] = {  {&_swigt__p_unsigned_long, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_unsigned_short[] = {  {&_swigt__p_unsigned_short, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_wchar_t[] = {  {&_swigt__p_wchar_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__ptrdiff_t[] = {  {&_swigt__ptrdiff_t, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__size_t[] = {  {&_swigt__size_t, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_unsigned_char,
  _swigc__p_unsigned_long,
  _swigc__p_unsigned_short,
  _swigc__p_wchar_t,
  _swigc__ptrdiff_t,
  _swigc__size_t,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

#ifdef __cplusplus
}
#endif
/*************************************************************************
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.

 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop though that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.

 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
**/

#ifdef __cplusplus
extern "C" {
#endif
    
    SWIGRUNTIME void
    SWIG_InitializeModule(void *clientdata) {
        swig_type_info *type, *ret;
        swig_cast_info *cast;
        size_t i;
        swig_module_info *module_head;
        static int init_run = 0;
        
        clientdata = clientdata;
        
        if (init_run) return;
        init_run = 1;
        
        /* Initialize the swig_module */
        swig_module.type_initial = swig_type_initial;
        swig_module.cast_initial = swig_cast_initial;
        
        /* Try and load any already created modules */
        module_head = SWIG_GetModule(clientdata);
        if (module_head) {
            swig_module.next = module_head->next;
            module_head->next = &swig_module;
        } else {
            /* This is the first module loaded */
            swig_module.next = &swig_module;
            SWIG_SetModule(clientdata, &swig_module);
        }
        
        /* Now work on filling in swig_module.types */
        for (i = 0; i < swig_module.size; ++i) {
            type = 0;
            
            /* if there is another module already loaded */
            if (swig_module.next != &swig_module) {
                type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
            }
            if (type) {
                /* Overwrite clientdata field */
                if (swig_module.type_initial[i]->clientdata) type->clientdata = swig_module.type_initial[i]->clientdata;
            } else {
                type = swig_module.type_initial[i];
            }
            
            /* Insert casting types */
            cast = swig_module.cast_initial[i];
            while (cast->type) {
                /* Don't need to add information already in the list */
                ret = 0;
                if (swig_module.next != &swig_module) {
                    ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
                }
                if (ret && type == swig_module.type_initial[i]) {
                    cast->type = ret;
                    ret = 0;
                }
                
                if (!ret) {
                    if (type->cast) {
                        type->cast->prev = cast;
                        cast->next = type->cast;
                    }
                    type->cast = cast;
                }
                
                cast++;
            }
            
            /* Set entry in modules->types array equal to the type */
            swig_module.types[i] = type;
        }
        swig_module.types[i] = 0;
    }
    
    /* This function will propagate the clientdata field of type to
    * any new swig_type_info structures that have been added into the list
    * of equivalent types.  It is like calling
    * SWIG_TypeClientData(type, clientdata) a second time.
    */
    SWIGRUNTIME void
    SWIG_PropagateClientData(void) {
        size_t i;
        swig_cast_info *equiv;
        static int init_run = 0;
        
        if (init_run) return;
        init_run = 1;
        
        for (i = 0; i < swig_module.size; i++) {
            if (swig_module.types[i]->clientdata) {
                equiv = swig_module.types[i]->cast;
                while (equiv) {
                    if (!equiv->converter) {
                        if (equiv->type && !equiv->type->clientdata)
                        SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
                    }
                    equiv = equiv->next;
                }
            }
        }
    }
    
#ifdef __cplusplus
}
#endif


SWIGEXPORT int SWIG_init(Tcl_Interp *interp) {
    int i;
    if (interp == 0) return TCL_ERROR;
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, (char*)"8.1", 0) == NULL) {
        return TCL_ERROR;
    }
#endif
    
    Tcl_PkgProvide(interp, (char*)SWIG_name, (char*)SWIG_version);
    
#ifdef SWIG_namespace
    Tcl_Eval(interp, "namespace eval " SWIG_namespace " { }");
#endif
    
    SWIG_InitializeModule((void *) interp);
    SWIG_PropagateClientData();
    
    for (i = 0; swig_commands[i].name; i++) {
        Tcl_CreateObjCommand(interp, (char *) swig_commands[i].name, (swig_wrapper_func) swig_commands[i].wrapper, swig_commands[i].clientdata, NULL);
    }
    for (i = 0; swig_variables[i].name; i++) {
        Tcl_SetVar(interp, (char *) swig_variables[i].name, (char *) "", TCL_GLOBAL_ONLY);
        Tcl_TraceVar(interp, (char *) swig_variables[i].name, TCL_TRACE_READS | TCL_GLOBAL_ONLY, (Tcl_VarTraceProc *) swig_variables[i].get, (ClientData) swig_variables[i].addr);
        Tcl_TraceVar(interp, (char *) swig_variables[i].name, TCL_TRACE_WRITES | TCL_GLOBAL_ONLY, (Tcl_VarTraceProc *) swig_variables[i].set, (ClientData) swig_variables[i].addr);
    }
    SWIG_InstallConstants(interp, swig_constants);
    
    return TCL_OK;
}
SWIGEXPORT int Uninum_SafeInit(Tcl_Interp *interp) {
    return SWIG_init(interp);
}

