### reader component

use parent 'OnePassBitmapAlgorithmComponent';

sub new {
    my $class = shift;

    $self = SUPER::OnePassBitmapAlgorithmComponent->new;

    ### 1. data is temporary output of the functor for example
    ### 2. operand is the class on which the functor works
    $self = { data => undef, op => undef, index => -1, };
    
    bless $self, $class;
}

sub addLoadPNG {
    my ($self) = @_;
    
    my $loader = MatrixBitmapLoader->new;

    ### sets index
    $self->{index} = $self->addFunctor(OnePassFunctor->new(&$loader->loadPNGFile));
    ### sets class on which this operates
    $self->{op} = \$loader;
    $self->indexFunctor($i)->setClassOp(\$loader);
}

sub exec {
    my ($self, $filename) = @_;

    my $result = $self->indexFunctor($self->{index})->do($filename);
    
    $self->indexFunctor($self->{index})->setResult($result);

}
    
