### Blue dither algorithm

use parent 'OnePassSystem';

sub new {
    my ($class, $pngfilename) = @_;

    $self = SUPER::OnePassSystem->new;
    $self->{pngfn} = $pngfilename;
    
    $self->init; ### sets bitmap undef
    
    bless $self, $class;
}


sub run {
    my ($self, $algo) = @_;

    my $componentsbag = $algo->getBag;
    my $matrixbitmap = $algo->getBitmap;

    my $bagelement1 = $componentsbag->getBagElement1;

    $bagelement1->executeAllFunctors($self->{pngfn}) or die "OnePassSystemBlue : Something went wrong executing your functors list of the first bag element, your bitmap may be incomplete.\n";

    ### FIXME stupid functionality, should loop over bag
    my $secondbagelement1 = $bagelement1->getNextElement;
    
    $secondbagelement1->executeAllFunctors($matrixbitmap) or die "OnePassSystemBlue : Something went wrong executing your functors list of the second bag element, your bitmap may be incomplete.\n";

    return $secondbagelement1->getBitmap; ### FIXME or test
}

1;
