package AI::MicroStructure::germany;
use AI::MicroStructure::MultiList;
our @ISA = ( AI::MicroStructure::MultiList );
__PACKAGE__->init();
1;

=head1 NAME

AI::MicroStructure::germany - The numbers structure

=head1 DESCRIPTION

You can count on this module. Almost.

=cut

__DATA__
# default
Dresden
# names Dresden
01067 01069 01097 01099 01108 01109 01127 01129 01139 01156 01157 01159 01169 01187 01189 01217 01219 01237 01239 01257 01259 01277 01279 01307 01309 01324 01326 01328 01462 01465 01478 
# names Radebeul
01445 
# names Radeberg
01454 
# names Wachau
01454 
# names Ottendorf-Okrilla
01458 
# names Moritzburg
01468 
# names Radeburg
01471 
# names Arnsdorf
01477 
# names Lampertswalde
01561 
# names Tauscha
01561 
# names Priestewitz
01561 
# names Ebersbach
01561 04720 
# names Wildenhain
01561 
# names Thiendorf
01561 
# names Zabeltitz
01561 
# names Riesa
01587 01589 01591 
# names Hirschstein
01594 
# names Stauchitz
01594 
# names Nauwalde
01609 
# names Glaubitz
01612 
# names Strehla
01616 
# names Zeithain
01619 
# names Lommatzsch
01623 
# names Leuben-Schleinitz
01623 
# names Ketzerbachtal
01623 
# names Coswig
01640 06869 
# names Triebischtal
01665 
# names Taubenheim
01665 
# names Diera-Zehren
01665 
# names Klipphausen
01665 
# names Heynitz
01683 
# names Nossen
01683 
# names Niederau
01689 
# names Freital
01705 
# names Wilsdruff
01723 
# names Bannewitz
01728 
# names Kreischa
01731 
# names Rabenau
01734 35466 
# names Tharandt
01737 
# names Dorfhain
01738 
# names Dippoldiswalde
01744 
# names Schmiedeberg
01762 16278 
# names Hartmannsdorf-Reichenau
01762 
# names Reinhardtsgrimma
01768 
# names Altenberg
01773 
# names Pretzschendorf
01774 
# names Geising
01778 
# names Pirna
01796 
# names Struppen
01796 
# names Dohma
01796 
# names Dohna
01809 
# names Heidenau
01809 21258 
# names Porschdorf
01814 
# names Rathmannsdorf
01814 39439 
# names Bahretal
01819 
# names Gohrisch
01824 
# names Rosenthal-Bielatal
01824 
# names Rathen
01824 
# names Liebstadt
01825 
# names Stolpen
01833 
# names Hohwald
01844 
# names Neustadt
37345 
# names Sachsen
91623 
# names Lohmen
01847 18276 
# names Hohnstein
01848 
# names Kirnitzschtal
01855 
# names Sebnitz
01855 
# names Rammenau
01877 
# names Demitz-Thumitz
01877 
# names Bischofswerda
01877 
# names Lichtenberg
01896 95192 
# names Pulsnitz
01896 
# names Ohorn
01896 
# names Bretnig-Hauswalde
01900 
# names Steinigtwolmsdorf
01904 
# names Burkau
01906 
# names Frankenthal
01909 
# names Kamenz
01917 
# names Crostwitz
01920 
# names Panschwitz-Kuckau
01920 
# names Steina
01920 
# names Dresden  01067 01069 01097 01099 01108 01109 01127 01129 01139 01156 01157 01159 01169 01187 01189 01217 01219 01237 01239 01257 01259 01277 01279 01307 01309 01324 01326 01328 01462 01465 01478 
# names Radebeul  01445 
# names Radeberg  01454 
# names Wachau  01454 
# names Ottendorf-Okrilla  01458 
# names Moritzburg  01468 
# names Radeburg  01471 
# names Arnsdorf  01477 
# names Lampertswalde  01561 
# names Tauscha  01561 
# names Priestewitz  01561 
# names Ebersbach  01561 04720 
# names Wildenhain  01561 
# names Thiendorf  01561 
# names Zabeltitz  01561 
# names Riesa  01587 01589 01591 
# names Hirschstein  01594 
# names Stauchitz  01594 
# names Nauwalde  01609 
# names Glaubitz  01612 
# names Strehla  01616 
# names Zeithain  01619 
# names Lommatzsch  01623 
# names Leuben-Schleinitz  01623 
# names Ketzerbachtal  01623 
# names Coswig  01640 06869 
# names Triebischtal  01665 
# names Taubenheim  01665 
# names Diera-Zehren  01665 
# names Klipphausen  01665 
# names Heynitz  01683 
# names Nossen  01683 
# names Niederau  01689 
# names Freital  01705 
# names Wilsdruff  01723 
# names Bannewitz  01728 
# names Kreischa  01731 
# names Rabenau  01734 35466 
# names Tharandt  01737 
# names Dorfhain  01738 
# names Dippoldiswalde  01744 
# names Schmiedeberg  01762 16278 
# names Hartmannsdorf-Reichenau  01762 
# names Reinhardtsgrimma  01768 
# names Altenberg  01773 
# names Pretzschendorf  01774 
# names Geising  01778 
# names Pirna  01796 
# names Struppen  01796 
# names Dohma  01796 
# names Dohna  01809 
# names Heidenau  01809 21258 
# names Porschdorf  01814 
# names Rathmannsdorf  01814 39439 
# names Bahretal  01819 
# names Gohrisch  01824 
# names Rosenthal-Bielatal  01824 
# names Rathen  01824 
# names Liebstadt  01825 
# names Stolpen  01833 
# names Hohwald  01844 
# names Neustadt  37345 
# names Sachsen  91623 
# names Lohmen  01847 18276 
# names Hohnstein  01848 
# names Kirnitzschtal  01855 
# names Sebnitz  01855 
# names Rammenau  01877 
# names Demitz-Thumitz  01877 
# names Bischofswerda  01877 
# names Lichtenberg  01896 95192 
# names Pulsnitz  01896 
# names Ohorn  01896 
# names Bretnig-Hauswalde  01900 
# names Steinigtwolmsdorf  01904 
# names Burkau  01906 
# names Frankenthal  01909 
# names Kamenz  01917 
# names Crostwitz  01920 
# names Panschwitz-Kuckau  01920 
# names Steina  01920 
# names Elstra  01920 
# names Haselbachtal  01920 01936 
# names Ralbitz-Rosenthal  01920 
# names Schwepnitz  01936 
# names Neukirch  01936 88099 
# names Oberlichtenau  01936 
# names Ruhland  01945 
# names Kroppen  01945 66957 
# names Schwarzbach  01945 07589 
# names Tettau  01945 96355 
# names Hohenbocka  01945 
# names Hermsdorf  01945 07629 39326 
# names Guteborn  01945 
# names Lindenau  01945 
# names Schipkau  01968 01993 01994 01998 
# names Senftenberg  01968 
# names Lauchhammer  01979 
# names Neu-Seeland  01983 03103 
# names Schwarzheide  01987 
# names Ortrand  01990 
# names Frauendorf  01990 03058 
# names Bautzen  02625 
# names Radibor  02627 
# names Hochkirch  02627 
# names Kirschau  02681 
# names Wilthen  02681 
# names Crostau  02681 
# names Schirgiswalde  02681 
# names Obergurig  02692 
# names Malschwitz  02694 
# names Guttau  02694 
# names Neschwitz  02699 
# names Puschwitz  02699 
# names Kittlitz  02708 03222 23911 
# names Lawalde  02708 
# names Rosenbach  02708 
# names Obercunnersdorf  02708 
# names Niedercunnersdorf  02708 
# names Neugersdorf  02727 
# names Cunewalde  02733 
# names Oppach  02736 
# names Beiersdorf  02736 
# names Eibau  02739 
# names Neusalza-Spremberg  02742 
# names Friedersdorf  02742 03253 06749 15754 98701 
# names Strahwalde  02747 
# names Berthelsdorf  02747 
# names Herrnhut  02747 
# names Bernstadt  89182 
# names Zittau  02763 
# names Mittelherwigsdorf  02763 
# names Hainewalde  02779 
# names Seifhennersdorf  02782 
# names Olbersdorf  02785 
# names Schlegel  02788 07366 
# names Hirschfelde  02788 16356 
# names Oderwitz  02791 
# names Leutersdorf  02794 98617 
# names Jonsdorf  02796 
# names Oybin  02797 
# names Waltersdorf  02799 07646 15732 
# names Markersdorf  02829 
# names Vierkirchen  02894 85256 
# names Ostritz  02899 
# names Niesky  02906 
# names Waldhufen  02906 
# names Kreba-Neudorf  02906 
# names Klitten  02906 
# names Hohendubrau  02906 
# names Horka  02923 
# names Kodersdorf  02923 
# names Gablenz  02953 03058 
# names Rietschen  02956 
# names Krauschwitz  02957 06682 
# names Schleife  02959 
# names Trebendorf  02959 
# names Hoyerswerda  02977 
# names Elsterheide  02979 02991 
# names Spreetal  02979 
# names Leippe-Torno  02991 
# names Lauta  02991 
# names Bernsdorf  02994 09337 
# names Wiednitz  02994 
# names Wittichenau  02997 
# names Knappensee  02999 
# names Uhyst  02999 
# names Lohsa  02999 
# names Cottbus  03042 03044 03046 03048 03050 03051 03052 03053 03054 03055 
# names Haasow  03058 
# names Koppatz  03058 
# names Kathlow  03058 
# names Komptendorf  03058 
# names Sergen  03058 
# names Kiekebusch  03058 15749 
# names Roggosen  03058 
# names Gallinchen  03058 
# names Laubsdorf  03058 
# names Neuhausen  03058 75242 
# names Schmogrow-Fehrow  03096 
# names Burg  39288 54646 
# names Werben  03096 
# names Guhrow  03096 
# names Briesen  03096 15757 
# names Dissen-Striesow  03096 
# names Kolkwitz  03099 
# names Neupetershain  03103 
# names Drebkau  03116 
# names Welzow  03119 
# names Bagenz  03130 
# names Graustein  03130 
# names Proschim  03130 
# names Hornow-Wadelsdorf  03130 
# names Tschernitz  03130 
# names Drieschnitz-Kahsel  03130 
# names Wolfshain  03130 
# names Lieskau  03130 03238 06120 
# names Reuthen  03130 
# names Spremberg  03130 
# names Felixsee  03130 
# names Forst  57537 76694 
# names Wiesengrund  03149 03159 
# names Gastrose-Kerkwitz  03172 
# names Atterwasch  03172 
# names Guben  03172 
# names Lutzketal  03172 
# names Pinnow-Heideland  03172 
# names Grabko  03172 
# names Peitz  03185 
# names Teichland  03185 
# names Turnow-Preilack  03185 
# names Tauer  03185 
# names Drachhausen  03185 
# names Drehnow  03185 
# names Drewitz  03197 39291 
# names Bronkow  03205 
# names Bischdorf  03205 
# names Luckaitztal  03205 03229 
# names Missen  03205 
# names Calau  03205 
# names Mlode  03205 
# names Laasow  03205 15913 
# names Bolschwitz  03205 
# names Ogrosen  03205 
# names Kemmen  03205 
# names Lipten  03205 
# names Lug  03205 76848 
# names Werchow  03205 
# names Hindenberg  03222 
# names Ragow  03222 15749 
# names Boblitz  03222 
# names Vetschau  03226 
# names Suschow  03226 
# names Leipe  03226 
# names Raddusch  03226 
# names Staupitz  03238 
# names Sallgast  03238 
# names Schadewitz  03238 
# names Dollenchen  03238 
# names Lugau  03238 
# names Gorden  03238 
# names Massen  03238 
# names Lindena  03238 
# names Lindthal  03238 
# names Betten  03238 
# names Ponnsdorf  03238 
# names Schacksdorf  03238 
# names Oppelhain  03238 
# names Finsterwalde  03238 
# names Lichterfeld  03238 
# names Gruhno  03238 
# names Fischwasser  03238 
# names Babben  03246 
# names Crinitz  03246 
# names Gahro  03246 
# names Breitenau  03249 56237 
# names Sonnewalde  03249 
# names Bahren  03249 
# names Kleinkrausnik  03249 
# names Zeckerin  03249 
# names Pahlsdorf  03249 
# names Schilda  03253 
# names Trebbus  03253 
# names Hennersdorf  03253 
# names Arenzhain  03253 
# names Doberlug-Kirchhain  03253 
# names Buchhain  03253 
# names Werenzhain  03253 
# names Nexdorf  03253 
# names Brenitz  03253 
# names Frankena  03253 
# names Leipzig  04103 04105 04107 04109 04129 04155 04157 04159 04177 04179 04205 04207 04209 04229 04249 04275 04277 04279 04289 04299 04315 04317 04318 04319 04329 04347 04349 04357 
# names Markkleeberg  04416 
# names Taucha  04425 06679 
# names Schkeuditz  04435 
# names Zwenkau  04442 
# names Borsdorf  04451 
# names Kitzen  04460 
# names Wiedemar  04509 
# names Delitzsch  04509 
# names Zschortau  04509 
# names Neukyhna  04509 
# names Krostitz  04509 
# names Zwochau  04509 
# names Rackwitz  04519 
# names Elstertrebnitz  04523 
# names Pegau  04523 
# names Groitzsch  04539 
# names Wyhratal  04552 
# names Borna  04552 
# names Regis-Breitingen  04565 
# names Kitzscher  04567 
# names Heuersdorf  04574 
# names Deutzen  04574 
# names Neukieritzsch  04575 
# names Espenhain  04579 
# names Altenburg  04600 
# names Nobitz  04603 
# names Saara  04603 07589 
# names Windischleuba  04603 
# names Meuselwitz  04610 
# names Wintersdorf  04610 
# names Lucka  04613 
# names Starkenberg  04617 
# names Monstab  04617 
# names Rositz  04617 
# names Haselbach  04617 94354 
# names Naundorf  04617 04769 04936 
# names Gerstenberg  04617 
# names Treben  04617 
# names Tegkwitz  04617 
# names Fockendorf  04617 
# names Kriebitzsch  04617 
# names Ziegelheim  04618 
# names Langenleuba-Niederhain  04618 
# names Frohnsdorf  04618 
# names Lumpzig  04626 
# names Mehna  04626 
# names Dobitschen  04626 
# names Drogen  04626 
# names Altkirchen  04626 
# names Vollmershain  04626 
# names Posterstein  04626 
# names Jonaswalde  04626 
# names Heukewalde  04626 
# names Thonhausen  04626 
# names Geithain  04643 
# names Eulatal  04651 
# names Frohburg  04654 
# names Kohren-Sahlis  04655 
# names Narsdorf  04657 
# names Grimma  04668 
# names Parthenstein  04668 
# names Otterwisch  04668 
# names Colditz  04680 
# names Belgershain  04683 
# names Naunhof  04683 
# names Nerchau  04685 
# names Mutzschen  04688 
# names Leisnig  04703 
# names Gersdorf  04703 09355 
# names Bockelwitz  04703 
# names Mochau  04720 06888 
# names Ziegra-Knobelsdorf  04720 
# names Zschaitz-Ottewig  04720 
# names Waldheim  04736 
# names Niederstriegis  04741 
# names Hartha  04746 
# names Ostrau  04749 06193 
# names Oschatz  04758 
# names Cavertitz  04758 
# names Dahlen  04774 39579 
# names Wermsdorf  04779 
# names Hohburg  04808 
# names Wurzen  04808 
# names Falkenhain  04808 
# names Thallwitz  04808 
# names Brandis  04821 
# names Machern  04827 
# names Bennewitz  04828 
# names Eilenburg  04838 
# names Jesewitz  04838 
# names Zschepplin  04838 
# names Mockrehna  04838 
# names Kossa  04849 
# names Torgau  04860 
# names Dreiheide  04860 
# names Zinna  04860 
# names Belgern  04874 
# names Dommitzsch  04880 
# names Trossin  04880 
# names Elsnig  04880 
# names Arzberg  04886 95659 
# names Beilrode  04886 
# names Schildau  04889 
# names Elsterwerda  04910 
# names Haida  04910 
# names Stolzenhain  04916 
# names Themesgrund  04916 
# names Heideeck  04916 
# names Herzberg  16835 19374 
# names Wildberg  04916 17091 72218 
# names Werchau  04916 
# names Kahla  04928 07768 
# names Schraden  04928 
# names Plessa  04928 
# names Wainsdorf  04932 
# names Saathain  04932 
# names Hirschfeld  04932 07554 08107 08144 55483 
# names Reichenhain  04932 
# names Merzdorf  04932 
# names Dreska  04934 
# names Hohenleipisch  04934 
# names Schlieben  04936 
# names Hohenbucko  04936 
# names Jagsal  04936 
# names Stechau  04936 
# names Kolochau  04936 
# names Malitschkendorf  04936 
# names Wehrhain  04936 
# names Frankenhain  04936 99330 
# names Hillmersdorf  04936 
# names Freileben  04936 
# names Lebusa  04936 
# names Halle  06108 06110 06112 06114 06116 06118 06120 06122 06124 06126 06128 06130 06132 33790 37620 49843 
# names Teutschenthal  06179 
# names Steuden  06179 
# names Schochwitz  06179 
# names Schkopau  06179 06184 06258 
# names Langenbogen  06179 
# names Holleben  06179 
# names Hohenweiden  06179 
# names Zscherben  06179 
# names Zappendorf  06179 
# names Dornstedt  06179 
# names Angersdorf  06179 
# names Bennstedt  06179 
# names Ermlitz  06184 
# names Dieskau  06184 
# names Burgliebenau  06184 
# names Lochau  06184 
# names Spickendorf  06188 
# names Sietzsch  06188 
# names Schwerz  06188 
# names Landsberg  06188 
# names Hohenthurm  06188 
# names Braschwitz  06188 
# names Brachstedt  06188 
# names Queis  06188 
# names Oppin  06188 
# names Niemberg  06188 
# names Wallwitz  06193 39291 
# names Teicha  06193 
# names Sennewitz  06193 
# names Krosigk  06193 
# names Gutenberg  06193 55595 
# names Petersberg  06193 07616 36100 66989 
# names Nehlitz  06193 
# names Nauendorf  06193 99448 
# names Morl  06193 
# names Kloschwitz  06198 
# names Wettin  06198 
# names Fienstedt  06198 
# names Brachwitz  06198 
# names Neutz-Lettewitz  06198 
# names Beesenstedt  06198 
# names Gimritz  06198 
# names Beuna  06217 
# names Merseburg  06217 
# names Geusa  06217 
# names Tollwitz  06231 
# names Rodden  06231 
# names Kreypau  06231 
# names Oebles-Schlechtewitz  06231 
# names Nempitz  06231 
# names Spergau  06237 
# names Leuna  06237 
# names Krumpa  06242 
# names Braunsbedra  06242 
# names Knapendorf  06246 
# names Klobikau  06246 
# names Berge  14641 19348 39638 49626 
# names Milzau  06246 
# names Wallendorf  06254 54675 
# names Zweimen  06254 
# names Friedensdorf  06254 
# names Luppenau  06254 
# names Korbetha  06258 
# names Frankleben  06259 
# names Vitzenburg  06268 
# names Steigra  06268 
# names Schmon  06268 
# names Leimbach  06268 36433 53518 54673 
# names Ziegelroda  06268 
# names Querfurt  06268 
# names Oechlitz  06268 
# names Obhausen  06268 
# names Albersroda  06268 
# names Schraplau  06279 
# names Esperstedt  06279 06567 
# names Alberstedt  06279 
# names Volkstedt  06295 
# names Schmalzerode  06295 
# names Rottelsdorf  06295 
# names Rothenschirmbach  06295 
# names Hornburg  06295 38315 
# names Hedersleben  06295 06458 
# names Wolferode  06295 
# names Dederstedt  06295 
# names Burgsdorf  06295 
# names Bornstedt  06295 39343 
# names Bischofrode  06295 
# names Polleben  06295 
# names Osterhausen  06295 
# names Neehausen  06295 
# names Siersleben  06308 
# names Siebigerode  06308 
# names Klostermansfeld  06308 
# names Augsdorf  06308 
# names Annarode  06308 
# names Benndorf  06308 
# names Helbra  06311 
# names Hergisdorf  06313 
# names Wimmelburg  06313 
# names Ahlsdorf  06313 
# names Stedten  06317 
# names Seeburg  06317 14476 37136 
# names Erdeborn  06317 
# names Aseleben  06317 
# names Amsdorf  06317 
# names Walbeck  06333 39356 
# names Sylda  06333 
# names Ritterode  06333 
# names Hettstedt  06333 
# names Harkerode  06333 
# names Wiederstedt  06333 
# names Welfesholz  06333 
# names Welbsleben  06333 
# names Endorf  06333 
# names Quenstedt  06333 
# names Neuplatendorf  06333 
# names Arnstedt  06333 
# names Greifenhagen  06333 
# names Vatterode  06343 
# names Biesenrode  06343 
# names Piskaborn  06343 
# names Mansfeld  06343 
# names Gorenzen  06343 
# names Ihlewitz  06347 
# names Heiligenthal  06347 21394 
# names Zabenstedt  06347 
# names Gerbstedt  06347 
# names Friedeburg  06347 26446 
# names Freist  06347 
# names Trinum  06369 
# names Schortewitz  06369 
# names Riesdorf  06369 
# names Reupzig  06369 
# names Zehbitz  06369 
# names Zabitz  06369 
# names Wulfen  06369 
# names Drosa  06369 
# names Dornbock  06369 
# names Dohndorf  06369 
# names Diebzig  06369 
# names Cosa  06369 
# names Radegast  06369 18239 
# names Prosigk  06369 
# names Arensdorf  06369 
# names Glauzig  06369 
# names Aken  06385 
# names Scheuder  06386 
# names Hinsdorf  06386 
# names Elsnigk  06386 
# names Quellendorf  06386 
# names Osternienburg  06386 
# names Micheln  06386 
# names Meilendorf  06386 
# names Libbesdorf  06386 
# names Reppichau  06386 
# names Wieskau  06388 
# names Edderitz  06388 
# names Piethen  06388 
# names Maasdorf  06388 
# names Baasdorf  06388 
# names Bernburg  06406 
# names Latdorf  06408 
# names Ilberstedt  06408 
# names Wohlsdorf  06408 
# names Biendorf  06408 18230 
# names Poley  06408 
# names Aderstedt  06408 38838 
# names Baalberge  06408 
# names Rothenburg  06420 
# names Lebendorf  06420 
# names Zickeritz  06420 
# names Wiendorf  06420 18258 
# names Gerlebogk  06420 
# names Edlau  06420 
# names Domnitz  06420 
# names Golbitz  06420 
# names Strenznaundorf  06425 
# names Schackstedt  06425 
# names Belleben  06425 
# names Beesenlaublingen  06425 
# names Wedlitz  06429 
# names Gerbitz  06429 
# names Pobzig  06429 
# names Neugattersleben  06429 
# names Schadeleben  06449 
# names Schackenthal  06449 
# names Winningen  06449 56333 
# names Wilsleben  06449 
# names Westdorf  06449 
# names Friedrichsaue  06449 
# names Cochstedt  06449 
# names Aschersleben  06449 
# names Giersleben  06449 
# names Sandersleben  06456 
# names Freckleben  06456 
# names Drohndorf  06456 
# names Mehringen  06456 
# names Heteborn  06458 
# names Hausneindorf  06458 
# names Wedderstedt  06458 
# names Ermsleben  06463 
# names Radisleben  06463 
# names Meisdorf  06463 
# names Reinstedt  06463 
# names Frose  06464 
# names Gatersleben  06466 
# names Hoym  06467 
# names Nachterstedt  06469 
# names Westerhausen  06484 
# names Ditfurt  06484 
# names Quedlinburg  06484 
# names Schielo  06493 
# names Harzgerode  06493 
# names Dankerode  06493 
# names Neudorf  06493 
# names Ballenstedt  06493 
# names Weddersleben  06502 
# names Warnstedt  06502 
# names Thale  06502 
# names Neinstedt  06502 
# names Timmenrode  06507 
# names Stecklenberg  06507 
# names Siptenfelde  06507 
# names Rieder  06507 
# names Friedrichsbrunn  06507 
# names Allrode  06507 
# names Gernrode  06507 37339 
# names Sangerhausen  06526 
# names Wallhausen  06528 55595 74599 
# names Sotterhausen  06528 
# names Riethnordhausen  06528 99195 
# names Riestedt  06528 
# names Kleinleinungen  06528 
# names Horla  06528 
# names Holdenstedt  06528 
# names Hainrode  06528 99735 
# names Wettelrode  06528 
# names Grillenberg  06528 
# names Emseloh  06528 
# names Edersleben  06528 
# names Drebsdorf  06528 
# names Breitenbach  06528 06712 37327 66916 
# names Blankenheim  06528 53945 
# names Beyernaumburg  06528 
# names Obersdorf  06528 
# names Morungen  06528 
# names Martinsrieth  06528 
# names Liedersdorf  06528 
# names Lengefeld  06528 09514 
# names Gonna  06528 
# names Hayn  06536 
# names Wolfsberg  06536 98704 
# names Wickerode  06536 
# names Dietersdorf  06536 
# names Breitungen  06536 98597 
# names Questenberg  06536 
# names Berga  06536 
# names Bennungen  06536 
# names Tilleda  06537 
# names Kelbra  06537 
# names Katharinenrieth  06542 
# names Wolferstedt  06542 
# names Winkel  06542 54558 
# names Nienstedt  06542 
# names Mittelhausen  06542 
# names Allstedt  06542 
# names Ulzigerode  06543 
# names Stangerode  06543 
# names Ritzgerode  06543 
# names Hermerode  06543 
# names Wippra  06543 
# names Wieserode  06543 
# names Friesdorf  06543 
# names Braunschwende  06543 
# names Pansfelde  06543 
# names Molmerswende  06543 
# names Alterode  06543 
# names Abberode  06543 
# names Schwenda  06547 
# names Breitenstein  06547 
# names Uftrungen  06548 
# names Rottleberode  06548 
# names Ichstedt  06556 
# names Ringleben  06556 99189 
# names Voigtstedt  06556 
# names Bretleben  06556 
# names Reinsdorf  06556 06642 08141 
# names Borxleben  06556 
# names Kalbsrieth  06556 
# names Artern  06556 
# names Heygendorf  06556 
# names Steinthaleben  06567 
# names Seega  06567 
# names Rottleben  06567 
# names Gehofen  06571 
# names Wiehe  06571 
# names Donndorf  06571 
# names Nausitz  06571 
# names Etzleben  06577 
# names Gorsleben  06577 
# names Hauteroda  06577 
# names Oberheldrungen  06577 
# names Hemleben  06577 
# names Heldrungen  06577 
# names Bilzingsleben  06578 
# names Oldisleben  06578 
# names Kannawurf  06578 
# names Utenbach  06618 
# names Leislau  06618 
# names Janisroda  06618 
# names Wethau  06618 
# names Casekirchen  06618 
# names Naumburg  06618 34311 
# names Molau  06618 
# names Mertendorf  06618 07619 
# names Gieckau  06618 
# names Taugwitz  06628 
# names Spielberg  06628 
# names Schleberoda  06632 
# names Zeuchfeld  06632 
# names Freyburg  06632 
# names Ebersroda  06632 
# names Branderoda  06632 
# names Baumersroda  06632 
# names Gleina  06632 
# names Laucha  06636 99880 
# names Kirchscheidungen  06636 
# names Hirschroda  06636 
# names Burgscheidungen  06636 
# names Golzen  06636 
# names Karsdorf  06638 
# names Wangen  06642 73117 
# names Wohlmirstedt  06642 
# names Bucha  06642 07389 07751 
# names Nebra  06642 
# names Memleben  06642 
# names Altenroda  06642 
# names Thalwinkel  06647 
# names Steinburg  06647 22964 
# names Saubach  06647 
# names Kahlwinkel  06647 
# names Wischroda  06647 
# names Burkersroda  06647 
# names Billroda  06647 
# names Lossa  06647 
# names Bibra  07768 98631 
# names Tromsdorf  06648 
# names Herrengosserstedt  06648 
# names Eckartsberga  06648 
# names Burgholzhausen  06648 
# names Uichteritz  06667 
# names Tagewerben  06667 
# names Storkau  06667 
# names Langendorf  06667 06729 29484 
# names Burgwerben  06667 
# names Prittitz  06667 
# names Pretzsch  06667 
# names Markwerben  06667 
# names Reichardtswerben  06667 
# names Goseck  06667 
# names Webau  06679 
# names Zorbau  06679 
# names Muschwitz  06679 
# names Trebnitz  06682 
# names Teuchern  06682 
# names Schelkau  06682 
# names Werschen  06682 
# names Deuben  06682 
# names Nessa  06682 
# names Starsiedel  06686 
# names Rippach  06686 
# names Dehlitz  06686 
# names Poserna  06686 
# names Schkortleben  06688 
# names Wengelsdorf  06688 
# names Schellbach  06712 
# names Kretzschau  06712 
# names Heuckewalde  06712 
# names Haynsburg  06712 
# names Zeitz  06712 
# names Wittgendorf  06712 07318 
# names Draschwitz  06712 
# names Bornitz  06712 
# names Bergisdorf  06712 
# names Grana  06712 
# names Waldau  06721 
# names Unterkaka  06721 
# names Osterfeld  06721 
# names Meineweh  06721 
# names Goldschau  06721 
# names Kleinhelmsdorf  06722 
# names Wetterzeube  06722 
# names Weickelsdorf  06722 
# names Spora  06724 
# names Kayna  06724 
# names Reuden  06725 39264 
# names Profen  06725 
# names Nonnewitz  06727 
# names Luckenau  06727 
# names Rehmsdorf  06729 
# names Bitterfeld  06749 
# names Thalheim  06766 
# names Wolfen  06766 
# names Bobbau  06766 
# names Uthausen  06773 
# names Selbitz  06773 95152 
# names Rotta  06773 
# names Radis  06773 
# names Bergwitz  06773 
# names Gossa  06773 
# names Kemberg  06773 06901 
# names Tornau  06774 06779 
# names Schwemsal  06774 
# names Schlaitz  06774 
# names Krina  06774 
# names Pouch  06774 
# names Plodda  06774 
# names Thurland  06779 
# names Schierau  06779 
# names Salzfurtkapelle  06779 
# names Retzau  06779 
# names Marke  06779 
# names Raguhn  06779 
# names Stumsdorf  06780 
# names Schrenz  06780 
# names Heideloh  06780 
# names Sandersdorf  06780 06792 06794 
# names Schleesen  06785 
# names Kakau  06785 
# names Horstdorf  06785 
# names Brandhorst  06785 
# names Oranienbaum  06785 
# names Vockerode  06786 
# names Riesigk  06786 
# names Rehsen  06786 
# names Gohrau  06786 
# names Zschornewitz  06791 
# names Zscherndorf  06794 
# names Glebitzsch  06794 
# names Renneritz  06794 
# names Ramsin  06794 
# names Brehna  06796 
# names Greppin  06803 
# names Burgkemnitz  06804 
# names Muldenstein  06804 
# names Roitzsch  06809 
# names Petersroda  06809 
# names Dessau  06842 06844 06846 06847 06849 
# names Stackelitz  06862 
# names Serno  06862 
# names Rodleben  06862 
# names Jeber-Bergfrieden  06862 
# names Hundeluft  06862 
# names Brambach  06862 
# names Senst  06869 
# names Klieken  06869 
# names Zieko  06869 
# names Griebo  06869 
# names Cobbelsdorf  06869 
# names Buko  06869 
# names Eutzsch  06888 
# names Dietrichsdorf  06888 
# names Dabrun  06888 
# names Abtsdorf  06888 
# names Leetza  06895 
# names Zahna  06895 
# names Rahnsdorf  06895 
# names Straach  06896 
# names Schmilkendorf  06896 
# names Nudersdorf  06896 
# names Wartenburg  06901 
# names Schnellin  06901 
# names Dorna  06901 
# names Rackith  06901 
# names Ateritz  06901 
# names Globig-Bleddin  06901 
# names Korgau  06905 
# names Meuro  06905 
# names Schmiedeberg  01762 16278 
# names Trebitz  06909 
# names Priesitz  06909 
# names Rade  06917 25579 
# names Seyda  06918 
# names Zemnick  06918 
# names Gentha  06918 
# names Gadegast  06918 
# names Naundorf  04617 04769 04936 
# names Seyda  06918 
# names Morxdorf  06918 
# names Mellnitz  06918 
# names Listerfehrda  06918 
# names Lebien  06922 
# names Labrun  06922 
# names Prettin  06922 
# names Plossig  06922 
# names Axien  06922 
# names Naundorf  04617 04769 04936 
# names Bethau  06925 
# names Purzien  06925 
# names Annaburg  06925 
# names Kleinkorga  06926 
# names Holzdorf  06926 24364 
# names Buschkuhnsdorf  06926 
# names Premsendorf  06926 
# names Neuerstadt  06926 
# names Reicho  06926 
# names Arnsgereuth  07318 
# names Probstzella  07330 
# names Unterwellenborn  07333 
# names Kamsdorf  07334 
# names Birkigt  07336 
# names Drognitz  07338 
# names Altenbeuthen  07338 
# names Hohenwarte  07338 
# names Leutenberg  07338 
# names Kaulsdorf  07338 
# names Wurzbach  07343 
# names Lehesten  07349 07778 
# names Lobenstein  07356 
# names Harra  07366 
# names Blankenberg  07366 19412 
# names Pottiga  07366 
# names Blankenstein  07366 
# names Saalburg-Ebersdorf  07368 07929 
# names Remptendorf  07368 
# names Oppurg  07381 
# names Moxa  07381 
# names Wernburg  07381 
# names Solkwitz  07381 
# names Oberoppurg  07381 
# names Paska  07381 
# names Bodelwitz  07381 
# names Nimritz  07381 
# names Langenorla  07381 
# names Lausnitz  01936 
# names Wilhelmsdorf  07389 88271 91489 
# names Knau  07389 
# names Gertewitz  07389 
# names Schmorda  07389 
# names Keila  07389 
# names Ranis  07389 
# names Seisla  07389 
# names Peuschen  07389 
# names Quaschwitz  07389 
# names Grobengereuth  07389 
# names Rudolstadt  07407 
# names Heilingen  07407 
# names Remda-Teichel  07407 
# names Rottenbach  07422 91187 91341 
# names Blankenburg  38889 99955 
# names Bechstedt  07426 
# names Oberhain  07426 
# names Allendorf  07426 56370 
# names Schwarzburg  07427 
# names Sitzendorf  07429 
# names Rohrbach  07429 55490 55776 76865 85296 99439 
# names Gera  07545 07546 07548 07549 07551 07552 
# names Brahmenau  07554 
# names Bethenhausen  07554 
# names Kauern  07554 
# names Schwaara  07554 
# names Hundhaupten  07557 
# names Bocka  07557 
# names Zedlitz  07557 
# names Crimla  07557 
# names Teichwitz  07570 
# names Weida  07570 
# names Steinsdorf  07570 
# names Gauern  07580 
# names Paitzdorf  07580 
# names Weida  07570 
# names Hilbersdorf  07580 09627 
# names Braunichswalde  07580 
# names Ronneburg  07580 63549 
# names Caaschwitz  07586 
# names Kraftsdorf  07586 
# names Hartmannsdorf  07586 07613 09232 
# names Lindenkreuz  07589 
# names Lederhose  07589 
# names Heideland  07607 
# names Hainspitz  07607 
# names Eisenberg  07607 67304 87637 
# names Seifartsdorf  07613 
# names Rauda  07613 
# names Walpernhain  07613 
# names Silbitz  07613 
# names Rauschwitz  07616 
# names Nausnitz  07616 
# names Poxdorf  07616 91099 
# names Serba  07616 
# names Reichenbach  07629 55776 93189 96358 
# names Schleifreisen  07629 
# names Tautenhain  07639 
# names Kleinbockedra  07646 
# names Ruttersdorf-Lotschen  07646 
# names Bollberg  07646 
# names Geisenhain  07646 
# names Lippersdorf-Erdmannsdorf  07646 
# names Meusebach  07646 
# names Rausdorf  07646 22929 
# names Tautendorf  07646 
# names Bremsnitz  07646 
# names Eineborn  07646 
# names Rattelsdorf  07646 96179 
# names Laasdorf  07646 
# names Bobeck  07646 
# names Quirla  07646 
# names Albersdorf  07646 25767 
# names Stadtroda  07646 
# names Unterbodnitz  07646 
# names Scheiditz  07646 
# names Karlsdorf  07646 
# names Oberbodnitz  07646 
# names Kleinebersdorf  07646 
# names Waldeck  07646 34513 
# names Ottendorf  07646 24107 
# names Gneus  07646 
# names Tissa  07646 
# names Renthendorf  07646 
# names Trockenborn-Wolfersdorf  07646 
# names Jena  07743 07745 07747 07749 
# names Sulza  07751 
# names Golmsdorf  07751 
# names Milda  07751 
# names Rothenstein  07751 
# names Bibra  07768 98631 
# names Eichenberg  07768 98553 
# names Altenberga  07768 
# names Seitenroda  07768 
# names Hummelshain  07768 
# names Lindig  07768 
# names Gumperda  07768 
# names Freienorla  07768 
# names Kleineutersdorf  07768 
# names Thierschneck  07774 
# names Wichmar  07774 
# names Camburg  07774 
# names Tautenburg  07778 
# names Hainichen  07778 09661 
# names Dornburg  07778 39264 65599 
# names Zimmern  07778 
# names Dorndorf-Steudnitz  07778 
# names Neustadt  37345 
# names Dreba  07806 
# names Lausnitz  01936 
# names Neustadt  37345 
# names Weira  07806 
# names Neustadt  37345 
# names Schmieritz  07819 
# names Dreitzsch  07819 
# names Lemnitz  07819 
# names Rosendorf  07819 
# names Pillingsdorf  07819 
# names Miesitz  07819 
# names Geroda  07819 97779 
# names Triptis  07819 
# names Schleiz  07907 
# names Dragensdorf  07907 
# names Plothen  07907 
# names Tegau  07907 
# names Dittersdorf  07907 
# names Oettersdorf  07907 
# names Kirschkau  07919 
# names Tanna  07922 
# names Volkmannsdorf  07924 
# names Crispendorf  07924 
# names Gefell  07926 54552 
# names Hirschberg  07927 65558 
# names Zeulenroda  07937 
# names Silberfeld  07937 
# names Langenwolschendorf  07937 
# names Zadelsdorf  07937 
# names Merkendorf  07950 91732 
# names Staitz  07950 
# names Wiebelsdorf  07950 
# names Triebes  07950 
# names Pausa  07952 
# names Braunsdorf  07955 
# names Auma  07955 
# names Hain  07957 
# names Langenwetzendorf  07957 
# names Hohenleuben  07958 
# names Greiz  07973 
# names Wildetaube  07980 
# names Neugernsdorf  07980 
# names Lunzig  07980 
# names Elsterberg  07985 
# names Mohlsdorf  07987 
# names Teichwolframsdorf  07989 
# names Zwickau  08056 08058 08060 08062 08064 08066 
# names Kirchberg  08107 55481 84434 
# names Hartmannsdorf  07586 07613 09232 
# names Kirchberg  08107 55481 84434 
# names Lichtentanne  08115 
# names Hartenstein  08118 91235 
# names Wildenfels  08134 
# names Crinitzberg  08147 
# names Werda  08223 
# names Rodewisch  08228 
# names Treuen  08233 
# names Ellefeld  08236 
# names Steinberg  08237 24972 92449 
# names Bergen  08239 29303 55608 83346 91790 
# names Markneukirchen  08258 
# names Erlbach  08265 84567 
# names Zwota  08267 
# names Aue  08280 
# names Schneeberg  08289 63936 
# names Schlema  08301 
# names Eibenstock  08309 
# names Bernsbach  08315 
# names Zschorlau  08321 
# names Bockau  08324 
# names Sosa  08326 
# names Beierfeld  08340 
# names Erlabrunn  08349 97250 
# names Johanngeorgenstadt  08349 
# names Markersbach  08352 
# names Raschau  08352 
# names Glauchau  08371 
# names Remse  08373 
# names Dennheritz  08393 
# names Meerane  08393 
# names Waldenburg  08396 74638 
# names Oberwiera  08396 
# names Werdau  08412 
# names Leubnitz  08412 
# names Fraureuth  08427 
# names Langenbernsdorf  08428 
# names Crimmitschau  08451 
# names Heinsdorfergrund  08468 
# names Lengenfeld  08485 
# names Netzschkau  08491 
# names Limbach  08491 55606 57629 74838 
# names Neumark  08496 99439 
# names Mylau  08499 
# names Plauen  08523 08525 08527 08529 
# names Reuth  08538 54597 
# names Burgstein  08538 
# names Weischlitz  08538 
# names Mehltheuer  08539 
# names Theuma  08541 
# names Neuensalz  08541 
# names Syrau  08548 
# names Oelsnitz  08606 
# names Tirpersdorf  08606 
# names Eichigt  08626 
# names Adorf  08626 
# names Brambach  06862 
# names Chemnitz  09111 09112 09113 09114 09116 09117 09119 09120 09122 09123 09125 09126 09127 09130 09131 
# names Limbach-Oberfrohna  09212 
# names Burkhardtsdorf  09235 
# names Niederfrohna  09243 
# names Lichtenau  09244 33165 77839 91586 
# names Taura  09249 
# names Wechselburg  09306 
# names Erlau  09306 
# names Zettlitz  09306 
# names Seelitz  09306 
# names Rochlitz  09306 
# names Penig  09322 
# names Geringswalde  09326 
# names Lunzenau  09328 
# names Callenberg  09337 
# names Hohenstein-Ernstthal  09337 
# names Oberlungwitz  09353 
# names Niederdorf  09366 
# names Erlbach-Kirchberg  09385 
# names Gornsdorf  09390 
# names Auerbach  09392 94530 
# names Hohndorf  09394 24217 
# names Hormersdorf  09395 
# names Zschopau  09405 
# names Thum  09419 
# names Ehrenfriedersdorf  09427 
# names Wolkenstein  09429 
# names Drebach  09430 
# names Venusberg  09430 
# names Scharfenstein  09435 
# names Amtsberg  09439 
# names Annaberg-Buchholz  09456 
# names Mildenau  09456 
# names Sehmatal  09465 
# names Geyer  09468 
# names Tannenberg  09468 
# names Crottendorf  09474 
# names Elterlein  09481 
# names Scheibenberg  09481 
# names Oberwiesenthal  09484 
# names Schlettau  09487 
# names Wiesa  09488 
# names Marienberg  09496 
# names Pobershau  09496 
# names Pockau  09509 
# names Pfaffroda  09526 
# names Heidersdorf  09526 
# names Olbernhau  09526 
# names Deutschneudorf  09548 
# names Falkenau  09569 
# names Frankenstein  09569 67468 
# names Gahlenz  09569 
# names Oederan  09569 
# names Leubsdorf  09573 53547 
# names Augustusburg  09573 
# names Eppendorf  09575 
# names Niederwiesa  09577 
# names Borstendorf  09579 
# names Freiberg  09599 
# names Brand-Erbisdorf  09618 
# names Sayda  09619 
# names Sayda  09619 
# names Frauenstein  09623 
# names Bobritzsch  09627 
# names Reinsberg  09629 
# names Siebenlehn  09634 
# names Kriebstein  09648 
# names Mittweida  09648 
# names Altmittweida  09648 
# names Tiefenbach  09661 55471 84184 88422 93464 94113 
# names Striegistal  09661 
# names Rossau  09661 39606 
# names Berlin  10115 10117 10119 10178 10179 10243 10245 10247 10249 10315 10317 10318 10319 10365 10367 10369 10405 10407 10409 10435 10437 10439 10551 10553 10555 10557 10559 10585 10587 10589 10623 10625 10627 10629 10707 10709 10711 10713 10715 10717 10719 10777 10779 10781 10783 10785 10787 10789 10823 10825 10827 10829 10961 10963 10965 10967 10969 10997 10999 12043 12045 12047 12049 12051 12053 12055 12057 12059 12099 12101 12103 12105 12107 12109 12157 12159 12161 12163 12165 12167 12169 12203 12205 12207 12209 12247 12249 12277 12279 12305 12307 12309 12347 12349 12351 12353 12355 12357 12359 12435 12437 12439 12459 12487 12489 12524 12526 12527 12529 12555 12557 12559 12587 12589 12619 12621 12623 12627 12629 12679 12681 12683 12685 12687 12689 13051 13053 13055 13057 13059 13086 13088 13089 13125 13127 13129 13156 13158 13159 13187 13189 13347 13349 13351 13353 13355 13357 13359 13403 13405 13407 13409 13435 13437 13439 13465 13467 13469 13503 13505 13507 13509 13581 13583 13585 13587 13589 13591 13593 13595 13597 13599 13627 13629 14050 14052 14053 14055 14057 14059 14089 14109 14129 14163 14165 14167 14169 14193 14195 14197 14199 
# names Potsdam  14467 14469 14471 14473 14478 14480 14482 
# names Fahrland  14476 
# names Fahrland  14476 
# names Satzkorn  14476 
# names Uetz-Paaren  14476 
# names Marquardt  14476 
# names Golm  14476 
# names Teltow  14513 
# names Nudow  14532 
# names Stahnsdorf  14532 
# names Philippsthal  14532 
# names Kleinmachnow  14532 
# names Fahlhorst  14532 
# names Schwielowsee  14542 14548 
# names Werder  15345 17089 19386 
# names Beelitz  14547 39596 
# names Krielow  14550 
# names Derwitz  14550 
# names Bochow  14550 
# names Schmergow  14550 
# names Deetz  14550 39264 
# names Fresdorf  14552 
# names Michendorf  14552 
# names Wildenbruch  14552 
# names Saarmund  14552 
# names Tremsdorf  14552 
# names Langerwisch  14557 
# names Wilhelmshorst  14557 
# names Falkensee  14612 
# names Paulinenaue  14641 
# names Wustermark  14641 
# names Tremmen  14641 
# names Tietzow  14641 
# names Lietzow  14641 18528 
# names Retzow  14641 19395 
# names Nauen  14641 
# names Zeestow  14641 
# names Pessin  14641 
# names Pausin  14641 
# names Berge  14641 19348 39638 49626 
# names Bergerdamm  14641 
# names Wansdorf  14641 
# names Bredow  14641 
# names Ribbeck  14641 
# names Perwenitz  14641 
# names Etzin  14641 
# names Kienberg  14641 83361 
# names Wachow  14641 
# names Selbelang  14641 
# names Markee  14641 
# names Falkenrehde  14641 
# names Brieselang  14656 
# names Friesack  14662 
# names Warsow  14662 19075 
# names Vietznitz  14662 
# names Ketzin  14669 
# names Zachow  14669 
# names Rathenow  14712 
# names Vieritz  14715 
# names Jerchel  14715 39517 39638 
# names Nennhausen  14715 
# names Kriele  14715 
# names Liepe  14715 16248 
# names Bamme  14715 
# names Havelaue  14715 14728 
# names Stechow-Ferchesar  14715 
# names Nitzahn  14715 
# names Kotzen  14715 
# names Zollchow  14715 
# names Landin  14715 
# names Milow  14715 19300 
# names Seeblick  14715 
# names Schollene  14715 
# names Premnitz  14727 
# names Gollenberg  14728 55767 
# names Rhinow  14728 
# names Jeserig  14778 
# names Planebruch  14778 14822 
# names Wust  14778 39524 
# names Wollin  14778 17328 
# names Havelsee  14778 14798 
# names Roskow  14778 
# names Wenzlow  14778 
# names Schenkenberg  14778 17291 
# names Gollwitz  14778 
# names Beetzseeheide  14778 
# names Golzow  14778 15328 
# names Trechwitz  14778 
# names Planetal  14778 14806 
# names Beetzsee  14778 
# names Wusterwitz  14789 
# names Bensdorf  14789 
# names Rosenau  14789 
# names Rottstock  14793 
# names Ziesar  14793 
# names Buckautal  14793 
# names Hagelberg  14806 
# names Belzig  14806 
# names Schwanebeck  14806 16341 39397 
# names Borkheide  14822 
# names Borkwalde  14822 
# names Linthe  14822 
# names Niemegk  14823 
# names Wiesenburg  14827 
# names Nuthe-Urstromtal  14913 
# names Wahlsdorf  14913 
# names Ihlow  14913 15377 26632 
# names Niebendorf-Heinsdorf  14913 
# names Herbersdorf  14913 
# names Hohenseefeld  14913 
# names Treuenbrietzen  14929 
# names Luckenwalde  14943 
# names Trebbin  14959 
# names Ludwigsfelde  14974 
# names Thyrow  14974 
# names Jacobsdorf  15236 
# names Treplin  15236 
# names Ziltendorf  15295 
# names Wiesenau  15295 
# names Brieskow-Finkenheerd  15295 
# names Grunow-Dammendorf  15299 
# names Mixdorf  15299 
# names Vierlinden  15306 
# names Gusow-Platkow  15306 
# names Falkenhagen  15306 16928 
# names Lindendorf  15306 
# names Werbig  15306 
# names Lietzen  15306 
# names Seelow  15306 
# names Neutrebbin  15320 
# names Neuhardenberg  15320 
# names Sietzing  15320 
# names Ortwig  15324 
# names Neuendorf  18246 38486 54597 97788 
# names Neubarnim  15324 
# names Loose  24366 
# names Kienitz  15324 
# names Kiehnwerder  15324 
# names Letschin  15324 
# names Lebus  15326 
# names Podelzig  15326 
# names Zeschdorf  15326 
# names Reitwein  15328 
# names Zechin  15328 
# names Bleyen-Genschmar  15328 
# names Strausberg  15344 
# names Oberbarnim  15345 15377 
# names Garzau-Garzin  15345 
# names Lichtenow  15345 
# names Rehfelde  15345 
# names Zinndorf  15345 
# names Petershagen-Eggersdorf  15345 15370 
# names Altlandsberg  15345 
# names Werder  15345 17089 19386 
# names Dahlwitz-Hoppegarten  15366 
# names Neuenhagen  16259 
# names Berlin  10115 10117 10119 10178 10179 10243 10245 10247 10249 10315 10317 10318 10319 10365 10367 10369 10405 10407 10409 10435 10437 10439 10551 10553 10555 10557 10559 10585 10587 10589 10623 10625 10627 10629 10707 10709 10711 10713 10715 10717 10719 10777 10779 10781 10783 10785 10787 10789 10823 10825 10827 10829 10961 10963 10965 10967 10969 10997 10999 12043 12045 12047 12049 12051 12053 12055 12057 12059 12099 12101 12103 12105 12107 12109 12157 12159 12161 12163 12165 12167 12169 12203 12205 12207 12209 12247 12249 12277 12279 12305 12307 12309 12347 12349 12351 12353 12355 12357 12359 12435 12437 12439 12459 12487 12489 12524 12526 12527 12529 12555 12557 12559 12587 12589 12619 12621 12623 12627 12629 12679 12681 12683 12685 12687 12689 13051 13053 13055 13057 13059 13086 13088 13089 13125 13127 13129 13156 13158 13159 13187 13189 13347 13349 13351 13353 13355 13357 13359 13403 13405 13407 13409 13435 13437 13439 13465 13467 13469 13503 13505 13507 13509 13581 13583 13585 13587 13589 13591 13593 13595 13597 13599 13627 13629 14050 14052 14053 14055 14057 14059 14089 14109 14129 14163 14165 14167 14169 14193 14195 14197 14199 
# names Fredersdorf-Vogelsdorf  15370 
# names Buckow  15377 
# names Waldsieversdorf  15377 
# names Hennickendorf  15378 
# names Herzfelde  15378 17268 
# names Rauen  15518 
# names Briesen  03096 15757 
# names Madlitz-Wilmersdorf  15518 
# names Falkenberg  15518 16259 39615 84326 95685 
# names Langewahl  15518 
# names Reichenwalde  15526 
# names Rietz-Neuendorf  15526 15848 15864 
# names Spreenhagen  15528 
# names Erkner  15537 
# names Wernsdorf  15537 
# names Berlin  10115 10117 10119 10178 10179 10243 10245 10247 10249 10315 10317 10318 10319 10365 10367 10369 10405 10407 10409 10435 10437 10439 10551 10553 10555 10557 10559 10585 10587 10589 10623 10625 10627 10629 10707 10709 10711 10713 10715 10717 10719 10777 10779 10781 10783 10785 10787 10789 10823 10825 10827 10829 10961 10963 10965 10967 10969 10997 10999 12043 12045 12047 12049 12051 12053 12055 12057 12059 12099 12101 12103 12105 12107 12109 12157 12159 12161 12163 12165 12167 12169 12203 12205 12207 12209 12247 12249 12277 12279 12305 12307 12309 12347 12349 12351 12353 12355 12357 12359 12435 12437 12439 12459 12487 12489 12524 12526 12527 12529 12555 12557 12559 12587 12589 12619 12621 12623 12627 12629 12679 12681 12683 12685 12687 12689 13051 13053 13055 13057 13059 13086 13088 13089 13125 13127 13129 13156 13158 13159 13187 13189 13347 13349 13351 13353 13355 13357 13359 13403 13405 13407 13409 13435 13437 13439 13465 13467 13469 13503 13505 13507 13509 13581 13583 13585 13587 13589 13591 13593 13595 13597 13599 13627 13629 14050 14052 14053 14055 14057 14059 14089 14109 14129 14163 14165 14167 14169 14193 14195 14197 14199 
# names Berlin  10115 10117 10119 10178 10179 10243 10245 10247 10249 10315 10317 10318 10319 10365 10367 10369 10405 10407 10409 10435 10437 10439 10551 10553 10555 10557 10559 10585 10587 10589 10623 10625 10627 10629 10707 10709 10711 10713 10715 10717 10719 10777 10779 10781 10783 10785 10787 10789 10823 10825 10827 10829 10961 10963 10965 10967 10969 10997 10999 12043 12045 12047 12049 12051 12053 12055 12057 12059 12099 12101 12103 12105 12107 12109 12157 12159 12161 12163 12165 12167 12169 12203 12205 12207 12209 12247 12249 12277 12279 12305 12307 12309 12347 12349 12351 12353 12355 12357 12359 12435 12437 12439 12459 12487 12489 12524 12526 12527 12529 12555 12557 12559 12587 12589 12619 12621 12623 12627 12629 12679 12681 12683 12685 12687 12689 13051 13053 13055 13057 13059 13086 13088 13089 13125 13127 13129 13156 13158 13159 13187 13189 13347 13349 13351 13353 13355 13357 13359 13403 13405 13407 13409 13435 13437 13439 13465 13467 13469 13503 13505 13507 13509 13581 13583 13585 13587 13589 13591 13593 13595 13597 13599 13627 13629 14050 14052 14053 14055 14057 14059 14089 14109 14129 14163 14165 14167 14169 14193 14195 14197 14199 
# names Woltersdorf  15569 16306 21516 29497 39175 
# names Zeesen  15711 
# names Schenkendorf  15711 
# names Schulzendorf  15732 16775 
# names Eichwalde  15732 
# names Zeuthen  15738 
# names Motzen  15741 
# names Bestensee  15741 
# names Wildau  15745 
# names Buchholz  16928 17209 23911 25712 31710 39579 99762 
# names Mittenwalde  15749 17268 
# names Brusendorf  15749 
# names Gallun  15749 
# names Niederlehme  15751 
# names Prieros  15752 
# names Streganz  15752 
# names Kolberg  15752 
# names Blossin  15754 
# names Senzig  15754 
# names Dolgenbrodt  15754 
# names Wolzig  15754 
# names Bindow  15754 
# names Gussow  15754 
# names Dannenreich  15754 
# names Teupitz  15755 
# names Schwerin  15755 19053 19055 19057 19059 19061 19063 
# names Oderin  15757 
# names Halbe  15757 
# names Freidorf  15757 
# names Kablow  15758 
# names Zernsdorf  15758 
# names Kummersdorf-Alexanderdorf  15806 
# names Kallinchen  15806 
# names Mellensee  15806 
# names Zossen  15806 
# names Neuendorf  18246 38486 54597 97788 
# names Nunsdorf  15806 
# names Rehagen  15806 
# names Telz  15806 
# names Gadsdorf  15806 
# names Glienick  15806 
# names Schulzendorf  15732 16775 
# names Saalow  15806 
# names Dahlewitz  15827 
# names Blankenfelde  15827 
# names Diepensee  15831 
# names Kienitz  15324 
# names Selchow  15831 
# names Mahlow  15831 
# names Rangsdorf  15834 
# names Sperenberg  15838 
# names Kummersdorf-Gut  15838 
# names Klausdorf  15838 18445 24147 
# names Tauche  15848 
# names Friedland  15848 15868 17098 37133 
# names Speichrow  15848 
# names Ragow-Merz  15848 
# names Beeskow  15848 
# names Plattkow  15848 
# names Kummersdorf  15859 
# names Storkow  17268 
# names Diensdorf-Radlow  15864 
# names Leeskow  15868 
# names Jamlitz  15868 
# names Lieberose  15868 
# names Ullersdorf  15868 
# names Doberburg  15868 
# names Schlaubetal  15890 
# names Siehdichum  15890 
# names Vogelsang  15890 
# names Neuzelle  15898 
# names Lawitz  15898 
# names Pretschen  15910 
# names Rietzneuendorf-Staakow  15910 
# names Unterspreewald  15910 
# names Schuhlen-Wiese  15910 
# names Alt-Schadow  15910 
# names Schlepzig  15910 
# names Kuschkow  15910 
# names Dollgen  15913 
# names Sacrow-Waldow  15913 
# names Mochow  15913 
# names Krugau  15913 
# names Glietz  15913 
# names Byhlen  15913 
# names Caminchen  15913 
# names Ressen-Zaue  15913 
# names Leibchel  15913 
# names Straupitz  15913 
# names Byhleguhre  15913 
# names Jessern  15913 
# names Goyatz  15913 
# names Butzen  15913 
# names Briesensee  15913 
# names Biebersdorf  15913 
# names Bersteland  15926 
# names Heideblick  15926 
# names Luckau  15926 29487 
# names Cahnsdorf  15926 
# names Schlabendorf  15926 
# names Walddrehna  15926 
# names Dahmetal  15936 
# names Steinreich  15936 15938 
# names Kasel-Golzig  15938 
# names Drahnsdorf  15938 
# names Eberswalde  16225 
# names Britz  16230 
# names Breydin  16230 
# names Melchow  16230 
# names Chorin  16230 
# names Finowfurt  16244 
# names Altenhof  16244 17209 24340 
# names Joachimsthal  16247 
# names Friedrichswalde  16247 
# names Neugrimnitz  16247 
# names Ziethen  16247 17390 23911 
# names Lunow-Stolzenhagen  16248 
# names Parsteinsee  16248 
# names Hohenfinow  16248 
# names Oderberg  16248 
# names Hohensaaten  16248 
# names Niederfinow  16248 
# names Heckelberg-Brunow  16259 
# names Oderaue  16259 
# names Beiersdorf-Freudenberg  16259 
# names Neulewin  16259 
# names Tiefensee  16259 
# names Neuenhagen  16259 
# names Hohenwutzen  16259 
# names Altglietzen  16259 
# names Bralitz  16259 
# names Bliesdorf  16269 
# names Wriezen  16269 
# names Frauenhagen  16278 
# names Bruchhagen  16278 
# names Wilmersdorf  16278 16356 16928 
# names Crussow  16278 
# names Wolletz  16278 
# names Welsow  16278 
# names Landin  14715 
# names Biesenbrow  16278 
# names Kerkow  16278 
# names Herzsprung  16278 
# names Greiffenberg  16278 
# names Gellmersdorf  16278 
# names Schmargendorf  16278 
# names Pinnow  16278 19065 
# names Pinnow  16278 19065 
# names Casekow  16306 
# names Hohenselchow  16306 
# names Wartin  16306 
# names Vierraden  16306 
# names Luckow-Petershagen  16306 
# names Stendell  16306 
# names Biesendahlshof  16306 
# names Zichow  16306 
# names Berkholz-Meyenburg  16306 
# names Friedrichsthal  16306 16515 66299 99735 
# names Blumberg  16306 16356 78176 
# names Welsebruch  16306 
# names Passow  16306 19386 
# names Geesow  16307 
# names Neurochlitz  16307 
# names Mescherin  16307 
# names Radekow  16307 
# names Hohenreinkendorf  16307 
# names Rosow  16307 
# names Tantow  16307 
# names Bernau  16321 79872 
# names Danewitz  16321 
# names Lindenberg  16321 16928 17111 67473 
# names Lobetal  16321 
# names Zepernick  16341 
# names Marienwerder  16348 
# names Wandlitz  16348 
# names Klosterfelde  16348 
# names Zerpenschleuse  16348 
# names Stolzenhagen  16348 
# names Prenden  16348 
# names Ruhlsdorf  16348 
# names Basdorf  16352 
# names Werneuchen  16356 
# names Seefeld  16356 25557 82229 
# names Krummensee  16356 
# names Eiche  16356 
# names Ahrensfelde  16356 
# names Mehrow  16356 
# names Biesenthal  16359 
# names Lanke  16359 
# names Nassenheide  16515 
# names Wensickendorf  16515 
# names Freienhagen  16515 37318 
# names Oranienburg  16515 
# names Schmachtenhagen  16515 
# names Neuholland  16515 
# names Zehlendorf  16515 
# names Malz  16515 
# names Neuendorf  18246 38486 54597 97788 
# names Stolpe  16540 17391 19372 24601 
# names Birkenwerder  16547 
# names Schildow  16552 
# names Liebenthal  16559 
# names Kreuzbruch  16559 
# names Liebenwalde  16559 
# names Hammer  16559 17358 
# names Lehnitz  16565 
# names Velten  16727 
# names Hennigsdorf  16761 
# names Kremmen  16766 
# names Germendorf  16767 
# names Leegebruch  16767 
# names Blumenow  16775 
# names Burgwall  16775 
# names Kappe  16775 
# names Badingen  16775 39579 
# names Zabelsdorf  16775 
# names Marienthal  16775 17309 67806 
# names Bredereiche  16775 
# names Krewelin  16775 
# names Tornow  16775 
# names Barsdorf  16775 
# names Mildenberg  16775 
# names Klein-Mutz  16775 
# names Gransee  16775 
# names Stechlin  16775 
# names Sonnenberg  16775 
# names Kurtschlag  16792 
# names Zehdenick  16792 
# names Wesendorf  16792 29392 
# names Altthymen  16798 
# names Himmelpfort  16798 
# names Zootzen  16798 
# names Neuruppin  16816 
# names Walsleben  16818 39606 
# names Dabergotz  16818 
# names Storbeck-Frankendorf  16818 
# names Temnitzquell  16818 
# names Linden  25791 35440 57629 66851 
# names Rheinsberg  16831 
# names Fehrbellin  16833 
# names Herzberg  16835 19374 
# names Temnitztal  16845 
# names Neustadt  37345 
# names Breddin  16845 
# names Dreetz  16845 18249 
# names Sieversdorf-Hohenofen  16845 
# names Zernitz-Lohm  16845 
# names Welle  21261 
# names Gumtow  16866 
# names Granzow  16866 
# names Kolrep  16866 
# names Demerthin  16866 
# names Dannenwalde  16866 
# names Wutike  16866 
# names Kunow  16866 
# names Vehlin  16866 
# names Barenthin  16866 
# names Vehlow  16866 
# names Schrepkow  16866 
# names Kyritz  16866 
# names Heiligengrabe  16909 
# names Woltersdorf  15569 16306 21516 29497 39175 
# names Kuhbier  16928 
# names Buchholz  16928 17209 23911 25712 31710 39579 99762 
# names Sadenbeck  16928 
# names Kehrberg  16928 
# names Steffenshagen  16928 18209 
# names Woltersdorf  15569 16306 21516 29497 39175 
# names Beveringen  16928 
# names Kuhsdorf  16928 
# names Hoppenrade  16928 18292 
# names Helle  16928 
# names Mesendorf  16928 
# names Boddin-Langnow  16928 
# names Pritzwalk  16928 
# names Kemnitz  16928 17509 
# names Vettin  16928 
# names Gerdshagen  16928 
# names Meyenburg  16945 
# names Halenbeck-Rohlsdorf  16945 
# names Putlitz  16949 
# names Triglitz  16949 
# names Neubrandenburg  17033 17034 17036 
# names Neuenkirchen  17039 17392 17498 18569 21640 21763 25792 27251 29643 48485 49586 
# names Neverin  17039 
# names Zirzow  17039 
# names Neddemin  17039 
# names Warlin  17039 
# names Sponholz  17039 
# names Staven  17039 
# names Wulkenzin  17039 
# names Trollenhagen  17039 
# names Woggersin  17039 
# names Brunn  17039 93164 98673 
# names Blankenhof  17039 
# names Beseritz  17039 
# names Altentreptow  17087 
# names Grapzow  17089 
# names Siedenbollentin  17089 
# names Gnevkow  17089 
# names Burow  17089 
# names Bartow  17089 
# names Breest  17089 
# names Grischow  17089 
# names Golchen  17089 
# names Knorrendorf  17091 
# names Wolde  17091 
# names Rosenow  17091 
# names Kriesow  17091 
# names Altenhagen  17091 18236 
# names Pripsleben  17091 
# names Breesen  17091 18334 
# names Cammin  17094 18195 
# names Burg  39288 54646 
# names Lindetal  17094 17348 17349 
# names Holldorf  17094 
# names Pragsdorf  17094 
# names Teschendorf  17094 
# names Brohm  17099 
# names Eichhorst  17099 
# names Schwanbeck  17099 
# names Glienke  17099 
# names Datzetal  17099 
# names Genzkow  17099 
# names Demmin  17109 
# names Utzedel  17111 
# names Beestland  17111 
# names Sanzkow  17111 
# names Wotenick  17111 
# names Kletzin  17111 
# names Meesiger  17111 
# names Hohenbollentin  17111 
# names Warrenzin  17111 
# names Quitzerow  17111 
# names Teusin  17111 
# names Kentzlin  17111 
# names Sommersdorf  17111 39365 
# names Borrentin  17111 
# names Beggerow  17111 
# names Hohenmocker  17111 
# names Sarow  17111 
# names Upost  17111 
# names Nossendorf  17111 
# names Sassen  17121 56767 
# names Loitz  17121 
# names Trantow  17121 
# names Jarmen  17126 
# names Kruckow  17129 
# names Schmarsow  17129 
# names Daberkow  17129 
# names Tutow  17129 
# names Bentzin  17129 
# names Duckow  17139 
# names Faulenrost  17139 
# names Basedow  17139 21483 
# names Remplin  17139 
# names Gielow  17139 
# names Kummerow  17139 18442 
# names Malchin  17139 
# names Schwinkendorf  17139 
# names Grammentin  17153 
# names Briggow  17153 
# names Bredenfelde  17153 
# names Zettemin  17153 
# names Kittendorf  17153 
# names Ritzerow  17153 
# names Ivenack  17153 
# names Neukalen  17154 
# names Wagun  17159 
# names Zarnekow  17159 
# names Brudersdorf  17159 
# names Stubbendorf  17159 18195 
# names Dargun  17159 
# names Teterow  17166 
# names Dalkendorf  17166 
# names Dahmen  17166 
# names Bristow  17166 
# names Poggelow  17168 
# names Lelkendorf  17168 
# names Sukow-Marienhof  17168 
# names Matgendorf  17168 
# names Warnkenhagen  17168 
# names Remlin  17168 
# names Levitzow  17168 
# names Prebberede  17168 
# names Boddin  17179 19243 
# names Walkendorf  17179 
# names Wasdow  17179 
# names Altkalen  17179 
# names Gnoien  17179 
# names Finkenthal  17179 
# names Torgelow  17358 
# names Schloen  17192 
# names Klink  17192 
# names Kargow  17192 
# names Varchentin  17192 
# names Lansen  17192 
# names Hinrichshagen  17194 17498 
# names Lupendorf  17194 
# names Vollrathsruhe  17194 
# names Jabel  17194 
# names Moltzow  17194 
# names Vielist  17194 
# names Klocksin  17194 
# names Bollewick  17207 
# names Kambs  17207 
# names Ludorf  17207 
# names Gotthun  17207 
# names Vipperow  17209 
# names Rogeez  17209 
# names Sietow  17209 
# names Melz  17209 
# names Zislow  17209 
# names Priborn  17209 
# names Leizen  17209 
# names Walow  17209 
# names Grabow-Below  17209 
# names Fincken  17209 
# names Satow  17209 18239 
# names Massow  17209 
# names Jaebetz  17209 
# names Stuer  17209 
# names Zepkow  17209 
# names Minzow  17209 
# names Kieve  17209 
# names Wredenhagen  17209 
# names Kogel  17213 19246 
# names Penkow  17213 
# names Malchow  17213 
# names Adamshoffnung  17213 
# names Lexow  17213 
# names Silz  17214 76857 
# names Schwerin  15755 19053 19055 19057 19059 19061 19063 
# names Lapitz  17217 
# names Mollenstorf  17217 
# names Krukow  17217 21483 
# names Puchow  17217 
# names Mallin  17217 
# names Penzlin  17217 
# names Marihn  17219 
# names Ankershagen  17219 
# names Neustrelitz  17235 
# names Carpin  17237 
# names Wokuhl-Dabelow  17237 
# names Blankensee  17237 17322 
# names Kratzeburg  17237 
# names Blumenholz  17237 
# names Godendorf  17237 
# names Userin  17237 
# names Watzkendorf  17237 
# names Hohenzieritz  17237 
# names Rechlin  17248 
# names Diemitz  17252 
# names Mirow  17252 
# names Schwarz  17252 
# names Roggentin  17252 18184 
# names Wustrow  17255 18347 29462 
# names Wesenberg  17255 23858 
# names Priepert  17255 
# names Gerswalde  17268 
# names Petznick  17268 
# names Hammelspring  17268 
# names Flieth-Stegelitz  17268 
# names Temmen-Ringenwalde  17268 
# names Densow  17268 
# names Vietmannsdorf  17268 
# names Templin  17268 
# names Klosterwalde  17268 
# names Gandenitz  17268 
# names Beutel  17268 
# names Milmersdorf  17268 
# names Gollin  17268 
# names Storkow  17268 
# names Lychen  17279 
# names Carmzow-Wallmow  17291 
# names Prenzlau  17291 
# names Uckerfelde  17291 
# names Randowtal  17291 
# names Oberuckersee  17291 
# names Gramzow  17291 
# names Nordwestuckermark  17291 
# names Krugsdorf  17309 
# names Papendorf  17309 18059 
# names Fahrenwalde  17309 
# names Pasewalk  17309 
# names Nieden  17309 
# names Viereck  17309 
# names Belling  17309 
# names Damerow  17309 
# names Zerrenthin  17309 
# names Jatznick  17309 
# names Rollwitz  17309 
# names Polzow  17309 
# names Koblentz  17309 
# names Brietzig  17309 
# names Ramin  17321 
# names Bergholz  17321 
# names Rothenklempenow  17321 
# names Glasow  17322 
# names Pampow  17322 19075 
# names Rossow  17322 
# names Grambow  17322 19071 
# names Mewegen  17322 
# names Bismark  17322 
# names Boock  17322 39606 
# names Lebehn  17322 
# names Penkun  17328 
# names Krackow  17329 
# names Nadrensee  17329 
# names Strasburg  17335 
# names Uckerland  17337 
# names Luckow  17375 
# names Luckow  17375 
# names Galenbeck  17337 
# names Blumenhagen  17337 
# names Daberkow  17129 
# names Mildenitz  17348 
# names Petersdorf  17348 86574 99735 
# names Woldegk  17348 
# names Neetzka  17349 
# names Kublank  17349 
# names Helpt  17349 
# names Miltzow  18519 
# names Voigtsdorf  17349 
# names Torgelow  17358 
# names Eggesin  17367 
# names Ahlbeck  17375 17419 
# names Hintersee  17375 
# names Grambin  17375 
# names Meiersberg  17375 
# names Liepgarten  17375 
# names Leopoldshagen  17375 
# names Luckow  17375 
# names Vogelsang-Warsin  17375 
# names Altwarp  17375 
# names Wilhelmsburg  17379 
# names Neuendorf  18246 38486 54597 97788 
# names Wietstock  17379 
# names Heinrichswalde  17379 
# names Heinrichsruh  17379 
# names Altwigshagen  17379 
# names Ferdinandshof  17379 
# names Anklam  17389 
# names Schmatzin  17390 
# names Murchin  17390 
# names Rubkow  17390 
# names Postlow  17391 
# names Iven  17391 
# names Liepen  17391 
# names Steinmocker  17391 
# names Medow  17391 
# names Krien  17391 
# names Nerdin  17391 
# names Neuendorf  18246 38486 54597 97788 
# names Krusenfelde  17391 
# names Neetzow  17391 
# names Pelsin  17392 
# names Blesewitz  17392 
# names Zinzow  17392 
# names Spantekow  17392 
# names Boldekow  17392 
# names Butzow  17392 18246 
# names Putzar  17392 
# names Drewelow  17392 
# names Japenzin  17392 
# names Sarnow  17392 
# names Rossin  17398 
# names Rathebur  17398 
# names Bargischow  17398 
# names Ducherow  17398 
# names Schwerinsburg  17398 
# names Bugewitz  17398 
# names Stolpe  16540 17391 19372 24601 
# names Usedom  17406 
# names Rankwitz  17406 
# names Usedom  17406 
# names Morgenitz  17406 
# names Garz  17419 18574 39524 
# names Dargen  17419 
# names Zirchow  17419 
# names Kamminke  17419 
# names Korswandt  17419 
# names Heringsdorf  17424 23777 
# names Mellenthin  17429 
# names Benz  17429 23970 
# names Pudagla  17429 
# names Bansin  17429 
# names Neppermin  17429 
# names Wolgast  17438 
# names Zemitz  17440 
# names Buggenhagen  17440 
# names Hohendorf  17440 
# names Pulow  17440 
# names Buddenhagen  17440 
# names Krummin  17440 
# names Lassan  17440 
# names Sauzin  17440 
# names Karlshagen  17449 
# names Trassenheide  17449 
# names Zinnowitz  17454 
# names Zempin  17459 
# names Koserow  17459 
# names Loddin  17459 
# names Greifswald  17489 17491 17493 
# names Ranzin  17495 
# names Karlsburg  17495 
# names Wrangelsburg  17495 
# names Wackerow  17498 
# names Dargelin  17498 
# names Behrenhoff  17498 
# names Levenhagen  17498 
# names Weitenhagen  17498 18461 
# names Mesekenhagen  17498 
# names Diedrichshagen  17498 
# names Dersekow  17498 
# names Breechen  17506 
# names Bandelin  17506 
# names Gribow  17506 
# names Kammin  17506 
# names Wusterhusen  17509 
# names Boltenhagen  23946 
# names Hanshagen  17509 23936 
# names Rubenow  17509 
# names Lubmin  17509 
# names Katzow  17509 
# names Loissin  17509 
# names Rostock  18055 18057 18059 18069 18106 18107 18109 18119 18146 18147 
# names Ziesendorf  18059 
# names Lambrechtshagen  18069 
# names Elmenhorst-Lichtenhagen  18107 
# names Blankenhagen  18182 
# names Bentwisch  18182 
# names Gelbensande  18182 
# names Poppendorf  18184 
# names Hohenfelde  18184 22946 24257 25358 
# names Broderstorf  18184 
# names Thulendorf  18184 
# names Steinfeld  18184 24888 76889 97854 
# names Mandelshagen  18184 
# names Sanitz  18190 
# names Grammow  18195 
# names Selpin  18195 
# names Zarnewanz  18195 
# names Tessin  18195 
# names Thelkow  18195 
# names Gnewitz  18195 
# names Nustrow  18195 
# names Dummerstorf  18196 
# names Prisannewitz  18196 
# names Kavelstorf  18196 
# names Damm  18196 19374 
# names Kessin  18196 
# names Lieblingshof  18196 
# names Kritzmow  18198 
# names Wittenbeck  18209 
# names Reddelich  18209 
# names Bartenshagen-Parkentin  18209 
# names Retschow  18211 
# names Nienhagen  18211 29336 39397 
# names Admannshagen-Bargeshagen  18211 
# names Bastorf  18230 
# names Rerik  18230 
# names Jennewitz  18230 
# names Karin  18233 
# names Kamin  18233 
# names Neubukow  18233 
# names Krempin  18233 
# names Pepelow  18233 
# names Rakow  18233 
# names Ravensberg  18233 
# names Schmadebeck  18236 
# names Heiligenhagen  18239 
# names Hanstorf  18239 
# names Reinshagen  18239 
# names Baumgarten  18246 
# names Steinhagen  18246 18442 33803 
# names Zepelin  18246 
# names Neuendorf  18246 38486 54597 97788 
# names Tarnow  18249 
# names Bernitt  18249 
# names Penzin  18249 
# names Warnow  18249 23936 
# names Rukieten  18258 
# names Benitz  18258 
# names Schwaan  18258 
# names Kassow  18258 
# names Vorbeck  18258 
# names Mistorf  18276 
# names Zehna  18276 
# names Kuhs  18276 
# names Recknitz  18276 
# names Reimershagen  18276 
# names Glasewitz  18276 
# names Gutow  18276 
# names Upahl  23936 
# names Lalendorf  18279 
# names Langhagen  18279 
# names Plaaz  18279 
# names Wattmannshagen  18279 
# names Dobbin-Linstow  18292 
# names Bellin  18292 
# names Diekhof  18299 
# names Wardow  18299 
# names Dolgen  18299 
# names Laage  18299 
# names Weitendorf  18299 19412 
# names Liessow  18299 
# names Ribnitz-Damgarten  18311 
# names Divitz-Spoldershagen  18314 
# names Saal  18317 
# names Schlemmin  18320 
# names Trinwillershagen  18320 
# names Ahrenshagen-Daskow  18320 
# names Dettmannsdorf  18320 
# names Schulenberg  18334 
# names Semlow  18334 
# names Langsdorf  18334 
# names Eixen  18334 
# names Marlow  18337 
# names Dierhagen  18347 
# names Ahrenshoop  18347 
# names Pruchten  18356 
# names Fuhlendorf  18356 24649 
# names Barth  18356 
# names Zingst  18374 
# names Wieck  18375 
# names Prerow  18375 
# names Born  39345 
# names Stralsund  18435 18437 18439 
# names Jakobsdorf  18442 
# names Wendorf  18442 19412 
# names Niepars  18442 
# names Pantelitz  18442 
# names Prohn  18445 
# names Kramerhof  18445 
# names Altenpleen  18445 
# names Preetz  18445 24211 
# names Richtenberg  18461 
# names Gremersdorf-Buchholz  18461 
# names Franzburg  18461 
# names Millienhagen-Oebelitz  18461 
# names Hugoldsdorf  18465 
# names Drechow  18465 
# names Tribsees  18465 
# names Karnin  18469 
# names Velgast  18469 
# names Grimmen  18507 
# names Elmenhorst  18510 21493 23869 23948 
# names Stoltenhagen  18510 
# names Zarrendorf  18510 
# names Wittenhagen  18510 
# names Papenhagen  18510 
# names Behnkendorf  18510 
# names Gransebieth  18513 
# names Grammendorf  18513 
# names Splietsdorf  18513 
# names Glewitz  18513 
# names Deyelsdorf  18513 
# names Brandshagen  18519 
# names Horst  18519 23883 
# names Miltzow  18519 
# names Wilmshagen  18519 
# names Reinberg  18519 
# names Kirchdorf  18519 27245 83527 93348 
# names Bergen  08239 29303 55608 83346 91790 
# names Thesenvitz  18528 
# names Buschvitz  18528 
# names Patzig  18528 
# names Zirkow  18528 
# names Sehlen  18528 
# names Parchtitz  18528 
# names Ralswiek  18528 
# names Rappin  18528 
# names Sassnitz  18546 
# names Sagard  18551 
# names Lohme  18551 
# names Glowe  18551 
# names Dranske  18556 
# names Putgarten  18556 
# names Altenkirchen  18556 57610 66903 
# names Wiek  18556 
# names Breege  18556 
# names Insel  39599 
# names Schaprode  18569 
# names Gingst  18569 
# names Ummanz  18569 
# names Trent  18569 
# names Kluis  18569 
# names Dreschvitz  18573 
# names Rambin  18573 
# names Samtens  18573 
# names Poseritz  18574 
# names Gustow  18574 
# names Karnitz  18574 
# names Zudar  18574 
# names Putbus  18581 
# names Middelhagen  18586 
# names Thiessow  18586 
# names Baabe  18586 
# names Lancken-Granitz  18586 
# names Gager  18586 
# names Sellin  18586 
# names Binz  18609 
# names Gneven  19065 
# names Godern  19065 
# names Steinfeld  18184 24888 76889 97854 
# names Leezen  19067 23816 
# names Retgendorf  19067 
# names Langen  27607 49838 63225 
# names Rubow  19067 
# names Cambs  19067 
# names Zickhusen  19069 
# names Pingelshagen  19069 
# names Seehof  19069 
# names Dalberg-Wendelstorf  19071 
# names Cramonshagen  19071 
# names Schossin  19073 
# names Stralendorf  19073 19372 
# names Holthusen  19075 
# names Rastow  19077 
# names Uelitz  19077 
# names Sukow  19079 
# names Banzkow  19079 
# names Plate  19086 
# names Ruthenbeck  19089 
# names Crivitz  19089 
# names Barnin  19089 
# names Tramm  19089 21516 
# names Demen  19089 
# names Zapel  19089 
# names Wessin  19089 
# names Pokrent  19205 
# names Kneese  19205 
# names Gadebusch  19205 
# names Roggendorf  19205 
# names Dragun  19205 
# names Krembz  19205 
# names Badow  19209 
# names Perlin  19209 
# names Renzow  19209 
# names Gottesgabe  19209 
# names Wedendorf  19217 
# names Rieps  19217 
# names Nesow  19217 
# names Holdorf  19217 49451 
# names Demern  19217 
# names Rehna  19217 
# names Thandorf  19217 
# names Dechow  19217 
# names Schlagsdorf  19217 
# names Vitense  19217 
# names Utecht  19217 
# names Carlow  19217 
# names Kuhstorf  19230 
# names Moraas  19230 
# names Picher  19230 
# names Belsch  19230 
# names Bandenitz  19230 
# names Hoort  19230 
# names Pritzier  19230 
# names Bobzin  19230 
# names Bresegard  19230 19294 
# names Hagenow  19230 
# names Setzin  19230 
# names Warlitz  19230 
# names Strohkirchen  19230 
# names Redefin  19230 
# names Gammelin  19230 
# names Toddin  19230 
# names Parum  19243 
# names Luckwitz  19243 
# names Karft  19243 
# names Tessin  18195 
# names Wittenburg  19243 
# names Dodow  19243 
# names Waschow  19243 
# names Wittenburg  19243 
# names Lehsen  19243 
# names Valluhn  19246 
# names Neuhof  19246 31195 36119 
# names Zarrentin  19246 
# names Camin  19246 
# names Lassahn  19246 
# names Bantin  19246 
# names Jessenitz  19249 
# names Garlitz  19249 
# names Boizenburg  19258 
# names Gresse  19258 
# names Wiebendorf  19258 
# names Schwanheide  19258 
# names Tessin  18195 
# names Boizenburg  19258 
# names Nostorf  19258 
# names Gallin  19258 
# names Greven  19258 48268 
# names Besitz  19258 
# names Vellahn  19260 
# names Rodenwalde  19260 
# names Bennin  19260 
# names Dersenow  19260 
# names Banzin  19260 
# names Kloddram  19260 
# names Teldau  19273 
# names Melkof  19273 
# names Brahlstorf  19273 
# names Fahrbinde  19288 
# names Leussow  19288 
# names Kummer  19288 
# names Ludwigslust  19288 
# names Warlow  19288 
# names Glaisin  19288 
# names Grebs  19294 
# names Gorlosen  19294 
# names Dadow  19294 
# names Eldena  19294 
# names Karenz  19294 
# names Krinitz  19294 
# names Niendorf  23919 23923 
# names Grabow  19300 39291 
# names Kremmin  19300 
# names Balow  19300 
# names Muchow  19300 
# names Werle  19300 
# names Prislich  19300 
# names Zierzow  19300 
# names Steesow  19300 
# names Woosmer  19303 
# names Heidhof  19303 
# names Tewswoos  19303 
# names Vielank  19303 
# names Polz  19303 
# names Neustadt-Glewe  19306 
# names Brenz  19306 
# names Blievenstorf  19306 
# names Besandten  19309 
# names Eldenburg  19309 
# names Lanz  19309 
# names Mellen  19309 
# names Wootz  19309 
# names Wittenberge  19322 
# names Weisen  19322 
# names Cumlosen  19322 
# names Breese  19322 
# names Breese  19322 
# names Viesecke  19336 
# names Kletzke  19336 
# names Netzow  19339 
# names Bendelin  19339 
# names Pirow  19348 
# names Perleberg  19348 
# names Retzin  19348 
# names Nebelin  19348 
# names Wolfshagen  19348 
# names Kleinow  19348 
# names Baek  19348 
# names Krampfer  19348 
# names Dambeck  19357 
# names Garlin  19357 
# names Boberow  19357 
# names Parchim  19370 
# names Karrenzin  19372 
# names Matzlow-Garwitz  19372 
# names Rom  19372 
# names Ziegendorf  19372 
# names Brunow  19372 
# names Spornitz  19372 
# names Herzfeld  19372 54619 
# names Severin  19374 
# names Raduhn  19374 
# names Grebbin  19374 
# names Niendorf  23919 23923 
# names Friedrichsruhe  19374 
# names Klinken  19374 
# names Mestlin  19374 
# names Suckow  19376 
# names Siggelkow  19376 
# names Tessenow  19376 
# names Marnitz  19376 
# names Broock  19386 
# names Kreien  19386 
# names Granzin  19386 
# names Lutheran  19386 
# names Gischow  19386 
# names Gallin-Kuppentin  19386 
# names Kritzow  19386 
# names Wahlstorf  19386 24211 
# names Karow  19395 39307 
# names Priborn  17209 
# names Gnevsdorf  19395 
# names Ganzlin  19395 
# names Barkow  19395 
# names Plauerhagen  19395 
# names Dobbertin  19399 
# names Techentin  19399 
# names Diestelow  19399 
# names Goldberg  19399 
# names Langenhagen  19399 30851 30853 30855 
# names Dabel  19406 
# names Witzin  19406 
# names Borkow  19406 
# names Kobrow  19406 
# names Sternberg  19406 
# names Mustin  19406 23911 
# names Langen  27607 49838 63225 
# names Kuhlen  19412 
# names Zahrensdorf  19412 
# names Bibow  19417 
# names Labenz  23898 
# names Ventschow  19417 
# names Jesendorf  19417 
# names Warin  19417 
# names Hamburg  20095 20097 20099 20144 20146 20148 20149 20249 20251 20253 20255 20257 20259 20354 20355 20357 20359 20457 20459 20535 20537 20539 21029 21031 21033 21035 21037 21039 21073 21075 21077 21079 21107 21109 21129 21147 21149 22041 22043 22045 22047 22049 22081 22083 22085 22087 22089 22111 22113 22115 22117 22119 22143 22145 22147 22149 22159 22175 22177 22179 22297 22299 22301 22303 22305 22307 22309 22335 22337 22339 22359 22391 22393 22395 22397 22399 22415 22417 22419 22453 22455 22457 22459 22523 22525 22527 22529 22547 22549 22559 22587 22589 22605 22607 22609 22761 22763 22765 22767 22769 
# names Hampuri  20095 20097 20099 20144 20146 20148 20149 20249 20251 20253 20255 20257 20259 20354 20355 20357 20359 20457 20459 20535 20537 20539 21029 21031 21033 21035 21037 21039 21073 21075 21077 21079 21107 21109 21129 21147 21149 22041 22043 22045 22047 22049 22081 22083 22085 22087 22089 22111 22113 22115 22117 22119 22143 22145 22147 22149 22159 22175 22177 22179 22297 22299 22301 22303 22305 22307 22309 22335 22337 22339 22359 22391 22393 22395 22397 22399 22415 22417 22419 22453 22455 22457 22459 22523 22525 22527 22529 22547 22549 22559 22587 22589 22605 22607 22609 22761 22763 22765 22767 22769 
# names Escheburg  21039 
# names Seevetal  21217 21218 21220 
# names Rosengarten  21224 74538 
# names Bendestorf  21227 
# names Harmstorf  21228 
# names Buchholz  16928 17209 23911 25712 31710 39579 99762 
# names Tostedt  21255 
# names Dohren  21255 39356 49770 
# names Kakenstorf  21255 
# names Wistedt  21255 
# names Handeloh  21256 
# names Otter  21259 
# names Welle  21261 
# names Jesteburg  21266 
# names Asendorf  21271 27330 
# names Hanstedt  21271 
# names Egestorf  21272 
# names Undeloh  21274 
# names Wenzendorf  21279 
# names Hollenstedt  21279 
# names Drestedt  21279 
# names Appel  21279 
# names Bleckede  21354 
# names Barum  21357 29576 
# names Wittorf  21357 
# names Bardowick  21357 
# names Mechtersen  21358 
# names Adendorf  21365 
# names Dahlenburg  21368 
# names Dahlem  21368 53949 54636 
# names Boitze  21368 
# names Nahrendorf  21369 
# names Tosterglope  21371 
# names Eyendorf  21376 
# names Salzhausen  21376 
# names Garlstorf  21376 
# names Rullstorf  21379 
# names Scharnebeck  21379 
# names Echem  21379 
# names Artlenburg  21380 
# names Brietlingen  21382 
# names Amelinghausen  21385 
# names Rehlingen  21385 
# names Oldendorf  21726 25588 
# names Betzendorf  21386 
# names Soderstorf  21388 
# names Dachtmissen  21391 
# names Reppenstedt  21391 
# names Westergellersen  21394 
# names Kirchgellersen  21394 
# names Tespe  21395 
# names Barendorf  21397 
# names Vastorf  21397 
# names Neetze  21398 
# names Reinstorf  21400 
# names Thomasburg  21401 
# names Barnstedt  21406 
# names Melbeck  21406 
# names Embsen  21409 
# names Drage  21423 25582 25878 
# names Winsen  24568 
# names Stelle  21435 
# names Marschacht  21436 
# names Brackel  21438 
# names Marxen  21439 
# names Garstedt  21441 
# names Toppenstedt  21442 
# names Wulfsen  21445 
# names Handorf  21447 
# names Radbruch  21449 
# names Wentorf  23898 
# names Hamburg  20095 20097 20099 20144 20146 20148 20149 20249 20251 20253 20255 20257 20259 20354 20355 20357 20359 20457 20459 20535 20537 20539 21029 21031 21033 21035 21037 21039 21073 21075 21077 21079 21107 21109 21129 21147 21149 22041 22043 22045 22047 22049 22081 22083 22085 22087 22089 22111 22113 22115 22117 22119 22143 22145 22147 22149 22159 22175 22177 22179 22297 22299 22301 22303 22305 22307 22309 22335 22337 22339 22359 22391 22393 22395 22397 22399 22415 22417 22419 22453 22455 22457 22459 22523 22525 22527 22529 22547 22549 22559 22587 22589 22605 22607 22609 22761 22763 22765 22767 22769 
# names Reinbek  21465 
# names Buchhorst  21481 
# names Schnakenbek  21481 
# names Lanze  21483 
# names Wangelau  21483 
# names Juliusburg  21483 
# names Dalldorf  21483 
# names Fuhlenhagen  21493 
# names Schretstaken  21493 
# names Grabau  21493 23845 
# names Sahms  21493 
# names Basthorst  21493 
# names Grove  21493 
# names Schwarzenbek  21493 
# names Talkau  21493 
# names Havekost  21493 
# names Worth  21502 85457 
# names Geesthacht  21502 
# names Hamwarde  21502 
# names Wiershop  21502 
# names Glinde  21509 39249 
# names Kankelau  21514 
# names Siebeneichen  21514 
# names Fitzen  21514 
# names Witzeeze  21514 
# names Roseburg  21514 
# names Hornbek  21514 
# names Langenlehsten  21514 
# names Schulendorf  21516 
# names Wohltorf  21521 
# names Dassendorf  21521 
# names Hittbergen  21522 
# names Brunstorf  21524 
# names Hohenhorn  21526 
# names Kollow  21527 
# names Buxtehude  21614 
# names Jork  21635 
# names Nottensdorf  21640 
# names Bliedersdorf  21640 
# names Horneburg  21640 
# names Apensen  21641 
# names Beckdorf  21643 
# names Sauensiek  21644 
# names Halvesbostel  21646 
# names Moisburg  21647 
# names Regesbostel  21649 
# names Stade  21680 21682 21683 21684 
# names Agathenburg  21684 
# names Harsefeld  21698 
# names Brest  21698 
# names Bargstedt  21698 24793 
# names Ahlerstedt  21702 
# names Drochtersen  21706 
# names Burweg  21709 
# names Himmelpforten  21709 
# names Engelschoff  21710 
# names Hammah  21714 
# names Deinste  21717 
# names Fredenbeck  21717 
# names Steinkirchen  21720 84439 
# names Guderhandviertel  21720 
# names Mittelnkirchen  21720 
# names Hollern-Twielenfleth  21723 
# names Kranenburg  21726 47559 
# names Oldendorf  21726 25588 
# names Heinbockel  21726 
# names Estorf  21727 31629 
# names Balje  21730 
# names Krummendeich  21732 
# names Oederquart  21734 
# names Wischhafen  21737 
# names Dollern  21739 
# names Hemmoor  21745 
# names Hechthausen  21755 
# names Osten  21756 
# names Osterbruch  21762 
# names Otterndorf  21762 
# names Nordleda  21765 
# names Hollnseth  21769 
# names Armstorf  21769 
# names Lamstedt  21769 
# names Mittelstenahe  21770 
# names Stinstedt  21772 
# names Odisheim  21775 
# names Ihlienworth  21775 
# names Steinau  21775 
# names Wanna  21776 
# names Cadenberge  21781 
# names Geversdorf  21784 
# names Belum  21785 
# names Oberndorf  21787 67821 
# names Wingst  21789 
# names Oststeinbek  22113 
# names Braak  22145 
# names Stapelfeld  22145 
# names Norderstedt  22844 22846 22848 22850 22851 
# names Schenefeld  22869 25560 
# names Wedel  22880 
# names Tangstedt  22889 25499 
# names Ahrensburg  22926 
# names Delingsdorf  22929 
# names Kasseburg  22929 
# names Hammoor  22929 
# names Bargteheide  22941 
# names Jersbek  22941 
# names Trittau  22946 
# names Brunsbek  22946 
# names Grande  22946 
# names Dahmker  22946 
# names Ammersbek  22949 
# names Hoisdorf  22955 
# names Linau  22959 
# names Siek  22962 
# names Todendorf  22965 
# names Witzhave  22969 
# names Stockelsdorf  23617 
# names Rehhorst  23619 
# names Zarpen  23619 
# names Hamberge  23619 
# names Heilshoop  23619 
# names Badendorf  23619 
# names Ratekau  23626 
# names Krummesse  23628 
# names Klempau  23628 
# names Scharbeutz  23683 23684 
# names Eutin  23701 
# names Malente  23714 
# names Bosau  23715 
# names Kasseedorf  23717 
# names Glasau  23719 
# names Schashagen  23730 
# names Neustadt  37345 
# names Sierksdorf  23730 
# names Altenkrempe  23730 
# names Lensahn  23738 
# names Beschendorf  23738 
# names Manhagen  23738 
# names Kabelhorst  23738 
# names Riepsdorf  23738 
# names Harmsdorf  23738 23911 
# names Damlos  23738 
# names Kellenhusen  23746 
# names Dahme  23747 
# names Grube  23749 
# names Wangels  23758 
# names Gremersdorf  23758 
# names Fehmarn  23769 
# names Heiligenhafen  23774 
# names Neukirchen  23779 25927 34626 94362 
# names Stipsdorf  23795 
# names Fahrenkrug  23795 
# names Weede  23795 
# names Schwissel  23795 
# names Traventhal  23795 
# names Schieren  23795 
# names Schackendorf  23795 
# names Wahlstedt  23812 
# names Nehms  23813 
# names Blunk  23813 
# names Geschendorf  23815 
# names Strukdorf  23815 
# names Westerrade  23815 
# names Neversdorf  23816 
# names Bebensee  23816 
# names Pronstorf  23820 
# names Rohlstorf  23821 
# names Seedorf  23823 23883 27404 
# names Tensfeld  23824 
# names Damsdorf  23824 
# names Fredesdorf  23826 
# names Bark  23826 
# names Todesfelde  23826 
# names Travenhorst  23827 
# names Wensin  23827 
# names Wittenborn  23829 
# names Neritz  23843 
# names Bahrenhof  23845 
# names Seth  23845 
# names Oering  23845 
# names Dreggers  23845 
# names Itzstedt  23845 
# names Lasbek  23847 
# names Westerau  23847 
# names Steinhorst  23847 29367 
# names Schiphorst  23847 
# names Bliestorf  23847 
# names Rethwisch  23847 25566 
# names Sierksrade  23847 
# names Kastorf  23847 
# names Boden  56412 
# names Meddewade  23847 
# names Stubben  23847 27616 
# names Grinau  23847 
# names Feldhorst  23858 
# names Barnitz  23858 
# names Heidekamp  23858 
# names Schenkenberg  14778 17291 
# names Wesenberg  17255 23858 
# names Nienwohld  23863 
# names Kayhude  23863 
# names Bargfeld-Stegen  23863 
# names Nahe  23866 
# names Niendorf  23919 23923 
# names Koberg  23881 
# names Borstorf  23881 
# names Breitenfelde  23881 
# names Lankau  23881 
# names Sterley  23883 
# names Brunsmark  23883 
# names Grambek  23883 
# names Lehmrade  23883 
# names Hollenbek  23883 
# names Walksfelde  23896 
# names Ritzerau  23896 
# names Poggensee  23896 
# names Panten  23896 
# names Nusse  23896 
# names Labenz  23898 
# names Sirksfelde  23898 
# names Wentorf  23898 
# names Sandesneben  23898 
# names Klinkrade  23898 
# names Duvensee  23898 
# names Besenthal  23899 
# names Gudow  23899 
# names Mechow  23909 
# names Fredeburg  23909 
# names Giesensdorf  23909 
# names Albsfelde  23909 
# names Ratzeburg  23909 
# names Salem  23911 88682 
# names Pogeez  23911 
# names Kulpin  23911 
# names Schmilau  23911 
# names Einhaus  23911 
# names Berkenthin  23919 
# names Niendorf  23919 23923 
# names Behlendorf  23919 
# names Rondeshagen  23919 
# names Roduchelstorf  23923 
# names Selmsdorf  23923 
# names Lockwisch  23923 
# names Menzendorf  23923 
# names Bernstorf  23936 
# names Upahl  23936 
# names Papenhusen  23936 
# names Mallentin  23936 
# names Testorf-Steinfort  23936 
# names Grieben  23936 39517 
# names Roggenstorf  23936 
# names Kalkhorst  23942 
# names Harkensee  23942 
# names Dassow  23942 
# names Boltenhagen  23946 
# names Moor-Rolofshagen  23948 
# names Damshagen  23948 
# names Wismar  23966 23968 23970 
# names Barnekow  23968 
# names Gramkow  23968 
# names Zierow  23968 
# names Schimm  23972 
# names Metelsdorf  23972 
# names Neuburg  23974 
# names Hornstorf  23974 
# names Krusenhagen  23974 
# names Blowatz  23974 
# names Boiensdorf  23974 
# names Zurow  23992 
# names Neukloster  23992 
# names Glasin  23992 
# names Passee  23992 
# names Bobitz  23996 
# names Beidendorf  23996 
# names Insel  39599 
# names Kiel  24103 24105 24106 24107 24109 24111 24113 24114 24116 24118 24143 24145 24146 24147 24148 24149 24159 
# names Quarnbek  24107 
# names Melsdorf  24109 
# names Molfsee  24113 
# names Kronshagen  24119 
# names Altenholz  24161 
# names Lehmkuhlen  24211 
# names Pohnsdorf  24211 
# names Honigsee  24211 
# names Schellhorn  24211 
# names Postfeld  24211 
# names Rastorf  24211 
# names Neudorf-Bornstein  24214 
# names Gettorf  24214 
# names Lindau  24214 39264 
# names Neuwittenbek  24214 
# names Schinkel  24214 
# names Noer  24214 
# names Wisch  24217 25876 
# names Krokau  24217 
# names Krummbek  24217 
# names Barsbek  24217 
# names Stakendorf  24217 
# names Fiefbergen  24217 
# names Bendfeld  24217 
# names Boksee  24220 
# names Flintbek  24220 
# names Techelsdorf  24220 
# names Raisdorf  24223 
# names Heikendorf  24226 
# names Strande  24229 
# names Schwedeneck  24229 
# names Dobersdorf  24232 
# names Laboe  24235 
# names Lutterbek  24235 
# names Stein  24235 
# names Wendtorf  24235 
# names Brodersdorf  24235 
# names Lammershagen  24238 
# names Selent  24238 
# names Martensrade  24238 
# names Mucheln  24238 
# names Achterwehr  24239 
# names Schierensee  24241 
# names Grevenkrug  24241 
# names Schmalstede  24241 
# names Reesdorf  24241 39291 
# names Blumenthal  24241 
# names Felde  24242 
# names Felm  24244 
# names Barmissen  24245 
# names Kirchbarkau  24245 
# names Rodenbek  24247 
# names Mielkendorf  24247 
# names Warnau  24250 39524 
# names Nettelsee  24250 
# names Bothkamp  24250 
# names Osdorf  24251 
# names Probsteierhagen  24253 
# names Fahren  24253 
# names Prasdorf  24253 
# names Passade  24253 
# names Rumohr  24254 
# names Fargau-Pratjau  24256 
# names Stoltenberg  24256 
# names Schlesen  24256 
# names Schwartbuck  24257 
# names Westensee  24259 
# names Wittmoldt  24306 
# names Lebrade  24306 
# names Rathjensdorf  24306 
# names Hohwacht  24321 
# names Klamp  24321 
# names Giekau  24321 
# names Panker  24321 
# names Helmstorf  24321 
# names Behrensdorf  24321 
# names Ascheberg  24326 59387 
# names Stocksee  24326 
# names Dersau  24326 
# names Nehmten  24326 
# names Kletkamp  24327 
# names Blekendorf  24327 
# names Grebin  24329 
# names Dannau  24329 
# names Rantzau  24329 
# names Windeby  24340 
# names Goosefeld  24340 
# names Gammelby  24340 
# names Damp  24351 
# names Thumby  24351 
# names Kosel  24354 
# names Rieseby  24354 
# names Fleckeby  24357 
# names Hummelfeld  24357 
# names Bistensee  24358 
# names Ascheffel  24358 
# names Barkelsby  24360 
# names Holzbunge  24361 
# names Damendorf  24361 
# names Haby  24361 
# names Holtsee  24363 
# names Loose  24366 
# names Osterby  24367 24994 
# names Waabs  24369 
# names Hasselberg  24376 
# names Rabel  24376 
# names Kappeln  24376 67744 
# names Arnis  24376 
# names Norderbrarup  24392 
# names Dollrottfeld  24392 
# names Wagersrott  24392 
# names Brebel  24392 
# names Kiesby  24392 
# names Scheggerott  24392 
# names Nottfeld  24392 
# names Boren  24392 
# names Ekenis  24392 
# names Saustrup  24392 
# names Gelting  24395 
# names Rabenholz  24395 
# names Pommerby  24395 
# names Nieby  24395 
# names Stangheck  24395 
# names Kronsgaard  24395 
# names Niesgrau  24395 
# names Winnemark  24398 
# names Karby  24398 
# names Brodersby  24398 24864 
# names Esgrus  24402 
# names Maasholm  24404 
# names Mohrkirch  24405 
# names Oersberg  24407 
# names Tasdorf  24536 
# names Henstedt-Ulzburg  24558 
# names Kattendorf  24568 
# names Kaltenkirchen  24568 
# names Oersdorf  24568 
# names Winsen  24568 
# names Bramstedt  27628 
# names Hagen  24576 25779 58089 58091 58093 58095 58097 58099 58119 58135 
# names Hitzhusen  24576 
# names Weddelbrook  24576 
# names Bissee  24582 
# names Hoffeld  24582 53534 
# names Wattenbek  24582 
# names Bordesholm  24582 
# names Nortorf  24589 25554 
# names Ellerdorf  24589 
# names Eisendorf  24589 
# names Borgdorf-Seedorf  24589 
# names Nortorf  24589 25554 
# names Heinkenborstel  24594 
# names Meezen  24594 
# names Jahrsdorf  24594 
# names Grauel  24594 
# names Tappendorf  24594 
# names Rade  06917 25579 
# names Hohenwestedt  24594 
# names Wapelfeld  24594 
# names Hohenwestedt  24594 
# names Remmels  24594 
# names Nindorf  24594 25704 
# names Latendorf  24598 
# names Boostedt  24598 
# names Belau  24601 
# names Ruhwinkel  24601 
# names Wankendorf  24601 
# names Trappenkamp  24610 
# names Wiedenborstel  24613 
# names Aukrug  24613 
# names Brokstedt  24616 
# names Borstel  24616 27246 
# names Hasenkrug  24616 
# names Sarlhusen  24616 
# names Willenscharen  24616 
# names Hardebek  24616 
# names Armstedt  24616 
# names Tarbek  24619 
# names Gnutz  24622 
# names Negenharrie  24625 
# names Kummerfeld  25495 
# names Hartenholm  24628 
# names Kisdorf  24629 
# names Langwedel  24631 27299 
# names Heidmoor  24632 
# names Arpsdorf  24634 
# names Padenstedt  24634 
# names Daldorf  24635 
# names Rickling  24635 
# names Schillsdorf  24637 
# names Schmalensee  24638 
# names Schmalfeld  24640 
# names Hasenmoor  24640 
# names Stuvenborn  24641 
# names Timmaspe  24644 
# names Krogaspe  24644 
# names Loop  24644 
# names Warder  24646 
# names Ehndorf  24647 
# names Wasbek  24647 
# names Wiemersdorf  24649 
# names Rendsburg  24768 
# names Rickert  24782 
# names Fockbek  24787 
# names Schacht-Audorf  24790 
# names Rade  06917 25579 
# names Rendsburg  24768 
# names Ostenfeld  24790 25872 
# names Brammer  24793 
# names Borgstedt  24794 
# names Bovenau  24796 
# names Krummwisch  24796 
# names Bredenbek  24796 
# names Breiholz  24797 
# names Friedrichsgraben  24799 
# names Christiansholm  24799 
# names Meggerdorf  24799 
# names Friedrichsholm  24799 
# names Emkendorf  24802 
# names Vollstedt  25821 
# names Bokel  24802 25364 27616 
# names Tielen  24803 
# names Erfde  24803 
# names Hamdorf  24805 
# names Prinzenmoor  24805 
# names Bargstall  24806 
# names Sophienhamm  24806 
# names Hohn  24806 56462 
# names Jevenstedt  24808 
# names Ahlefeld  24811 
# names Owschlag  24811 
# names Brekendorf  24811 
# names Rendsburg  24768 
# names Sehestedt  24814 
# names Hamweddel  24816 
# names Luhnstedt  24816 
# names Stafstedt  24816 
# names Brinjahe  24816 
# names Tetenhusen  24817 
# names Nienborstel  24819 
# names Haale  24819 
# names Schleswig  24837 
# names Kropp  24848 
# names Schuby  24850 
# names Eggebek  24852 
# names Langstedt  24852 
# names Sollerup  24852 
# names Bollingstedt  24855 
# names Fahrdorf  24857 
# names Borgwedel  24857 
# names Uelsby  24860 
# names Klappholz  24860 
# names Bergenhusen  24861 
# names Goltoft  24864 
# names Busdorf  24866 
# names Dannewerk  24867 
# names Ellingstedt  24870 
# names Havetoft  24873 
# names Havetoftloit  24875 
# names Hollingstedt  24876 25788 
# names Jagel  24878 
# names Lottorf  24878 
# names Idstedt  24879 
# names Neuberend  24879 
# names Schaalby  24882 
# names Geltorf  24884 
# names Selk  24884 
# names Sieverstedt  24885 
# names Silberstedt  24887 
# names Loit  24888 
# names Stolk  24890 
# names Schnarup-Thumby  24891 
# names Struxdorf  24891 
# names Taarstedt  24893 
# names Twedt  24894 
# names Tolk  24894 
# names Treia  24896 
# names Ulsnis  24897 
# names Wohlde  24899 
# names Flensburg  24937 24939 24941 24943 24944 
# names Flensborg  24937 24939 24941 24943 24944 
# names Jarplund-Weding  24941 
# names Tastrup  24943 
# names Harrislee  24955 
# names Munkbrarup  24960 
# names Jerrishoe  24963 
# names Tarp  24963 
# names Lindewitt  24969 
# names Quern  24972 
# names Steinbergkirche  24972 
# names Ausacker  24975 
# names Westerholz  24977 
# names Langballig  24977 
# names Grundhof  24977 
# names Ringsberg  24977 
# names Schafflund  24980 
# names Nordhackstedt  24980 
# names Meyn  24980 
# names Handewitt  24983 
# names Satrup  24986 
# names Sankelmark  24988 
# names Oeversee  24988 
# names Dollerup  24989 
# names Freienwill  24991 
# names Janneby  24992 
# names Weesby  24994 
# names Jardelund  24994 
# names Medelby  24994 
# names Holt  24994 
# names Ahneby  24996 
# names Sterup  24996 
# names Wanderup  24997 
# names Wees  24999 
# names Altenmoor  25335 
# names Elmshorn  25335 25336 25337 
# names Bokholt-Hanredder  25335 
# names Neuendorf  18246 38486 54597 97788 
# names Elmshorn  25335 25336 25337 
# names Raa-Besenbek  25335 
# names Seeth-Ekholt  25337 
# names Barmstedt  25355 
# names Bullenkuhlen  25355 
# names Heede  25355 26892 
# names Bevern  25355 37639 
# names Lutzhorn  25355 
# names Sommerland  25358 
# names Horst  18519 23883 
# names Elskop  25361 
# names Krempe  25361 
# names Grevenkop  25361 
# names Westerhorn  25364 
# names Osterhorn  25364 
# names Kiebitzreihe  25368 
# names Seester  25370 
# names Ellerhoop  25373 
# names Borsfleth  25376 
# names Krempdorf  25376 
# names Kollmar  25377 
# names Herzhorn  25379 
# names Pinneberg  25421 
# names Tornesch  25436 
# names Neuendeich  25436 
# names Uetersen  25436 
# names Heidgraben  25436 
# names Moorrege  25436 
# names Quickborn  25451 25712 
# names Rellingen  25462 
# names Halstenbek  25469 
# names Ellerbek  25474 
# names Hasloh  25474 
# names Ellerau  25479 
# names Appen  25482 
# names Langeln  25485 38871 
# names Bilsen  25485 
# names Hemdingen  25485 
# names Alveslohe  25486 
# names Holm  25488 25923 
# names Haseldorf  25489 
# names Haselau  25489 
# names Hetlingen  25491 
# names Heist  25492 
# names Borstel-Hohenraden  25494 
# names Kummerfeld  25495 
# names Prisdorf  25497 
# names Heiligenstedtenerkamp  25524 
# names Itzehoe  25524 
# names Kollmoor  25524 
# names Oelixdorf  25524 
# names Heiligenstedten  25524 
# names Breitenburg  25524 
# names Wittenbergen  25548 
# names Kellinghusen  25548 
# names Rosdorf  25548 37124 39307 64380 98590 
# names Auufer  25548 
# names Peissen  25551 
# names Schlotfeld  25551 
# names Lockstedt  25551 
# names Winseldorf  25551 
# names Silzen  25551 
# names Lohbarbek  25551 
# names Hohenlockstedt  25551 
# names Landrecht  25554 
# names Moorhusen  25554 
# names Bekdorf  25554 
# names Dammfleth  25554 
# names Kleve  25554 25779 47533 
# names Wilster  25554 
# names Krummendiek  25554 
# names Neuendorf-Sachsenbande  25554 
# names Neuendorf  18246 38486 54597 97788 
# names Wilster  25554 
# names Sachsenbande  25554 
# names Hanerau-Hademarschen  25557 
# names Steenfeld  25557 
# names Gokels  25557 
# names Bendorf  25557 56170 
# names Beldorf  25557 
# names Thaden  25557 
# names Bokhorst  25560 
# names Agethorst  25560 
# names Kaisborstel  25560 
# names Puls  25560 
# names Warringholz  25560 
# names Oldenborstel  25560 
# names Hadenfeld  25560 
# names Wulfsmoor  25563 
# names Hingstheide  25563 
# names Wrist  25563 
# names Quarnstedt  25563 
# names Hodorf  25569 
# names Kremperheide  25569 
# names Bahrenfleth  25569 
# names Krempermoor  25569 
# names Ecklak  25572 
# names Kudensee  25572 
# names Aebtissinwisch  25572 
# names Landscheide  25572 
# names Beidenfleth  25573 
# names Beringstedt  25575 
# names Brokdorf  25576 
# names Neuenbrook  25578 
# names Fitzbek  25579 
# names Poyenberg  25581 
# names Hennstedt  25581 25779 
# names Looft  25582 
# names Kaaks  25582 
# names Hohenaspe  25582 
# names Besdorf  25584 
# names Holstenniendorf  25584 
# names Tackesdorf  25585 
# names Huje  25588 
# names Mehlbek  25588 
# names Osterstedt  25590 
# names Reher  25593 
# names Christinenthal  25593 
# names Vaale  25594 
# names Nutteln  25594 
# names Vaalermoor  25594 
# names Gribbohm  25596 
# names Bokelrehm  25596 
# names Wacken  25596 
# names Breitenberg  25597 94139 
# names Westermoor  25597 
# names Moordiek  25597 
# names Kronsmoor  25597 
# names Moordorf  25597 
# names Wewelsfleth  25599 
# names Volsemenhusen  25693 
# names Gudendorf  25693 
# names Trennewurth  25693 
# names Nordermeldorf  25704 
# names Wolmersdorf  25704 
# names Meldorf  25704 
# names Bargenstedt  25704 
# names Marne  25709 
# names Marnerdeich  25709 
# names Helse  25709 
# names Kronprinzenkoog  25709 
# names Kaiser-Wilhelm-Koog  25709 
# names Diekhusen-Fahrstedt  25709 
# names Kuden  25712 
# names Hochdonn  25712 
# names Burg  39288 54646 
# names Brickeln  25712 
# names Averlak  25715 
# names Ramhusen  25715 
# names Eddelak  25715 
# names Dingen  25715 
# names Friedrichskoog  25718 
# names Busenwurth  25719 
# names Barlt  25719 
# names Eggstedt  25721 
# names Neufeld  25724 
# names Neufelderkoog  25724 
# names Schmedeswurth  25724 
# names Schafstedt  25725 
# names Bornholt  25725 
# names Frestedt  25727 
# names Krumstedt  25727 
# names Windbergen  25729 
# names Ostrohe  25746 
# names Lohe-Rickelshof  25746 
# names Heide  25746 
# names Wesseln  25746 
# names Hedwigenkoog  25761 
# names Oesterdeichstrich  25761 
# names Warwerort  25761 
# names Westerdeichstrich  25761 
# names Oesterwurth  25764 
# names Friedrichsgabekoog  25764 
# names Wesselburen  25764 
# names Hillgroven  25764 
# names Norddeich  25764 
# names Wesselburener-Deichhausen  25764 
# names Hellschen-Heringsand-Unterschaar  25764 
# names Wesselburenerkoog  25764 
# names Arkebek  25767 
# names Osterrade  25767 
# names Bunsoh  25767 
# names Hemmingstedt  25770 
# names Lieth  25770 
# names Hemme  25774 
# names Lehe  25774 26892 
# names Krempel  25774 
# names Lunden  25774 
# names Karolinenkoog  25774 
# names Groven  25774 
# names Schlichting  25776 
# names Rehm-Flehde-Bargen  25776 
# names Wiemerstedt  25779 
# names Norderheistedt  25779 
# names Fedderingen  25779 
# names Gaushorn  25782 
# names Westerborstel  25782 
# names Schalkholz  25782 
# names Tellingstedt  25782 
# names Schrum  25782 
# names Odderade  25785 
# names Nordhastedt  25785 
# names Dellstedt  25786 
# names Wallen  25788 
# names Delve  25788 
# names Linden  25791 35440 57629 66851 
# names Barkenholm  25791 
# names Tielenhemme  25794 
# names Pahlen  25794 
# names Stelle-Wittenwurth  25795 
# names Weddingstedt  25795 
# names Wrohm  25799 
# names Schwesing  25813 
# names Husum  25813 31632 
# names Simonsberg  25813 
# names Almdorf  25821 
# names Breklum  25821 
# names Vollstedt  25821 
# names Bredstedt  25821 
# names Struckum  25821 
# names Welt  25836 
# names Katharinenheerd  25836 
# names Garding  25836 
# names Grothusenkoog  25836 
# names Garding  25836 
# names Osterhever  25836 
# names Vollerwiek  25836 
# names Friedrichstadt  25840 
# names Langenhorn  25842 
# names Bargum  25842 
# names Ockholm  25842 
# names Nordstrand  25845 
# names Elisabeth-Sophien-Koog  25845 
# names Pellworm  25849 
# names Bondelum  25850 
# names Behrendorf  25850 39606 
# names Bordelum  25852 
# names Drelsdorf  25853 
# names Bohmstedt  25853 
# names Haselund  25855 
# names Hattstedt  25856 
# names Hattstedtermarsch  25856 
# names Hooge  25859 
# names Horstedt  25860 27367 
# names Olderup  25860 
# names Arlewatt  25860 
# names Goldebek  25862 
# names Kolkerheide  25862 
# names Goldelund  25862 
# names Joldelund  25862 
# names Mildstedt  25866 
# names Norderstapel  25868 
# names Norderfriedrichskoog  25870 
# names Oldenswort  25870 
# names Wittbek  25872 
# names Oldersbek  25873 
# names Rantrum  25873 
# names Ramstedt  25876 
# names Fresendelf  25876 
# names Schwabstedt  25876 
# names Hude  25876 49448 
# names Seeth  25878 
# names Augustenkoog  25881 
# names Westerhever  25881 
# names Tating  25881 
# names Sollwitt  25884 
# names Norstedt  25884 
# names Immenstedt  25885 
# names Oster-Ohrstedt  25885 
# names Wester-Ohrstedt  25885 
# names Winnert  25887 
# names Witzwort  25889 
# names Enge-Sande  25917 
# names Stadum  25917 
# names Tinningstedt  25917 
# names Leck  25917 
# names Achtrup  25917 
# names Stedesand  25920 
# names Risum-Lindholm  25920 
# names Humptrup  25923 
# names Braderup  25923 
# names Lexgaard  25923 
# names Uphusum  25923 
# names Karlum  25926 
# names Ladelund  25926 
# names Bramstedtlund  25926 
# names Westre  25926 
# names Aventoft  25927 
# names Dunsum  25938 
# names Midlum  25938 27632 
# names Oevenum  25938 
# names Oldsum  25938 
# names Alkersum  25938 
# names Wrixum  25938 
# names Borgsum  25938 
# names Nieblum  25938 
# names Witsum  25938 
# names Utersum  25938 
# names Nebel  25946 
# names Norddorf  25946 
# names Rantum  25980 
# names Westerland  25980 
# names Sylt-Ost  25980 
# names List  25992 
# names Wenningstedt  25996 
# names Kampen  25999 
# names Friesoythe  26169 
# names Rastede  26180 
# names Edewecht  26188 
# names Wardenburg  26203 
# names Hatten  26209 
# names Wiefelstede  26215 
# names Varel  26316 
# names Zetel  26340 
# names Bockhorn  26345 85461 
# names Jade  26349 
# names Wilhelmshaven  26382 26384 26386 26388 26389 
# names Wittmund  26409 
# names Schortens  26419 
# names Dunum  26427 
# names Esens  26427 
# names Stedesdorf  26427 
# names Werdum  26427 
# names Neuharlingersiel  26427 
# names Holtgast  26427 
# names Moorweg  26427 
# names Wangerland  26434 
# names Jever  26441 
# names Sande  26452 
# names Langeoog  26465 
# names Spiekeroog  26474 
# names Wangerooge  26486 
# names Blomberg  26487 32825 
# names Neuschoo  26487 
# names Ochtersum  26489 
# names Norden  26506 
# names Hagermarsch  26524 
# names Hage  26524 
# names Halbemond  26524 
# names Berumbur  26524 
# names Wirdum  26529 
# names Marienhafe  26529 
# names Upgant-Schott  26529 
# names Rechtsupweg  26529 
# names Osteel  26529 
# names Leezdorf  26529 
# names Norderney  26548 
# names Dornum  26553 
# names Utarp  26556 
# names Westerholt  26556 
# names Nenndorf  26556 
# names Schweindorf  26556 
# names Eversmeer  26556 
# names Juist  26571 
# names Baltrum  26579 
# names Aurich  26603 26605 26607 
# names Wiesmoor  26639 
# names Westerstede  26655 
# names Uplengen  26670 
# names Saterland  26683 
# names Apen  26689 
# names Emden  26721 26723 26725 39343 
# names Borkum  26757 
# names Hinte  26759 
# names Moormerland  26802 
# names Westoverledingen  26810 
# names Rhauderfehn  26817 
# names Weener  26826 
# names Bunde  26831 32257 
# names Bunderhee  26831 
# names Boen  26831 
# names Wymeer  26831 
# names Dollart  26831 
# names Holtland  26835 
# names Firrel  26835 
# names Hesel  26835 
# names Brinkum  26835 
# names Schwerinsdorf  26835 
# names Neukamperfehn  26835 
# names Ostrhauderfehn  26842 
# names Jemgum  26844 
# names Nortmoor  26845 
# names Detern  26847 
# names Filsum  26849 
# names Papenburg  26871 
# names Wippingen  26892 
# names Kluse  26892 
# names Esterwegen  26897 
# names Breddenberg  26897 
# names Hilkenbrook  26897 
# names Bockhorst  26897 
# names Rhede  26899 46414 
# names Rastdorf  26901 
# names Lorup  26901 
# names Surwold  26903 
# names Dersum  26906 
# names Walchum  26907 
# names Neulehe  26909 
# names Brake  26919 
# names Elsfleth  26931 
# names Stadland  26935 26936 26937 
# names Nordenham  26954 
# names Butjadingen  26969 
# names Bassum  27211 
# names Sulingen  27232 
# names Twistringen  27239 
# names Kirchseelte  27243 
# names Colnrade  27243 
# names Winkelsett  27243 
# names Harpstedt  27243 
# names Beckeln  27243 
# names Barenburg  27245 
# names Bahrenborstel  27245 
# names Ehrenburg  27248 
# names Mellinghausen  27249 
# names Maasen  27249 
# names Scholen  27251 
# names Siedenburg  27254 
# names Staffhorst  27254 
# names Affinghausen  27257 
# names Sudwalde  27257 
# names Freistatt  27259 
# names Wehrbleck  27259 
# names Varrel  27259 
# names Engeln  27305 
# names Bruchhausen-Vilsen  27305 
# names Kirchlinteln  27308 
# names Hilgermissen  27318 
# names Hoya  27318 
# names Hoyerhagen  27318 
# names Emtinghausen  27321 
# names Thedinghausen  27321 
# names Morsum  27321 
# names Gandesbergen  27324 
# names Hassel  39596 
# names Eystrup  27324 
# names Martfeld  27327 
# names Schwarme  27327 
# names Warpe  27333 
# names Schweringen  27333 
# names Frankenfeld  27336 
# names Blender  27337 
# names Riede  27339 
# names Hassendorf  27367 
# names Hellwege  27367 
# names Sottrum  27367 
# names Ahausen  27367 
# names Hemslingen  27386 
# names Kirchwalsede  27386 
# names Bothel  27386 
# names Brockel  27386 29356 
# names Westerwalsede  27386 
# names Stemmen  27389 
# names Vahlde  27389 
# names Helvesiek  27389 
# names Fintel  27389 
# names Zeven  27404 
# names Ostereistedt  27404 
# names Elsdorf  27404 50189 
# names Rhade  27404 
# names Heeslingen  27404 
# names Gyhum  27404 
# names Tarmstedt  27412 
# names Westertimke  27412 
# names Kirchtimke  27412 
# names Hepstedt  27412 
# names Breddorf  27412 
# names Vorwerk  27412 
# names Wilstedt  27412 
# names Lengenbostel  27419 
# names Sittensen  27419 
# names Wohnste  27419 
# names Vierden  27419 
# names Kalbe  27419 
# names Hamersen  27419 
# names Tiste  27419 
# names Alfstedt  27432 
# names Hipstedt  27432 
# names Oerel  27432 
# names Basdahl  27432 
# names Ebersdorf  27432 96237 
# names Gnarrenburg  27442 
# names Deinstedt  27446 
# names Sandbostel  27446 
# names Farven  27446 
# names Selsingen  27446 
# names Anderlingen  27446 
# names Kutenholz  27449 
# names Cuxhaven  27472 27474 27476 27478 
# names Helgoland  27498 
# names Bremerhaven  27568 27570 27572 27574 27576 27578 27580 
# names Langen  27607 49838 63225 
# names Loxstedt  27612 
# names Beverstedt  27616 
# names Frelsdorf  27616 
# names Heerstedt  27616 
# names Hollen  27616 
# names Kirchwistedt  27616 
# names Lunestedt  27616 
# names Appeln  27616 
# names Schiffdorf  27619 
# names Ringstedt  27624 
# names Drangstedt  27624 
# names Lintig  27624 
# names Elmlohe  27624 
# names Sandstedt  27628 
# names Driftsethe  27628 
# names Uthlede  27628 
# names Hagen  24576 25779 58089 58091 58093 58095 58097 58099 58119 58135 
# names Bramstedt  27628 
# names Misselwarden  27632 
# names Cappel  27632 
# names Dorum  27632 
# names Mulsum  27632 
# names Nordholz  27637 
# names Wremen  27638 
# names Osterholz-Scharmbeck  27711 
# names Ritterhude  27721 
# names Worpswede  27726 
# names Axstedt  27729 
# names Holste  27729 
# names Vollersode  27729 
# names Hambergen  27729 
# names Delmenhorst  27749 27751 27753 27755 
# names Ganderkesee  27777 
# names Wildeshausen  27793 
# names Hude  25876 49448 
# names Berne  27804 
# names Lemwerder  27809 
# names Bremen  28195 28197 28199 28201 28203 28205 28207 28209 28211 28213 28215 28217 28219 28237 28239 28259 28277 28279 28307 28309 28325 28327 28329 28355 28357 28359 28717 28719 28755 28757 28759 28777 28779 
# names Schwanewede  28790 
# names Stuhr  28816 
# names Achim  28832 38312 
# names Weyhe  28844 
# names Syke  28857 
# names Lilienthal  28865 
# names Ottersberg  28870 
# names Oyten  28876 
# names Grasberg  28879 
# names Celle  29221 29223 29225 29227 29229 
# names Winsen  24568 
# names Hermannsburg  29320 
# names Wietze  29323 
# names Lachendorf  29331 
# names Wathlingen  29339 
# names Wienhausen  29342 
# names Eschede  29348 
# names Scharnhorst  29348 
# names Eldingen  29351 
# names Adelheidsdorf  29352 
# names Ahnsbeck  29353 
# names Beedenbostel  29355 
# names Eicklingen  29358 
# names Habighorst  29359 
# names Hohne  29362 
# names Langlingen  29364 
# names Sprakensehl  29365 
# names Ummern  29369 
# names Wittingen  29378 29379 
# names Obernholz  29386 
# names Dedelstorf  29386 
# names Wahrenholz  29399 
# names Salzwedel  29410 
# names Wallstawe  29413 
# names Tylsen  29413 
# names Seebenau  29413 
# names Langenapel  29413 
# names Lagendorf  29413 
# names Henningen  29413 
# names Ellenberg  29413 55765 73488 
# names Bonese  29413 
# names Osterwohle  29413 
# names Neuekrug  29413 
# names Mehmke  29413 
# names Gieseritz  29413 
# names Stappenbeck  29416 
# names Vissum  29416 
# names Valfitz  29416 
# names Steinitz  29416 
# names Siedenlangenbeck  29416 
# names Riebau  29416 
# names Kuhfelde  29416 
# names Kerkau  29416 
# names Kaulitz  29416 
# names Jeggeleben  29416 
# names Winterfeld  29416 
# names Wieblitz-Eversdorf  29416 
# names Fleetmark  29416 
# names Binde  29416 
# names Bierstedt  29416 
# names Rademin  29416 
# names Pretzier  29416 
# names Mechau  29416 
# names Liesten  29416 
# names Altensalzwedel  29416 
# names Benkendorf  29416 
# names Gischau  29416 
# names Hitzacker  29456 
# names Clenze  29459 
# names Schnega  29465 
# names Bergen  08239 29303 55608 83346 91790 
# names Gartow  29471 
# names Damnatz  29472 
# names Gorleben  29475 
# names Gusborn  29476 
# names Jameln  29479 
# names Karwitz  29481 
# names Lemgow  29485 
# names Prezelle  29491 
# names Schnackenburg  29493 
# names Trebel  29494 
# names Waddeweitz  29496 
# names Zernien  29499 
# names Uelzen  29525 
# names Suderburg  29556 
# names Wrestedt  29559 
# names Suhlendorf  29562 
# names Wriedel  29565 
# names Wieren  29568 
# names Rosche  29571 
# names Ebstorf  29574 
# names Altenmedingen  29575 
# names Eimke  29578 
# names Emmendorf  29579 
# names Gerdau  29581 
# names Hanstedt  21271 
# names Himbergen  29584 
# names Jelmstorf  29585 
# names Natendorf  29587 
# names Oetzen  29588 
# names Schwienau  29593 
# names Soltendieck  29594 
# names Stadensen  29596 
# names Stoetze  29597 
# names Weste  29599 
# names Soltau  29614 
# names Munster  29633 48143 48145 48147 48149 48151 48153 48155 48157 48159 48161 48163 48165 48167 64839 86692 
# names Schneverdingen  29640 
# names Bispingen  29646 
# names Wietzendorf  29649 
# names Walsrode  29664 
# names Fallingbostel  29683 
# names Buchholz  16928 17209 23911 25712 31710 39579 99762 
# names Gilten  29690 
# names Grethem  29690 
# names Lindwedel  29690 
# names Essel  29690 
# names Schwarmstedt  29690 
# names Hodenhagen  29693 
# names Eickeloh  29693 
# names Hademstorf  29693 
# names Bomlitz  29699 
# names Hannover  30159 30161 30163 30165 30167 30169 30171 30173 30175 30177 30179 30419 30449 30451 30453 30455 30457 30459 30519 30521 30539 30559 30625 30627 30629 30655 30657 30659 30669 
# names Garbsen  30823 30826 30827 
# names Laatzen  30880 
# names Barsinghausen  30890 
# names Wedemark  30900 
# names Isernhagen  30916 
# names Seelze  30926 
# names Burgwedel  30938 
# names Ronnenberg  30952 
# names Hemmingen  30966 71282 
# names Wennigsen  30974 
# names Pattensen  30982 
# names Gehrden  30989 39264 
# names Elze  31008 
# names Salzhemmendorf  31020 
# names Banteln  31029 
# names Betheln  31032 
# names Despetal  31035 
# names Eime  31036 
# names Rheden  31039 
# names Alfeld  91236 
# names Delligsen  31073 
# names Westfeld  31079 
# names Sibbesse  31079 
# names Almstedt  31079 
# names Eberholzen  31079 
# names Adenstedt  31079 
# names Everode  31085 
# names Landwehr  31087 
# names Winzenburg  31088 
# names Duingen  31089 
# names Coppengrave  31091 
# names Hoyershausen  31093 
# names Marienhagen  31094 
# names Weenzen  31096 
# names Harbarnsen  31097 
# names Woltershausen  31099 
# names Hildesheim  31134 31135 31137 31139 31141 
# names Sarstedt  31157 
# names Bockenem  31167 
# names Nordstemmen  31171 
# names Schellerten  31174 
# names Harsum  31177 
# names Giesen  31180 35390 35392 35394 35396 35398 
# names Holle  31188 
# names Algermissen  31191 
# names Lamspringe  31195 
# names Sehlem  31196 54518 
# names Diekholzen  31199 
# names Peine  31224 31226 31228 
# names Edemissen  31234 
# names Ilsede  31241 
# names Lahstedt  31246 
# names Hohenhameln  31249 
# names Lehrte  31275 
# names Burgdorf  31303 38272 
# names Uetze  31311 
# names Sehnde  31319 
# names Wunstorf  31515 
# names Neustadt  37345 
# names Nenndorf  26556 
# names Rehburg-Loccum  31547 
# names Apelern  31552 
# names Rodenberg  31552 
# names Sachsenhagen  31553 
# names Auhagen  31553 
# names Suthfeld  31555 
# names Hagenburg  31558 
# names Haste  31559 
# names Hohnhorst  31559 
# names Stolzenau  31592 
# names Steyerberg  31595 
# names Uchte  31600 
# names Diepenau  31603 
# names Raddestorf  31604 
# names Warmsen  31606 
# names Marklohe  31608 
# names Balge  31609 
# names Wietzen  31613 
# names Liebenau  31618 34396 
# names Binnen  31619 
# names Pennigsehl  31621 
# names Heemsen  31622 
# names Drakenburg  31623 
# names Rohrsen  31627 
# names Landesbergen  31628 
# names Leese  31633 
# names Steimbke  31634 
# names Linsburg  31636 
# names Rodewald  31637 
# names Stadthagen  31655 
# names Obernkirchen  31683 
# names Helpsen  31691 
# names Seggebruch  31691 
# names Hespe  31693 
# names Lindhorst  31698 
# names Beckedorf  31699 
# names Ahnsen  31708 
# names Luhden  31711 
# names Lauenhagen  31714 
# names Meerbeck  31715 
# names Nordsehl  31717 
# names Pollhagen  31718 
# names Wiedensahl  31719 
# names Rinteln  31737 
# names Auetal  31749 
# names Hameln  31785 31787 31789 
# names Springe  31832 
# names Oldendorf  21726 25588 
# names Aerzen  31855 
# names Emmerthal  31860 
# names Lauenau  31867 
# names Pohle  31867 
# names Messenkamp  31867 
# names Ottenstein  31868 
# names Herford  32049 32051 32052 
# names Hiddenhausen  32120 
# names Enger  32130 
# names Spenge  32139 
# names Kirchlengern  32278 
# names Espelkamp  32339 
# names Stemwede  32351 
# names Oldendorf  21726 25588 
# names Rahden  32369 
# names Minden  32423 32425 32427 32429 54310 
# names Petershagen  32469 
# names Hille  32479 
# names Vlotho  32602 
# names Lemgo  32657 
# names Barntrup  32683 
# names Kalletal  32689 
# names Extertal  32699 
# names Detmold  32756 32758 32760 
# names Lage  32791 49828 
# names Schieder-Schwalenberg  32816 
# names Augustdorf  32832 
# names Steinheim  32839 
# names Brakel  33034 
# names Nieheim  33039 
# names Paderborn  33098 33100 33102 33104 33106 
# names Salzkotten  33154 
# names Borchen  33178 
# names Altenbeken  33184 
# names Schlangen  33189 
# names Rietberg  33397 
# names Verl  33415 
# names Harsewinkel  33428 
# names Herzebrock-Clarholz  33442 
# names Langenberg  33449 
# names Bielefeld  33602 33604 33605 33607 33609 33611 33613 33615 33617 33619 33647 33649 33659 33689 33699 33719 33729 33739 
# names Versmold  33775 
# names Oerlinghausen  33813 
# names Werther  33824 99735 
# names Borgholzhausen  33829 
# names Kassel  34117 34119 34121 34123 34125 34127 34128 34130 34131 34132 34134 
# names Melsungen  34212 
# names Baunatal  34225 
# names Fuldatal  34233 
# names Vellmar  34246 
# names Lohfelden  34253 
# names Kaufungen  34260 
# names Niestetal  34266 
# names Schauenburg  34270 
# names Gudensberg  34281 
# names Spangenberg  34286 
# names Zierenberg  34289 
# names Ahnatal  34292 
# names Helsa  34298 
# names Guxhagen  34302 
# names Niedenstein  34305 
# names Espenau  34314 
# names Habichtswald  34317 
# names Malsfeld  34323 
# names Morschen  34326 
# names Nieste  34329 
# names Staufenberg  34355 35460 
# names Reinhardshagen  34359 
# names Hofgeismar  34369 
# names Immenhausen  34376 
# names Calden  34379 
# names Trendelburg  34388 
# names Grebenstein  34393 
# names Oberweser  34399 
# names Warburg  34414 
# names Marsberg  34431 
# names Borgentreich  34434 
# names Willebadessen  34439 
# names Wolfhagen  34466 
# names Volkmarsen  34471 
# names Diemelstadt  34474 
# names Twistetal  34477 
# names Breuna  34479 
# names Korbach  34497 
# names Willingen  56479 
# names Diemelsee  34519 
# names Edertal  34549 
# names Fritzlar  34560 
# names Homberg  56379 56479 67744 
# names Borken  34582 46325 
# names Felsberg  34587 
# names Wabern  34590 
# names Neuental  34599 
# names Schwalmstadt  34613 
# names Frielendorf  34621 
# names Willingshausen  34628 
# names Gilserberg  34630 
# names Jesberg  34632 
# names Ottrau  34633 
# names Schrecksbach  34637 
# names Schwarzenborn  34639 54533 
# names Marburg  35037 35039 35041 35043 
# names Gladenbach  35075 
# names Wetter  35083 
# names Ebsdorfergrund  35085 
# names Lahntal  35094 
# names Weimar  35096 99423 99425 99427 
# names Burgwald  35099 
# names Lohra  35102 
# names Lichtenfels  35104 96215 
# names Allendorf  07426 56370 
# names Frankenau  35110 
# names Fronhausen  35112 
# names Haina  99869 
# names Rosenthal  35119 
# names Biedenkopf  35216 
# names Dautphetal  35232 
# names Breidenbach  35236 
# names Steffenberg  35239 
# names Stadtallendorf  35260 
# names Kirchhain  35274 
# names Neustadt  37345 
# names Rauschenberg  35282 
# names Wohratal  35288 
# names Homberg  56379 56479 67744 
# names Laubach  35321 56288 56759 
# names Ulrichstein  35327 
# names Hungen  35410 
# names Pohlheim  35415 
# names Buseck  35418 
# names Lich  35423 
# names Wettenberg  35435 
# names Biebertal  35444 
# names Reiskirchen  35447 
# names Heuchelheim  35452 
# names Lollar  35457 
# names Fernwald  35463 
# names Allendorf  07426 56370 
# names Butzbach  35510 
# names Rockenberg  35519 
# names Wetzlar  35576 35578 35579 35580 35581 35582 35583 35584 35585 35586 
# names Solms  35606 
# names Braunfels  35619 
# names Ehringshausen  35630 
# names Lahnau  35633 
# names Leun  35638 
# names Hohenahr  35644 
# names Waldsolms  35647 
# names Bischoffen  35649 
# names Dillenburg  35683 35684 35685 35686 35687 35688 35689 35690 
# names Haiger  35708 
# names Eschenburg  35713 
# names Angelburg  35719 
# names Herborn  35745 55758 
# names Greifenstein  35753 
# names Mittenaar  35756 
# names Driedorf  35759 
# names Sinn  35764 
# names Breitscheid  35767 53547 55422 
# names Siegbach  35768 
# names Weilburg  35781 
# names Mengerskirchen  35794 
# names Weinbach  35796 
# names Merenberg  35799 
# names Fulda  36037 36039 36041 36043 
# names Flieden  36103 
# names Schlitz  36110 
# names Ehrenberg  36115 98660 
# names Hilders  36115 
# names Eichenzell  36124 
# names Gersfeld  36129 
# names Eiterfeld  36132 
# names Tann  36142 84367 
# names Hofbieber  36145 
# names Kalbach  36148 
# names Burghaun  36151 
# names Hosenfeld  36154 
# names Ebersburg  36157 
# names Dipperz  36160 
# names Poppenhausen  36163 97490 
# names Haunetal  36166 
# names Rasdorf  36169 
# names Bebra  36179 
# names Fulda  36037 36039 36041 36043 
# names Sontra  36205 
# names Wildeck  36208 
# names Alheim  36211 
# names Nentershausen  36214 56412 
# names Ronshausen  36217 
# names Cornberg  36219 
# names Ludwigsau  36251 
# names Philippsthal  14532 
# names Niederaula  36272 
# names Kirchheim  36275 97268 99334 
# names Schenklengsfeld  36277 
# names Oberaula  36280 
# names Hauneck  36282 
# names Hohenroda  36284 
# names Neuenstein  36286 74632 
# names Breitenbach  06528 06712 37327 66916 
# names Herzberg  16835 19374 
# names Friedewald  36289 57520 
# names Alsfeld  36304 
# names Schwalmtal  36318 41366 
# names Kirtorf  36320 
# names Grebenau  36323 
# names Feldatal  36325 
# names Antrifttal  36326 
# names Romrod  36329 
# names Lauterbach  36341 78730 99826 
# names Grebenhain  36355 
# names Herbstein  36358 
# names Wartenberg  36367 85456 
# names Lautertal  36369 64686 96486 
# names Sinntal  36391 
# names Steinau  21775 
# names Freiensteinau  36399 
# names Martinroda  36404 98693 
# names Oechsen  36404 
# names Vacha  36404 
# names Unterbreizbach  36414 
# names Rockenstuhl  36419 
# names Geisa  36419 
# names Schleid  36419 54636 
# names Gerstengrund  36419 
# names Buttlar  36419 
# names Immelborn  36433 
# names Moorgrund  36433 
# names Steinbach  36448 37308 56291 
# names Liebenstein  99330 
# names Schweina  36448 
# names Neidhartshausen  36452 
# names Kaltennordheim  36452 
# names Diedorf  36452 86420 
# names Zella  36452 
# names Empfertshausen  36452 
# names Kaltenlengsfeld  36452 
# names Brunnhartshausen  36452 
# names Klings  36452 
# names Andenhausen  36452 
# names Barchfeld  36456 
# names Stadtlengsfeld  36457 
# names Urnshausen  36457 
# names Weilar  36457 
# names Frauensee  36460 
# names Merkers-Kieselbach  36460 
# names Dorndorf  36460 
# names Dermbach  36466 
# names Wiesenthal  36466 
# names Tiefenort  36469 
# names Duderstadt  37115 
# names Bovenden  37120 
# names Scheden  37127 
# names Niemetal  37127 
# names Dransfeld  37127 
# names Gleichen  37130 
# names Landolfshausen  37136 
# names Seulingen  37136 
# names Waake  37136 
# names Adelebsen  37139 
# names Northeim  37154 
# names Uslar  37170 
# names Hardegsen  37181 
# names Moringen  37186 39599 
# names Katlenburg-Lindau  37191 
# names Wahlsburg  37194 
# names Bodenfelde  37194 
# names Wulften  37199 
# names Witzenhausen  37213 37214 37215 37216 37217 37218 
# names Lichtenau  09244 33165 77839 91586 
# names Neu-Eichenberg  37249 
# names Eschwege  37269 
# names Meinhard  37276 
# names Wanfried  37281 
# names Waldkappel  37284 
# names Wehretal  37287 
# names Herleshausen  37293 
# names Ringgau  37296 
# names Berkatal  37297 
# names Reinholterode  37308 
# names Glasehausen  37308 
# names Krombach  37308 63829 
# names Heiligenstadt  91332 
# names Sickerode  37308 
# names Volkerode  37308 
# names Wiesenfeld  37308 
# names Schimberg  37308 
# names Heuthen  37308 
# names Wingerode  37308 
# names Kella  37308 
# names Bodenrode-Westhausen  37308 
# names Geismar  37308 
# names Pfaffschwende  37308 
# names Geisleden  37308 
# names Schachtebich  37318 
# names Lutter  37318 
# names Rohrberg  37318 38489 
# names Kirchgandern  37318 
# names Thalwenden  37318 
# names Hohengandern  37318 
# names Wahlhausen  37318 
# names Mackenrode  37318 
# names Fretterode  37318 
# names Gerbershausen  37318 
# names Uder  37318 
# names Eichstruth  37318 
# names Steinheuterode  37318 
# names Lenterode  37318 
# names Bornhagen  37318 
# names Marth  37318 
# names Lindewerra  37318 
# names Asbach-Sickenberg  37318 
# names Rustenfelde  37318 
# names Burgwalde  37318 
# names Arenshausen  37318 
# names Birkenfelde  37318 
# names Schwobfeld  37318 
# names Dieterode  37318 
# names Dietzenrode-Vatterode  37318 
# names Kallmerode  37327 
# names Leinefelde  37327 
# names Hausen  37327 55608 63840 91353 93345 97647 
# names Wehnde  37339 
# names Haynrode  37339 
# names Brehme  37339 
# names Teistungen  37339 
# names Wintzingerode  37339 
# names Berlingerode  37339 
# names Worbis  37339 
# names Ferna  37339 
# names Kirchworbis  37339 
# names Tastungen  37339 
# names Breitenworbis  37339 
# names Hundeshagen  37339 
# names Buhla  37339 
# names Ecklingerode  37339 
# names Bockelnhagen  37345 
# names Steinrode  37345 
# names Silkerode  37345 
# names Neustadt  37345 
# names Bischofferode  37345 
# names Holungen  37345 
# names Zwinge  37345 
# names Silberhausen  37351 
# names Kefferhausen  37351 
# names Kreuzebra  37351 
# names Helmsdorf  37351 
# names Vollenborn  37355 
# names Niederorschel  37355 
# names Gerterode  37355 
# names Deuna  37355 
# names Kleinbartloff  37355 
# names Wachstedt  37359 
# names Effelder  37359 
# names Elbingerode  37412 38875 
# names Herzberg  16835 19374 
# names Wollershausen  37434 
# names Rollshausen  37434 
# names Krebeck  37434 
# names Bilshausen  37434 
# names Wollbrandshausen  37434 
# names Bodensee  37434 
# names Obernfeld  37434 
# names Gieboldehausen  37434 
# names Rhumspringe  37434 
# names Walkenried  37445 
# names Wieda  37447 
# names Zorge  37449 
# names Osterode  38835 
# names Eisdorf  37534 
# names Gittelde  37534 
# names Badenhausen  37534 
# names Windhausen  37539 
# names Kreiensen  37547 
# names Einbeck  37574 
# names Dassel  37586 
# names Kalefeld  37589 
# names Holzminden  37603 
# names Kirchbrak  37619 
# names Pegestorf  37619 
# names Hehlen  37619 
# names Heyen  37619 
# names Bodenwerder  37619 
# names Heinade  37627 
# names Deensen  37627 
# names Stadtoldendorf  37627 
# names Wangelnstedt  37627 
# names Lenne  37627 
# names Arholzen  37627 
# names Holzen  37632 
# names Eschershausen  37632 
# names Eimen  37632 
# names Dielmissen  37633 
# names Golmbach  37640 
# names Holenberg  37642 
# names Negenborn  37643 
# names Polle  37647 
# names Vahlbruch  37647 
# names Heinsen  37649 
# names Beverungen  37688 
# names Derental  37691 
# names Boffzen  37691 
# names Braunschweig  38100 38102 38104 38106 38108 38110 38112 38114 38116 38118 38120 38122 38124 38126 
# names Vechelde  38159 
# names Cremlingen  38162 
# names Lehre  38165 
# names Dahlum  38170 
# names Kneitlingen  38170 
# names Uehrde  38170 
# names Winnigstedt  38170 
# names Vahlberg  38170 
# names Evessen  38173 
# names Dettum  38173 
# names Veltheim  38173 38835 
# names Erkerode  38173 
# names Sickte  38173 
# names Wendeburg  38176 
# names Salzgitter  38226 38228 38229 38239 38259 
# names Lengede  38268 
# names Baddeckenstedt  38271 
# names Elbe  38274 
# names Haverlah  38275 
# names Heere  38277 
# names Sehlde  38279 
# names Heiningen  38312 73092 
# names Cramme  38312 
# names Dorstadt  38312 
# names Ohrum  38312 
# names Schladen  38315 
# names Werlaburgdorf  38315 
# names Gielde  38315 
# names Remlingen  38319 97280 
# names Denkte  38321 
# names Hedeper  38322 
# names Roklum  38325 
# names Semmenstedt  38327 
# names Wittmar  38329 
# names Helmstedt  38350 
# names Grasleben  38368 
# names Mariental  38368 
# names Rennau  38368 
# names Querenhorst  38368 
# names Frellstedt  38373 
# names Warberg  38378 
# names Wolsdorf  38379 
# names Jerxheim  38381 
# names Beierstedt  38382 
# names Gevensleben  38384 
# names Ingeleben  38385 
# names Twieflingen  38388 
# names Wolfsburg  38440 38442 38444 38446 38448 
# names Velpke  38458 
# names Bahrdorf  38459 
# names Danndorf  38461 
# names Grafhorst  38462 
# names Brome  38465 
# names Bergfeld  38467 
# names Ehra-Lessien  38468 
# names Parsau  38470 
# names Tiddische  38473 
# names Barwedel  38476 
# names Jembke  38477 
# names Tappenbeck  38479 
# names Steimke  38486 
# names Ristedt  38486 
# names Kusey  38486 
# names Kunrau  38486 
# names Jahrstedt  38486 
# names Immekath  38486 
# names Wenze  38486 
# names Neuferchau  38486 
# names Bandau  38486 
# names Tangeln  38489 
# names Jeeben  38489 
# names Hohentramm  38489 
# names Hanum  38489 
# names Beetzendorf  38489 
# names Nettgau  38489 
# names Mellin  38489 
# names Ahlum  38489 
# names Gifhorn  38518 
# names Sassenburg  38524 
# names Meine  38527 
# names Didderse  38530 
# names Vordorf  38533 
# names Meinersen  38536 
# names Leiferde  38542 
# names Hillerse  38543 
# names Calberlah  38547 
# names Weyhausen  38554 
# names Bokensdorf  38556 
# names Wagenhoff  38559 
# names Goslar  38640 38642 38644 
# names Clausthal-Zellerfeld  38678 
# names Langelsheim  38685 
# names Vienenburg  38690 
# names Braunlage  38700 
# names Liebenburg  38704 
# names Schulenberg  18334 
# names Altenau  38707 
# names Wildemann  38709 
# names Seesen  38723 
# names Lutter  37318 
# names Wallmoden  38729 
# names Hahausen  38729 
# names Halberstadt  38820 
# names Sargstedt  38822 
# names Quenstedt  06333 
# names Athenstedt  38822 
# names Aspenstedt  38822 
# names Wegeleben  38828 
# names Harsleben  38829 
# names Schauen  38835 
# names Rhoden  38835 
# names Hessen  38835 
# names Zilly  38835 
# names Deersheim  38835 
# names Osterwieck  38835 
# names Osterode  38835 
# names Vogelsdorf  38836 
# names Rohrsheim  38836 
# names Huy-Neinstedt  38836 
# names Dedeleben  38836 
# names Dardesheim  38836 
# names Pabstorf  38836 
# names Anderbeck  38836 
# names Badersleben  38836 
# names Schlanstedt  38838 
# names Eilsdorf  38838 
# names Eilenstedt  38838 
# names Dingelstedt  38838 
# names Schmatzfeld  38855 
# names Heudeber  38855 
# names Wernigerode  38855 
# names Danstedt  38855 
# names Reddeber  38855 
# names Wasserleben  38871 
# names Veckenstedt  38871 
# names Stapelburg  38871 
# names Ilsenburg  38871 
# names Darlingerode  38871 
# names Abbenrode  38871 
# names Tanne  38875 
# names Sorge  38875 
# names Elend  38875 
# names Benneckenstein  38877 
# names Schierke  38879 
# names Treseburg  38889 
# names Heimburg  38889 
# names Wienrode  38889 
# names Cattenstedt  38889 
# names Blankenburg  38889 99955 
# names Altenbrak  38889 
# names Langenstein  38895 
# names Derenburg  38895 
# names Trautenstein  38899 
# names Stiege  38899 
# names Hasselfelde  38899 
# names Magdeburg  39104 39106 39108 39110 39112 39114 39116 39118 39120 39122 39124 39126 39128 39130 
# names Wanzleben  39164 
# names Wanzleben  39164 
# names Domersleben  39164 
# names Bottmersdorf  39164 
# names Irxleben  39167 
# names Hohendodeleben  39167 
# names Wellen  39167 54441 
# names Eichenbarleben  39167 
# names Ochtmersleben  39167 
# names Niederndodeleben  39167 
# names Wahlitz  39175 
# names Biederitz  39175 
# names Menz  39175 
# names Gerwisch  39175 
# names Ebendorf  39179 
# names Barleben  39179 39326 
# names Mittelland  39179 39326 
# names Zens  39221 
# names Welsleben  39221 
# names Eickendorf  39221 39359 
# names Eggersdorf  39221 
# names Biere  39221 
# names Ranies  39221 
# names Sachsendorf  39240 
# names Zuchau  39240 
# names Calbe  39240 
# names Brumby  39240 
# names Breitenhagen  39240 
# names Dannigkow  39245 
# names Pretzien  39245 
# names Gommern  39245 
# names Tornitz  39249 
# names Wespen  39249 
# names Barby  39249 
# names Gnadau  39249 
# names Zerbst  39261 
# names Walternienburg  39264 
# names Straguth  39264 
# names Steutz  39264 
# names Hohenlepte  39264 
# names Zernitz  39264 
# names Grimme  39264 
# names Buhlendorf  39264 
# names Bornum  39264 
# names Bias  39264 
# names Polenzko  39264 
# names Nutha  39264 
# names Nedlitz  39264 39291 
# names Moritz  39264 
# names Luso  39264 
# names Leps  39264 
# names Schweinitz  39279 
# names Rosian  39279 
# names Ladeburg  39279 
# names Hobeck  39279 
# names Zeppernick  39279 
# names Loburg  39279 
# names Leitzkau  39279 
# names Burg  39288 54646 
# names Vehlitz  39291 
# names Tryppehna  39291 
# names Stresow  39291 
# names Stegelitz  39291 
# names Schopsdorf  39291 
# names Schermen  39291 
# names Schartau  39291 
# names Rietzel  39291 
# names Karith  39291 
# names Ihleburg  39291 
# names Hohenziatz  39291 
# names Hohenwarthe  39291 
# names Ziepel  39291 
# names Zeddenick  39291 
# names Friedensau  39291 
# names Detershagen  39291 
# names Pietzpuhl  39291 
# names Parchau  39291 
# names Niegripp  39291 
# names Magdeburgerforth  39291 
# names Lostau  39291 
# names Reesen  39291 
# names Tucheim  39307 
# names Schlagenthin  39307 
# names Klitsche  39307 
# names Kade  39307 
# names Zabakuck  39307 
# names Genthin  39307 
# names Elbe-Parey  39307 39317 
# names Demsin  39307 
# names Brettin  39307 
# names Parchen  39307 
# names Paplitz  39307 
# names Gladau  39307 
# names Jerichow  39319 
# names Wulkow  39319 
# names Nielebock  39319 
# names Redekin  39319 
# names Samswegen  39326 
# names Jersleben  39326 
# names Hohenwarsleben  39326 
# names Heinrichsberg  39326 
# names Gutenswegen  39326 
# names Zielitz  39326 
# names Wolmirstedt  39326 
# names Farsleben  39326 
# names Dahlenwarsleben  39326 
# names Colbitz  39326 
# names Meseberg  39326 39606 
# names Loitsche  39326 
# names Angern  39326 
# names Glindenberg  39326 
# names Meitzendorf  39326 
# names Haldensleben  39340 
# names Uhrsleben  39343 
# names Schwanefeld  39343 
# names Schackensleben  39343 
# names Rottmersleben  39343 
# names Ivenrode  39343 
# names Hillersleben  39343 
# names Hakenstedt  39343 
# names Erxleben  39343 39606 
# names Eimersleben  39343 
# names Bregenstedt  39343 
# names Ostingersleben  39343 
# names Nordgermersleben  39343 
# names Morsleben  39343 
# names Altenhausen  39343 
# names Alleringersleben  39343 
# names Ackendorf  39343 
# names Beendorf  39343 
# names Bebertal  39343 
# names Bartensleben  39343 
# names Vahldorf  39345 
# names Wieglitz  39345 
# names Flechtingen  39345 
# names Born  39345 
# names Neuenhofe  39345 
# names Siestedt  39356 
# names Seggerde  39356 
# names Weferlingen  39356 
# names Eschenrode  39356 
# names Belsdorf  39356 
# names Behnsdorf  39356 
# names Velsdorf  39359 
# names Kathendorf  39359 
# names Wegenstedt  39359 
# names Everingen  39359 
# names Etingen  39359 
# names Mannhausen  39359 
# names Grauingen  39359 
# names Ummendorf  39365 88444 
# names Seehausen  39365 39615 
# names Harbke  39365 
# names Wormsdorf  39365 
# names Wefensleben  39365 
# names Eilsleben  39365 
# names Eggenstedt  39365 
# names Druxberge  39365 
# names Dreileben  39365 
# names Drackenstedt  39365 
# names Marienborn  39365 
# names Schermcke  39387 
# names Hornhausen  39387 
# names Wulferstedt  39387 
# names Oschersleben  39387 
# names Ampfurth  39387 
# names Altbrandsleben  39387 
# names Neuwegersleben  39387 
# names Bruch  54518 
# names Wackersleben  39393 
# names Ohrsleben  39393 
# names Ausleben  39393 
# names Barneberg  39393 
# names Hamersleben  39393 
# names Gunsleben  39393 
# names Kroppenstedt  39397 
# names Oschersleben  39387 
# names Hadmersleben  39398 
# names Peseckendorf  39398 
# names Alikendorf  39398 
# names Unseburg  39435 
# names Tarthun  39435 
# names Schneidlingen  39435 
# names Wolmirsleben  39435 
# names Egeln  39435 
# names Borne  39435 
# names Amesdorf  39439 
# names Hohenerxleben  39443 
# names Atzendorf  39443 
# names Hecklingen  39444 
# names Hakeborn  39448 
# names Westeregeln  39448 
# names Etgersleben  39448 
# names Uetz  39517 
# names Uchtdorf  39517 
# names Schernebeck  39517 
# names Schelldorf  39517 
# names Sandbeiendorf  39517 
# names Ringfurth  39517 
# names Kehnert  39517 
# names Wenddorf  39517 
# names Dolle  39517 
# names Cobbel  39517 
# names Burgstall  39517 
# names Buch  39517 56290 56357 89290 
# names Bittkau  39517 
# names Birkholz  39517 
# names Mahlwinkel  39517 
# names Bertingen  39517 
# names Kuhlhausen  39524 
# names Klietz  39524 
# names Kamern  39524 
# names Wulkau  39524 
# names Mangelsdorf  39524 
# names Havelberg  39539 
# names Stendal  39576 
# names Uenglingen  39579 
# names Schinne  39579 
# names Schernikau  39579 
# names Rochau  39579 
# names Wittenmoor  39579 
# names Windberge  39579 
# names Grobleben  39579 
# names Garlipp  39579 
# names Demker  39579 
# names Querstedt  39579 
# names Bellingen  39579 56459 
# names Grassau  39579 83224 
# names Storkau  06667 
# names Langensalzwedel  39590 
# names Heeren  39590 
# names Miltern  39590 
# names Schwarzholz  39596 
# names Sanne  39596 
# names Jarchau  39596 
# names Hohenberg-Krusemark  39596 
# names Hindenburg  39596 
# names Hassel  39596 
# names Lindtorf  39596 
# names Bertkow  39596 
# names Arneburg  39596 
# names Altenzaun  39596 
# names Baben  39596 
# names Goldbeck  39596 
# names Volgfelde  39599 
# names Vinzelberg  39599 
# names Uchtspringe  39599 
# names Steinfeld  18184 24888 76889 97854 
# names Staats  39599 
# names Insel  39599 
# names Nahrstedt  39599 
# names Schorstedt  39606 
# names Sanne-Kerkuhn  39606 
# names Sandauerholz  39606 
# names Krevese  39606 
# names Kossebau  39606 
# names Kleinau  39606 
# names Iden  39606 
# names Hohenwulsch  39606 
# names Heiligenfelde  39606 
# names Gagel  39606 
# names Flessau  39606 
# names Dobberkau  39606 
# names Bretsch  39606 
# names Osterburg  39606 
# names Gladigau  39606 
# names Ballerstedt  39606 
# names Wanzer  39615 
# names Wahrenberg  39615 
# names Werben  03096 
# names Wendemark  39615 
# names Garz  17419 18574 39524 
# names Geestgottberg  39615 
# names Beuster  39615 
# names Pollitz  39615 
# names Neulingen  39615 75245 
# names Neukirchen  23779 25927 34626 94362 
# names Losse  39615 
# names Losenrade  39615 
# names Lichterfelde  39615 
# names Leppin  39615 
# names Aulosen  39615 
# names Gollensdorf  39615 
# names Thielbeer  39619 
# names Schrampe  39619 
# names Ziemendorf  39619 
# names Arendsee  39619 
# names Vienau  39624 
# names Kremkau  39624 
# names Kalbe  27419 
# names Kakerbeck  39624 
# names Kahrstedt  39624 
# names Jeetze  39624 
# names Zethlingen  39624 
# names Winkelstedt  39624 
# names Wernstedt  39624 
# names Brunau  39624 
# names Packebusch  39624 
# names Neuendorf  18246 38486 54597 97788 
# names Damm  18196 19374 
# names Altmersleben  39624 
# names Berkau  39624 
# names Badel  39624 
# names Holzhausen  39629 
# names Bismark  17322 
# names Wannefeld  39638 
# names Solpke  39638 
# names Seethen  39638 
# names Schwiesau  39638 
# names Schenkenhorst  39638 
# names Neuendorf  18246 38486 54597 97788 
# names Kassieck  39638 
# names Jeseritz  39638 
# names Hottendorf  39638 
# names Hemstedt  39638 
# names Zobbenitz  39638 
# names Zichtau  39638 
# names Wiepke  39638 
# names Gardelegen  39638 
# names Estedt  39638 
# names Engersen  39638 
# names Dorst  39638 
# names Breitenfeld  39638 
# names Potzehne  39638 
# names Lindstedt  39638 
# names Letzlingen  39638 
# names Algenstedt  39638 
# names Berenbrock  39638 
# names Oebisfelde  39646 
# names Sichau  39649 
# names Sachau  39649 
# names Jeggau  39649 
# names Dannefeld  39649 
# names Peckfitz  39649 
# names Miesterhorst  39649 
# names Mieste  39649 
# names Meerbusch  40667 40668 40670 
# names Erkrath  40699 
# names Hilden  40721 40723 40724 
# names Langenfeld  40764 56729 91474 
# names Monheim  86653 
# names Mettmann  40822 
# names Ratingen  40878 40880 40882 40883 40885 
# names Nettetal  41334 
# names Korschenbroich  41352 
# names Neuss  41460 41462 41464 41466 41468 41469 41470 41472 
# names Grevenbroich  41515 41516 41517 
# names Dormagen  41539 41540 41541 41542 
# names Kaarst  41564 
# names Rommerskirchen  41569 
# names Viersen  41747 41748 41749 41751 
# names Erkelenz  41812 
# names Wegberg  41844 
# names Wassenberg  41849 
# names Wuppertal  42103 42105 42107 42109 42111 42113 42115 42117 42119 42275 42277 42279 42281 42283 42285 42287 42289 42327 42329 42349 42369 42389 42399 
# names Radevormwald  42477 
# names Velbert  42549 42551 42553 42555 
# names Heiligenhaus  42579 
# names Solingen  42651 42653 42655 42657 42659 42697 42699 42719 
# names Haan  42781 
# names Leichlingen  42799 
# names Remscheid  42853 42855 42857 42859 42897 42899 
# names Wermelskirchen  42929 
# names Dortmund  44135 44137 44139 44141 44143 44145 44147 44149 44225 44227 44229 44263 44265 44267 44269 44287 44289 44309 44319 44328 44329 44339 44357 44359 44369 44379 44388 
# names Castrop-Rauxel  44575 44577 44579 44581 
# names Herne  44623 44625 44627 44628 44629 44649 44651 44652 44653 
# names Bochum  44787 44789 44791 44793 44795 44797 44799 44801 44803 44805 44807 44809 44866 44867 44869 44879 44892 44894 
# names Essen  45127 45128 45130 45131 45133 45134 45136 45138 45139 45141 45143 45144 45145 45147 45149 45219 45239 45257 45259 45276 45277 45279 45289 45307 45309 45326 45327 45329 45355 45356 45357 45359 
# names Hattingen  45525 45527 45529 
# names Recklinghausen  45657 45659 45661 45663 45665 
# names Herten  45699 45701 
# names Datteln  45711 
# names Waltrop  45731 
# names Oer-Erkenschwick  45739 
# names Marl  45768 45770 45772 49448 
# names Gelsenkirchen  45879 45881 45883 45884 45886 45888 45889 45891 45892 45894 45896 45897 45899 
# names Gladbeck  45964 45966 45968 
# names Oberhausen  46045 46047 46049 46117 46119 46145 46147 46149 55606 76887 82386 86697 
# names Bottrop  46236 46238 46240 46242 46244 
# names Dorsten  46282 46284 46286 
# names Velen  46342 
# names Raesfeld  46348 
# names Heiden  46359 
# names Bocholt  46395 46397 46399 
# names Isselburg  46419 
# names Emmerich  46446 
# names Rees  46459 
# names Wesel  46483 46485 46487 
# names Hamminkeln  46499 
# names Xanten  46509 
# names Schermbeck  46514 
# names Alpen  46519 
# names Dinslaken  46535 46537 46539 
# names Voerde  46562 
# names Duisburg  47051 47053 47055 47057 47058 47059 47119 47137 47138 47139 47166 47167 47169 47178 47179 47198 47199 47226 47228 47229 47239 47249 47259 47269 47279 
# names Moers  47441 47443 47445 47447 
# names Kamp-Lintfort  47475 
# names Rheinberg  47495 
# names Neukirchen-Vluyn  47506 
# names Rheurdt  47509 
# names Kalkar  47546 
# names Bedburg-Hau  47551 
# names Goch  47574 
# names Uedem  47589 
# names Geldern  47608 
# names Kevelaer  47623 47624 47625 47626 47627 
# names Straelen  47638 
# names Kerken  47647 
# names Weeze  47652 
# names Issum  47661 
# names Sonsbeck  47665 
# names Wachtendonk  47669 
# names Krefeld  47798 47799 47800 47802 47803 47804 47805 47807 47809 47829 47839 
# names Willich  47877 
# names Kempen  47906 
# names Grefrath  47929 
# names Warendorf  48231 
# names Emsdetten  48282 
# names Telgte  48291 
# names Nottuln  48301 
# names Senden  48308 89250 
# names Drensteinfurt  48317 
# names Sendenhorst  48324 
# names Havixbeck  48329 
# names Sassenberg  48336 
# names Altenberge  48341 
# names Ostbevern  48346 
# names Everswinkel  48351 
# names Nordwalde  48356 
# names Beelen  48361 
# names Laer  48366 
# names Saerbeck  48369 
# names Rheine  48429 48431 48432 
# names Samern  48465 
# names Suddendorf  48465 
# names Isterberg  48465 
# names Engden  48465 
# names Ohne  48465 
# names Quendorf  48465 
# names Schapen  48480 
# names Spelle  48480 
# names Wettringen  48493 91631 
# names Hopsten  48496 
# names Salzbergen  48499 
# names Nordhorn  48527 48529 48531 
# names Steinfurt  48565 
# names Ochtrup  48607 
# names Horstmar  48612 
# names Heek  48619 
# names Metelen  48629 
# names Coesfeld  48653 
# names Ahaus  48683 
# names Vreden  48691 
# names Stadtlohn  48703 
# names Gescher  48712 
# names Rosendahl  48720 
# names Billerbeck  48727 
# names Reken  48734 
# names Legden  48739 
# names Wallenhorst  49134 
# names Bissendorf  49143 
# names Essen  45127 45128 45130 45131 45133 45134 45136 45138 45139 45141 45143 45144 45145 45147 45149 45219 45239 45257 45259 45276 45277 45279 45289 45307 45309 45326 45327 45329 45355 45356 45357 45359 
# names Bohmte  49163 
# names Hagen  24576 25779 58089 58091 58093 58095 58097 58099 58119 58135 
# names Wald  87616 88639 93192 
# names Wald  87616 88639 93192 
# names Ostercappeln  49179 
# names Belm  49191 
# names Laer  48366 
# names Wald  87616 88639 93192 
# names Glandorf  49219 
# names Melle  49324 49326 49328 
# names Diepholz  49356 
# names Vechta  49377 
# names Lohne  32584 
# names Damme  49401 
# names Eydelstedt  49406 
# names Barnstorf  49406 
# names Drentwede  49406 
# names Dinklage  49413 
# names Wagenfeld  49419 
# names Goldenstedt  49424 
# names Visbek  49429 
# names Steinfeld  18184 24888 76889 97854 
# names Quernheim  49448 
# names Stemshorn  49448 
# names Brockum  49448 
# names Hemsloh  49453 
# names Rehden  49453 
# names Wetschen  49453 
# names Dickel  49453 
# names Barver  49453 
# names Bakum  49456 
# names Drebber  49457 
# names Lembruch  49459 
# names Westerkappeln  49492 
# names Mettingen  49497 
# names Lotte  49504 
# names Recke  49509 
# names Lengerich  49525 49838 
# names Lienen  49536 
# names Tecklenburg  49545 
# names Ladbergen  49549 
# names Bramsche  49565 
# names Kettenkamp  49577 
# names Ankum  49577 
# names Merzen  49586 
# names Alfhausen  49594 
# names Gehrde  49596 
# names Rieste  49597 
# names Voltlage  49599 
# names Bippen  49626 
# names Essen  45127 45128 45130 45131 45133 45134 45136 45138 45139 45141 45143 45144 45145 45147 45149 45219 45239 45257 45259 45276 45277 45279 45289 45307 45309 45326 45327 45329 45355 45356 45357 45359 
# names Badbergen  49635 
# names Menslage  49637 
# names Nortrup  49638 
# names Cloppenburg  49661 
# names Garrel  49681 
# names Emstek  49685 
# names Lastrup  49688 
# names Molbergen  49696 
# names Meppen  49716 
# names Haren  49733 
# names Geeste  49744 
# names Werpeloh  49751 
# names Vrees  49757 
# names Werlte  49757 
# names Lahn  49757 
# names Fresenburg  49762 
# names Sustrum  49762 
# names Renkenberge  49762 
# names Lathen  49762 
# names Twist  49767 
# names Herzlake  49770 
# names Stavern  49777 
# names Niederlangen  49779 
# names Oberlangen  49779 
# names Lingen  49808 49809 49811 
# names Ringe  49824 
# names Laar  49824 
# names Emlichheim  49824 
# names Osterwald  49828 
# names Georgsdorf  49828 
# names Esche  49828 
# names Neuenhaus  49828 
# names Beesten  49832 
# names Andervenne  49832 
# names Thuine  49832 
# names Freren  49832 
# names Messingen  49832 
# names Wietmarschen  49835 
# names Wettrup  49838 
# names Gersten  49838 
# names Handrup  49838 
# names Uelsen  49843 
# names Wielen  49843 
# names Getelo  49843 
# names Bawinkel  49844 
# names Hoogstede  49846 
# names Itterbeck  49847 
# names Wilsum  49849 
# names Bergheim  50126 50127 50129 86673 
# names Kerpen  50169 50170 50171 54578 
# names Bedburg  50181 
# names Frechen  50226 
# names Pulheim  50259 
# names Erftstadt  50374 
# names Wesseling  50389 
# names Leverkusen  51371 51373 51375 51377 51379 51381 
# names Burscheid  51399 54673 
# names Gladbach  54518 
# names Overath  51491 
# names Odenthal  51519 
# names Windeck  51570 
# names Reichshof  51580 
# names Morsbach  51597 57629 
# names Friesenhagen  51598 
# names Gummersbach  51643 51645 51647 
# names Wiehl  51674 
# names Bergneustadt  51702 
# names Marienheide  51709 
# names Engelskirchen  51766 
# names Lindlar  51789 
# names Aachen  52062 52064 52066 52068 52070 52072 52074 52076 52078 52080 
# names Herzogenrath  52134 
# names Simmerath  52152 
# names Monschau  52156 
# names Roetgen  52159 
# names Eschweiler  52249 
# names Kreuzau  52372 
# names Langerwehe  52379 
# names Niederzier  52382 
# names Nideggen  52385 
# names Heimbach  52396 55779 
# names Merzenich  52399 
# names Linnich  52441 
# names Titz  52445 
# names Aldenhoven  52457 
# names Inden  52459 
# names Alsdorf  52477 54668 57518 
# names Baesweiler  52499 
# names Geilenkirchen  52511 
# names Heinsberg  52525 
# names Waldfeucht  52525 
# names Selfkant  52538 
# names Gangelt  52538 
# names Bonn  53111 53113 53115 53117 53119 53121 53123 53125 53127 53129 53173 53175 53177 53179 53225 53227 53229 
# names Bornheim  53332 55237 76879 
# names Meckenheim  53340 67149 
# names Wachtberg  53343 
# names Alfter  53347 
# names Rheinbach  53359 
# names Remagen  53424 
# names Schalkenbach  53426 
# names Dedenbach  53426 
# names Sinzig  53489 
# names Waldorf  53498 
# names Grafschaft  53501 
# names Kalenborn  53505 56759 
# names Berg  53505 56357 82335 88276 95180 
# names Altenahr  53505 
# names Kirchsahr  53505 
# names Lind  53506 56729 
# names Rech  53506 
# names Heckenbach  53506 
# names Kesseling  53506 
# names Dernau  53507 
# names Kottenborn  53518 
# names Adenau  53518 
# names Herschbroich  53518 
# names Welcherath  53518 
# names Wimbach  53518 
# names Honerath  53518 
# names Quiddelbach  53518 
# names Insul  53520 
# names Drees  53520 
# names Harscheid  53520 
# names Trierscheid  53520 
# names Rodder  53520 
# names Senscheid  53520 
# names Ohlenhard  53520 
# names Reifferscheid  53520 
# names Kaltenborn  53520 
# names Meuspath  53520 
# names Schuld  53520 
# names Wershofen  53520 
# names Sierscheid  53520 
# names Winnerath  53520 
# names Dankerath  53520 
# names Antweiler  53533 
# names Eichenbach  53533 
# names Dorsel  53533 
# names Fuchshofen  53533 
# names Aremberg  53533 
# names Wiesemscheid  53534 
# names Bauler  53534 54673 
# names Pomster  53534 
# names Barweiler  53534 55606 
# names Wirft  53534 
# names Borler  53539 
# names Gelenberg  53539 
# names Reimerath  53539 
# names Bodenbach  53539 
# names Kirsbach  53539 
# names Kelberg  53539 
# names Bongard  53539 
# names Ockenfels  53545 
# names Dattenberg  53547 
# names Kasbach-Ohlenberg  53547 
# names Hausen  37327 55608 63840 91353 93345 97647 
# names Buchholz  16928 17209 23911 25712 31710 39579 99762 
# names Asbach  53567 55758 
# names Unkel  53572 
# names Bruchhausen  53572 
# names Neustadt  37345 
# names Windhagen  53578 
# names Erpel  53579 
# names Rheinbreitbach  53619 
# names Siegburg  53721 
# names Hennef  53773 
# names Eitorf  53783 
# names Lohmar  53797 
# names Much  53804 
# names Ruppichteroth  53809 
# names Neunkirchen-Seelscheid  53819 
# names Troisdorf  53840 53842 53844 
# names Niederkassel  53859 
# names Euskirchen  53879 53881 
# names Mechernich  53894 
# names Swisttal  53913 
# names Weilerswist  53919 
# names Kall  53925 
# names Schleiden  53937 
# names Hellenthal  53940 
# names Nettersheim  53947 
# names Trier  54290 54292 54293 54294 54295 54296 
# names Welschbillig  54298 
# names Orenhofen  54298 
# names Greimerath  54298 54533 
# names Igel  54298 
# names Aach  54298 78267 
# names Eisenach  54298 99817 
# names Gilzem  54298 
# names Kordel  54306 
# names Langsur  54308 
# names Newel  54309 
# names Menningen  54310 
# names Trierweiler  54311 
# names Zemmer  54313 
# names Baldringen  54314 
# names Zerf  54314 
# names Hentern  54314 
# names Vierherrenborn  54314 
# names Paschel  54314 
# names Bonerath  54316 
# names Hockweiler  54316 
# names Franzenheim  54316 
# names Lampaden  54316 
# names Ollmuth  54316 
# names Hinzenburg  54316 
# names Pluwig  54316 
# names Holzerath  54316 
# names Morscheid  54317 
# names Riveris  54317 
# names Kasel  54317 
# names Gutweiler  54317 
# names Lorscheid  54317 
# names Korlingen  54317 
# names Thomm  54317 
# names Gusterath  54317 
# names Farschweiler  54317 
# names Herl  54317 
# names Osburg  54317 
# names Sommerau  54317 
# names Mertesdorf  54318 
# names Waldrach  54320 
# names Konz  54329 
# names Oberbillig  54331 
# names Pellingen  54331 
# names Wasserliesch  54332 
# names Schweich  54338 
# names Longen  54338 
# names Ensch  54340 
# names Riol  54340 
# names Leiwen  54340 
# names Longuich  54340 
# names Schleich  54340 
# names Bekond  54340 
# names Naurath  54426 
# names Detzem  54340 
# names Fell  54341 
# names Kenn  54344 
# names Mehring  54346 84561 
# names Neumagen-Dhron  54347 
# names Trittenheim  54349 
# names Hermeskeil  54411 
# names Deuselbach  54411 
# names Rorodt  54411 
# names Rascheid  54413 
# names Gusenburg  54413 
# names Geisfeld  54413 
# names Damflos  54413 
# names Beuren  56825 72660 
# names Bescheid  54413 
# names Grimburg  54413 
# names Reinsfeld  54421 
# names Etgert  54424 
# names Thalfang  54424 
# names Burtscheid  54424 
# names Gielert  54424 
# names Breit  54426 
# names Berglicht  54426 
# names Hilscheid  54426 
# names Merschbach  54426 
# names Neunkirchen  54426 56479 57290 63930 74867 
# names Naurath  54426 
# names Heidenburg  54426 
# names Dhronecken  54426 
# names Talling  54426 
# names Immert  54426 
# names Malborn  54426 
# names Waldweiler  54429 
# names Schillingen  54429 
# names Heddert  54429 
# names Mandern  54429 
# names Saarburg  54439 
# names Merzkirchen  54439 
# names Fisch  54439 
# names Palzem  54439 
# names Trassem  54441 
# names Schoden  54441 
# names Kastel-Staadt  54441 
# names Wawern  54441 54612 
# names Mannebach  54441 56769 
# names Kanzem  54441 
# names Ayl  54441 
# names Kirf  54441 
# names Taben-Rodt  54441 
# names Temmels  54441 
# names Ockfen  54441 
# names Freudenburg  54450 
# names Irsch  54451 
# names Nittel  54453 
# names Serrig  54455 
# names Onsdorf  54456 
# names Tawern  54456 
# names Wincheringen  54457 
# names Wiltingen  54459 
# names Lieser  54470 
# names Bernkastel-Kues  54470 
# names Graach  54470 
# names Kommen  54472 
# names Hochscheid  54472 
# names Longkamp  54472 
# names Veldenz  54472 
# names Brauneberg  54472 
# names Burgen  54472 56332 
# names Gornhausen  54472 
# names Monzelfeld  54472 
# names Kleinich  54483 
# names Maring-Noviand  54484 
# names Wintrich  54487 
# names Erden  54492 
# names Zeltingen-Rachtig  54492 
# names Horath  54497 
# names Morbach  54497 
# names Piesport  54498 
# names Wittlich  54516 
# names Binsfeld  54518 
# names Rivenich  54518 
# names Arenrath  54518 
# names Plein  54518 
# names Bergweiler  54518 
# names Esch  54518 54585 
# names Platten  54518 
# names Bruch  54518 
# names Hupperath  54518 
# names Altrich  54518 
# names Minheim  54518 
# names Osann-Monzel  54518 
# names Minderlittgen  54518 
# names Dodenburg  54518 
# names Gladbach  54518 
# names Kesten  54518 
# names Dreis  54518 
# names Heidweiler  54518 
# names Niersbach  54518 
# names Dierscheid  54523 
# names Hetzerath  54523 
# names Klausen  54524 
# names Landscheid  54526 
# names Salmtal  54528 
# names Spangdahlem  54529 
# names Eckfeld  54531 
# names Meerfeld  54531 
# names Pantenburg  54531 
# names Manderscheid  54531 54649 
# names Wallscheid  54531 
# names Willwerscheid  54533 
# names Niederscheidweiler  54533 
# names Hasborn  54533 
# names Bettenfeld  54533 
# names Gransdorf  54533 
# names Laufeld  54533 
# names Dierfeld  54533 
# names Eisenschmitt  54533 
# names Oberscheidweiler  54533 
# names Oberkail  54533 
# names Gipperath  54533 
# names Musweiler  54534 
# names Karl  54534 
# names Schladt  54534 
# names Hontheim  54538 
# names Diefenbach  54538 
# names Kinderbeuern  54538 
# names Bengel  54538 
# names Kinheim  54538 
# names Bausendorf  54538 
# names Daun  54550 
# names Darscheid  54552 
# names Katzwinkel  54552 57581 
# names Utzerath  54552 
# names Mehren  54552 57635 
# names Demerath  54552 
# names Ellscheid  54552 
# names Beinhausen  54552 
# names Steiningen  54552 
# names Sarmersbach  54552 
# names Kradenbach  54552 
# names Neichen  54552 
# names Brockscheid  54552 
# names Udler  54552 
# names Schalkenmehren  54552 
# names Steineberg  54552 
# names Boxberg  54552 97944 
# names Immerath  54552 
# names Nerdlen  54552 
# names Dockweiler  54552 
# names Gillenfeld  54558 
# names Strohn  54558 
# names Saxler  54558 
# names Gerolstein  54568 
# names Niederstadtfeld  54570 
# names Neroth  54570 
# names Hohenfels-Essingen  54570 
# names Bleckhausen  54570 
# names Kirchweiler  54570 
# names Kalenborn-Scheuern  54570 
# names Berlingen  54570 
# names Rockeskyll  54570 
# names Wallenborn  54570 
# names Pelm  54570 
# names Salm  54570 
# names Hinterweiler  54570 
# names Densborn  54570 
# names Weidenbach  54570 56355 91746 
# names Betteldorf  54570 
# names Deudesfeld  54570 
# names Meisburg  54570 
# names Schutz  54570 
# names Oberstadtfeld  54570 
# names Kopp  54574 
# names Birresborn  54574 
# names Hillesheim  54576 67586 
# names Dohm-Lammersdorf  54576 
# names Oberbettingen  54578 
# names Berndorf  54578 
# names Walsdorf  54578 96194 
# names Basberg  54578 
# names Nohn  54578 
# names Wiesbaum  54578 
# names Oberehe-Stroheich  54578 
# names Feusdorf  54584 
# names Lissendorf  54587 
# names Birgel  54587 
# names Kerschenbach  54589 
# names Stadtkyll  54589 
# names Watzerath  54595 
# names Weinsheim  54595 55595 
# names Pittenbach  54595 
# names Orlenbach  54595 
# names Gondenbrett  54595 
# names Burbach  54597 57299 
# names Wallersheim  54597 
# names Kleinlangenfeld  54597 
# names Olzheim  54597 
# names Steffeln  54597 
# names Neuheilenbach  54597 
# names Habscheid  54597 
# names Kinzenburg  54597 
# names Euscheid  54597 
# names Masthorn  54597 
# names Duppach  54597 
# names Rommersheim  54597 
# names Pronsfeld  54597 
# names Balesfeld  54597 
# names Lierfeld  54597 
# names Merlscheid  54597 
# names Strickscheid  54597 
# names Hersdorf  54597 
# names Fleringen  54597 
# names Roth  54597 55442 56288 56368 57539 91154 
# names Lascheid  54597 
# names Seiwerath  54597 
# names Schwirzheim  54597 
# names Feuerscheid  54597 
# names Matzerath  54597 
# names Ormont  54597 
# names Bleialf  54608 
# names Oberlascheid  54608 
# names Sellerich  54608 
# names Winterscheid  54608 
# names Buchet  54608 
# names Brandscheid  54608 56459 
# names Scheid  54611 
# names Hallschlag  54611 
# names Nimshuscheid  54612 
# names Lasel  54612 
# names Niederlauch  54614 
# names Nimsreuland  54614 
# names Oberlauch  54614 
# names Heisdorf  54614 
# names Dingdorf  54614 
# names Giesdorf  54614 
# names Winringen  54614 
# names Winterspelt  54616 
# names Sevenig  54673 
# names Harspelt  54617 
# names Heckhuscheid  54619 
# names Kesfeld  54619 
# names Eschfeld  54619 
# names Roscheid  54619 
# names Sengerich  54619 
# names Leidenborn  54619 
# names Reiff  54619 
# names Lichtenborn  54619 
# names Bitburg  54634 
# names Niederstedem  54634 
# names Oberstedem  54634 
# names Metterich  54634 
# names Birtlingen  54634 
# names Meckel  54636 
# names Ehlenz  54636 
# names Idesheim  54636 
# names Baustert  54636 
# names Bickendorf  54636 
# names Nattenheim  54636 
# names Dockendorf  54636 
# names Altscheid  54636 
# names Wolsfeld  54636 
# names Idenheim  54636 
# names Seffern  54636 
# names Oberweis  54636 
# names Brecht  54636 
# names Wiersdorf  54636 
# names Echtershausen  54636 
# names Biersdorf  54636 
# names Feilsdorf  54636 
# names Trimport  54636 
# names Niederweiler  54636 55491 
# names Rittersdorf  54636 99448 
# names Messerich  54636 
# names Heilenbach  54636 
# names Ingendorf  54636 
# names Weidingen  54636 
# names Hamm  54636 57577 59063 59065 59067 59069 59071 59073 59075 59077 67580 
# names Oberweiler  54636 
# names Sefferweich  54636 
# names Scharfbillig  54636 
# names Hisel  54646 
# names Wettlingen  54646 
# names Enzen  54646 
# names Halsdorf  54646 
# names Bettingen  54646 
# names Brimingen  54646 
# names Olsdorf  54646 
# names Stockem  54646 
# names Niehl  54646 
# names Dudeldorf  54647 
# names Gondorf  54647 
# names Eilscheid  54649 
# names Dackscheid  54649 
# names Niederpierscheid  54649 
# names Hargarten  54649 
# names Oberpierscheid  54649 
# names Lambertsberg  54649 
# names Mauel  54649 
# names Lauperath  54649 
# names Waxweiler  54649 
# names Pintesfeld  54649 
# names Seinsfeld  54655 
# names Kyllburgweiler  54655 
# names Malberg  54655 57629 
# names Usch  54655 
# names Orsfeld  54655 
# names Zendscheid  54655 
# names Kyllburg  54655 
# names Steinborn  54655 
# names Etteldorf  54655 
# names Malbergweich  54655 
# names Wilsecker  54655 
# names Gindorf  54657 
# names Badem  54657 
# names Neidenbach  54657 
# names Philippsheim  54662 
# names Speicher  54662 
# names Beilingen  54662 
# names Herforst  54662 
# names Preist  54664 
# names Hosten  54664 
# names Irrel  54666 
# names Ferschweiler  54668 
# names Kaschenbach  54668 
# names Holsthum  54668 
# names Ernzen  54668 
# names Peffingen  54668 
# names Schankweiler  54668 
# names Niederweis  54668 
# names Bollendorf  54669 
# names Plascheid  54673 
# names Berkoth  54673 
# names Keppeshausen  54673 
# names Zweifelscheid  54673 
# names Sevenig  54673 
# names Neuerburg  54673 
# names Scheuern  54673 
# names Waldhof-Falkenstein  54673 
# names Rodershausen  54673 
# names Karlshausen  54673 
# names Heilbach  54673 
# names Koxhausen  54673 
# names Emmelbaum  54673 
# names Krautscheid  54673 
# names Muxerath  54673 
# names Berscheid  54673 
# names Neuerburg  54673 
# names Scheitenkorb  54673 
# names Dauwelshausen  54673 
# names Nasingen  54673 
# names Uppershausen  54673 
# names Fischbach-Oberraden  54675 
# names Geichlingen  54675 
# names Roth  54597 55442 56288 56368 57539 91154 
# names Obergeckler  54675 
# names Sinspelt  54675 
# names Utscheid  54675 
# names Kruchten  54675 
# names Nusbaum  54675 55569 
# names Mettendorf  54675 
# names Niedergeckler  54675 
# names Lahr  54675 56288 
# names Gentingen  54675 
# names Biesdorf  54675 
# names Hommerdingen  54675 
# names Niederraden  54675 
# names Arzfeld  54687 
# names Affler  54689 
# names Olmscheid  54689 
# names Jucken  54689 
# names Dasburg  54689 
# names Dahnen  54689 
# names Daleiden  54689 
# names Reipeldingen  54689 
# names Preischeid  54689 
# names Irrhausen  54689 
# names Kickeshausen  54689 
# names Mainz  55116 55118 55120 55122 55124 55126 55127 55128 55129 55130 55131 
# names Ensheim  55232 
# names Alzey  55232 
# names Dintesheim  55234 
# names Hangen-Weisheim  55234 
# names Hochborn  55234 
# names Esselborn  55234 
# names Bechenheim  55234 
# names Gau-Heppenheim  55234 
# names Kettenheim  55234 
# names Bechtolsheim  55234 
# names Eppelsheim  55234 
# names Flomborn  55234 
# names Framersheim  55234 
# names Freimersheim  55234 67482 
# names Wendelsheim  55234 
# names Monzernheim  55234 
# names Biebelnheim  55234 
# names Wahlheim  55234 
# names Albig  55234 
# names Bermersheim  67593 
# names Nieder-Wiesen  55234 
# names Offenheim  55234 
# names Nack  55234 
# names Lonsheim  55237 
# names Flonheim  55237 
# names Gau-Odernheim  55239 
# names Budenheim  55257 
# names Wackernheim  55263 
# names Nieder-Olm  55268 
# names Zornheim  55270 
# names Essenheim  55270 
# names Ober-Olm  55270 
# names Jugenheim  55270 
# names Engelstadt  55270 
# names Klein-Winternheim  55270 
# names Bubenheim  55270 67308 
# names Stadecken-Elsheim  55271 
# names Oppenheim  55276 
# names Dienheim  55276 
# names Friesenheim  55278 77948 
# names Weinolsheim  55278 
# names Uelversheim  55278 
# names Undenheim  55278 
# names Dexheim  55278 
# names Selzen  55278 
# names Dolgesheim  55278 
# names Dalheim  55278 
# names Hahnheim  55278 
# names Eimsheim  55278 
# names Mommenheim  55278 
# names Nierstein  55283 
# names Sulzheim  55286 97529 
# names Gabsheim  55288 
# names Partenheim  55288 
# names Schornsheim  55288 
# names Armsheim  55288 
# names Spiesheim  55288 
# names Udenheim  55288 
# names Saulheim  55291 
# names Bodenheim  55294 
# names Harxheim  55296 
# names Gau-Bischofsheim  55296 
# names Nackenheim  55299 
# names Bingen  72511 
# names Manubach  55413 
# names Niederheimbach  55413 
# names Oberheimbach  55413 
# names Oberdiebach  55413 
# names Weiler  55413 56729 56825 
# names Trechtingshausen  55413 
# names Bacharach  55422 
# names Waldalgesheim  55425 
# names Oberwesel  55430 
# names Perscheid  55430 
# names Urbar  55430 56182 
# names Niederburg  55432 
# names Damscheid  55432 
# names Gau-Algesheim  55435 
# names Ockenheim  55437 
# names Appenheim  55437 
# names Nieder-Hilbersheim  55437 
# names Ober-Hilbersheim  55437 
# names Daxweiler  55442 
# names Warmsroth  55442 
# names Stromberg  55442 
# names Seibersbach  55444 
# names Schweppenhausen  55444 
# names Waldlaubersheim  55444 
# names Eckenroth  55444 
# names Langenlonsheim  55450 
# names Guldental  55452 
# names Windesheim  55452 
# names Hergenfeld  55452 
# names Laubenheim  55452 
# names Dorsheim  55452 
# names Gensingen  55457 
# names Horrweiler  55457 
# names Grolsheim  55459 
# names Aspisheim  55459 
# names Nannhausen  55469 
# names Horn  55469 
# names Altweidelbach  55469 
# names Riegenroth  55469 
# names Niederkumbd  55469 
# names Oppertshausen  55469 
# names Mutterschied  55469 
# names Ohlweiler  55469 
# names Rayerschied  55469 
# names Bergenhausen  55469 
# names Simmern  55469 56337 
# names Klosterkumbd  55469 
# names Belgweiler  55469 
# names Holzbach  55469 
# names Budenbach  55469 
# names Pleizenhausen  55469 
# names Ravengiersburg  55471 
# names Sargenroth  55471 
# names Keidelheim  55471 
# names Fronhofen  55471 
# names Biebern  55471 
# names Reich  55471 
# names Neuerkirch  55471 
# names Lindenschied  55481 
# names Hecken  55481 
# names Metzenhausen  55481 
# names Womrath  55481 
# names Todenroth  55481 
# names Kludenbach  55481 
# names Reckershausen  55481 
# names Dillendorf  55481 
# names Schwarzen  55481 
# names Maitzborn  55481 
# names Krummenau  55483 
# names Kappel  55483 
# names Heinzenbach  55483 
# names Horbruch  55483 
# names Unzenberg  55483 
# names Dickenschied  55483 
# names Schlierschied  55483 
# names Lautzenhausen  55483 
# names Sohren  55487 
# names Dill  55487 
# names Sohrschied  55487 
# names Laufersweiler  55487 
# names Niedersohren  55487 
# names Woppenroth  55490 
# names Henau  55490 
# names Mengerschied  55490 
# names Gehlweiler  55490 
# names Wahlenau  55491 
# names Wahlbach  55494 
# names Erbach  55494 64711 89155 
# names Dichtelbach  55494 
# names Benzweiler  55494 
# names Liebshausen  55494 
# names Argenthal  55496 
# names Ellern  55497 
# names Schnorbach  55497 
# names Riesweiler  55499 
# names Tiefenthal  55546 67311 
# names Frei-Laubersheim  55546 
# names Hackenheim  55546 
# names Neu-Bamberg  55546 
# names Biebelsheim  55546 
# names Pfaffen-Schwabenheim  55546 
# names Volxheim  55546 
# names Bretzenheim  55559 
# names Kirschroth  55566 
# names Rehbach  55566 
# names Daubach  55566 56412 
# names Ippenschied  55566 
# names Meddersheim  55566 
# names Abtweiler  55568 
# names Lauschied  55568 
# names Staudernheim  55568 
# names Langenthal  55569 
# names Auen  55569 
# names Monzingen  55569 
# names Sprendlingen  55576 
# names Pleitersheim  55576 
# names Badenheim  55576 
# names Welgesheim  55576 
# names Zotzenheim  55576 
# names Wallertheim  55578 
# names Wolfsheim  55578 
# names Vendersheim  55578 
# names Gau-Weinheim  55578 
# names Oberhausen  46045 46047 46049 46117 46119 46145 46147 46149 55606 76887 82386 86697 
# names Nahe  23866 
# names Duchroth  55585 
# names Norheim  55585 
# names Altenbamberg  55585 
# names Niederhausen  55585 
# names Meisenheim  55590 77974 
# names Desloch  55592 
# names Rehborn  55592 
# names Breitenheim  55592 
# names Jeckenbach  55592 
# names Raumbach  55592 
# names Hargesheim  55595 
# names Burgsponheim  55595 
# names Winterbach  55595 66484 73650 89368 
# names Spall  55595 
# names Roxheim  55595 
# names Gebroth  55595 
# names Winterburg  55595 
# names Sommerloch  55595 
# names Traisen  55595 
# names Bockenau  55595 
# names Argenschwang  55595 
# names Allenfeld  55595 
# names Boos  55595 56729 87737 
# names Mandel  55595 
# names Sponheim  55595 
# names Dalberg  55595 
# names Braunweiler  55595 
# names Oberstreit  55596 
# names Gumbsheim  55597 
# names Gau-Bickelheim  55599 
# names Stein-Bockenheim  55599 
# names Siefersheim  55599 
# names Eckelsheim  55599 
# names Wonsheim  55599 
# names Hahnenbach  55606 
# names Brauweiler  55606 
# names Meckenbach  55606 55767 
# names Hochstetten-Dhaun  55606 
# names Kirn  55606 
# names Kellenbach  55606 
# names Bruschied  55606 
# names Otzweiler  55606 
# names Horbach  55606 56412 66851 
# names Heinzenberg  55606 
# names Heimweiler  55606 
# names Becherbach  67827 
# names Kirn  55606 
# names Griebelschied  55608 
# names Berschweiler  55608 55777 
# names Schneppenbach  55608 
# names Simmertal  55618 
# names Hennweiler  55619 
# names Hundsbach  55621 
# names Oberkirn  55624 
# names Weitersbach  55624 
# names Rhaunen  55624 
# names Schwerbach  55624 
# names Bollenbach  55624 
# names Bundenbach  55626 
# names Merxheim  55627 
# names Martinstein  55627 
# names Weiler  55413 56729 56825 
# names Monzingen  55569 
# names Seesbach  55629 
# names Weitersborn  55629 
# names Schwarzerden  55629 
# names Kirschweiler  55743 
# names Idar-Oberstein  55743 
# names Gerach  55743 96161 
# names Hintertiefenbach  55743 
# names Fischbach  55743 67693 
# names Herrstein  55756 
# names Allenbach  55758 
# names Sonnschied  55758 
# names Schmidthachenbach  55758 
# names Sensweiler  55758 
# names Niederhosenbach  55758 
# names Kempfeld  55758 
# names Veitsrodt  55758 
# names Weiden  55758 92637 
# names Oberreidenbach  55758 
# names Breitenthal  55758 86488 
# names Sienhachenbach  55758 
# names Sien  55758 
# names Wickenrodt  55758 
# names Mittelreidenbach  55758 
# names Dickesbach  55758 
# names Langweiler  55758 67746 
# names Bruchweiler  55758 
# names Sulzbach  55758 56379 65843 
# names Mackenrodt  55758 
# names Oberhosenbach  55758 
# names Vollmersbach  55758 
# names Stipshausen  55758 
# names Wirschweiler  55758 
# names Hottenbach  55758 
# names Hellertshausen  55758 
# names Hettenrodt  55758 
# names Schauren  55758 56865 
# names Dienstweiler  55765 
# names Oberhambach  55765 
# names Birkenfeld  55765 75217 97834 
# names Ellweiler  55765 
# names Rimsberg  55765 
# names Elchweiler  55765 
# names Dambach  55765 
# names Rinzenberg  55767 
# names Niederhambach  55767 
# names Kronweiler  55767 
# names Niederbrombach  55767 
# names Buhlenberg  55767 
# names Sonnenberg-Winnenberg  55767 
# names Hattgenstein  55767 
# names Nohen  55767 
# names Abentheuer  55767 
# names Gimbweiler  55767 
# names Schwollen  55767 
# names Siesbach  55767 
# names Achtelsbach  55767 
# names Leisel  55767 
# names Oberbrombach  55767 
# names Baumholder  55774 
# names Berglangenbach  55776 
# names Ruschberg  55776 
# names Frauenberg  55776 
# names Hahnweiler  55776 
# names Fohren-Linden  55777 
# names Eckersweiler  55777 
# names Mettweiler  55777 
# names Leitzweiler  55779 
# names Koblenz  56068 56070 56072 56073 56075 56076 56077 
# names Lahnstein  56112 
# names Miellen  56132 
# names Becheln  56132 
# names Kemmenau  56132 
# names Dausenau  56132 
# names Nievern  56132 
# names Fachbach  56133 
# names Boppard  56154 
# names Niederwerth  56179 
# names Vallendar  56179 
# names Weitersburg  56191 
# names Hillscheid  56204 
# names Kammerforst  56206 99986 
# names Hilgert  56206 
# names Kaltenengers  56220 
# names Kettig  56220 
# names Urmitz  56220 
# names Bassenheim  56220 
# names Ransbach-Baumbach  56235 
# names Hundsdorf  56235 
# names Wirscheid  56237 
# names Wittgert  56237 
# names Alsbach  56237 
# names Caan  56237 
# names Deesen  56237 
# names Oberhaid  56237 96173 
# names Nauort  56237 
# names Sessenbach  56237 
# names Marienrachdorf  56242 
# names Quirnbach  56242 66909 
# names Nordhofen  56242 
# names Ellenhausen  56242 
# names Selters  56242 
# names Ewighausen  56244 
# names Freilingen  56244 
# names Ettinghausen  56244 
# names Weidenhahn  56244 
# names Hartenfels  56244 
# names Hahn  56850 
# names Schenkelberg  56244 
# names Maxsain  56244 
# names Leuterod  56244 
# names Helferskirchen  56244 
# names Freirachdorf  56244 
# names Sessenhausen  56244 
# names Steinen  56244 79585 
# names Goddert  56244 
# names Vielbach  56244 
# names Niedersayn  56244 
# names Herschbach  56249 
# names Treis-Karden  56253 
# names Moselkern  56254 
# names Marienhausen  56269 
# names Dierdorf  56269 
# names Maroth  56271 
# names Kleinmaischeid  56271 
# names Isenburg  56271 
# names Stebach  56276 
# names Schwall  56281 
# names Karbach  56281 97842 
# names Hungenroth  56281 
# names Emmelshausen  56281 
# names Kratzenburg  56283 
# names Halsenbach  56283 
# names Morshausen  56283 
# names Gondershausen  56283 
# names Mermuth  56283 
# names Ney  56283 
# names Beulich  56283 
# names Michelbach  56288 57610 
# names Spesenroth  56288 
# names Bubach  56288 
# names Zilshausen  56288 
# names Kastellaun  56288 
# names Hasselbach  56288 57635 
# names Korweiler  56288 
# names Bell  56288 56745 
# names Hollnich  56288 
# names Braunshorn  56288 
# names Beltheim  56290 
# names Macken  56290 
# names Dommershausen  56290 
# names Lieg  56290 
# names Uhler  56290 
# names Birkheim  56291 
# names Norath  56291 
# names Maisborn  56291 
# names Kisselbach  56291 
# names Hausbay  56291 
# names Niedert  56291 
# names Badenhard  56291 
# names Bickenbach  56291 64404 
# names Pfalzfeld  56291 
# names Wiebelsheim  56291 
# names Leiningen  56291 
# names Laudert  56291 
# names Utzenhain  56291 
# names Lingerhahn  56291 
# names Gierschnach  56294 
# names Kalt  56294 
# names Gappenach  56294 
# names Wierschem  56294 
# names Lonnig  56295 
# names Kerben  56295 
# names Ochtendung  56299 
# names Puderbach  56305 
# names Dernbach  56307 76857 
# names Harschbach  56307 
# names Hanroth  56316 
# names Niederhofen  56316 
# names Raubach  56316 
# names Linkenbach  56317 
# names Urbach  56317 73660 99765 
# names Rhens  56321 
# names Brey  56321 
# names Spay  56322 
# names Waldesch  56323 
# names Kobern-Gondorf  56330 
# names Oberfell  56332 
# names Hatzenport  56332 
# names Lehmen  56332 
# names Dieblich  56332 
# names Kattenes  56332 
# names Alken  56332 
# names Brodenbach  56332 
# names Wolken  56332 
# names Niederfell  56332 
# names Arzbach  56337 
# names Eitelborn  56337 
# names Kadenbach  56337 
# names Braubach  56338 
# names Dachsenhausen  56340 
# names Osterspai  56340 
# names Filsen  56341 
# names Kamp-Bornhofen  56341 
# names Lykershausen  56346 
# names Prath  56346 
# names Dahlheim  56348 
# names Weisel  56348 
# names Kestert  56348 
# names Patersberg  56348 
# names Bornich  56348 
# names Kaub  56349 
# names Lautert  56355 
# names Endlichhofen  56355 
# names Diethardt  56355 
# names Bettendorf  56355 
# names Hunzel  56355 
# names Winterwerb  56355 
# names Oberbachheim  56355 
# names Kehlbach  56355 
# names Dornholzhausen  56357 
# names Reitzenhain  56357 
# names Himmighofen  56357 
# names Obertiefenbach  56357 
# names Rettershain  56357 
# names Geisig  56357 
# names Eschbach  56357 76831 79427 
# names Reichenberg  56357 97234 
# names Nochern  56357 
# names Niederwallmenach  56357 
# names Lipporn  56357 
# names Weyer  56357 
# names Auel  56357 
# names Lierschied  56357 
# names Gemmerich  56357 
# names Holzhausen  39629 
# names Welterod  56357 
# names Hainau  56357 
# names Niederbachheim  56357 
# names Kasdorf  56357 
# names Miehlen  56357 
# names Oelsberg  56357 
# names Lollschied  56357 
# names Dessighofen  56357 
# names Ehr  56357 
# names Oberwallmenach  56357 
# names Marienfels  56357 
# names Ruppertshofen  56357 73577 
# names Bogel  56357 
# names Klingelbach  56368 
# names Herold  56368 
# names Katzenelnbogen  56368 
# names Niedertiefenbach  56368 
# names Ergeshausen  56368 
# names Berghausen  56368 
# names Ebertshausen  56370 
# names Bremberg  56370 
# names Reckenroth  56370 
# names Rettert  56370 
# names Eisighofen  56370 
# names Attenhausen  56370 
# names Biebrich  56370 
# names Oberfischbach  56370 
# names Gutenacker  56370 
# names Wasenbach  56370 
# names Berndroth  56370 
# names Mittelfischbach  56370 
# names Misselberg  56377 
# names Seelbach  56377 57577 57632 77960 
# names Schweighausen  56377 
# names Nassau  56377 
# names Horhausen  56379 56593 
# names Charlottenberg  56379 
# names Geilnau  56379 
# names Zimmerschied  56379 
# names Oberwies  56379 
# names Obernhof  56379 
# names Steinsberg  56379 
# names Dienethal  56379 
# names Scheidt  56379 
# names Laurenburg  56379 
# names Singhofen  56379 
# names Holzappel  56379 
# names Winden  56379 76872 
# names Montabaur  56410 
# names Girod  56412 
# names Ruppach-Goldhausen  56412 
# names Nomborn  56412 
# names Holler  56412 
# names Heiligenroth  56412 
# names Welschneudorf  56412 
# names Gackenbach  56412 
# names Untershausen  56412 
# names Niederelbert  56412 
# names Boden  56412 
# names Heilberscheid  56412 
# names Niedererbach  56412 
# names Stahlhofen  56412 
# names Oberelbert  56412 
# names Steinefrenz  56414 
# names Wallmerod  56414 
# names Salz  56414 97616 
# names Oberahr  56414 
# names Wallmerod  56414 
# names Wallmerod  56414 
# names Weroth  56414 
# names Dreikirchen  56414 
# names Herschbach  56249 
# names Bilkheim  56414 
# names Niederahr  56414 
# names Obererbach  56414 57612 
# names Hundsangen  56414 
# names Molsberg  56414 
# names Meudt  56414 
# names Wirges  56422 
# names Bannberscheid  56424 
# names Moschheim  56424 
# names Ebernhahn  56424 
# names Staudt  56424 
# names Mogendorf  56424 
# names Siershahn  56427 
# names Dernbach  56307 76857 
# names Westerburg  56457 
# names Halbs  56457 
# names Hergenroth  56457 
# names Willmenrod  56459 
# names Langenhahn  56459 
# names Girkenroth  56459 
# names Winnen  56459 
# names Ailertchen  56459 
# names Rothenbach  56459 
# names Kaden  56459 
# names Rotenhain  56459 
# names Stahlhofen  56412 
# names Pottum  56459 
# names Guckheim  56459 
# names Berzhahn  56459 
# names Weltersburg  56459 
# names Elbingen  56459 
# names Marienberg  09496 
# names Dreisbach  56472 
# names Fehl-Ritzhausen  56472 
# names Hardt  56472 78739 
# names Hahn  56850 
# names Marienberg  09496 
# names Nisterau  56472 
# names Stockhausen-Illfurth  56472 
# names Nisterberg  56472 
# names Hof  56472 95028 95030 95032 
# names Rennerod  56477 
# names Rennerod  56477 
# names Waigandshain  56477 
# names Stein-Neukirch  56479 
# names Liebenscheid  56479 
# names Westernohe  56479 
# names Rehe  56479 
# names Seck  56479 
# names Bretthausen  56479 
# names Irmtraut  56479 
# names Salzburg  56479 
# names Hellenhahn-Schellenberg  56479 
# names Willingen  56479 
# names Neustadt  37345 
# names Oberrod  56479 
# names Neuwied  56564 56566 56567 
# names Bonefeld  56579 
# names Rengsdorf  56579 
# names Hardert  56579 
# names Kurtscheid  56581 
# names Ehlscheid  56581 
# names Melsbach  56581 
# names Anhausen  56584 
# names Thalhausen  56584 
# names Meinborn  56584 
# names Oberraden  56587 
# names Oberhonnefeld-Gierend  56587 
# names Waldbreitbach  56588 
# names Datzeroth  56589 
# names Niederbreitbach  56589 
# names Niedersteinebach  56593 
# names Pleckhausen  56593 
# names Krunkel  56593 
# names Obersteinebach  56593 
# names Willroth  56594 
# names Rheinbrohl  56598 
# names Hammerstein  56598 
# names Leutesdorf  56599 
# names Andernach  56626 
# names Kretz  56630 
# names Plaidt  56637 
# names Kruft  56642 
# names Nickenich  56645 
# names Saffig  56648 
# names Niederzissen  56651 
# names Oberzissen  56651 
# names Brenk  56651 
# names Galenberg  56651 
# names Glees  56653 
# names Wehr  56653 79664 
# names Wassenach  56653 
# names Burgbrohl  56659 
# names Reudelsterz  56727 
# names Mayen  56727 
# names Bermel  56729 
# names Acht  56729 
# names Ettringen  56729 86833 
# names Arft  56729 
# names Anschau  56729 
# names Siebenbach  56729 
# names Virneburg  56729 
# names Monreal  56729 
# names Luxem  56729 
# names Hirten  56729 
# names Ditscheid  56729 
# names Langscheid  56729 
# names Nachtsheim  56729 
# names Nitz  56729 
# names Herresbach  56729 
# names Kehrig  56729 
# names Baar  56729 86672 
# names Welschenbach  56729 
# names Kirchwald  56729 
# names Kottenheim  56736 
# names Mendig  56743 
# names Weibern  56745 
# names Hausten  56745 
# names Rieden  56745 87668 92286 
# names Volkesfeld  56745 
# names Spessart  56746 
# names Hohenleimbach  56746 
# names Kempenich  56746 
# names Polch  56751 
# names Kollig  56751 
# names Gering  56751 
# names Einig  56751 
# names Welling  56753 
# names Naunheim  56753 
# names Mertloch  56753 
# names Trimbs  56753 
# names Pillig  56753 
# names Binningen  56754 
# names Roes  56754 
# names Brohl  56754 
# names Forst  57537 76694 
# names Eppenberg  56759 
# names Kaisersesch  56759 
# names Leienkaul  56759 
# names Kaifenheim  56761 
# names Brachtendorf  56761 
# names Hauroth  56761 
# names Eulgem  56761 
# names Urmersbach  56761 
# names Masburg  56761 
# names Zettingen  56761 
# names Hambuch  56761 
# names Gamlen  56761 
# names Berenbach  56766 
# names Filz  56766 
# names Auderath  56766 
# names Ulmen  56766 
# names Horperath  56766 
# names Mosbruch  56767 
# names Gunderath  56767 
# names Lirstal  56767 
# names Kaperich  56767 
# names Kolverath  56767 
# names Oberelz  56767 
# names Uersfeld  56767 
# names Arbach  56769 
# names Retterath  56769 
# names Bereborn  56769 
# names Valwig  56812 
# names Cochem  56812 
# names Dohr  56812 
# names Bremm  56814 
# names Ediger-Eller  56814 
# names Wirfus  56814 
# names Greimersburg  56814 
# names Bruttig-Fankel  56814 
# names Landkern  56814 
# names Ernst  56814 
# names Illerich  56814 
# names Beilstein  56814 71543 71717 
# names Faid  56814 
# names Klotten  56818 
# names Senheim-Senhals  56820 
# names Briedern  56820 
# names Mesenich  56820 
# names Nehren  56820 72147 
# names Ellenz-Poltersdorf  56821 
# names Urschmitt  56825 
# names Gevenich  56825 
# names Schmitt  56825 
# names Gillenbeuren  56825 
# names Kliding  56825 
# names Beuren  56825 72660 
# names Lutzerath  56826 
# names Wollmerath  56826 
# names Wagenhausen  56826 
# names Alflen  56828 
# names Pommern  56829 
# names Brieden  56829 
# names Kail  56829 
# names Traben-Trarbach  56841 
# names Starkenburg  56843 
# names Irmenach  56843 
# names Burg  39288 54646 
# names Enkirch  56850 
# names Raversbeuren  56850 
# names Hahn  56850 
# names Zell  56856 93199 95239 
# names Altlay  56858 
# names Liesenich  56858 
# names Grenderich  56858 
# names Mittelstrimmig  56858 
# names Neef  56858 
# names Sosberg  56858 
# names Tellig  56858 
# names Altstrimmig  56858 
# names Forst  57537 76694 
# names Belg  56858 
# names Haserich  56858 
# names Alf  56859 
# names Bullay  56859 
# names Reil  56861 
# names Moritzheim  56865 
# names Panzweiler  56865 
# names Blankenrath  56865 
# names Hesweiler  56865 
# names Walhausen  56865 
# names Reidenhausen  56865 
# names Briedel  56867 
# names Mastershausen  56869 
# names Siegen  57072 57074 57076 57078 57080 
# names Kreuztal  57223 
# names Wilnsdorf  57234 
# names Netphen  57250 
# names Freudenberg  57258 92272 97896 
# names Hilchenbach  57271 
# names Lennestadt  57368 
# names Schmallenberg  57392 
# names Kirchhundem  57399 
# names Finnentrop  57413 
# names Attendorn  57439 
# names Olpe  57462 
# names Wenden  57482 
# names Drolshagen  57489 
# names Steineroth  57518 
# names Betzdorf  57518 
# names Derschen  57520 
# names Molzhain  57520 
# names Mauden  57520 
# names Schutzbach  57520 
# names Kausen  57520 
# names Dickendorf  57520 
# names Langenbach  66909 85416 
# names Kirburg  57629 
# names Niederdreisbach  57520 
# names Emmerzhausen  57520 
# names Neunkhausen  57520 
# names Rosenheim  57520 83022 83024 83026 
# names Mittelhof  57537 
# names Wissen  57537 
# names Forst  57537 76694 
# names Bitzen  57539 
# names Bruchertseifen  57539 
# names Selbach  57539 
# names Etzbach  57539 
# names Breitscheidt  57539 
# names Kirchen  57548 
# names Mudersbach  57555 
# names Brachbach  57555 
# names Herdorf  57562 
# names Daaden  57567 
# names Niederfischbach  57572 
# names Harbach  57572 
# names Elkenroth  57578 
# names Elben  57580 
# names Fensdorf  57580 
# names Gebhardshain  57580 
# names Nauroth  57583 
# names Wallmenroth  57584 
# names Scheuerfeld  57584 
# names Weitefeld  57586 
# names Birken-Honigsessen  57587 
# names Niederirsen  57589 
# names Birkenbeul  57589 
# names Pracht  57589 
# names Ingelbach  57610 
# names Bachenberg  57610 
# names Gieleroth  57610 
# names Almersbach  57610 
# names Kroppach  57612 
# names Hilgenroth  57612 
# names Volkerzen  57612 
# names Racksen  57612 
# names Isert  57612 
# names Hemmelzen  57612 
# names Eichelhardt  57612 
# names Birnbach  57612 
# names Helmenzen  57612 
# names Helmeroth  57612 
# names Kettenhausen  57612 
# names Idelberg  57612 
# names Giesenhausen  57612 
# names Heupelzen  57612 
# names Busenhausen  57612 
# names Steimel  57614 
# names Ratzert  57614 
# names Woldert  57614 
# names Fluterschen  57614 
# names Niederwambach  57614 
# names Wahlrod  57614 
# names Borod  57614 
# names Mudenbach  57614 
# names Oberwambach  57614 
# names Gehlert  57627 
# names Heuzert  57627 
# names Marzhausen  57627 
# names Astert  57627 
# names Hachenburg  57627 
# names Wied  57629 
# names Dreifelden  57629 
# names Heimborn  57629 
# names Kirburg  57629 
# names Streithausen  57629 
# names Norken  57629 
# names Atzelgift  57629 
# names Merkelbach  57629 
# names Luckenbach  57629 
# names Wied  57629 
# names Lochum  57629 
# names Stein-Wingert  57629 
# names Kundert  57629 
# names Flammersfeld  57632 
# names Ziegenhain  57632 
# names Burglahr  57632 
# names Rott  57632 86935 
# names Reiferscheid  57632 
# names Eichen  57632 
# names Giershausen  57632 
# names Seifen  57632 
# names Walterschen  57632 
# names Eulenberg  57632 
# names Orfgen  57632 
# names Kescheid  57632 
# names Berzhausen  57632 
# names Peterslahr  57632 
# names Rettersen  57635 
# names Hirz-Maulsbach  57635 
# names Ersfeld  57635 
# names Kircheib  57635 
# names Werkhausen  57635 
# names Kraam  57635 
# names Weyerbusch  57635 
# names Fiersbach  57635 
# names Oberirsen  57635 
# names Forstmehren  57635 
# names Mammelzen  57636 
# names Neitersen  57638 
# names Obernau  57638 
# names Oberdreis  57639 
# names Rodenbach  57639 63517 67688 
# names Oberlahr  57641 
# names Alpenrod  57642 
# names Winkelbach  57644 
# names Hattert  57644 
# names Welkenbach  57644 
# names Nister  57645 
# names Nistertal  57647 
# names Enspel  57647 
# names Unnau  57648 
# names Schwerte  58239 
# names Ennepetal  58256 
# names Gevelsberg  58285 
# names Wetter  35083 
# names Herdecke  58313 
# names Schwelm  58332 
# names Breckerfeld  58339 
# names Witten  58452 58453 58454 58455 58456 
# names Meinerzhagen  58540 
# names Halver  58553 
# names Kierspe  58566 
# names Iserlohn  58636 58638 58640 58642 58644 
# names Hemer  58675 
# names Menden  58706 58708 58710 
# names Wickede  58739 
# names Altena  58762 
# names Nachrodt-Wiblingwerde  58769 
# names Werdohl  58791 
# names Balve  58802 
# names Neuenrade  58809 
# names Plettenberg  58840 
# names Herscheid  58849 
# names Kamen  59174 
# names Bergkamen  59192 
# names Ahlen  59227 59229 
# names Beckum  59269 
# names Oelde  59302 
# names Ennigerloh  59320 
# names Wadersloh  59329 
# names Werne  59368 
# names Selm  59379 
# names Nordkirchen  59394 
# names Olfen  59399 
# names Unna  59423 59425 59427 
# names Holzwickede  59439 
# names Werl  59457 
# names Ense  59469 
# names Soest  59494 
# names Lippetal  59510 
# names Welver  59514 
# names Lippstadt  59555 59556 59557 59558 
# names Warstein  59581 
# names Geseke  59590 
# names Erwitte  59597 
# names Arnsberg  59755 59757 59759 59821 59823 
# names Sundern  59846 
# names Meschede  59872 
# names Eslohe  59889 
# names Bestwig  59909 
# names Brilon  59929 
# names Olsberg  59939 
# names Winterberg  59955 
# names Medebach  59964 
# names Hallenberg  59969 
# names Bromskirchen  59969 
# names Nidderau  61130 
# names Niederdorfelden  61138 
# names Friedberg  61169 86316 
# names Karben  61184 
# names Rosbach  06242 53547 56271 94439 
# names Niddatal  61194 
# names Florstadt  61197 
# names Reichelsheim  61203 64385 
# names Echzell  61209 
# names Nauheim  64569 
# names Usingen  61250 
# names Neu-Anspach  61267 
# names Wehrheim  61273 
# names Weilrod  61276 
# names Homburg  66424 
# names Friedrichsdorf  61381 
# names Schmitten  61389 
# names Oberursel  61440 
# names Steinbach  36448 37308 56291 
# names Offenbach  63065 63067 63069 63071 63073 63075 
# names Rodgau  63110 
# names Dietzenbach  63128 
# names Heusenstamm  63150 
# names Obertshausen  63179 
# names Neu-Isenburg  63263 
# names Dreieich  63303 
# names Egelsbach  63329 
# names Hanau  63450 63452 63454 63456 63457 
# names Maintal  63477 
# names Seligenstadt  63500 
# names Langenselbold  63505 
# names Hainburg  63512 
# names Erlensee  63526 
# names Mainhausen  63533 
# names Neuberg  63543 
# names Hammersbach  63546 
# names Gelnhausen  63571 
# names Freigericht  63579 
# names Linsengericht  63589 
# names Hasselroth  63594 
# names Birstein  63633 
# names Brachttal  63636 
# names Jossgrund  63637 
# names Nidda  63667 
# names Altenstadt  63674 86972 89281 
# names Schotten  63679 
# names Ortenberg  63683 77799 
# names Gedern  63688 
# names Ranstadt  63691 
# names Limeshain  63694 
# names Glauburg  63695 
# names Hirzenhain  63697 
# names Kefenrod  63699 
# names Aschaffenburg  63739 63741 63743 
# names Goldbach  63773 99869 
# names Kleinostheim  63801 
# names Haibach  63808 94353 
# names Mainaschaff  63814 
# names Elsenfeld  63820 
# names Westerngrund  63825 
# names Sommerkahl  63825 
# names Blankenbach  63825 
# names Geiselbach  63826 
# names Kleinkahl  63828 
# names Wiesen  63831 
# names Sulzbach  55758 56379 65843 
# names Kleinwallstadt  63839 
# names Niedernberg  63843 
# names Laufach  63846 
# names Leidersbach  63849 
# names Bessenbach  63856 
# names Waldaschaff  63857 
# names Rothenbuch  63860 
# names Eschau  63863 
# names Glattbach  63864 
# names Johannesberg  63867 
# names Heinrichsthal  63871 
# names Heimbuchenthal  63872 
# names Dammbach  63874 
# names Mespelbrunn  63875 
# names Sailauf  63877 
# names Weibersbrunn  63879 
# names Miltenberg  63897 
# names Erlenbach  74235 76872 76891 
# names Amorbach  63916 
# names Kleinheubach  63924 
# names Laudenbach  63925 69514 
# names Kirchzell  63931 
# names Weilbach  63937 
# names Darmstadt  64283 64285 64287 64289 64291 64293 64295 64297 
# names Pfungstadt  64319 
# names Weiterstadt  64331 
# names Seeheim-Jugenheim  64342 
# names Griesheim  64347 
# names Reinheim  64354 
# names Ober-Ramstadt  64372 
# names Erzhausen  64390 
# names Brensbach  64395 
# names Modautal  64397 
# names Fischbachtal  64405 
# names Messel  64409 
# names Riedstadt  64560 
# names Nauheim  64569 
# names Gernsheim  64579 
# names Bensheim  64625 
# names Lorsch  64653 
# names Rimbach  64668 84326 93485 
# names Zwingenberg  64673 69439 
# names Lindenfels  64678 
# names Einhausen  64683 98617 
# names Grasellenbach  64689 
# names Michelstadt  64720 
# names Beerfelden  64743 
# names Breuberg  64747 
# names Brombachtal  64753 
# names Hesseneck  64754 
# names Mossautal  64756 
# names Rothenberg  64757 
# names Sensbachtal  64759 
# names Dieburg  64807 
# names Babenhausen  64832 87727 
# names Schaafheim  64850 
# names Otzberg  64853 
# names Eppertshausen  64859 
# names Wiesbaden  65183 65185 65187 65189 65191 65193 65195 65197 65199 65201 65203 65205 65207 
# names Taunusstein  65232 
# names Hochheim  97633 99869 
# names Schwalbach  66773 
# names Heidenrod  65321 
# names Aarbergen  65326 
# names Hohenstein  65329 72531 99735 99755 
# names Geisenheim  65366 
# names Oestrich-Winkel  65375 
# names Schlangenbad  65388 
# names Lorch  65391 73547 
# names Sauerthal  65391 
# names Walluf  65396 
# names Kiedrich  65399 
# names Kelsterbach  65451 
# names Ginsheim-Gustavsburg  65462 
# names Trebur  65468 
# names Bischofsheim  65474 
# names Raunheim  65479 
# names Idstein  65510 
# names Niedernhausen  65527 
# names Waldems  65529 
# names Lahn  49757 
# names Cramberg  65558 
# names Balduinstein  65558 
# names Holzheim  65558 86684 89291 89438 
# names Langenscheid  65558 
# names Flacht  65558 
# names Heistenbach  65558 
# names Eppenrod  65558 
# names Lohrheim  65558 
# names Oberneisen  65558 
# names Isselbach  65558 
# names Burgschwalbach  65558 
# names Kaltenholzhausen  65558 
# names Hambach  65582 
# names Aull  65582 
# names Diez  65582 
# names Hadamar  65589 
# names Runkel  65594 
# names Elz  65604 
# names Villmar  65606 
# names Brechen  65611 
# names Beselich  65614 
# names Selters  56242 
# names Waldbrunn  69429 97295 
# names Mudershausen  65623 
# names Schiesheim  65623 
# names Netzbach  65623 
# names Altendiez  65624 
# names Birlenbach  65626 
# names Elbtal  65627 
# names Niederneisen  65629 
# names Eschborn  65760 
# names Hattersheim  65795 
# names Eppstein  65817 
# names Schwalbach  66773 
# names Kriftel  65830 
# names Heusweiler  66265 
# names Kleinblittersdorf  66271 
# names Quierschied  66287 
# names Riegelsberg  66292 
# names Bous  66359 
# names Mandelbachtal  66399 
# names Homburg  66424 
# names Blieskastel  66440 
# names Bexbach  66450 
# names Gersheim  66453 
# names Kirkel  66459 
# names Battweiler  66484 
# names Kleinsteinhausen  66484 
# names Dietrichingen  66484 
# names Riedelberg  66484 
# names Schmitshausen  66484 
# names Walshausen  66484 
# names Althornbach  66484 
# names Contwig  66497 
# names Hornbach  66500 
# names Mauschbach  66500 
# names Kleinbundenbach  66501 
# names Dellfeld  66503 
# names Bottenbach  66504 
# names Reifenberg  66507 
# names Illingen  66557 75428 
# names Ottweiler  66564 
# names Eppelborn  66571 
# names Schiffweiler  66578 
# names Spiesen-Elversberg  66583 
# names Merchweiler  66589 
# names Nonnweiler  66620 
# names Nohfelden  66625 
# names Freisen  66629 
# names Tholey  66636 
# names Namborn  66640 
# names Marpingen  66646 
# names Oberthal  66649 
# names Merzig  66663 
# names Wadern  66687 
# names Mettlach  66693 
# names Beckingen  66701 
# names Perl  66706 
# names Weiskirchen  66709 
# names Saarlouis  66740 
# names Dillingen  66763 
# names Schwalbach  66773 
# names Rehlingen-Siersburg  66780 
# names Wadgassen  66787 
# names Saarwellingen  66793 
# names Wallerfangen  66798 
# names Ensdorf  66806 92266 
# names Nalbach  66809 
# names Lebach  66822 
# names Schmelz  66839 
# names Landstuhl  66849 
# names Mittelbrunn  66851 
# names Bann  66851 
# names Oberarnbach  66851 
# names Steinalben  66851 
# names Queidersbach  66851 
# names Hauptstuhl  66851 
# names Kindsbach  66862 
# names Schellweiler  66869 
# names Blaubach  66869 
# names Ruthweiler  66869 
# names Pfeffelbach  66871 
# names Konken  66871 
# names Theisbergstegen  66871 
# names Ehweiler  66871 
# names Reichweiler  66871 
# names Etschberg  66871 
# names Albessen  66871 
# names Oberalben  66871 
# names Thallichtenberg  66871 
# names Selchenbach  66871 
# names Dennweiler-Frohnbach  66871 
# names Herchweiler  66871 
# names Ramstein-Miesenbach  66877 
# names Kottweiler-Schwanden  66879 
# names Steinwenden  66879 
# names Niederstaufenbach  66879 
# names Kollweiler  66879 
# names Reichenbach-Steegen  66879 
# names Oberstaufenbach  66879 
# names Niedermohr  66879 
# names Bedesbach  66885 
# names Altenglan  66885 
# names Ulmet  66887 
# names Neunkirchen  54426 56479 57290 63930 74867 
# names Jettenbach  66887 84555 
# names Welchweiler  66887 
# names Rammelsbach  66887 
# names Elzweiler  66887 
# names Horschbach  66887 
# names Erdesbach  66887 
# names Bosenbach  66887 
# names Rathsweiler  66887 
# names Niederalben  66887 
# names Bechhofen  66894 91572 
# names Wiesbach  66894 
# names Gerhardsbrunn  66894 
# names Langwieden  66894 
# names Rosenkopf  66894 
# names Lambsborn  66894 
# names Ohmbach  66903 
# names Gries  66903 
# names Dittweiler  66903 
# names Frohnhofen  66903 
# names Rehweiler  66907 
# names Henschtal  66909 
# names Steinbach  36448 37308 56291 
# names Wahnwegen  66909 
# names Herschweiler-Pettersheim  66909 
# names Langenbach  66909 85416 
# names Krottelbach  66909 
# names Nanzdietschweiler  66909 
# names Matzenbach  66909 
# names Waldmohr  66914 
# names Dunzweiler  66916 
# names Knopp-Labach  66917 
# names Wallhalben  66917 
# names Biedershausen  66917 
# names Hermersberg  66919 
# names Schauerberg  66919 
# names Hettenhausen  66919 
# names Obernheim-Kirchenarnbach  66919 
# names Herschberg  66919 
# names Saalstadt  66919 
# names Weselberg  66919 
# names Pirmasens  66953 66954 66955 
# names Obersimten  66957 
# names Vinningen  66957 
# names Ruppertsweiler  66957 
# names Schweix  66957 
# names Eppenbrunn  66957 
# names Hilst  66957 
# names Trulben  66957 
# names Lemberg  66969 
# names Rodalben  66976 
# names Leimen  66978 69181 
# names Clausen  66978 
# names Donsieders  66978 
# names Merzalben  66978 
# names Dahn  66994 
# names Schindhard  66996 
# names Erfweiler  66996 
# names Hirschthal  66996 
# names Fischbach  55743 67693 
# names Dahn  66994 
# names Ludwigswinkel  66996 
# names Hinterweidenthal  66999 
# names Schifferstadt  67105 
# names Mutterstadt  67112 
# names Limburgerhof  67117 
# names Altrip  67122 
# names Dannstadt-Schauernheim  67125 
# names Hochdorf-Assenheim  67126 
# names Maxdorf  67133 
# names Birkenheide  67134 
# names Neuhofen  67141 
# names Deidesheim  67146 
# names Forst  57537 76694 
# names Niederkirchen  67700 
# names Deidesheim  67146 
# names Ruppertsberg  67152 
# names Wachenheim  67591 
# names Ellerstadt  67158 
# names Friedelsheim  67159 
# names Waldsee  67165 
# names Otterstadt  67166 
# names Erpolzheim  67167 
# names Kallstadt  67169 
# names Frankenthal  01909 
# names Laumersheim  67229 
# names Gerolsheim  67229 
# names Bobenheim-Roxheim  67240 
# names Lambsheim  67245 
# names Dirmstein  67246 
# names Freinsheim  67251 
# names Kleinniedesheim  67259 
# names Beindersheim  67259 
# names Heuchelheim  35452 
# names Frankenthal  01909 
# names Kleinkarlbach  67271 
# names Neuleiningen  67271 
# names Mertesheim  67271 
# names Kindenheim  67271 
# names Berg  53505 56357 82335 88276 95180 
# names Berg  53505 56357 82335 88276 95180 
# names Dackenheim  67273 
# names Berg  53505 56357 82335 88276 95180 
# names Bockenheim  67278 
# names Quirnheim  67280 
# names Ebertsheim  67280 
# names Kirchheim  36275 97268 99334 
# names Bissersheim  67281 
# names Obrigheim  67283 74847 
# names Kirchheimbolanden  67292 
# names Gauersheim  67294 
# names Bischheim  67294 
# names Oberwiesen  67294 
# names Morschheim  67294 
# names Stetten  67294 87778 88719 
# names Orbis  67294 
# names Mauchenheim  67294 
# names Rittersheim  67294 
# names Ilbesheim  67294 
# names Bolanden  67295 
# names Marnheim  67297 
# names Kerzenheim  67304 
# names Ramsen  67305 
# names Biedesheim  67308 
# names Niefernheim-Zellertal  67308 
# names Einselthum  67308 
# names Harxheim-Zellertal  67308 
# names Ottersheim  67308 76879 
# names Lautersheim  67308 
# names Immesheim  67308 
# names Zell-Zellertal  67308 
# names Hettenleidelheim  67310 
# names Carlsberg  67316 
# names Altleiningen  67317 
# names Wattenheim  67319 
# names Speyer  67346 
# names Lingenfeld  67360 
# names Freisbach  67361 
# names Lustadt  67363 
# names Schwegenheim  67365 
# names Weingarten  67366 76356 88250 99869 
# names Westheim  67368 91747 
# names Dudenhofen  67373 
# names Hanhofen  67374 
# names Harthausen  67376 
# names Gommersheim  67377 
# names Zeiskam  67378 
# names Neustadt  37345 
# names Lambrecht  67466 
# names Frankeneck  67468 
# names Neidenfels  67468 
# names Elmstein  67471 
# names Esthal  67472 
# names Weidenthal  67475 
# names Edenkoben  67480 
# names Venningen  67482 
# names Altdorf  67482 71155 72655 84032 90518 
# names Edesheim  67483 
# names Kleinfischlingen  67483 
# names Maikammer  67487 
# names Kirrweiler  67744 
# names Worms  67547 67549 67550 67551 
# names Osthofen  67574 
# names Eich  67575 
# names Alsheim  67577 
# names Gimbsheim  67578 
# names Mettenheim  67582 84562 
# names Guntersblum  67583 
# names Wintersheim  67587 
# names Monsheim  67590 71297 
# names Offstein  67591 
# names Wachenheim  67591 
# names Bermersheim  67593 
# names Westhofen  67593 
# names Bechtheim  67595 
# names Frettenheim  67596 
# names Gundersheim  67598 
# names Gundheim  67599 
# names Kaiserslautern  67655 67657 67659 67661 67663 
# names Enkenbach-Alsenborn  67677 
# names Mehlingen  67678 
# names Neuhemsbach  67680 
# names Sembach  67681 
# names Wartenberg-Rohrbach  67681 
# names Weilerbach  67685 
# names Erzenhausen  67685 
# names Eulenbis  67685 
# names Schwedelbach  67685 
# names Mackenbach  67686 
# names Hochspeyer  67691 
# names Waldleiningen  67693 
# names Otterberg  67697 
# names Schneckenhausen  67699 
# names Heiligenmoschel  67699 
# names Niederkirchen  67700 
# names Schallodenbach  67701 
# names Stelzenberg  67705 
# names Trippstadt  67705 
# names Krickenbach  67706 
# names Schopp  67707 
# names Waldfischbach-Burgalben  67714 
# names Geiselberg  67715 
# names Heltersberg  67716 
# names Schmalenberg  67718 
# names Winnweiler  67722 
# names Hochstein  67722 
# names Potzbach  67722 
# names Gonbach  67724 
# names Gehrweiler  67724 
# names Gundersweiler  67724 
# names Breunigweiler  67725 
# names Lohnsfeld  67727 
# names Alsenz  67821 
# names Sippersfeld  67729 
# names Otterbach  67731 
# names Hirschhorn  67732 69434 
# names Katzweiler  67734 
# names Sulzbachtal  67734 
# names Mehlbach  67735 
# names Frankelbach  67737 
# names Deimberg  67742 
# names Adenbach  67742 
# names Herren-Sulzbach  67742 
# names Lauterecken  67742 
# names Buborn  67742 
# names Heinzenhausen  67742 
# names Hausweiler  67742 
# names Ginsweiler  67742 
# names Lohnweiler  67744 
# names Wiesweiler  67744 
# names Medard  67744 
# names Seelen  67744 
# names Kirrweiler  67744 
# names Cronenberg  67744 
# names Schweinschied  67744 
# names Rathskirchen  67744 
# names Grumbach  67745 
# names Unterjeckenbach  67746 
# names Merzweiler  67746 
# names Odenbach  67748 
# names Offenbach-Hundheim  67749 
# names Nerzweiler  67749 
# names Lauter  96169 
# names Wolfstein  67752 
# names Oberweiler-Tiefenbach  67752 
# names Aschbach  67753 
# names Hefersweiler  67753 
# names Rothselberg  67753 
# names Reipoltskirchen  67753 
# names Oberweiler  54636 
# names Hinzweiler  67756 
# names Relsberg  67756 
# names Kreimbach-Kaulbach  67757 
# names Reichsthal  67759 
# names Bisterschied  67806 
# names Teschenmoschel  67806 
# names Katzenbach  67806 
# names Rockenhausen  67806 
# names Ransweiler  67808 
# names Schweisweiler  67808 
# names Bennhausen  67808 
# names Falkenstein  67808 93167 
# names Steinbach  36448 37308 56291 
# names Ruppertsecken  67808 
# names Imsweiler  67808 
# names Stahlberg  67808 
# names Bayerfeld-Steckweiler  67808 
# names Weitersweiler  67808 
# names Dielkirchen  67811 
# names Gerbach  67813 
# names Jakobsweiler  67814 
# names Dannenfels  67814 
# names Dreisen  67816 
# names Imsbach  67817 
# names Kriegsfeld  67819 
# names Alsenz  67821 
# names Finkenbach-Gersweiler  67822 
# names Winterborn  67822 
# names Waldgrehweiler  67822 
# names Oberhausen  46045 46047 46049 46117 46119 46145 46147 46149 55606 76887 82386 86697 
# names Appel  21279 
# names Niederhausen  55585 
# names Appel  21279 
# names Niedermoschel  67822 
# names Gaugrehweiler  67822 
# names Kalkofen  67822 
# names Sitters  67823 
# names Obermoschel  67823 
# names Lettweiler  67823 
# names Schiersfeld  67823 
# names Unkenbach  67823 
# names Feilbingert  67824 
# names Hallgarten  67826 
# names Becherbach  67827 
# names Schmittweiler  67829 
# names Callbach  67829 
# names Reiffelbach  67829 
# names Mannheim  68159 68161 68163 68165 68167 68169 68199 68219 68229 68239 68259 68305 68307 68309 
# names Viernheim  68519 
# names Ladenburg  68526 
# names Edingen-Neckarhausen  68535 
# names Heddesheim  68542 
# names Ilvesheim  68549 
# names Lampertheim  68623 
# names Biblis  68647 
# names Plankstadt  68723 
# names Oftersheim  68723 
# names Schwetzingen  68723 
# names Hockenheim  68766 
# names Ketsch  68775 
# names Oberhausen-Rheinhausen  68794 
# names Reilingen  68799 
# names Heidelberg  69115 69117 69118 69120 69121 69123 69124 69126 
# names Wiesloch  69168 
# names Walldorf  69190 98639 
# names Schriesheim  69198 
# names Sandhausen  69207 
# names Eppelheim  69214 
# names Dossenheim  69221 
# names Rauenberg  69231 
# names Dielheim  69234 
# names Neckarsteinach  69239 
# names Bammental  69245 
# names Gaiberg  69251 
# names Heiligkreuzsteinach  69253 
# names Malsch  69254 76316 
# names Mauer  69256 
# names Wiesenbach  69257 86519 
# names Wilhelmsfeld  69259 
# names Eberbach  69412 
# names Mudau  69427 
# names Waldbrunn  69429 97295 
# names Heddesbach  69434 
# names Neckargerach  69437 
# names Weinheim  69469 
# names Wald-Michelbach  69483 
# names Birkenau  69488 
# names Hirschberg  07927 65558 
# names Hemsbach  69502 
# names Gorxheimertal  69517 
# names Abtsteinach  69518 
# names Stuttgart  70173 70174 70176 70178 70180 70182 70184 70186 70188 70190 70191 70192 70193 70195 70197 70199 70327 70329 70372 70374 70376 70378 70435 70437 70439 70469 70499 70563 70565 70567 70569 70597 70599 70619 70629 
# names Fellbach  70734 70736 
# names Leinfelden-Echterdingen  70771 
# names Filderstadt  70794 
# names Kornwestheim  70806 
# names Gerlingen  70839 
# names Sindelfingen  71063 71065 71067 71069 
# names Herrenberg  71083 
# names Holzgerlingen  71088 
# names Weil  86947 
# names Magstadt  71106 
# names Waldenbuch  71111 
# names Grafenau  71120 94481 
# names Jettingen  71131 
# names Aidlingen  71134 
# names Ehningen  71139 
# names Steinenbronn  71144 
# names Bondorf  71149 
# names Nufringen  71154 
# names Hildrizhausen  71157 
# names Leonberg  71229 95666 
# names Ditzingen  71254 
# names Weil  86947 
# names Renningen  71272 
# names Rutesheim  71277 
# names Weissach  71287 
# names Friolzheim  71292 
# names Heimsheim  71296 
# names Wimsheim  71299 
# names Waiblingen  71332 71334 71336 
# names Winnenden  71364 
# names Weinstadt  71384 
# names Leutenbach  71397 91359 
# names Korb  71404 
# names Schwaikheim  71409 
# names Backnang  71522 
# names Murrhardt  71540 
# names Aspach  71546 99880 
# names Auenwald  71549 
# names Weissach  71287 
# names Sulzbach  55758 56379 65843 
# names Murr  71711 
# names Affalterbach  71563 
# names Oppenweiler  71570 
# names Burgstetten  71576 
# names Spiegelberg  71579 
# names Ludwigsburg  71634 71636 71638 71640 71642 
# names Asperg  71679 
# names Freiberg  09599 
# names Schwieberdingen  71701 
# names Steinheim  32839 
# names Murr  71711 
# names Murr  71711 
# names Oberstenfeld  71720 
# names Benningen  87734 
# names Erdmannhausen  71729 
# names Tamm  71732 
# names Eberdingen  71735 
# names Kirchberg  08107 55481 84434 
# names Murr  71711 
# names Oberriexingen  71739 
# names Ammerbuch  72119 
# names Pliezhausen  72124 
# names Kusterdingen  72127 
# names Ofterdingen  72131 
# names Dettenhausen  72135 
# names Kirchentellinsfurt  72138 
# names Hirrlingen  72145 
# names Neustetten  72149 
# names Dornhan  72175 
# names Waldachtal  72178 
# names Starzach  72181 
# names Empfingen  72186 
# names Nagold  72202 
# names Altensteig  72213 
# names Haiterbach  72221 
# names Ebhausen  72224 
# names Simmersfeld  72226 
# names Egenhausen  72227 
# names Rohrdorf  72229 83101 
# names Freudenstadt  72250 
# names Baiersbronn  72270 
# names Alpirsbach  72275 
# names Dornstetten  72280 
# names Pfalzgrafenweiler  72285 
# names Glatten  72293 
# names Schopfloch  72296 91626 
# names Seewald  72297 
# names Balingen  72336 
# names Rosenfeld  72348 
# names Geislingen  72351 
# names Dautmergen  72356 
# names Dormettingen  72358 
# names Dotternhausen  72359 
# names Hausen  37327 55608 63840 91353 93345 97647 
# names Tann  36142 84367 
# names Nusplingen  72362 
# names Obernheim  72364 
# names Ratshausen  72365 
# names Zimmern  07778 
# names Burg  39288 54646 
# names Hechingen  72379 
# names Burladingen  72393 
# names Haigerloch  72401 
# names Bisingen  72406 
# names Bodelshausen  72411 
# names Rangendingen  72414 
# names Grosselfingen  72415 
# names Jungingen  72417 
# names Neufra  72419 
# names Albstadt  72458 72459 72461 
# names Winterlingen  72474 
# names Bitz  72475 
# names Schwenningen  72477 89443 
# names Sigmaringen  72488 
# names Gammertingen  72501 
# names Krauchenwies  72505 
# names Stetten  67294 87778 88719 
# names Bingen  72511 
# names Hettingen  72513 
# names Inzigkofen  72514 
# names Scheer  72516 
# names Sigmaringendorf  72517 
# names Veringenstadt  72519 
# names Gomadingen  72532 
# names Hayingen  72534 
# names Heroldstatt  72535 
# names Mehrstetten  72537 
# names Pfronstetten  72539 
# names Metzingen  72555 
# names Grabenstetten  72582 
# names Riederich  72585 
# names Westerheim  72589 87784 
# names Aichtal  72631 
# names Frickenhausen  72636 
# names Neuffen  72639 
# names Oberboihingen  72644 
# names Wolfschlugen  72649 
# names Neckartenzlingen  72654 
# names Altenriet  72657 
# names Bempflingen  72658 
# names Grafenberg  72661 91322 
# names Kohlberg  72664 92702 
# names Neckartailfingen  72666 
# names Schlaitdorf  72667 
# names Unterensingen  72669 
# names Reutlingen  72760 72762 72764 72766 72768 72770 
# names Pfullingen  72793 
# names Lichtenstein  72805 
# names Gomaringen  72810 
# names Trochtelfingen  72818 
# names Wannweil  72827 
# names Engstingen  72829 
# names Ebersbach  01561 04720 
# names Uhingen  73066 
# names Donzdorf  73072 
# names Salach  73084 
# names Boll  73087 
# names Albershausen  73095 
# names Rechberghausen  73098 
# names Adelberg  73099 
# names Aichelberg  73101 
# names Birenbach  73102 
# names Eschenbach  73107 
# names Gammelshausen  73108 
# names Hattenhofen  73110 82285 
# names Lauterstein  73111 
# names Ottenbach  73113 
# names Schlat  73114 
# names Zell  56856 93199 95239 
# names Aichelberg  73101 
# names Plochingen  73207 
# names Kirchheim  36275 97268 99334 
# names Weilheim  79809 
# names Wernau  73249 
# names Lenningen  73252 
# names Reichenbach  07629 55776 93189 96358 
# names Bissingen  86657 
# names Erkenbrechtsweiler  73268 
# names Hochdorf  73269 88454 
# names Holzmaden  73271 
# names Neidlingen  73272 
# names Notzingen  73274 
# names Ohmden  73275 
# names Owen  73277 
# names Schlierbach  73278 
# names Geislingen  72351 
# names Deggingen  73326 
# names Kuchen  73329 
# names Amstetten  73340 
# names Gruibingen  73344 
# names Hohenstadt  73345 
# names Drackenstein  73345 
# names Wiesensteig  73349 
# names Aalen  73430 73431 73432 73433 73434 
# names Bopfingen  73441 
# names Oberkochen  73447 
# names Neresheim  73450 
# names Essingen  73457 76879 
# names Westhausen  73463 98663 99869 
# names Lauchheim  73466 
# names Kirchheim  36275 97268 99334 
# names Unterschneidheim  73485 
# names Adelmannsfelden  73486 
# names Jagstzell  73489 
# names Neuler  73491 
# names Rainau  73492 
# names Rosenberg  73494 74749 
# names Tannhausen  73497 
# names Heubach  73540 
# names Waldstetten  73550 89367 
# names Alfdorf  73553 
# names Mutlangen  73557 
# names Spraitbach  73565 
# names Durlangen  73568 
# names Eschach  73569 
# names Heuchlingen  73572 
# names Iggingen  73574 
# names Leinzell  73575 
# names Schechingen  73579 
# names Schorndorf  73614 93489 
# names Remshalden  73630 
# names Rudersberg  73635 
# names Welzheim  73642 
# names Berglen  73663 
# names Baltmannsweiler  73666 
# names Kaisersbach  73667 
# names Lichtenwald  73669 
# names Ostfildern  73760 
# names Neuhausen  03058 75242 
# names Denkendorf  73770 85095 
# names Aichwald  73773 
# names Altbach  73776 
# names Deizisau  73779 
# names Heilbronn  74072 74074 74076 74078 74080 74081 
# names Neckarsulm  74172 
# names Obersulm  74182 
# names Weinsberg  74189 
# names Schwaigern  74193 
# names Untergruppenbach  74199 
# names Leingarten  74211 
# names Flein  74223 
# names Nordheim  74226 98631 
# names Oedheim  74229 
# names Abstatt  74232 
# names Erlenbach  74235 76872 76891 
# names Krautheim  74238 99439 
# names Langenbrettach  74243 
# names Eberstadt  74246 
# names Ellhofen  74248 
# names Jagsthausen  74249 
# names Lehrensteinsfeld  74251 
# names Massenbachhausen  74252 
# names Offenau  74254 
# names Roigheim  74255 
# names Untereisesheim  74257 
# names Widdern  74259 
# names Bietigheim-Bissingen  74321 
# names Brackenheim  74336 
# names Sachsenheim  74343 
# names Besigheim  74354 
# names Ilsfeld  74360 
# names Kirchheim  36275 97268 99334 
# names Sersheim  74372 
# names Zaberfeld  74374 
# names Gemmrigheim  74376 
# names Ingersheim  74379 
# names Neckarwestheim  74382 
# names Pleidelsheim  74385 
# names Talheim  74388 78607 
# names Cleebronn  74389 
# names Erligheim  74391 
# names Freudental  74392 
# names Hessigheim  74394 
# names Mundelsheim  74395 
# names Pfaffenhofen  74397 
# names Walheim  74399 
# names Gaildorf  74405 
# names Gschwend  74417 
# names Oberrot  74420 
# names Obersontheim  74423 
# names Fichtenberg  74427 
# names Sulzbach-Laufen  74429 
# names Ilshofen  74532 
# names Mainhardt  74535 
# names Vellberg  74541 
# names Braunsbach  74542 
# names Michelbach  56288 57610 
# names Michelfeld  74545 
# names Wolpertshausen  74549 
# names Crailsheim  74564 
# names Blaufelden  74572 
# names Schrozberg  74575 
# names Fichtenau  74579 
# names Gerabronn  74582 
# names Frankenhardt  74586 
# names Satteldorf  74589 
# names Kirchberg  08107 55481 84434 
# names Langenburg  74595 
# names Stimpfach  74597 
# names Bretzfeld  74626 
# names Pfedelbach  74629 
# names Kupferzell  74635 
# names Zweiflingen  74639 
# names Ingelfingen  74653 
# names Forchtenberg  74670 
# names Mulfingen  74673 
# names Niedernhall  74676 
# names Osterburken  74706 
# names Buchen  21514 
# names Hardheim  74736 
# names Adelsheim  74740 
# names Seckach  74743 
# names Ahorn  74744 96482 
# names Ravenstein  74747 
# names Mosbach  74821 
# names Gundelsheim  74831 96163 
# names Elztal  74834 
# names Billigheim  74842 
# names Schefflenz  74850 
# names Aglasterhausen  74858 
# names Neudenau  74861 
# names Binau  74862 
# names Fahrenbach  74864 
# names Neckarzimmern  74865 
# names Schwarzach  74869 94374 
# names Sinsheim  74889 
# names Meckesheim  74909 
# names Kirchardt  74912 
# names Waibstadt  74915 
# names Angelbachtal  74918 
# names Helmstadt-Bargen  74921 
# names Neckarbischofsheim  74924 
# names Epfenbach  74925 
# names Eschelbronn  74927 
# names Ittlingen  74930 
# names Lobbach  74931 
# names Neidenstein  74933 
# names Reichartshausen  74934 
# names Siegelsbach  74936 
# names Spechbach  74937 
# names Zuzenhausen  74939 
# names Bretten  75015 
# names Eppingen  75031 
# names Oberderdingen  75038 
# names Walzbachtal  75045 
# names Gemmingen  75050 
# names Gondelsheim  75053 
# names Sulzfeld  75056 97633 98617 
# names Zaisenhausen  75059 
# names Pforzheim  75172 75173 75175 75177 75179 75180 75181 
# names Remchingen  75196 
# names Keltern  75210 
# names Ispringen  75228 
# names Tiefenbronn  75233 
# names Eisingen  75239 97249 
# names Kieselbronn  75249 
# names Engelsbrand  75331 
# names Straubenhardt  75334 
# names Dobel  75335 
# names Calw  75365 
# names Althengstett  75382 
# names Neubulach  75387 
# names Neuweiler  75389 
# names Gechingen  75391 
# names Deckenpfronn  75392 
# names Oberreichenbach  75394 91097 
# names Ostelsheim  75395 
# names Simmozheim  75397 
# names Unterreichenbach  75399 
# names Maulbronn  75433 
# names Knittlingen  75438 
# names Wiernsheim  75446 
# names Sternenfels  75447 
# names Wurmberg  75449 
# names Karlsruhe  76131 76133 76135 76137 76139 76149 76185 76187 76189 76199 76227 76228 76229 
# names Ettlingen  76275 
# names Rheinstetten  76287 
# names Stutensee  76297 
# names Karlsbad  76307 
# names Pfinztal  76327 
# names Waldbronn  76337 
# names Eggenstein-Leopoldshafen  76344 
# names Linkenheim-Hochstetten  76351 
# names Marxzell  76359 
# names Rastatt  76437 
# names Durmersheim  76448 
# names Kuppenheim  76456 
# names Muggensturm  76461 
# names Bietigheim  76467 
# names Iffezheim  76473 
# names Au  79280 
# names Bischweier  76476 
# names Elchesheim-Illingen  76477 
# names Steinmauern  76479 
# names Baden-Baden  76530 76532 76534 
# names Sinzheim  76547 
# names Gaggenau  76571 
# names Gernsbach  76593 
# names Forbach  76596 
# names Loffenau  76597 
# names Weisenbach  76599 
# names Bruchsal  76646 
# names Philippsburg  76661 
# names Graben-Neudorf  76676 
# names Karlsdorf-Neuthard  76689 
# names Ubstadt-Weiher  76698 
# names Kraichtal  76703 
# names Dettenheim  76706 
# names Kronau  76709 
# names Germersheim  76726 
# names Vollmersweiler  76744 
# names Jockgrim  76751 
# names Bellheim  76756 
# names Rheinzabern  76764 
# names Hagenbach  76767 
# names Berg  53505 56357 82335 88276 95180 
# names Kuhardt  76773 
# names Leimersheim  76774 
# names Neuburg  23974 
# names Neupotz  76777 
# names Scheibenhardt  76779 
# names Leinsweiler  76829 
# names Ranschbach  76829 
# names Heuchelheim-Klingen  76831 
# names Billigheim-Ingenheim  76831 
# names Birkweiler  76831 
# names Impflingen  76831 
# names Ilbesheim  67294 
# names Siebeldingen  76833 
# names Walsheim  76833 
# names Frankweiler  76833 
# names Hainfeld  76835 
# names Gleisweiler  76835 
# names Burrweiler  76835 
# names Roschbach  76835 
# names Flemlingen  76835 
# names Hauenstein  76846 
# names Dimbach  76848 
# names Darstein  76848 
# names Schwanheim  76848 
# names Wilgartswiesen  76848 
# names Spirkelbach  76848 
# names Wernersberg  76857 
# names Albersweiler  76857 
# names Ramberg  76857 
# names Rinnthal  76857 
# names Waldrohrbach  76857 
# names Gossersweiler-Stein  76857 
# names Waldhambach  76857 
# names Herxheimweyher  76863 
# names Insheim  76865 
# names Kandel  76870 
# names Steinweiler  76872 
# names Hergersweiler  76872 
# names Minfeld  76872 
# names Freckenfeld  76872 
# names Offenbach  63065 63067 63069 63071 63073 63075 
# names Knittelsheim  76879 
# names Hochstadt  76879 
# names Pleisweiler-Oberhofen  76889 
# names Kapellen-Drusweiler  76889 
# names Schweigen-Rechtenbach  76889 
# names Oberotterbach  76889 
# names Schweighofen  76889 
# names Oberschlettenbach  76889 
# names Niederotterbach  76889 
# names Barbelroth  76889 
# names Kapsweyer  76889 
# names Vorderweidenthal  76889 
# names Dierbach  76889 
# names Gleiszellen-Gleishorbach  76889 
# names Niederhorbach  76889 
# names Bundenthal  76891 
# names Bobenthal  76891 
# names Nothweiler  76891 
# names Niederschlettenbach  76891 
# names Busenberg  76891 
# names Rumbach  76891 
# names Offenburg  77652 77654 77656 
# names Kehl  77694 
# names Oberkirch  77704 
# names Wolfach  77709 
# names Oberwolfach  77709 
# names Hofstetten  77716 86928 
# names Fischerbach  77716 
# names Gengenbach  77723 
# names Oppenau  77728 
# names Zell  56856 93199 95239 
# names Neuried  77743 82061 
# names Schutterwald  77746 
# names Hohberg  77749 
# names Hausach  77756 
# names Schiltach  77761 
# names Appenweier  77767 
# names Durbach  77770 
# names Schenkenzell  77773 
# names Biberach  77781 
# names Oberharmersbach  77784 
# names Nordrach  77787 
# names Steinach  77790 94377 96523 
# names Berghaupten  77791 
# names Lautenbach  77794 
# names Ohlsbach  77797 
# names Ottersweier  77833 
# names Achern  77855 
# names Rheinau  77866 
# names Renchen  77871 
# names Kappelrodeck  77876 
# names Sasbach  77880 
# names Lauf  77886 
# names Sasbachwalden  77887 
# names Seebach  77889 99846 
# names Ettenheim  77955 
# names Schwanau  77963 
# names Kappel-Grafenhausen  77966 
# names Kippenheim  77971 
# names Mahlberg  77972 
# names Ringsheim  77975 
# names Rust  77977 
# names Schuttertal  77978 
# names Villingen-Schwenningen  78048 78050 78052 78054 78056 
# names Niedereschach  78078 
# names Dauchingen  78083 
# names Brigachtal  78086 
# names Unterkirnach  78089 
# names Triberg  78098 
# names Hornberg  78132 
# names Tennenbronn  78144 
# names Donaueschingen  78166 
# names Geisingen  78187 
# names Immendingen  78194 
# names Singen  78224 
# names Engen  78234 
# names Rielasingen-Worblingen  78239 
# names Gottmadingen  78244 
# names Hilzingen  78247 
# names Tengen  78250 
# names Eigeltingen  78253 
# names Volkertshausen  78269 
# names Bodensee  37434 
# names Stockach  78333 
# names Gaienhofen  78343 
# names Moos  78345 94554 
# names Bodman-Ludwigshafen  78351 
# names Sipplingen  78354 
# names Hohenfels  78355 92366 
# names Orsingen-Nenzingen  78359 
# names Konstanz  78462 78464 78465 78467 
# names Allensbach  78476 
# names Reichenau  78479 
# names Tuttlingen  78532 
# names Spaichingen  78549 
# names Aldingen  78554 
# names Gosheim  78559 
# names Wehingen  78564 
# names Reichenbach  07629 55776 93189 96358 
# names Wurmlingen  78573 
# names Emmingen-Liptingen  78576 
# names Neuhausen  03058 75242 
# names Balgheim  78582 
# names Bubsheim  78585 
# names Deilingen  78586 
# names Denkingen  78588 
# names Durchhausen  78591 
# names Egesheim  78592 
# names Gunningen  78594 
# names Hausen  37327 55608 63840 91353 93345 97647 
# names Irndorf  78597 
# names Mahlstetten  78601 
# names Renquishausen  78603 
# names Rietheim-Weilheim  78604 
# names Seitingen-Oberflacht  78606 
# names Tuningen  78609 
# names Rottweil  78628 
# names Trossingen  78647 
# names Dunningen  78655 
# names Zimmern  07778 
# names Rottweil  78628 
# names Dietingen  78661 
# names Eschbronn  78664 
# names Frittlingen  78665 
# names Villingendorf  78667 
# names Wellendingen  78669 
# names Schramberg  78713 
# names Oberndorf  21787 67821 
# names Aichhalden  78733 
# names Epfendorf  78736 
# names Fluorn-Winzeln  78737 
# names Waldkirch  79183 
# names Heuweiler  79194 
# names Gundelfingen  79194 
# names Kirchzarten  79199 
# names Denzlingen  79211 
# names Biederbach  79215 
# names Elzach  79215 
# names Umkirch  79224 
# names Schallstadt  79227 
# names March  79232 
# names Ehrenkirchen  79238 
# names Ihringen  79241 
# names Merzhausen  79249 
# names Stegen  79252 
# names Oberried  79254 
# names Buchenbach  79256 91186 
# names Hartheim  79258 
# names Simonswald  79263 
# names Reute  79276 
# names Au  79280 
# names Ballrechten-Dottingen  79282 
# names Bollschweil  79283 
# names Ebringen  79285 
# names Glottertal  79286 
# names Gottenheim  79288 
# names Horben  79289 
# names Merdingen  79291 
# names Pfaffenweiler  79292 
# names Sulzburg  79295 
# names Winden  56379 76872 
# names Elztal  74834 
# names Wittnau  79299 
# names Emmendingen  79312 
# names Teningen  79331 
# names Herbolzheim  79336 
# names Kenzingen  79341 
# names Freiamt  79348 
# names Sexau  79350 
# names Sasbach  77880 
# names Forchheim  79362 91301 
# names Malterdingen  79364 
# names Rheinhausen  79365 
# names Weisweil  79367 
# names Neuenburg  75305 
# names Kandern  79400 
# names Badenweiler  79410 
# names Bellingen  39579 56459 
# names Schliengen  79418 
# names Heitersheim  79423 
# names Auggen  79424 
# names Buggingen  79426 
# names Malsburg-Marzell  79429 
# names Weil  86947 
# names Efringen-Kirchen  79588 
# names Binzen  79589 
# names Eimeldingen  79591 
# names Fischingen  79592 
# names Inzlingen  79594 
# names Schallbach  79597 
# names Wittlingen  79599 
# names Rheinfelden  79618 
# names Grenzach-Wyhlen  79639 
# names Schopfheim  79650 
# names Zell  56856 93199 95239 
# names Todtnau  79674 
# names Aitern  79677 
# names Wembach  79677 
# names Tunau  79677 
# names Todtmoos  79682 
# names Hasel  79686 
# names Hausen  37327 55608 63840 91353 93345 97647 
# names Maulburg  79689 
# names Neuenweg  79691 
# names Raich  79692 
# names Tegernau  79692 
# names Sallneck  79692 
# names Elbenschwand  79692 
# names Utzenfeld  79694 
# names Wieden  79695 
# names Wies  79697 
# names Wieslet  79699 
# names Laufenburg  79725 
# names Murg  79730 
# names Rickenbach  79736 
# names Herrischried  79737 
# names Waldshut-Tiengen  79761 
# names Klettgau  79771 
# names Albbruck  79774 
# names Lauchringen  79787 
# names Jestetten  79798 
# names Hohentengen  88367 
# names Dettighofen  79802 
# names Dogern  79804 
# names Eggingen  79805 
# names Lottstetten  79807 
# names Weilheim  79809 
# names Titisee-Neustadt  79822 
# names Ibach  79837 
# names Lenzkirch  79853 
# names Hinterzarten  79856 
# names Schluchsee  79859 
# names Grafenhausen  79865 
# names Feldberg  79868 
# names Breitnau  79874 
# names Dachsberg  79875 
# names Friedenweiler  79877 
# names Wutach  79879 
# names Unterhaching  82008 
# names Taufkirchen  82024 84574 
# names Oberhaching  82041 
# names Sauerlach  82054 
# names Icking  82057 
# names Baierbrunn  82065 
# names Germering  82110 
# names Gauting  82131 
# names Olching  82140 
# names Planegg  82152 
# names Krailling  82152 
# names Puchheim  82178 
# names Gilching  82205 
# names Maisach  82216 
# names Eichenau  82223 
# names Alling  82239 
# names Geltendorf  82269 
# names Moorenweis  82272 
# names Emmering  82275 83550 
# names Adelshofen  82276 91587 
# names Althegnenberg  82278 
# names Eching  84174 85386 
# names Egenhofen  82281 
# names Grafrath  82284 
# names Jesenwang  82287 
# names Kottgeisering  82288 
# names Landsberied  82290 
# names Mammendorf  82291 
# names Mittelstetten  82293 
# names Oberschweinbach  82294 
# names Steindorf  82297 
# names Starnberg  82319 
# names Tutzing  82327 
# names Feldafing  82340 
# names Andechs  82346 
# names Bernried  82347 94505 
# names Weilheim  79809 
# names Penzberg  82377 
# names Huglfing  82386 
# names Antdorf  82387 
# names Eberfing  82390 
# names Habach  82392 
# names Iffeldorf  82393 
# names Polling  82398 84570 
# names Raisting  82399 
# names Rottenbuch  82401 
# names Seeshaupt  82402 
# names Sindelsdorf  82404 
# names Wessobrunn  82405 
# names Wielenbach  82407 
# names Wildsteig  82409 
# names Riegsee  82418 
# names Seehausen  39365 39615 
# names Eglfing  82436 
# names Eschenlohe  82438 
# names Ohlstadt  82441 
# names Saulgrub  82442 
# names Schlehdorf  82444 
# names Schwaigen  82445 
# names Spatzenhausen  82447 
# names Garmisch-Partenkirchen  82467 
# names Mittenwald  82481 
# names Oberammergau  82487 
# names Ettal  82488 
# names Farchant  82490 
# names Grainau  82491 
# names Oberau  82496 
# names Unterammergau  82497 
# names Wallgau  82499 
# names Wolfratshausen  82515 
# names Geretsried  82538 
# names Egling  82544 
# names Eurasburg  82547 86495 
# names Kolbermoor  83059 
# names Raubling  83064 
# names Stephanskirchen  83071 
# names Oberaudorf  83080 
# names Riedering  83083 
# names Kiefersfelden  83088 
# names Endorf  06333 
# names Brannenburg  83098 
# names Tuntenhausen  83104 
# names Neubeuern  83115 
# names Obing  83119 
# names Samerberg  83122 
# names Amerang  83123 
# names Flintsbach  83126 
# names Halfing  83128 
# names Pittenhart  83132 
# names Prutting  83134 
# names Schechen  83135 
# names Schonstett  83137 
# names Chiemsee  83256 
# names Staudach-Egerndach  83224 
# names Bernau  16321 79872 
# names Chiemsee  83256 
# names Marquartstein  83250 
# names Rimsting  83253 
# names Breitbrunn  96151 
# names Chiemsee  83256 
# names Chiemsee  83256 
# names Chiemsee  83256 
# names Schleching  83259 
# names Traunstein  83278 
# names Traunreut  83301 
# names Trostberg  83308 
# names Siegsdorf  83313 
# names Teisendorf  83317 
# names Ruhpolding  83324 
# names Wonneberg  83329 
# names Inzell  83334 
# names Chieming  83339 
# names Tacherting  83342 
# names Palling  83349 
# names Seeon-Seebruck  83358 83370 
# names Surberg  83362 
# names Petting  83367 
# names Vachendorf  83377 
# names Freilassing  83395 
# names Ainring  83404 
# names Laufen  83410 
# names Fridolfing  83413 
# names Saaldorf-Surheim  83416 
# names Piding  83451 
# names Anger  83454 
# names Schneizlreuth  83458 
# names Berchtesgaden  83471 
# names Bischofswiesen  83483 
# names Ramsau  83486 
# names Marktschellenberg  83487 
# names Haag  95473 
# names Schnaitsee  83530 
# names Edling  83533 
# names Albaching  83539 
# names Pfaffing  83539 
# names Rott  57632 86935 
# names Babensham  83547 
# names Eiselfing  83549 
# names Frauenneuharting  83553 
# names Maitenbeth  83558 
# names Ramerberg  83561 
# names Rechtmehring  83562 
# names Soyen  83564 
# names Unterreit  83567 
# names Vogtareuth  83569 
# names Holzkirchen  83607 97292 
# names Feldkirchen-Westerham  83620 
# names Dietramszell  83623 
# names Otterfing  83624 
# names Valley  83626 
# names Warngau  83627 
# names Weyarn  83629 
# names Wackersberg  83646 
# names Lenggries  83661 
# names Waakirchen  83666 
# names Benediktbeuern  83671 
# names Bichl  83673 
# names Jachenau  83676 
# names Greiling  83677 
# names Reichersbeuern  83677 
# names Sachsenkam  83679 
# names Tegernsee  83684 
# names Rottach-Egern  83700 
# names Tegernsee  83684 
# names Kreuth  83708 
# names Miesbach  83714 
# names Schliersee  83727 
# names Fischbachau  83730 
# names Hausham  83734 
# names Bayrischzell  83735 
# names Irschenberg  83737 
# names Landshut  84028 84030 84032 84034 84036 
# names Ergolding  84030 
# names Kumhausen  84036 
# names Mainburg  84048 
# names Essenbach  84051 
# names Laaber  93164 
# names Ergoldsbach  84061 
# names Mallersdorf-Pfaffenberg  84066 
# names Schierling  84069 
# names Au  79280 
# names Pfeffenhausen  84076 
# names Bruckberg  84079 91590 
# names Laberweinting  84082 
# names Langquaid  84085 
# names Aiglsbach  84089 
# names Attenhofen  84091 
# names Bayerbach  84092 94137 
# names Elsendorf  84094 
# names Herrngiersdorf  84097 
# names Hohenthann  84098 
# names Niederaichbach  84100 
# names Postau  84103 
# names Rudelzhausen  84104 
# names Volkenschwand  84106 
# names Weihmichl  84107 
# names Dingolfing  84130 
# names Vilsbiburg  84137 
# names Gangkofen  84140 
# names Geisenhausen  84144 
# names Velden  84149 91235 
# names Mengkofen  84152 
# names Bodenkirchen  84155 
# names Frontenhausen  84160 
# names Marklkofen  84163 
# names Moosthenning  84164 
# names Adlkofen  84166 
# names Aham  84168 
# names Altfraunhofen  84169 
# names Baierbach  84171 
# names Buch  39517 56290 56357 89290 
# names Erlbach  08265 84567 
# names Eching  84174 85386 
# names Schalkham  84175 
# names Gerzen  84175 
# names Gottfrieding  84177 
# names Loiching  84180 
# names Neufraunhofen  84181 
# names Niederviehbach  84183 
# names Vilsheim  84186 
# names Weng  84187 
# names Wurmsham  84189 
# names Eggenfelden  84307 
# names Massing  84323 
# names Wurmannsquick  84329 
# names Hebertsfelden  84332 
# names Malgersdorf  84333 
# names Mitterskirchen  84335 
# names Unterdietfurt  84339 
# names Pfarrkirchen  84347 
# names Simbach  94436 
# names Birnbach  57612 
# names Reut  84367 
# names Zeilarn  84367 
# names Triftern  84371 
# names Kirchdorf  18519 27245 83527 93348 
# names Dietersburg  84378 
# names Johanniskirchen  84381 
# names Wittibreut  84384 
# names Egglham  84385 
# names Julbach  84387 
# names Dorfen  84405 
# names Taufkirchen  82024 84574 
# names Obertaufkirchen  84419 
# names Schwindegg  84419 
# names Isen  84424 
# names Buchbach  84428 
# names Rattenkirchen  84431 
# names Heldenstein  84431 
# names Hohenpolding  84432 
# names Lengdorf  84435 
# names Reichertsheim  84437 
# names Waldkraiburg  84478 
# names Burghausen  84489 
# names Lohkirchen  84494 
# names Niedertaufkirchen  84494 
# names Niederbergkirchen  84494 
# names Erharting  84513 
# names Tittmoning  84529 
# names Stammham  84533 85134 
# names Marktl  84533 
# names Haiming  84533 
# names Ampfing  84539 
# names Zangberg  84539 
# names Egglkofen  84546 
# names Emmerting  84547 
# names Engelsberg  84549 
# names Geratskirchen  84552 
# names Kastl  84556 92280 95506 
# names Halsbach  84558 
# names Tyrlaching  84558 
# names Kirchweidach  84558 
# names Oberbergkirchen  84564 
# names Oberneukirchen  84565 
# names Perach  84567 
# names Pleiskirchen  84568 
# names Reischach  84571 
# names Teising  84576 
# names Unterneukirchen  84579 
# names Ingolstadt  85049 85051 85053 85055 85057 
# names Manching  85077 
# names Gaimersheim  85080 
# names Reichertshofen  85084 
# names Lenting  85101 
# names Baar-Ebenhausen  85107 
# names Kipfenberg  85110 
# names Adelschlag  85111 
# names Buxheim  85114 87740 
# names Egweil  85116 
# names Eitensheim  85117 
# names Ernsgaden  85119 
# names Hepberg  85120 
# names Hitzhofen  85122 
# names Karlskron  85123 
# names Kinding  85125 
# names Nassenfels  85128 
# names Oberdolling  85129 
# names Pollenfeld  85131 
# names Schernfeld  85132 
# names Titting  85135 
# names Walting  85137 
# names Wettstetten  85139 
# names Dachau  85221 
# names Bergkirchen  85232 
# names Odelzhausen  85235 
# names Pfaffenhofen  74397 
# names Glonn  85625 
# names Petershausen  85238 
# names Hebertshausen  85241 
# names Schwabhausen  85247 99869 
# names Erdweg  85253 
# names Sulzemoos  85254 
# names Weichs  85258 
# names Hettenshausen  85276 
# names Pfaffenhofen  74397 
# names Wolnzach  85283 
# names Geisenfeld  85290 
# names Reichertshausen  85293 
# names Scheyern  85298 
# names Schweitenkirchen  85301 
# names Gerolsbach  85302 
# names Jetzendorf  85305 
# names Paunzhausen  85307 
# names Freising  85354 85356 
# names Wang  85368 
# names Moosburg  85368 88422 
# names Freising  85354 85356 
# names Allershausen  85391 
# names Attenkirchen  85395 
# names Wolfersdorf  85395 
# names Hallbergmoos  85399 
# names Kranzberg  85402 
# names Nandlstadt  85405 
# names Zolling  85406 
# names Gammelsdorf  85408 
# names Haag  95473 
# names Hohenkammer  85411 
# names Kirchdorf  18519 27245 83527 93348 
# names Marzling  85417 
# names Mauern  85419 
# names Erding  85435 
# names Oberding  85445 
# names Fraunberg  85447 
# names Moosinning  85452 
# names Berglern  85459 
# names Eitting  85462 
# names Finsing  85464 
# names Langenpreising  85465 
# names Neuching  85467 
# names Walpertskirchen  85469 
# names Ottobrunn  85521 
# names Haar  85540 
# names Kirchheim  36275 97268 99334 
# names Ebersberg  85560 
# names Ottenhofen  85570 
# names Neubiberg  85579 
# names Poing  85586 
# names Vaterstetten  85591 
# names Zorneding  85604 
# names Aschheim  85609 
# names Kirchseeon  85614 
# names Feldkirchen  85622 94351 
# names Baiern  85625 
# names Glonn  85625 
# names Grasbrunn  85630 
# names Putzbrunn  85640 
# names Anzing  85646 
# names Brunnthal  85649 
# names Pliening  85652 
# names Aying  85653 
# names Buch  39517 56290 56357 89290 
# names Egmating  85658 
# names Forstern  85659 
# names Forstinning  85661 
# names Hohenbrunn  85662 
# names Hohenlinden  85664 
# names Moosach  85665 
# names Oberpframmern  85667 
# names Pastetten  85669 
# names Ismaning  85737 
# names Karlsfeld  85757 
# names Fahrenzhausen  85777 
# names Haimhausen  85778 
# names Augsburg  86150 86152 86153 86154 86156 86157 86159 86161 86163 86165 86167 86169 86179 86199 
# names Gersthofen  86368 
# names Krumbach  86381 
# names Stadtbergen  86391 
# names Meitingen  86405 
# names Mering  86415 
# names Dinkelscherben  86424 
# names Kissing  86438 
# names Zusmarshausen  86441 
# names Affing  86444 
# names Aindling  86447 
# names Todtenweis  86447 
# names Dasing  86453 
# names Gablingen  86456 
# names Gessertshausen  86459 
# names Heretsried  86465 
# names Welden  86465 
# names Thannhausen  86470 
# names Ziemetshausen  86473 
# names Neuburg  23974 
# names Adelsried  86477 
# names Aichen  86479 
# names Aletshausen  86480 
# names Waltenhausen  86480 
# names Aystetten  86482 
# names Balzhausen  86483 
# names Biberbach  86485 
# names Bonstetten  86486 
# names Deisenhausen  86489 
# names Ebershausen  86491 
# names Egling  82544 
# names Emersacker  86494 
# names Horgau  86497 
# names Kettershausen  86498 
# names Kutzenhausen  86500 
# names Laugna  86502 
# names Merching  86504 
# names Oberottmarshausen  86507 
# names Kleinaitingen  86507 
# names Rehling  86508 
# names Ried  86510 
# names Schmiechen  86511 
# names Ursberg  86513 
# names Ustersbach  86514 
# names Wehringen  86517 
# names Schrobenhausen  86529 
# names Aichach  86551 
# names Hohenwart  86558 
# names Adelzhausen  86559 
# names Aresing  86561 
# names Berg  53505 56357 82335 88276 95180 
# names Brunnen  86564 
# names Gachenbach  86565 
# names Hilgertshausen-Tandern  86567 
# names Hollenbach  86568 
# names Inchenhofen  86570 
# names Langenmosen  86571 
# names Obergriesbach  86573 
# names Schiltberg  86576 
# names Sielenbach  86577 
# names Waidhofen  86579 
# names Neuburg  23974 
# names Wertingen  86637 
# names Rain  86641 94369 
# names Rennertshofen  86643 
# names Buttenwiesen  86647 
# names Wemding  86650 
# names Monheim  86653 
# names Daiting  86653 
# names Harburg  86655 
# names Bissingen  86657 
# names Tapfheim  86660 
# names Burgheim  86666 
# names Karlshuld  86668 
# names Thierhaupten  86672 
# names Buchdorf  86675 
# names Ehekirchen  86676 
# names Ehingen  86678 91725 
# names Ellgau  86679 
# names Genderkingen  86682 
# names Huisheim  86685 
# names Kaisheim  86687 
# names Marxheim  86688 
# names Mertingen  86690 
# names Allmannshofen  86695 
# names Nordendorf  86695 
# names Oberndorf  21787 67821 
# names Otting  86700 
# names Rohrenfels  86701 
# names Tagmersheim  86704 
# names Weichering  86706 
# names Westendorf  86707 87679 
# names Wolferstadt  86709 
# names Alerheim  86733 
# names Forheim  86735 
# names Amerdingen  86735 
# names Auhausen  86736 
# names Deiningen  86738 
# names Ederheim  86739 
# names Ehingen  86678 91725 
# names Fremdingen  86742 
# names Hainsfarth  86744 
# names Hohenaltheim  86745 
# names Maihingen  86747 
# names Marktoffingen  86748 
# names Megesheim  86750 
# names Munningen  86754 
# names Reimlingen  86756 
# names Wallerstein  86757 
# names Wechingen  86759 
# names Buchloe  86807 
# names Untermeitingen  86836 
# names Klosterlechfeld  86836 
# names Obermeitingen  86836 
# names Fischach  86850 
# names Langerringen  86853 
# names Amberg  86854 92224 
# names Hiltenfingen  86856 
# names Hurlach  86857 
# names Igling  86859 
# names Jengen  86860 
# names Lamerdingen  86862 
# names Langenneufnach  86863 
# names Wald  87616 88639 93192 
# names Mickhausen  86866 
# names Mittelneufnach  86868 
# names Oberostendorf  86869 
# names Rammingen  86871 89192 
# names Scherstetten  86872 
# names Tussenhausen  86874 
# names Waal  86875 
# names Walkertshofen  86877 
# names Wiedergeltingen  86879 
# names Landsberg  06188 
# names Kaufering  86916 
# names Denklingen  86920 
# names Eresing  86922 
# names Finning  86923 
# names Fuchstal  86925 
# names Greifenberg  86926 
# names Penzing  86929 
# names Prittriching  86931 
# names Reichling  86934 
# names Scheuring  86937 
# names Schondorf  07924 54316 
# names Schwifting  86940 
# names Thaining  86943 
# names Vilgertshofen  86946 
# names Weil  86947 
# names Windach  86949 
# names Schongau  86956 
# names Peiting  86971 
# names Apfeldorf  86974 
# names Bernbeuren  86975 
# names Burggen  86977 
# names Hohenfurch  86978 
# names Ingenried  86980 
# names Kinsau  86981 
# names Lechbruck  86983 
# names Prem  86984 
# names Schwabbruck  86986 
# names Schwabsoien  86987 
# names Steingaden  86989 
# names Kempten  87435 87437 87439 
# names Waltenhofen  87448 
# names Altusried  87452 
# names Pfronten  87459 
# names Dietmannsried  87463 
# names Oy-Mittelberg  87466 
# names Durach  87471 
# names Buchenberg  87474 
# names Sulzberg  87477 
# names Weitnau  87480 
# names Nesselwang  87484 
# names Wiggensbach  87487 
# names Betzigau  87488 
# names Haldenwang  87490 89356 
# names Lauben  87493 87761 
# names Untrasried  87496 
# names Wertach  87497 
# names Wildpoldsried  87499 
# names Sonthofen  87527 
# names Ofterschwang  87527 
# names Oberstaufen  87534 
# names Bolsterlang  87538 
# names Obermaiselstein  87538 
# names Balderschwang  87538 
# names Blaichach  87544 
# names Missen-Wilhams  87547 
# names Rettenberg  87549 
# names Oberstdorf  87561 
# names Kaufbeuren  87600 
# names Marktoberdorf  87616 
# names Wald  87616 88639 93192 
# names Seeg  87637 
# names Biessenhofen  87640 
# names Halblech  87642 
# names Schwangau  87645 
# names Kraftisried  87647 
# names Unterthingau  87647 
# names Aitrang  87648 
# names Baisweil  87650 
# names Bidingen  87651 
# names Eggenthal  87653 
# names Friesenried  87654 
# names Germaringen  87656 
# names Hopferau  87659 
# names Irsee  87660 
# names Kaltental  87662 
# names Osterzell  87662 
# names Lengenwang  87663 
# names Mauerstetten  87665 
# names Pforzen  87666 
# names Rieden  56745 87668 92286 
# names Ronsberg  87671 
# names Ruderatshofen  87674 
# names Rettenbach  89364 93191 
# names Memmingen  87700 
# names Mindelheim  87719 
# names Ottobeuren  87724 
# names Rettenbach  89364 93191 
# names Benningen  87734 
# names Breitenbrunn  87739 92363 
# names Apfeltrach  87742 
# names Dirlewang  87742 
# names Eppishausen  87745 
# names Erkheim  87746 
# names Fellheim  87748 
# names Hawangen  87749 
# names Heimertingen  87751 
# names Kammlach  87754 
# names Kirchhaslach  87755 
# names Kirchheim  36275 97268 99334 
# names Kronburg  87758 
# names Lachen  87760 
# names Lautrach  87763 
# names Legau  87764 
# names Memmingerberg  87766 
# names Niederrieden  87767 
# names Oberrieden  87769 
# names Pfaffenhausen  87772 
# names Salgen  87775 
# names Sontheim  87776 
# names Trunkelsberg  87779 
# names Ungerhausen  87781 
# names Unteregg  87782 
# names Winterrieden  87785 
# names Wolfertschwenden  87787 
# names Woringen  87789 
# names Friedrichshafen  88045 88046 88048 
# names Tettnang  88069 
# names Meckenbeuren  88074 
# names Bodensee  37434 
# names Langenargen  88085 
# names Bodensee  37434 
# names Oberteuringen  88094 
# names Eriskirch  88097 
# names Bodolz  88131 
# names Lindau  24214 39264 
# names Hergensweiler  88138 
# names Sigmarszell  88138 
# names Opfenbach  88145 
# names Hergatz  88145 
# names Achberg  88147 
# names Nonnenhorn  88149 
# names Lindenberg  16321 16928 17111 67473 
# names Gestratz  88167 
# names Stiefenhofen  88167 
# names Weiler-Simmerberg  88171 
# names Scheidegg  88175 
# names Heimenkirch  88178 
# names Oberreute  88179 
# names Ravensburg  88212 88213 88214 
# names Wangen  06642 73117 
# names Baindt  88255 
# names Baienfurt  88255 
# names Horgenzell  88263 
# names Vogt  88267 
# names Fronreute  88273 
# names Amtzell  88279 
# names Schlier  88281 
# names Wolpertswende  88284 
# names Bodnegg  88285 
# names Waldburg  88289 
# names Aichstetten  88317 
# names Aitrach  88319 
# names Aulendorf  88326 
# names Waldsee  67165 
# names Allmannsweiler  88348 
# names Ostrach  88356 
# names Boms  88361 
# names Eichstegen  88361 
# names Altshausen  88361 
# names Wolfegg  88364 
# names Hohentengen  88367 
# names Bergatreute  88368 
# names Ebenweiler  88370 
# names Ebersbach-Musbach  88371 
# names Fleischwangen  88373 
# names Riedhausen  88377 
# names Guggenhausen  88379 
# names Unterwaldhausen  88379 
# names Biberach  77781 
# names Erlenmoos  88416 
# names Ochsenhausen  88416 
# names Oggelshausen  88422 
# names Betzenweiler  88422 
# names Seekirch  88422 
# names Kanzach  88422 
# names Alleshausen  88422 
# names Schemmerhofen  88433 
# names Eberhardzell  88436 
# names Maselheim  88437 
# names Mittelbiberach  88441 
# names Warthausen  88447 
# names Attenweiler  88448 
# names Berkheim  88450 
# names Erolzheim  88453 
# names Ingoldingen  88456 
# names Kirchdorf  18519 27245 83527 93348 
# names Tannheim  88459 
# names Laupheim  88471 
# names Schwendi  88477 
# names Achstetten  88480 
# names Balzheim  88481 
# names Burgrieden  88483 
# names Kirchberg  08107 55481 84434 
# names Mietingen  88487 
# names Wain  88489 
# names Emeringen  88499 
# names Riedlingen  88499 
# names Altheim  88499 89605 
# names Mengen  88512 
# names Langenenslingen  88515 
# names Herbertingen  88518 
# names Ertingen  88521 
# names Uttenweiler  88524 
# names Unlingen  88527 
# names Zwiefalten  88529 
# names Sauldorf  88605 
# names Pfullendorf  88630 
# names Beuron  88631 
# names Heiligenberg  88633 
# names Illmensee  88636 
# names Buchheim  88637 
# names Leibertingen  88637 
# names Markdorf  88677 
# names Deggenhausertal  88693 
# names Owingen  88696 
# names Bermatingen  88697 
# names Frickingen  88699 
# names Meersburg  88709 
# names Bodensee  37434 
# names Daisendorf  88718 
# names Ulm  89073 89075 89077 89079 89081 
# names Nerenstetten  89129 
# names Langenau  89129 
# names Setzingen  89129 
# names Blaustein  89134 
# names Blaubeuren  89143 
# names Laichingen  89150 
# names Dornstadt  89160 
# names Dietenheim  89165 
# names Niederstotzingen  89168 
# names Illerkirchberg  89171 
# names Lonsee  89173 
# names Altheim  88499 89605 
# names Asselfingen  89176 
# names Ballendorf  89177 
# names Beimerstetten  89179 
# names Bernstadt  89182 
# names Breitingen  89183 
# names Holzkirch  89183 
# names Illerrieden  89186 
# names Merklingen  89188 
# names Neenstetten  89189 
# names Nellingen  89191 
# names Staig  89195 
# names Weidenstetten  89197 
# names Westerstetten  89198 
# names Neu-Ulm  89231 89233 
# names Illertissen  89257 
# names Elchingen  89275 
# names Nersingen  89278 
# names Pfaffenhofen  74397 
# names Roth  54597 55442 56288 56368 57539 91154 
# names Bellenberg  89287 
# names Oberroth  89294 
# names Osterberg  89296 
# names Roggenburg  89297 
# names Unterroth  89299 
# names Burgau  89331 
# names Ichenhausen  89335 
# names Leipheim  89340 
# names Jettingen-Scheppach  89343 
# names Aislingen  89344 
# names Bibertal  89346 
# names Bubesheim  89347 
# names Burtenbach  89349 
# names Ellzee  89352 
# names Gundremmingen  89355 
# names Kammeltal  89358 
# names Landensberg  89361 
# names Offingen  89362 
# names Rettenbach  89364 93191 
# names Dillingen  66763 
# names Gundelfingen  79194 
# names Wittislingen  89426 
# names Syrgenstein  89428 
# names Bachhagel  89429 
# names Brenz  19306 
# names Binswangen  89432 
# names Blindheim  89434 
# names Finningen  89435 
# names Haunsheim  89437 
# names Lutzingen  89440 
# names Medlingen  89441 
# names Villenbach  89444 
# names Ziertheim  89446 
# names Zusamaltheim  89449 
# names Heidenheim  91719 
# names Brenz  19306 
# names Brenz  19306 
# names Herbrechtingen  89542 
# names Gerstetten  89547 
# names Steinheim  32839 
# names Dischingen  89561 
# names Nattheim  89564 
# names Sontheim  87776 
# names Brenz  19306 
# names Hermaringen  89568 
# names Ehingen  86678 91725 
# names Lauterach  89584 
# names Munderkingen  89597 
# names Unterwachingen  89597 
# names Hausen  37327 55608 63840 91353 93345 97647 
# names Schelklingen  89601 
# names Allmendingen  89604 
# names Emerkingen  89607 
# names Griesingen  89608 
# names Oberdischingen  89610 
# names Rechtenstein  89611 
# names Obermarchtal  89611 
# names Oberstadion  89613 
# names Grundsheim  89613 
# names Rottenacker  89616 
# names Untermarchtal  89617 
# names Unterstadion  89619 
# names Zirndorf  90513 
# names Oberasbach  90522 
# names Wendelstein  90530 
# names Feucht  90537 
# names Eckental  90542 
# names Stein  24235 
# names Pegnitz  91257 
# names Cadolzburg  90556 
# names Seukendorf  90556 
# names Burgthann  90559 
# names Heroldsberg  90562 
# names Kalchreuth  90562 
# names Schwaig  90571 
# names Langenzenn  90579 
# names Allersberg  90584 
# names Tuchenbach  90587 
# names Veitsbronn  90587 
# names Obermichelbach  90587 
# names Schwarzenbruck  90592 
# names Schwanstetten  90596 
# names Dietenhofen  90599 
# names Pyrbaum  90602 
# names Winkelhaid  90610 
# names Ammerndorf  90614 
# names Neuhof  19246 31195 36119 
# names Puschendorf  90617 
# names Trautskirchen  90619 
# names Erlangen  91052 91054 91056 91058 
# names Buckenhof  91054 
# names Herzogenaurach  91074 
# names Hetzles  91077 
# names Neunkirchen  54426 56479 57290 63930 74867 
# names Brand  95682 
# names Dormitz  91077 
# names Kleinsendelbach  91077 
# names Spardorf  91080 
# names Uttenreuth  91080 
# names Marloffstein  91080 
# names Baiersdorf  91083 
# names Aurachtal  91086 
# names Bubenreuth  91088 
# names Effeltrich  91090 
# names Langensendelbach  91094 
# names Schwabach  91126 
# names Kammerstein  91126 
# names Rednitzhembach  91126 
# names Hilpoltstein  91161 
# names Greding  91171 
# names Spalt  91174 
# names Heideck  91180 
# names Abenberg  91183 
# names Rohr  91189 98530 
# names Lauf  77886 
# names Pegnitz  91257 
# names Hersbruck  91217 
# names Schnaittach  91220 
# names Pommelsbrunn  91224 
# names Leinburg  91227 
# names Happurg  91230 
# names Neunkirchen  54426 56479 57290 63930 74867 
# names Alfeld  91236 
# names Engelthal  91238 
# names Offenhausen  91238 
# names Henfenfeld  91239 
# names Kirchensittenbach  91241 
# names Ottensoos  91242 
# names Reichenschwand  91244 
# names Simmelsdorf  91245 
# names Vorra  91247 
# names Weigendorf  91249 
# names Pegnitz  91257 
# names Auerbach  09392 94530 
# names Pottenstein  91278 
# names Kirchenthumbach  91281 
# names Betzenstein  91282 
# names Pegnitz  91257 
# names Obertrubach  91286 
# names Plech  91287 
# names Schnabelwaid  91289 
# names Ebermannstadt  91320 
# names Adelsdorf  91325 
# names Eggolsheim  91330 
# names Heiligenstadt  91332 
# names Hemhofen  91334 
# names Heroldsbach  91336 
# names Igensdorf  91338 
# names Waischenfeld  91344 
# names Wiesenttal  91346 
# names Egloffstein  91349 
# names Gremsdorf  91350 
# names Hallerndorf  91352 
# names Hiltpoltstein  91355 
# names Kirchehrenbach  91356 
# names Kunreuth  91358 
# names Pinzberg  91361 
# names Pretzfeld  91362 
# names Unterleinleiter  91364 
# names Weilersbach  91365 
# names Wiesenthau  91369 
# names Neustadt  37345 
# names Scheinfeld  91443 
# names Emskirchen  91448 
# names Wilhermsdorf  91452 
# names Diespeck  91456 
# names Erlbach  08265 84567 
# names Baudenbach  91460 
# names Dachsbach  91462 
# names Dietersheim  91463 
# names Ergersheim  91465 
# names Gerhardshofen  91466 
# names Gutenstetten  91468 
# names Illesheim  91471 
# names Ipsheim  91472 
# names Lonnerstadt  91475 
# names Nordheim  74226 98631 
# names Oberscheinfeld  91483 
# names Sugenheim  91484 
# names Uehlfeld  91486 
# names Vestenbergsgreuth  91487 
# names Ansbach  91522 
# names Rothenburg  06420 
# names Feuchtwangen  91555 
# names Heilsbronn  91560 
# names Neuendettelsau  91564 
# names Herrieden  91567 
# names Windsbach  91575 
# names Leutershausen  91578 
# names Petersaurach  91580 
# names Diebach  91583 
# names Aurach  91589 
# names Buch  39517 56290 56357 89290 
# names Wald  87616 88639 93192 
# names Burgbernheim  91593 
# names Burgoberbach  91595 
# names Burk  91596 
# names Colmberg  91598 
# names Forst  57537 76694 
# names Flachslanden  91604 
# names Gallmersgarten  91605 
# names Gebsattel  91607 
# names Geslau  91608 
# names Insingen  91610 
# names Lehrberg  91611 
# names Marktbergel  91613 
# names Neusitz  91616 
# names Oberdachstetten  91617 
# names Obernzenn  91619 
# names Ohrenbach  91620 
# names Sachsen  91623 
# names Schnelldorf  91625 
# names Steinsfeld  91628 
# names Weihenzell  91629 
# names Wieseth  91632 
# names Wilburgstetten  91634 
# names Windelsbach  91635 
# names Wolframs-Eschenbach  91639 
# names Gunzenhausen  91710 
# names Heidenheim  91719 
# names Absberg  91720 
# names Arberg  91722 
# names Dittenheim  91723 
# names Gerolfingen  91726 
# names Gnotzheim  91728 
# names Haundorf  91729 
# names Langfurth  91731 
# names Mitteleschenbach  91734 
# names Ornbau  91737 
# names Pfofeld  91738 
# names Theilenhofen  91741 
# names Unterschwaningen  91743 
# names Weiltingen  91744 
# names Wittelshofen  91749 
# names Treuchtlingen  91757 
# names Pleinfeld  91785 
# names Pappenheim  91788 
# names Burgsalach  91790 
# names Raitenbuch  91790 
# names Nennslingen  91790 
# names Ellingen  91792 
# names Alesheim  91793 
# names Dollnstein  91795 
# names Ettenstatt  91796 
# names Langenaltheim  91799 
# names Meinheim  91802 
# names Polsingen  91805 
# names Solnhofen  91807 
# names Wellheim  91809 
# names Sulzbach-Rosenberg  92237 
# names Hirschau  92242 
# names Vilseck  92249 
# names Schnaittenbach  92253 
# names Hahnbach  92256 
# names Neukirchen  23779 25927 34626 94362 
# names Sulzbach-Rosenberg  92237 
# names Ammerthal  92260 
# names Birgland  92262 
# names Ebermannsdorf  92263 
# names Edelsfeld  92265 
# names Etzelwang  92268 
# names Fensterbach  92269 
# names Freihung  92271 
# names Gebenbach  92274 
# names Hirschbach  92275 
# names Hohenburg  92277 
# names Illschwang  92278 
# names Lauterhofen  92283 
# names Poppenricht  92284 
# names Ursensollen  92289 
# names Parsberg  92331 
# names Lupburg  92331 
# names Berching  92334 
# names Beilngries  92339 
# names Freystadt  92342 
# names Berg  53505 56357 82335 88276 95180 
# names Postbauer-Heng  92353 
# names Velburg  92355 
# names Berngau  92361 
# names Deining  92364 
# names Pilsach  92367 
# names Sengenthal  92369 
# names Schwandorf  92421 
# names Wald  87616 88639 93192 
# names Bruck  14822 85567 
# names Wackersdorf  92442 
# names Neukirchen-Balbini  92445 
# names Schwarzhofen  92447 
# names Nabburg  92507 
# names Schwarzenfeld  92521 
# names Oberviechtach  92526 
# names Pfreimd  92536 
# names Altendorf  92540 96146 
# names Dieterskirchen  92542 
# names Guteneck  92543 
# names Niedermurach  92545 
# names Schmidgaden  92546 
# names Schwarzach  74869 94374 
# names Nabburg  92507 
# names Stadlern  92549 
# names Stulln  92551 
# names Teunz  92552 
# names Thanstein  92554 
# names Trausnitz  92555 
# names Weiding  92557 93495 
# names Winklarn  92559 
# names Theisseil  92637 
# names Neustadt  37345 
# names Kirchendemenreuth  92665 
# names Altenstadt  63674 86972 89281 
# names Windischeschenbach  92670 
# names Eschenbach  73107 
# names Speinshart  92676 
# names Erbendorf  92681 
# names Pressath  92690 
# names Eslarn  92693 
# names Etzenricht  92694 
# names Georgenberg  92697 
# names Irchenrieth  92699 
# names Bechtsrieth  92699 
# names Krummennaab  92703 
# names Leuchtenberg  92705 
# names Luhe-Wildenau  92706 
# names Mantel  92708 
# names Moosbach  92709 
# names Parkstein  92711 
# names Pirk  92712 
# names Pleystein  92714 
# names Reuth  08538 54597 
# names Erbendorf  92681 
# names Schirmitz  92718 
# names Schwarzenbach  92720 
# names Gleiritsch  92723 
# names Trabitz  92724 
# names Waidhaus  92726 
# names Waldthurn  92727 
# names Weiherhammer  92729 
# names Regensburg  93047 93049 93051 93053 93055 93057 93059 
# names Neutraubling  93073 
# names Pentling  93080 
# names Obertraubling  93083 
# names Alteglofsheim  93087 
# names Aufhausen  93089 
# names Barbing  93092 
# names Donaustauf  93093 
# names Hagelstadt  93095 
# names Mintraching  93098 
# names Pfakofen  93101 
# names Pfatter  93102 
# names Riekofen  93104 
# names Tegernheim  93105 
# names Wiesent  93109 
# names Regenstauf  93128 
# names Burglengenfeld  93133 
# names Lappersdorf  93138 
# names Nittenau  93149 
# names Nittendorf  93152 
# names Hemau  93155 
# names Teublitz  93158 
# names Sinzing  93161 
# names Laaber  93164 
# names Bernhardswald  93170 
# names Wenzenbach  93173 
# names Beratzhausen  93176 
# names Altenthann  93177 
# names Brennberg  93179 
# names Deuerling  93180 
# names Duggendorf  93182 
# names Holzheim  65558 86684 89291 89438 
# names Forst  57537 76694 
# names Michelsneukirchen  93185 
# names Pettendorf  93186 
# names Pielenhofen  93188 
# names Walderbach  93194 
# names Wolfsegg  93195 
# names Zeitlarn  93197 
# names Kelheim  93309 
# names Abensberg  93326 
# names Neustadt  37345 
# names Altmannstein  93336 
# names Riedenburg  93339 
# names Saal  18317 
# names Essing  93343 
# names Ihrlerstein  93346 
# names Mindelstetten  93349 
# names Painten  93351 
# names Rohr  91189 98530 
# names Biburg  93354 
# names Siegenburg  93354 
# names Teugn  93356 
# names Train  93358 
# names Wildenberg  93359 
# names Cham  93413 
# names Roding  93426 
# names Furth  64658 84095 90762 90763 90765 90766 90768 
# names Wald  87616 88639 93192 
# names Neukirchen  23779 25927 34626 94362 
# names Traitsching  93455 
# names Eschlkam  93458 
# names Lam  93462 
# names Chamerau  93466 
# names Miltach  93468 
# names Lohberg  93470 
# names Arnbruck  93471 
# names Arnschwang  93473 
# names Arrach  93474 
# names Blaibach  93476 
# names Grafenwiesen  93479 
# names Hohenwarth  93480 
# names Pemfling  93482 
# names Runding  93486 
# names Stamsried  93491 
# names Treffelstein  93492 
# names Waffenbrunn  93494 
# names Willmering  93497 
# names Zandt  93499 
# names Passau  94032 94034 94036 
# names Hauzenberg  94051 
# names Waldkirchen  94065 
# names Freyung  94078 
# names Neureichenau  94089 
# names Malching  94094 
# names Rott  57632 86935 
# names Tittling  94104 
# names Witzmannsberg  94104 
# names Untergriesbach  94107 
# names Wegscheid  94110 
# names Hutthurm  94116 
# names Jandelsbrunn  94118 
# names Salzweg  94121 
# names Neuburg  23974 
# names Obernzell  94130 
# names Thyrnau  94136 
# names Ering  94140 
# names Grainet  94143 
# names Hinterschmiding  94146 
# names Kirchham  94148 
# names Mauth  94151 
# names Neukirchen  23779 25927 34626 94362 
# names Wald  87616 88639 93192 
# names Perlesreut  94157 
# names Philippsreut  94158 
# names Ringelai  94160 
# names Ruderting  94161 
# names Saldenburg  94163 
# names Sonnen  94164 
# names Stubenberg  94166 
# names Tettenweis  94167 
# names Thurmansbang  94169 
# names Regen  94209 
# names Lindberg  94227 
# names Zwiesel  94227 
# names Viechtach  94234 
# names Zachenberg  94239 
# names Gotteszell  94239 
# names Ruhmannsfelden  94239 
# names Geiersthal  94244 
# names Teisnach  94244 
# names Bodenmais  94249 
# names Achslach  94250 
# names Bischofsmais  94253 
# names Drachselsried  94256 
# names Frauenau  94258 
# names Kirchberg  08107 55481 84434 
# names Wald  87616 88639 93192 
# names Kirchdorf  18519 27245 83527 93348 
# names Wald  87616 88639 93192 
# names Kollnburg  94262 
# names Langdorf  94264 
# names Patersdorf  94265 
# names Prackenbach  94267 
# names Rinchnach  94269 
# names Straubing  94315 
# names Bogen  94327 
# names Aiterhofen  94330 
# names Salching  94330 
# names Windberg  94336 
# names Hunderdorf  94336 
# names Leiblfing  94339 
# names Irlbach  94342 
# names Wiesenfelden  94344 
# names Aholfing  94345 
# names Ascha  94347 
# names Atting  94348 
# names Falkenfels  94350 
# names Kirchroth  94356 
# names Konzell  94357 
# names Loitzendorf  94359 
# names Mitterfels  94360 
# names Oberschneiding  94363 
# names Parkstetten  94365 
# names Perasdorf  94366 
# names Perkam  94368 
# names Rattenberg  94371 
# names Rattiszell  94372 
# names Stallwang  94375 
# names Reisbach  94419 
# names Arnstorf  94424 
# names Eichendorf  94428 
# names Pilsting  94431 
# names Simbach  94436 
# names Mamming  94437 
# names Plattling  94447 
# names Deggendorf  94469 
# names Vilshofen  94474 
# names Osterhofen  94486 
# names Hengersberg  94491 
# names Ortenburg  94496 
# names Beutelsbach  94501 
# names Aidenbach  94501 
# names Aldersbach  94501 
# names Spiegelau  94518 
# names Wallersdorf  94522 
# names Metten  94526 
# names Aholming  94527 
# names Wald  87616 88639 93192 
# names Buchhofen  94533 
# names Eppenschlag  94536 
# names Grafling  94539 
# names Grattersdorf  94541 
# names Haarbach  94542 
# names Hofkirchen  94544 
# names Hohenau  94545 
# names Iggensbach  94547 
# names Innernzell  94548 
# names Hunding  94551 
# names Lalling  94551 
# names Mariaposching  94553 
# names Niederalteich  94557 
# names Niederwinkling  94559 
# names Offenberg  94560 
# names Otzing  94563 
# names Stephansposching  94569 
# names Schaufling  94571 
# names Wallerfing  94574 
# names Windorf  94575 
# names Winzer  94577 
# names Zenting  94579 
# names Selb  95100 
# names Rehau  95111 
# names Naila  95119 
# names Schwarzenbach  92720 
# names Schwarzenbach  92720 
# names Wald  87616 88639 93192 
# names Oberkotzau  95145 
# names Kirchenlamitz  95158 
# names Marktleuthen  95168 
# names Konradsreuth  95176 
# names Feilitzsch  95183 
# names Trogen  95183 
# names Gattendorf  95185 
# names Issigau  95188 
# names Regnitzlosau  95194 
# names Schauenstein  95197 
# names Thierstein  95199 
# names Helmbrechts  95233 
# names Sparneck  95234 
# names Stammbach  95236 
# names Kulmbach  95326 
# names Mainleus  95336 
# names Wirsberg  95339 
# names Neuenmarkt  95339 
# names Stadtsteinach  95346 
# names Thurnau  95349 
# names Marktleugast  95352 
# names Presseck  95355 
# names Grafengehaig  95356 
# names Guttenberg  95358 
# names Kasendorf  95359 
# names Kupferberg  95362 
# names Ludwigschorgast  95364 
# names Rugendorf  95365 
# names Trebgast  95367 
# names Untersteinach  95369 
# names Bayreuth  95444 95445 95447 95448 
# names Bindlach  95463 
# names Weidenberg  95466 
# names Kirchenpingarten  95466 
# names Speichersdorf  95469 
# names Prebitz  95473 
# names Haag  95473 
# names Kemnath  95478 
# names Gefrees  95482 
# names Warmensteinach  95485 
# names Eckersdorf  95488 
# names Mistelgau  95490 
# names Ahorntal  95491 
# names Gesees  95494 
# names Goldkronach  95497 
# names Harsdorf  95499 
# names Heinersreuth  95500 
# names Himmelkron  95502 
# names Hummeltal  95503 
# names Immenreuth  95505 
# names Kulmain  95508 
# names Marktschorgast  95509 
# names Mistelbach  95511 
# names Neudrossenfeld  95512 
# names Neustadt  37345 
# names Plankenfels  95515 
# names Emtmannsberg  95517 
# names Seybothenreuth  95517 
# names Vorbach  95519 
# names Schlammersdorf  95519 
# names Marktredwitz  95615 
# names Wunsiedel  95632 
# names Tirschenreuth  95643 
# names Waldsassen  95652 
# names Mitterteich  95666 
# names Wiesau  95676 
# names Waldershof  95679 
# names Brand  95682 
# names Ebnath  95683 
# names Fichtelberg  95686 
# names Friedenfels  95688 
# names Konnersreuth  95692 
# names Mehlmeisel  95694 
# names Nagel  95697 
# names Neualbenreuth  95698 
# names Neusorg  95700 
# names Pechbrunn  95701 
# names Pullenreuth  95704 
# names Schirnding  95706 
# names Thiersheim  95707 
# names Bamberg  96047 96049 96050 96052 
# names Hallstadt  96103 
# names Ebern  96106 
# names Hirschaid  96114 
# names Memmelsdorf  96117 
# names Bischberg  96120 
# names Litzendorf  96123 
# names Ermershausen  96126 
# names Maroldsweisach  96126 
# names Strullendorf  96129 
# names Stegaurach  96135 
# names Burgebrach  96138 
# names Hollfeld  96142 
# names Baunach  96148 
# names Breitbrunn  96151 
# names Burghaslach  96152 
# names Burgwindheim  96154 
# names Buttenheim  96155 
# names Ebrach  96157 
# names Frensdorf  96158 
# names Geiselwind  96160 
# names Kemmern  96164 
# names Kirchlauter  96166 
# names Lauter  96169 
# names Priesendorf  96170 
# names Lisberg  96170 
# names Pettstadt  96175 
# names Pfarrweisach  96176 
# names Pommersfelden  96178 
# names Rauhenebrach  96181 
# names Reckendorf  96182 
# names Rentweinsdorf  96184 
# names Stadelhofen  96187 
# names Stettfeld  96188 
# names Untermerzbach  96190 
# names Viereth-Trunstadt  96191 
# names Wachenroth  96193 
# names Wattendorf  96196 
# names Wonsees  96197 
# names Zapfendorf  96199 
# names Burgkunstadt  96224 
# names Sonnefeld  96242 
# names Ebensfeld  96250 
# names Untersiemau  96253 
# names Marktgraitz  96257 
# names Weismain  96260 
# names Altenkunstadt  96264 
# names Mitwitz  96268 
# names Forst  57537 76694 
# names Hochstadt  76879 
# names Itzgrund  96274 
# names Marktzeuln  96275 
# names Schneckenlohe  96277 
# names Coburg  96450 
# names Kronach  96317 
# names Pressig  96332 
# names Ludwigsstadt  96337 
# names Stockheim  96342 97640 
# names Wallenfels  96346 
# names Steinwiesen  96349 
# names Wilhelmsthal  96352 
# names Teuschnitz  96358 
# names Steinbach  36448 37308 56291 
# names Wald  87616 88639 93192 
# names Marktrodach  96364 
# names Nordhalben  96365 
# names Tschirn  96367 
# names Coburg  96450 
# names Neustadt  37345 
# names Coburg  96450 
# names Weitramsdorf  96479 
# names Meeder  96484 
# names Sonneberg  96515 
# names Judenbach  96515 
# names Neuhaus-Schierschnitz  96524 
# names Effelder-Rauenstein  96528 
# names Schalkau  96528 
# names Bachfeld  96528 
# names Ochsenfurt  97199 
# names Uffenheim  97215 
# names Weigenheim  97215 
# names Simmershofen  97215 
# names Gerbrunn  97218 
# names Rimpar  97222 
# names Zellingen  97225 
# names Rottendorf  97228 
# names Estenfeld  97230 
# names Giebelstadt  97232 
# names Randersacker  97236 
# names Altertheim  97237 
# names Aub  97239 
# names Bergtheim  97241 
# names Oberpleichfeld  97241 
# names Bieberehren  97243 
# names Eibelstadt  97246 
# names Eisenheim  97247 
# names Frickenhausen  72636 
# names Sonderhofen  97255 
# names Gelchsheim  97255 
# names Geroldshausen  97256 
# names Oberickelsheim  97258 
# names Gollhofen  97258 
# names Ippesheim  97258 
# names Hemmersheim  97258 
# names Hausen  37327 55608 63840 91353 93345 97647 
# names Helmstadt  97264 
# names Hettstadt  97265 
# names Himmelstadt  97267 
# names Kist  97270 
# names Kleinrinderfeld  97271 
# names Leinach  97274 
# names Neubrunn  97277 98617 
# names Prosselsheim  97279 
# names Retzstadt  97282 
# names Riedenheim  97283 
# names Tauberrettersheim  97285 
# names Sommerhausen  97286 
# names Winterhausen  97286 
# names Theilheim  97288 
# names Uettingen  97292 
# names Unterpleichfeld  97294 
# names Zell  56856 93199 95239 
# names Kitzingen  97318 
# names Biebelried  97318 
# names Sulzfeld  75056 97633 98617 
# names Mainstockheim  97320 
# names Albertshofen  97320 
# names Buchbrunn  97320 
# names Volkach  97332 
# names Sommerach  97334 
# names Nordheim  74226 98631 
# names Dettelbach  97337 
# names Marktbreit  97340 
# names Segnitz  97340 
# names Martinsheim  97340 
# names Seinsheim  97342 
# names Obernbreit  97342 
# names Marktsteft  97342 
# names Iphofen  97346 
# names Willanzheim  97348 
# names Mainbernheim  97350 
# names Wiesentheid  97353 
# names Castell  97355 
# names Wiesenbronn  97355 
# names Abtswind  97355 
# names Kleinlangheim  97355 
# names Prichsenstadt  97357 
# names Schwarzach  74869 94374 
# names Schweinfurt  97421 97422 97424 
# names Werneck  97440 
# names Gerolzhofen  97447 
# names Frankenwinheim  97447 
# names Arnstein  97450 
# names Schonungen  97453 
# names Dittelbrunn  97456 
# names Niederwerrn  97464 
# names Gochsheim  97469 
# names Knetzgau  97478 
# names Eltmann  97483 
# names Stadtlauringen  97488 
# names Aidhausen  97491 
# names Bergrheinfeld  97493 
# names Bundorf  97494 
# names Burgpreppach  97496 
# names Dingolshausen  97497 
# names Donnersdorf  97499 
# names Ebelsbach  97500 
# names Euerbach  97502 
# names Geldersheim  97505 
# names Grafenrheinfeld  97506 
# names Grettstadt  97508 
# names Kolitzheim  97509 
# names Oberaurach  97514 
# names Oberschwarzach  97516 
# names Rannungen  97517 
# names Riedbach  97519 
# names Schwanfeld  97523 
# names Schwebheim  97525 
# names Sennfeld  97526 
# names Theres  97531 
# names Waigolshausen  97534 
# names Wasserlosen  97535 
# names Wipfeld  97537 
# names Wonfurt  97539 
# names Neustadt  37345 
# names Heustreu  97618 
# names Hohenroth  97618 
# names Unsleben  97618 
# names Strahlungen  97618 
# names Hollstadt  97618 
# names Wollbach  97618 
# names Niederlauer  97618 
# names Aubstadt  97633 
# names Trappstadt  97633 
# names Herbstadt  97633 
# names Saal  18317 
# names Mellrichstadt  97638 
# names Oberstreu  97640 
# names Hendungen  97640 
# names Willmars  97647 
# names Nordheim  74226 98631 
# names Fladungen  97650 
# names Bischofsheim  65474 
# names Bastheim  97654 
# names Oberelsbach  97656 
# names Sandberg  97657 
# names Burkardroth  97705 
# names Oerlenbach  97714 
# names Euerdorf  97717 
# names Sulzthal  97717 
# names Oberthulba  97723 
# names Burglauer  97724 
# names Elfershausen  97725 
# names Fuchsstadt  97727 
# names Ramsthal  97729 
# names Karlstadt  97753 
# names Hammelburg  97762 
# names Wildflecken  97772 
# names Burgsinn  97775 
# names Fellen  97778 
# names Karsbach  97783 
# names Mittelsinn  97785 
# names Motten  97786 
# names Oberleichtersbach  97789 
# names Obersinn  97791 
# names Riedenberg  97792 
# names Rieneck  97794 
# names Schondra  97795 
# names Wartmannsroth  97797 
# names Zeitlofs  97799 
# names Marktheidenfeld  97828 
# names Frammersbach  97833 
# names Bischbrunn  97836 
# names Erlenbach  74235 76872 76891 
# names Marktheidenfeld  97828 
# names Esselbach  97839 
# names Hafenlohr  97840 
# names Neustadt  37345 
# names Partenstein  97846 
# names Rechtenbach  97848 
# names Roden  97849 
# names Rothenfels  97851 
# names Schollbrunn  97852 
# names Triefenstein  97855 
# names Urspringen  97857 
# names Wiesthal  97859 
# names Wertheim  97877 
# names Kreuzwertheim  97892 
# names Altenbuch  97901 
# names Collenberg  97903 
# names Dorfprozelten  97904 
# names Faulbach  97906 
# names Stadtprozelten  97909 
# names Tauberbischofsheim  97941 
# names Werbach  97956 
# names Wittighausen  97957 
# names Assamstadt  97959 
# names Weikersheim  97990 
# names Creglingen  97993 
# names Niederstetten  97996 
# names Igersheim  97999 
# names Suhl  98527 98528 98529 
# names Oberstadt  98530 
# names Marisfeld  98530 
# names Schmeheim  98530 
# names Zella-Mehlis  98544 
# names Christes  98547 
# names Schwarza  98547 
# names Viernau  98547 
# names Schleusingen  98553 
# names Bischofrod  98553 
# names Nahetal-Waldau  98553 
# names Benshausen  98554 
# names Oberhof  98559 
# names Gehlberg  98559 
# names Schmalkalden  98574 
# names Steinbach-Hallenberg  98587 
# names Altersbach  98587 
# names Bermbach  98587 
# names Springstille  98587 
# names Rotterode  98587 
# names Wernshausen  98590 
# names Schwallungen  98590 
# names Floh-Seligenthal  98593 
# names Kleinschmalkalden  98593 
# names Trusetal  98596 
# names Fambach  98597 
# names Brotterode  98599 
# names Bauerbach  98617 
# names Ellingshausen  98617 
# names Stepfershausen  98617 
# names Henneberg  98617 
# names Ritschenhausen  98617 
# names Belrieth  98617 
# names Vachdorf  98617 
# names Utendorf  98617 
# names Meiningen  98617 
# names Herpf  98617 
# names Behrungen  98631 
# names Queienfeld  98631 
# names Mendhausen  98631 
# names Berkach  98631 
# names Wolfmannshausen  98631 
# names Rentwertshausen  98631 
# names Westenfeld  98631 
# names Milz  98631 
# names Schweickershausen  98631 
# names Exdorf  98631 
# names Schwickershausen  98631 
# names Unterweid  98634 
# names Kaltensundheim  98634 
# names Mehmels  98634 
# names Birx  98634 
# names Wasungen  98634 
# names Melpers  98634 
# names Oepfershausen  98634 
# names Aschenhausen  98634 
# names Erbenhausen  98634 
# names Kaltenwestheim  98634 
# names Unterkatz  98634 
# names Oberkatz  98634 
# names Wahns  98634 
# names Friedelshausen  98634 
# names Oberweid  98634 
# names Frankenheim  98634 
# names Wallbach  98639 
# names Rippershausen  98639 
# names Metzels  98639 
# names Gleichamberg  98646 
# names Dingsleben  98646 
# names Straufhain  98646 
# names Reurieth  98646 
# names Trostadt  98646 
# names Hildburghausen  98646 
# names Siegritz  98646 
# names Beinerstadt  98660 
# names Themar  98660 
# names Grimmelshausen  98660 
# names Lengfeld  98660 
# names Gompertshausen  98663 
# names Hellingen  98663 
# names Ummerstadt  98663 
# names Masserberg  98666 
# names Schleusegrund  98667 
# names Schlechtsart  98669 
# names Veilsdorf  98669 
# names Auengrund  98673 
# names Eisfeld  98673 
# names Sachsenbrunn  98678 
# names Ilmenau  98693 
# names Wildenspring  98701 
# names Herschdorf  98701 
# names Gillersdorf  98701 
# names Altenfeld  98701 
# names Neustadt  37345 
# names Langewiesen  98704 
# names Gehren  98708 
# names Pennewitz  98708 
# names Schmiedefeld  98739 
# names Frauenwald  98711 
# names Elgersburg  98716 
# names Geschwenda  98716 
# names Geraberg  98716 
# names Lauscha  98724 
# names Schmiedefeld  98739 
# names Lichte  98739 
# names Reichmannsdorf  98739 
# names Piesau  98739 
# names Deesbach  98744 
# names Cursdorf  98744 
# names Meura  98744 
# names Mellenbach-Glasbach  98746 
# names Goldisthal  98746 
# names Steinheid  98749 
# names Scheibe-Alsbach  98749 
# names Siegmundsburg  98749 
# names Erfurt  99084 99085 99086 99087 99089 99091 99092 99094 99096 99097 99099 
# names Dachwig  99100 
# names Zimmernsupra  99100 
# names Rockhausen  99102 
# names Klettbach  99102 
# names Witterda  99189 
# names Elxleben  99189 99334 
# names Andisleben  99189 
# names Walschleben  99189 
# names Gebesee  99189 
# names Neudietendorf  99192 
# names Nottleben  99192 
# names Ingersleben  99192 
# names Markvippach  99195 
# names Alperstedt  99195 
# names Eckstedt  99195 
# names Ollendorf  99198 
# names Udestedt  99198 
# names Dornheim  99310 
# names Witzleben  99310 
# names Wachsenburggemeinde  99310 
# names Wipfratal  99310 
# names Alkersleben  99310 
# names Arnstadt  99310 
# names Ilmtal  99326 
# names Stadtilm  99326 
# names Liebenstein  99330 
# names Crawinkel  99330 
# names Ichtershausen  99334 
# names Elleben  99334 
# names Gossel  99338 
# names Angelroda  99338 
# names Plaue  99338 
# names Hopfgarten  99428 
# names Berge  14641 19348 39638 49626 
# names Niederzimmern  99428 
# names Nohra  99428 99735 
# names Berge  14641 19348 39638 49626 
# names Utzberg  99428 
# names Isseroda  99428 
# names Vollersroda  99438 
# names Hetschburg  99438 
# names Troistedt  99438 
# names Tonndorf  99438 
# names Oettern  99438 
# names Gutendorf  99438 
# names Buchfart  99438 
# names Sachsenhausen  99439 
# names Buttelstedt  99439 
# names Vippachedelhausen  99439 
# names Wohlsborn  99439 
# names Heichelheim  99439 
# names Ettersburg  99439 
# names Leutenthal  99439 
# names Kleinobringen  99439 
# names Ballstedt  99439 
# names Ramsla  99439 
# names Berlstedt  99439 
# names Schwerstedt  99439 99634 
# names Hottelstedt  99439 
# names Magdala  99441 
# names Umpferstedt  99441 
# names Mechelroda  99441 
# names Lehnstedt  99441 
# names Frankendorf  99441 
# names Kiliansroda  99441 
# names Hohlstedt  99441 
# names Hammerstedt  99441 
# names Mellingen  99441 
# names Kleinschwabhausen  99441 
# names Kromsdorf  99441 
# names Blankenhain  99444 
# names Hohenfelden  99448 
# names Kranichfeld  99448 
# names Nirmsdorf  99510 
# names Obertrebra  99510 
# names Mattstedt  99510 
# names Saaleplatte  99510 
# names Pfiffelbach  99510 
# names Kapellendorf  99510 
# names Flurstedt  99510 
# names Apolda  99510 
# names Willerstedt  99510 
# names Gebstedt  99510 
# names Liebstedt  99510 
# names Wiegendorf  99510 
# names Wickerstedt  99510 
# names Rannstedt  99518 
# names Schmiedehausen  99518 
# names Niedertrebra  99518 
# names Eberstedt  99518 
# names Sulza  07751 
# names Auerstedt  99518 
# names Reisdorf  99518 
# names Wundersleben  99610 
# names Kleinbrembach  99610 
# names Vogelsberg  99610 
# names Schillingstedt  99625 
# names Kleinneuhausen  99625 
# names Beichlingen  99625 
# names Guthmannshausen  99628 
# names Hardisleben  99628 
# names Ellersleben  99628 
# names Rudersdorf  99628 
# names Mannstedt  99628 
# names Olbersleben  99628 
# names Herrnschwende  99631 
# names Henschleben  99634 
# names Werningshausen  99634 
# names Rastenberg  99636 
# names Ostramondra  99636 
# names Riethgen  99638 
# names Griefstedt  99638 
# names Bendeleben  99706 
# names Sondershausen  99706 
# names Badra  99706 
# names Hachelbich  99706 
# names Abtsbessingen  99713 
# names Wolferschwenda  99713 
# names Bellstedt  99713 
# names Freienbessingen  99713 
# names Rockstedt  99713 
# names Schernberg  99713 
# names Ebeleben  99713 
# names Trebra  99718 
# names Wasserthaleben  99718 
# names Topfstedt  99718 
# names Clingen  99718 
# names Nordhausen  99734 
# names Kleinfurra  99735 
# names Wolkramshausen  99735 
# names Etzelsrode  99735 
# names Kleinbodungen  99752 
# names Kraja  99752 
# names Wipperdorf  99752 
# names Lipprechterode  99752 
# names Kehmstedt  99752 
# names Ellrich  99755 
# names Obergebra  99759 
# names Niedergebra  99759 
# names Rehungen  99759 
# names Harzungen  99762 
# names Niedersachswerfen  99762 
# names Herrmannsacker  99762 
# names Stempeda  99762 
# names Rodishain  99762 
# names Auleben  99765 
# names Hamma  99765 
# names Uthleben  99765 
# names Windehausen  99765 
# names Ilfeld  99768 
# names Unterellen  99819 
# names Wolfsburg-Unkeroda  99819 
# names Oberellen  99819 
# names Krauthausen  99819 
# names Suhl  98527 98528 98529 
# names Marksuhl  99819 
# names Hallungen  99826 
# names Ebenshausen  99826 
# names Nazza  99826 
# names Bischofroda  99826 
# names Mihla  99826 
# names Frankenroda  99826 
# names Treffurt  99830 
# names Creuzburg  99831 
# names Ifta  99831 
# names Gerstungen  99834 
# names Dankmarshausen  99837 
# names Dippach  99837 
# names Ruhla  99842 
# names Wutha-Farnroda  99848 
# names Gotha  99867 
# names Haina  99869 
# names Emleben  99869 
# names Ebenheim  99869 
# names Wandersleben  99869 
# names Wangenheim  99869 
# names Bufleben  99869 
# names Eschenbergen  99869 
# names Sonneborn  99869 
# names Grabsleben  99869 
# names Seebergen  99869 
# names Friemar  99869 
# names Molschleben  99869 
# names Wechmar  99869 
# names Friedrichswerth  99869 
# names Warza  99869 
# names Pferdingsleben  99869 
# names Teutleben  99880 
# names Leinatal  99880 
# names Metebach  99880 
# names Waltershausen  99880 
# names Ohrdruf  99885 
# names Luisenthal  99885 
# names Hohenkirchen  99887 
# names Petriroda  99887 
# names Georgenthal  99887 
# names Herrenhof  99887 
# names Emsetal  99891 
# names Tabarz  99891 
# names Ernstroda  99894 
# names Friedrichroda  99894 
# names Tambach-Dietharz  99897 
# names Finsterbergen  99898 
# names Bothenheilingen  99947 
# names Behringen  99947 
# names Kleinwelsbach  99947 
# names Tottleben  99947 
# names Issersheilingen  99947 
# names Weberstedt  99947 
# names Neunheilingen  99947 
# names Sundhausen  99947 
# names Kirchheilingen  99947 
# names Bruchstedt  99955 
# names Klettstedt  99955 
# names Kutzleben  99955 
# names Herbsleben  99955 
# names Urleben  99955 
# names Ballhausen  99955 
# names Tonna  99958 
# names Unstruttal  99974 99976 
# names Anrode  99976 
# names Lengenfeld  08485 
# names Stein  24235 
# names Hildebrandshausen  99976 
# names Rodeberg  99976 
# names Flarchheim  99986 
# names Oppershausen  99986 
# names Langula  99986 
# names Niederdorla  99986 
# names Oberdorla  99986 
# names Katharinenberg  99988 
# names Heyerode  99988 
# names Altengottern  99991 
# names Heroldishausen  99991 
# names Schlotheim  99994 
# names Marolterode  99994 
# names Obermehler  99996 
# names Menteroda  99996 
# names Weinbergen  99998 
