/*
    GPSUTIL a program to interact with NMEA compatable and other supported
      GPS units.

    Copyright (C) 2000  Brian J. Hennings

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    I can be contacted at hennings@cs.uakron.edu or by US mail at:

    Brian Hennings
    114 Rex Ave.
    Wintersville, OH 43953
*/

#ifndef _MAGELLAN_H
#define _MAGELLAN_H

#define MAXERR       5
#define MNAME_SIZE   8
#define MDESC_SIZE  30

typedef struct mWpT {
     double Latitude;
     char   LatDir;
     double Longitude;
     char   LongDir;
     long   Altitude;
     char   AltType;
     char   Name[MNAME_SIZE + 1];      //8 Characters and a NULL
     char   Desc[MDESC_SIZE + 1];      //30 Char and a NULL;
     char   Icon;
     struct mWpT *Next;
} MWpt;

int  magellan_init ();
MWpt *  magellan_dl_waypoints (char *cmd);
void magellan_ul_waypoints (char *FName);
int  magellan_free_waypoints (MWpt *List);
int  magellan_del_waypoint (char *wptname);
void magellan_handon ();
void magellan_handoff ();


#endif
