package Google::Ads::AdWords::v201109_1::ManualCPMAdGroupCriterionBids;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201109_1' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201109_1::AdGroupCriterionBids);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %AdGroupCriterionBids__Type_of :ATTR(:get<AdGroupCriterionBids__Type>);
my %maxCpm_of :ATTR(:get<maxCpm>);
my %bidSource_of :ATTR(:get<bidSource>);

__PACKAGE__->_factory(
    [ qw(        AdGroupCriterionBids__Type
        maxCpm
        bidSource

    ) ],
    {
        'AdGroupCriterionBids__Type' => \%AdGroupCriterionBids__Type_of,
        'maxCpm' => \%maxCpm_of,
        'bidSource' => \%bidSource_of,
    },
    {
        'AdGroupCriterionBids__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'maxCpm' => 'Google::Ads::AdWords::v201109_1::Bid',
        'bidSource' => 'Google::Ads::AdWords::v201109_1::BidSource',
    },
    {

        'AdGroupCriterionBids__Type' => 'AdGroupCriterionBids.Type',
        'maxCpm' => 'maxCpm',
        'bidSource' => 'bidSource',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109_1::ManualCPMAdGroupCriterionBids

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ManualCPMAdGroupCriterionBids from the namespace https://adwords.google.com/api/adwords/cm/v201109_1.

Data representing a criterion-level CPM bid. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * maxCpm


=item * bidSource




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109_1::ManualCPMAdGroupCriterionBids
   maxCpm =>  $a_reference_to, # see Google::Ads::AdWords::v201109_1::Bid
   bidSource => $some_value, # BidSource
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

