package Google::Ads::AdWords::v201802::MaximizeConversionValueBiddingScheme;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201802' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201802::BiddingScheme);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %BiddingScheme__Type_of :ATTR(:get<BiddingScheme__Type>);
my %targetRoas_of :ATTR(:get<targetRoas>);

__PACKAGE__->_factory(
    [ qw(        BiddingScheme__Type
        targetRoas

    ) ],
    {
        'BiddingScheme__Type' => \%BiddingScheme__Type_of,
        'targetRoas' => \%targetRoas_of,
    },
    {
        'BiddingScheme__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'targetRoas' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
    },
    {

        'BiddingScheme__Type' => 'BiddingScheme.Type',
        'targetRoas' => 'targetRoas',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201802::MaximizeConversionValueBiddingScheme

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
MaximizeConversionValueBiddingScheme from the namespace https://adwords.google.com/api/adwords/cm/v201802.

Maximize Conversion Value bidding strategy is an automated bidding strategy which tries to maximize conversion value given a daily budget. <span class="constraint AdxEnabled">This is disabled for AdX.</span> 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * targetRoas




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

