package Google::Ads::AdWords::v201809::Chain;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201809' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %chainId_of :ATTR(:get<chainId>);

__PACKAGE__->_factory(
    [ qw(        chainId

    ) ],
    {
        'chainId' => \%chainId_of,
    },
    {
        'chainId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'chainId' => 'chainId',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201809::Chain

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Chain from the namespace https://adwords.google.com/api/adwords/cm/v201809.

Chain defines chain related metadata required in order to sync features belonging to a chain. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * chainId




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

