#!/usr/bin/perl

package eBay::API::XML::Call::GetProductFamilyMembers::GetProductFamilyMembersRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetProductFamilyMembersRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetProductFamilyMembers::GetProductFamilyMembersRequestType

=head1 DESCRIPTION

GetProductFamilyMembers is intended to be used combination with GetProductSearchResults.
If a search result returned from GetProductSearchResults does not return all
product versions in a family, and if the user wants to see more versions (editions)
of the product, you can use GetProductFamilyMembers to retrieve all versions of the product.
That is, if GetProductSearchResultsonly returns the product family header (ParentProduct),
use this call to zoom in on a particular family of product versions.
(This situation usually occurs when you call GetProductSearchResults and more more
matches are found than the MaxChildrenPerFamily value you specified.)<br>
<br>
The structure of tGetProductFamilyMembers is similar to that of GetProductSearchResults.
Instead of passing in a query, you pass in a product ID. This product ID is used to
find all the members of the product family that the specified product is a member of.
The results are compatible with the results from GetProductSearchResults,
so similar application logic can be used to handle both requests and responses.
This call supports batch requests. This means you can retrieve products in
multiple families by using a single request. To perform a batch request,
pass an array of ProductSearch objects in the call.<br>
<br>
For each ProductSearch object, GetProductFamilyMembers returns a list of all the
products in the specified product family. Each product is represented as a list of
attributes (Item Specifics) plus other identifying information, such as a product ID
and a stock photo.<br>
<br>
Once the user selects a product from the results, pass its ID in a GetProductSellingPages
request to retrieve more detailed information about the product, including a set of
optional Item Specifics that the seller can use in addition to the
pre-filled Item Specifics (see GetProductSellingPages). <br>
<br>
To use this data in a listing, pass the product ID and the optional Item Specifics
in the seller's listing request (AddItem).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetProductFamilyMembers::GetProductFamilyMembersRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ProductSearchType;


my @gaProperties = ( [ 'ProductSearch', 'ns:ProductSearchType', '1'
	     ,'eBay::API::XML::DataType::ProductSearchType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setProductSearch()

Specifies the ID of a product in the family to be retrieved,
along with pagination and sorting instructions.
ProductSearch is a required input.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrGPFM
Title: Retrieving All Members of a Product Family

  RequiredInput: Yes
#    Argument: reference to an array  
                      of 'ns:ProductSearchType'

=cut

sub setProductSearch {
  my $self = shift;
  $self->{'ProductSearch'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getProductSearch()

#    Returns: reference to an array  
                      of 'ns:ProductSearchType'

=cut

sub getProductSearch {
  my $self = shift;
  return $self->_getDataTypeArray('ProductSearch');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
