#!/usr/bin/perl

package eBay::API::XML::Call::GetSellerEvents;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSellerEvents.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSellerEvents

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSellerEvents inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetSellerEvents::GetSellerEventsRequestType;
use eBay::API::XML::Call::GetSellerEvents::GetSellerEventsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetSellerEvents';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSellerEvents::GetSellerEventsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetSellerEvents::GetSellerEventsResponseType';
}

#
# input properties
#

=head2 setEndTimeFrom()

Describes the earliest (oldest) date to use in a date range filter based
on item end time. Must be specified if EndTimeTo is specified. Either
the StartTimeFrom, EndTimeFrom, or ModTimeFrom filter must be specified.
If you do not specify the correspoding To filter,
it is set to the time you make the call.
For better results, the time period you use should be less than 48 hours.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut
       
sub setEndTimeFrom {
   my $self   = shift;
   my $sEndTimeFrom = shift;
   $self->getRequestDataType()->setEndTimeFrom($sEndTimeFrom);
}

=head2 setEndTimeTo()

Describes the latest (most recent) date to use in a date range filter
based on item end time. If you specify the corresponding From filter,
but you do not include EndTimeTo, then EndTimeTo is set
to the time you make the call.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut
       
sub setEndTimeTo {
   my $self   = shift;
   my $sEndTimeTo = shift;
   $self->getRequestDataType()->setEndTimeTo($sEndTimeTo);
}

=head2 setIncludeWatchCount()

Specifies whether to include WatchCount in Item nodes returned. WatchCount
is the number of watches buyers have placed on the item from their My eBay
accounts.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setIncludeWatchCount {
   my $self   = shift;
   my $sIncludeWatchCount = shift;
   $self->getRequestDataType()->setIncludeWatchCount($sIncludeWatchCount);
}

=head2 setModTimeFrom()

Describes the earliest (oldest) date to use in a date range filter based
on item modification time. Must be specified if ModTimeTo is specified. Either
the StartTimeFrom, EndTimeFrom, or ModTimeFrom filter must be specified.
If you do not specify the correspoding To filter,
it is set to the time you make the call.
<br><br>
For better results, the time period you use should be less than 48 hours.
<br><br>
If an unexpected item is returned (including an old item
or an unchanged active item), please ignore the item.
Although a maintenance process may have triggered a change in the modification time,
item characteristics are unchanged.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut
       
sub setModTimeFrom {
   my $self   = shift;
   my $sModTimeFrom = shift;
   $self->getRequestDataType()->setModTimeFrom($sModTimeFrom);
}

=head2 setModTimeTo()

Describes the latest (most recent) date to use in a date range filter
based on the time an item's record was modified. If you specify
the corresponding From filter, but you do not include ModTimeTo,
then ModTimeTo is set to the time you make the call.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut
       
sub setModTimeTo {
   my $self   = shift;
   my $sModTimeTo = shift;
   $self->getRequestDataType()->setModTimeTo($sModTimeTo);
}

=head2 setNewItemFilter()

Specifies that only new items are to be returned. NewItemFilter is an
optional input.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setNewItemFilter {
   my $self   = shift;
   my $sNewItemFilter = shift;
   $self->getRequestDataType()->setNewItemFilter($sNewItemFilter);
}

=head2 setStartTimeFrom()

Describes the earliest (oldest) date to use in a date range filter based
on item start time. Must be specified if StartTimeTo is specified. Either
the StartTimeFrom, EndTimeFrom, or ModTimeFrom filter must be specified.
If you do not specify the correspoding To filter,
it is set to the time you make the call.
For better results, the time period you use should be less than 48 hours.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut
       
sub setStartTimeFrom {
   my $self   = shift;
   my $sStartTimeFrom = shift;
   $self->getRequestDataType()->setStartTimeFrom($sStartTimeFrom);
}

=head2 setStartTimeTo()

Describes the latest (most recent) date to use in a date range filter
based on item start time. If you specify the corresponding From filter,
but you do not include StartTimeTo, the StartTimeTo is set to
the time you make the call.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut
       
sub setStartTimeTo {
   my $self   = shift;
   my $sStartTimeTo = shift;
   $self->getRequestDataType()->setStartTimeTo($sStartTimeTo);
}

=head2 setUserID()

eBay user ID for the seller whose events are to be returned.
If not specified, retrieves events for the user identified by
the authentication token passed in the request. Note that since user information is anonymous to everyone except the bidder and the seller (during an active auction), only sellers looking for information about
their own listings and bidders who know the user IDs of their sellers
will be able to make this API call successfully. See <a href="http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo">Working with Anonymous User Information</a>in the eBay Web Services Guide for more information.

  RequiredInput: No
#    Argument: 'ns:UserIDType'

=cut
       
sub setUserID {
   my $self   = shift;
   my $pUserID = shift;
   $self->getRequestDataType()->setUserID($pUserID);
}



#
# output properties
#

=head2 getItemArray()

Collection of Item objects, each of which represents an item listing
that incurred the type of seller event change specified in the call's
inputs. Returns empty if the seller has no item events within the
time window indicated in the request.

  Returned: Always
  Details: DetailLevel: none, ReturnAll
#    Returns: 'ns:ItemArrayType'

=cut
       
sub getItemArray {
   my $self = shift;
   return $self->getResponseDataType()->getItemArray();
}

=head2 getTimeTo()

Indicates the latest (most recent) date for any date-based filtering specified as
input. Specifically, this field contains the value you specified in the StartTimeTo, EndTimeTo, or ModTimeTo filter, if you used a time filter in the request. If no time filter was specified, TimeTo returns the current time.

  Returned: Always
  Details: DetailLevel: none, ReturnAll
#    Returns: 'xs:dateTime'

=cut
       
sub getTimeTo {
   my $self = shift;
   return $self->getResponseDataType()->getTimeTo();
}





1;   
