#!/usr/bin/perl

package eBay::API::XML::Call::GetWantItNowSearchResults::GetWantItNowSearchResultsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetWantItNowSearchResultsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetWantItNowSearchResults::GetWantItNowSearchResultsRequestType

=head1 DESCRIPTION

Retrieves a list of active Want It Now posts that match specified keywords
and/or a specific category ID. The response contains the following data:
CategoryID, PostID, StartTime, ResponseCount, Site, and Title. To get the post
description (Description), you must use GetWantItNowPost to retrieve individual
posts.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetWantItNowSearchResults::GetWantItNowSearchResultsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::PaginationType;


my @gaProperties = ( [ 'CategoryID', 'xs:string', '', '', '' ]
	, [ 'Pagination', 'ns:PaginationType', ''
	     ,'eBay::API::XML::DataType::PaginationType', '1' ]
	, [ 'Query', 'xs:string', '', '', '' ]
	, [ 'SearchInDescription', 'xs:boolean', '', '', '' ]
	, [ 'SearchWorldwide', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryID()

Limits the result set to just those Want It Now posts listed in the
specified category. Defaults to all categories if no category ID is
specified. If the specified category ID does not match an existing
category for the site, an invalid-category error message is returned.
Controls the set of listings to return (not the details to return for each
listing).
You must specify a Query and/or a CategoryID in the request.

MaxLength: 10

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setCategoryID {
  my $self = shift;
  $self->{'CategoryID'} = shift
}

=head2 getCategoryID()

#    Returns: 'xs:string'

=cut

sub getCategoryID {
  my $self = shift;
  return $self->{'CategoryID'};
}


=head2 setPagination()

Controls the pagination of the result set. Child elements specify the
maximum number of item listings to return per call and which page of data
to return.

  RequiredInput: No
#    Argument: 'ns:PaginationType'

=cut

sub setPagination {
  my $self = shift;
  $self->{'Pagination'} = shift
}

=head2 getPagination()

#    Returns: 'ns:PaginationType'

=cut

sub getPagination {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Pagination'
		,'eBay::API::XML::DataType::PaginationType');
}


=head2 setQuery()

Specifies a search string. The search string consists of one or more
keywords to search for in the listing title. Note that the post
description will also be searched if SearchInDescription is enabled.
By default, requests return a list of Want It Now posts that include all
of the keywords specified in the Query. All words used in the query,
including "and," "or," and "the,"  will be treated as keywords. You can,
however, use modifiers and wildcards (e.g., +, -, and *) in the Query
field to create more complex searches. Be careful when using spaces before
or after modifiers and wildcards (+, -, or *), as the spaces can affect
the query logic.
See the eBay Web Services Guide for a list of valid search keyword query
operators and examples.

MaxLength: 350 (characters)

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setQuery {
  my $self = shift;
  $self->{'Query'} = shift
}

=head2 getQuery()

#    Returns: 'xs:string'

=cut

sub getQuery {
  my $self = shift;
  return $self->{'Query'};
}


=head2 setSearchInDescription()

If true, include the description field of Want It Now posts in the keyword search. Want
It Now posts returned are those where specified search keywords appear in
either the description or the title. This is the default behavior if SearchInDescription
is not specified. If false, only the title will be searched. SearchInDescription is an
optional input.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setSearchInDescription {
  my $self = shift;
  $self->{'SearchInDescription'} = shift
}

=head2 isSearchInDescription()

#    Returns: 'xs:boolean'

=cut

sub isSearchInDescription {
  my $self = shift;
  return $self->{'SearchInDescription'};
}


=head2 setSearchWorldwide()

If true, the search applies to all eBay sites. If false, the search is
limited to the site specified in the URL query string when the call is
made.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setSearchWorldwide {
  my $self = shift;
  $self->{'SearchWorldwide'} = shift
}

=head2 isSearchWorldwide()

#    Returns: 'xs:boolean'

=cut

sub isSearchWorldwide {
  my $self = shift;
  return $self->{'SearchWorldwide'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
