#!/usr/bin/perl

package eBay::API::XML::DataType::AccountSummaryType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AccountSummaryType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AccountSummaryType

=head1 DESCRIPTION

Summary data for the requesting user's seller account as a whole. This includes a
balance for the account, any past due amount and date, and defining data for
additional accounts (if the user has changed country of residency while having an
active eBay account).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AccountSummaryType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AdditionalAccountType;
use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::Enum::AccountStateCodeType;
use eBay::API::XML::DataType::Enum::SellerPaymentMethodCodeType;


my @gaProperties = ( [ 'AccountState', 'ns:AccountStateCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AccountStateCodeType', '' ]
	, [ 'AdditionalAccount', 'ns:AdditionalAccountType', '1'
	     ,'eBay::API::XML::DataType::AdditionalAccountType', '1' ]
	, [ 'AmountPastDue', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'BankAccountInfo', 'xs:string', '', '', '' ]
	, [ 'BankModifyDate', 'xs:dateTime', '', '', '' ]
	, [ 'BillingCycleDate', 'xs:int', '', '', '' ]
	, [ 'CreditCardExpiration', 'xs:dateTime', '', '', '' ]
	, [ 'CreditCardInfo', 'xs:string', '', '', '' ]
	, [ 'CreditCardModifyDate', 'xs:dateTime', '', '', '' ]
	, [ 'CurrentBalance', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'Email', 'xs:string', '', '', '' ]
	, [ 'InvoiceBalance', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'InvoiceCredit', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'InvoiceDate', 'xs:dateTime', '', '', '' ]
	, [ 'InvoiceNewFee', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'InvoicePayment', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'LastAmountPaid', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'LastPaymentDate', 'xs:dateTime', '', '', '' ]
	, [ 'PastDue', 'xs:boolean', '', '', '' ]
	, [ 'PaymentMethod', 'ns:SellerPaymentMethodCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SellerPaymentMethodCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAccountState()

Indicates the current state of the account (such as active or inactive).
Possible values are enumerated in the AccountStateCodeType code list.

#    Argument: 'ns:AccountStateCodeType'

=cut

sub setAccountState {
  my $self = shift;
  $self->{'AccountState'} = shift
}

=head2 getAccountState()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AccountStateCodeType'

=cut

sub getAccountState {
  my $self = shift;
  return $self->{'AccountState'};
}


=head2 setAdditionalAccount()

Contains the data for one additional account. An AccountSummaryType object
may return zero, one, or multiple additional accounts. See the schema
documentation for AdditionalAccountType for details on additional accounts.
The value is positive for debits and negative for credits.

#    Argument: reference to an array  
                      of 'ns:AdditionalAccountType'

=cut

sub setAdditionalAccount {
  my $self = shift;
  $self->{'AdditionalAccount'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getAdditionalAccount()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:AdditionalAccountType'

=cut

sub getAdditionalAccount {
  my $self = shift;
  return $self->_getDataTypeArray('AdditionalAccount');
}


=head2 setAmountPastDue()

Amount past due, 0.00 if not past due.
The value is positive for debits and negative for credits.

#    Argument: 'ns:AmountType'

=cut

sub setAmountPastDue {
  my $self = shift;
  $self->{'AmountPastDue'} = shift
}

=head2 getAmountPastDue()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getAmountPastDue {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AmountPastDue'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setBankAccountInfo()

First four digits of the bank account the user associated with the seller
account (with remainder Xed-out). This may be an empty string depending
upon the payment type the user selected for the account (e.g., if no
debit-card specified).

MaxLength: 4

#    Argument: 'xs:string'

=cut

sub setBankAccountInfo {
  my $self = shift;
  $self->{'BankAccountInfo'} = shift
}

=head2 getBankAccountInfo()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getBankAccountInfo {
  my $self = shift;
  return $self->{'BankAccountInfo'};
}


=head2 setBankModifyDate()

Indicates the date and time BankAccountInfo was last modified, in GMT.
(Also see the Data Types appendix for more information on how GMT dates are
handled in SOAP.) This may be an empty string depending upon the payment
type the user selected for the account (e.g., if no debit-card specified).

#    Argument: 'xs:dateTime'

=cut

sub setBankModifyDate {
  my $self = shift;
  $self->{'BankModifyDate'} = shift
}

=head2 getBankModifyDate()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getBankModifyDate {
  my $self = shift;
  return $self->{'BankModifyDate'};
}


=head2 setBillingCycleDate()

Indicates the billing cycle in which eBay sends a billing invoice to the
user. A value of 0 (zero) indicates an invoice sent on the last day of the
month. A value of 15 indicates an invoice sent on the 15th day of the
month.

#    Argument: 'xs:int'

=cut

sub setBillingCycleDate {
  my $self = shift;
  $self->{'BillingCycleDate'} = shift
}

=head2 getBillingCycleDate()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getBillingCycleDate {
  my $self = shift;
  return $self->{'BillingCycleDate'};
}


=head2 setCreditCardExpiration()

Expiration date for the credit card selected by the user as payment method
for the account, in GMT. (Also see the Data Types appendix for more
information on how GMT dates are handled in SOAP.) Empty string if no
credit card is on file or if the account is inactive - even if there is a
credit card on file.

#    Argument: 'xs:dateTime'

=cut

sub setCreditCardExpiration {
  my $self = shift;
  $self->{'CreditCardExpiration'} = shift
}

=head2 getCreditCardExpiration()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getCreditCardExpiration {
  my $self = shift;
  return $self->{'CreditCardExpiration'};
}


=head2 setCreditCardInfo()

Last four digits of the credit card the user selected as payment method for
the account. Empty string if no credit is on file.

#    Argument: 'xs:string'

=cut

sub setCreditCardInfo {
  my $self = shift;
  $self->{'CreditCardInfo'} = shift
}

=head2 getCreditCardInfo()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getCreditCardInfo {
  my $self = shift;
  return $self->{'CreditCardInfo'};
}


=head2 setCreditCardModifyDate()

Indicates the date and time credit card or credit card expiration date was
last modified, in GMT. (Also see the Data Types appendix for more
information on how GMT dates are handled in SOAP.) This may be an empty
string depending on the payment method the user selected for the account
(e.g., Empty string if no credit card is on file.)

#    Argument: 'xs:dateTime'

=cut

sub setCreditCardModifyDate {
  my $self = shift;
  $self->{'CreditCardModifyDate'} = shift
}

=head2 getCreditCardModifyDate()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getCreditCardModifyDate {
  my $self = shift;
  return $self->{'CreditCardModifyDate'};
}


=head2 setCurrentBalance()

Current balance for the account. Can be 0.00, positive, or negative.
The value is positive for debits and negative for credits.

#    Argument: 'ns:AmountType'

=cut

sub setCurrentBalance {
  my $self = shift;
  $self->{'CurrentBalance'} = shift
}

=head2 getCurrentBalance()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getCurrentBalance {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CurrentBalance'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setEmail()

(out) Email address for the user. You cannot retrieve an email address for any
user with whom you do not have a transactional relationship, regardless of
site. Email is only returned for applicable calls when you are retrieving your
own user data OR when you and the other user are in a transactional
relationship and the call is being executed within a certain amount of time
after the transaction is created.

#    Argument: 'xs:string'

=cut

sub setEmail {
  my $self = shift;
  $self->{'Email'} = shift
}

=head2 getEmail()

#    Returns: 'xs:string'

=cut

sub getEmail {
  my $self = shift;
  return $self->{'Email'};
}


=head2 setInvoiceBalance()

Amount of last invoice. 0.00 if account not yet invoiced.
The value is positive for debits and negative for credits.

#    Argument: 'ns:AmountType'

=cut

sub setInvoiceBalance {
  my $self = shift;
  $self->{'InvoiceBalance'} = shift
}

=head2 getInvoiceBalance()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getInvoiceBalance {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InvoiceBalance'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setInvoiceCredit()

Specifies credits granted since the previous invoice, but
is only returned AccountHistorySelection is LastInvoice or Specified
Invoice.
The value is positive for debits and negative for credits.

#    Argument: 'ns:AmountType'

=cut

sub setInvoiceCredit {
  my $self = shift;
  $self->{'InvoiceCredit'} = shift
}

=head2 getInvoiceCredit()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getInvoiceCredit {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InvoiceCredit'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setInvoiceDate()

Date of last invoice sent by eBay to the user, in GMT. (Also see the Data
Types appendix for more information on how GMT dates are handled in SOAP.)
Empty string if this account has not been invoiced yet.

#    Argument: 'xs:dateTime'

=cut

sub setInvoiceDate {
  my $self = shift;
  $self->{'InvoiceDate'} = shift
}

=head2 getInvoiceDate()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getInvoiceDate {
  my $self = shift;
  return $self->{'InvoiceDate'};
}


=head2 setInvoiceNewFee()

Specifies fees incurred since the last invoice, including
tax if applicable. Returned only if AccountHistorySelection
is LastInvoice or Specified Invoice. The value is positive for debits and negative for credits.

#    Argument: 'ns:AmountType'

=cut

sub setInvoiceNewFee {
  my $self = shift;
  $self->{'InvoiceNewFee'} = shift
}

=head2 getInvoiceNewFee()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getInvoiceNewFee {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InvoiceNewFee'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setInvoicePayment()

Specifies payment made since the previous invoice, but is
returned only if AccountHistorySelection is LastInvoice or Specified
Invoice. The value is positive for debits and negative for credits.

#    Argument: 'ns:AmountType'

=cut

sub setInvoicePayment {
  my $self = shift;
  $self->{'InvoicePayment'} = shift
}

=head2 getInvoicePayment()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getInvoicePayment {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InvoicePayment'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setLastAmountPaid()

Amount of last payment posted, 0.00 if no payments posted.
The value is positive for debits and negative for credits.

#    Argument: 'ns:AmountType'

=cut

sub setLastAmountPaid {
  my $self = shift;
  $self->{'LastAmountPaid'} = shift
}

=head2 getLastAmountPaid()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getLastAmountPaid {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LastAmountPaid'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setLastPaymentDate()

Date of last payment by the user to eBay, in GMT. (Also see the Data Types
appendix for more information on how GMT dates are handled in SOAP.) Empty
string if no payments have been posted.

#    Argument: 'xs:dateTime'

=cut

sub setLastPaymentDate {
  my $self = shift;
  $self->{'LastPaymentDate'} = shift
}

=head2 getLastPaymentDate()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getLastPaymentDate {
  my $self = shift;
  return $self->{'LastPaymentDate'};
}


=head2 setPastDue()

Indicates whether the account has past due amounts outstanding. A value of
true indicates that the account is past due. A value of false indicates the
account is current.

#    Argument: 'xs:boolean'

=cut

sub setPastDue {
  my $self = shift;
  $self->{'PastDue'} = shift
}

=head2 isPastDue()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isPastDue {
  my $self = shift;
  return $self->{'PastDue'};
}


=head2 setPaymentMethod()

Indicates the method the user selected to pay eBay with for the account.
The values for PaymentMethod vary from one global eBay site to the next.
Payment methods are enumerated in the SellerPaymentMethodCodeType code
list.

#    Argument: 'ns:SellerPaymentMethodCodeType'

=cut

sub setPaymentMethod {
  my $self = shift;
  $self->{'PaymentMethod'} = shift
}

=head2 getPaymentMethod()

  Calls: GetAccount
  Returned: Conditionally

#    Returns: 'ns:SellerPaymentMethodCodeType'

=cut

sub getPaymentMethod {
  my $self = shift;
  return $self->{'PaymentMethod'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
