#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::CategoryListingsOrderCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CategoryListingsOrderCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::CategoryListingsOrderCodeType

=head1 DESCRIPTION

CategoryListingsOrderCodeType - Type declaration to be used by other
schema. This code identifies the CategoryListingsOrder codes (e.g.,
for GetCategoryListings request) to be used to filter the returned
data in the ways enumerated below.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 NoFilter

(in) Applies no filter.



=cut


use constant NoFilter => scalar('NoFilter');


=head2 ItemsBy24Hr

(in) Returns items that were listed in the past 24 hours.



=cut


use constant ItemsBy24Hr => scalar('ItemsBy24Hr');


=head2 ItemsEndToday

(in) Reserved for internal use.



=cut


use constant ItemsEndToday => scalar('ItemsEndToday');


=head2 ItemsEndIn5Hr

(in) Reserved for internal use.



=cut


use constant ItemsEndIn5Hr => scalar('ItemsEndIn5Hr');


=head2 SortByPriceAsc

(in) Sort items by price (lowest first)



=cut


use constant SortByPriceAsc => scalar('SortByPriceAsc');


=head2 SortByPriceDesc

(in) Sort items by price (highest first)



=cut


use constant SortByPriceDesc => scalar('SortByPriceDesc');


=head2 BestMatchSort

(in) Sorts items by Best Match, which is based on community buying activity and other relevance-based factors.



=cut


use constant BestMatchSort => scalar('BestMatchSort');


=head2 DistanceSort

(in) Sort items by distance



=cut


use constant DistanceSort => scalar('DistanceSort');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');


=head2 BestMatchCategoryGroup

(in) groups Best Match search results by category. See BestMatchSort. You can also set the number of groups and items per group within the Group
section of the call.



=cut


use constant BestMatchCategoryGroup => scalar('BestMatchCategoryGroup');


=head2 PricePlusShippingAsc

(in) This field is part of the Price Plus Shipping Sort feature, to be enabled
by the end of Sept. 2007 for the following sites:
US (site ID 0), Germany (77), Canada (2), and Australia (15).
The Price Plus Shipping Sort feature causes item sorting to consider shipping costs.
Specify PricePlusShippingAsc to sort items by lowest cost first, as follows:
Lowest-total-cost (for items where shipping was properly specified),
then freight-shipping items, then items for which shipping was not specified (sorted by price).



=cut


use constant PricePlusShippingAsc => scalar('PricePlusShippingAsc');


=head2 PricePlusShippingDesc

(in) This field is part of the Price Plus Shipping Sort feature, to be enabled
by the end of Sept. 2007 for the following sites:
US (site ID 0), Germany (77), Canada (2), and Australia (15).
The Price Plus Shipping Sort feature causes item sorting to consider shipping costs.
Specify PricePlusShippingDesc to sort items by highest cost first, as follows:
highest-total-cost (for items where shipping was properly specified),
then freight-shipping items, then items for which shipping was not specified (sorted by price).



=cut


use constant PricePlusShippingDesc => scalar('PricePlusShippingDesc');







1;   
