
/* File Server variable names */

char *fs_varNames[] = {
"numPerfCalls",		/* Performance Numbers */
"vcache_L_Entries",
"vcache_L_Allocs",
"vcache_L_Gets",
"vcache_L_Reads",
"vcache_L_Writes",
"vcache_S_Entries",
"vcache_S_Allocs",
"vcache_S_Gets",
"vcache_S_Reads",
"vcache_S_Writes",
"vcache_H_Entries",
"vcache_H_Gets",
"vcache_H_Replacements",
"dir_Buffers",
"dir_Calls",
"dir_IOs",
"rx_packetRequests",
"rx_noPackets_RcvClass",
"rx_noPackets_SendClass",
"rx_noPackets_SpecialClass",
"rx_socketGreedy",
"rx_bogusPacketOnRead",
"rx_bogusHost",
"rx_noPacketOnRead",
"rx_noPacketBuffersOnRead",
"rx_selects",
"rx_sendSelects",
"rx_packetsRead_RcvClass",
"rx_packetsRead_SendClass",
"rx_packetsRead_SpecialClass",
"rx_dataPacketsRead",
"rx_ackPacketsRead",
"rx_dupPacketsRead",
"rx_spuriousPacketsRead",
"rx_packetsSent_RcvClass",
"rx_packetsSent_SendClass",
"rx_packetsSent_SpecialClass",
"rx_ackPacketsSent",
"rx_pingPacketsSent",
"rx_abortPacketsSent",
"rx_busyPacketsSent",
"rx_dataPacketsSent",
"rx_dataPacketsReSent",
"rx_dataPacketsPushed",
"rx_ignoreAckedPacket",
"rx_totalRtt_Sec",
"rx_totalRtt_Usec",
"rx_minRtt_Sec",
"rx_minRtt_Usec",
"rx_maxRtt_Sec",
"rx_maxRtt_Usec",
"rx_nRttSamples",
"rx_nServerConns",
"rx_nClientConns",
"rx_nPeerStructs",
"rx_nCallStructs",
"rx_nFreeCallStructs",
"host_NumHostEntries",
"host_HostBlocks",
"host_NonDeletedHosts",
"host_HostsInSameNetOrSubnet",
"host_HostsInDiffSubnet",
"host_HostsInDiffNetwork",
"host_NumClients",
"host_ClientBlocks",	/* ",sysname_ID", has been junked */
"epoch",			/* RPC Operation timings */
"FetchData_ops",
"FetchData_ops_ok",
"FetchData_sum",
"FetchData_sqr",
"FetchData_min",
"FetchData_max",
"FetchACL_ops",
"FetchACL_ops_ok",
"FetchACL_sum",
"FetchACL_sqr",
"FetchACL_min",
"FetchACL_max",
"FetchStatus_ops",
"FetchStatus_ops_ok",
"FetchStatus_sum",
"FetchStatus_sqr",
"FetchStatus_min",
"FetchStatus_max",
"StoreData_ops",
"StoreData_ops_ok",
"StoreData_sum",
"StoreData_sqr",
"StoreData_min",
"StoreData_max",
"StoreACL_ops",
"StoreACL_ops_ok",
"StoreACL_sum",
"StoreACL_sqr",
"StoreACL_min",
"StoreACL_max",
"StoreStatus_ops",
"StoreStatus_ops_ok",
"StoreStatus_sum",
"StoreStatus_sqr",
"StoreStatus_min",
"StoreStatus_max",
"RemoveFile_ops",
"RemoveFile_ops_ok",
"RemoveFile_sum",
"RemoveFile_sqr",
"RemoveFile_min",
"RemoveFile_max",
"CreateFile_ops",
"CreateFile_ops_ok",
"CreateFile_sum",
"CreateFile_sqr",
"CreateFile_min",
"CreateFile_max",
"Rename_ops",
"Rename_ops_ok",
"Rename_sum",
"Rename_sqr",
"Rename_min",
"Rename_max",
"Symlink_ops",
"Symlink_ops_ok",
"Symlink_sum",
"Symlink_sqr",
"Symlink_min",
"Symlink_max",
"Link_ops",
"Link_ops_ok",
"Link_sum",
"Link_sqr",
"Link_min",
"Link_max",
"MakeDir_ops",
"MakeDir_ops_ok",
"MakeDir_sum",
"MakeDir_sqr",
"MakeDir_min",
"MakeDir_max",
"RemoveDir_ops",
"RemoveDir_ops_ok",
"RemoveDir_sum",
"RemoveDir_sqr",
"RemoveDir_min",
"RemoveDir_max",
"SetLock_ops",
"SetLock_ops_ok",
"SetLock_sum",
"SetLock_sqr",
"SetLock_min",
"SetLock_max",
"ExtendLock_ops",
"ExtendLock_ops_ok",
"ExtendLock_sum",
"ExtendLock_sqr",
"ExtendLock_min",
"ExtendLock_max",
"ReleaseLock_ops",
"ReleaseLock_ops_ok",
"ReleaseLock_sum",
"ReleaseLock_sqr",
"ReleaseLock_min",
"ReleaseLock_max",
"GetStatistics_ops",
"GetStatistics_ops_ok",
"GetStatistics_sum",
"GetStatistics_sqr",
"GetStatistics_min",
"GetStatistics_max",
"GiveUpCallbacks_ops",
"GiveUpCallbacks_ops_ok",
"GiveUpCallbacks_sum",
"GiveUpCallbacks_sqr",
"GiveUpCallbacks_min",
"GiveUpCallbacks_max",
"GetVolumeInfo_ops",
"GetVolumeInfo_ops_ok",
"GetVolumeInfo_sum",
"GetVolumeInfo_sqr",
"GetVolumeInfo_min",
"GetVolumeInfo_max",
"GetVolumeStatus_ops",
"GetVolumeStatus_ops_ok",
"GetVolumeStatus_sum",
"GetVolumeStatus_sqr",
"GetVolumeStatus_min",
"GetVolumeStatus_max",
"SetVolumeStatus_ops",
"SetVolumeStatus_ops_ok",
"SetVolumeStatus_sum",
"SetVolumeStatus_sqr",
"SetVolumeStatus_min",
"SetVolumeStatus_max",
"GetRootVolume_ops",
"GetRootVolume_ops_ok",
"GetRootVolume_sum",
"GetRootVolume_sqr",
"GetRootVolume_min",
"GetRootVolume_max",
"CheckToken_ops",
"CheckToken_ops_ok",
"CheckToken_sum",
"CheckToken_sqr",
"CheckToken_min",
"CheckToken_max",
"GetTime_ops",
"GetTime_ops_ok",
"GetTime_sum",
"GetTime_sqr",
"GetTime_min",
"GetTime_max",
"NGetVolumeInfo_ops",
"NGetVolumeInfo_ops_ok",
"NGetVolumeInfo_sum",
"NGetVolumeInfo_sqr",
"NGetVolumeInfo_min",
"NGetVolumeInfo_max",
"BulkStatus_ops",
"BulkStatus_ops_ok",
"BulkStatus_sum",
"BulkStatus_sqr",
"BulkStatus_min",
"BulkStatus_max",
"XStatsVersion_ops",
"XStatsVersion_ops_ok",
"XStatsVersion_sum",
"XStatsVersion_sqr",
"XStatsVersion_min",
"XStatsVersion_max",
"GetXStats_ops",
"GetXStats_ops_ok",
"GetXStats_sum",
"GetXStats_sqr",
"GetXStats_min",
"GetXStats_max",
"FetchData_xfers",	/* Timings for some byte sized data transfer ops */
"FetchData_xfers_ok",
"FetchData_xfers_sum",
"FetchData_xfers_sqr",
"FetchData_xfers_min",
"FetchData_xfers_max",
"FetchData_xfers_Kbytes_sum",
"FetchData_xfers_bytes_min",
"FetchData_xfers_bytes_max",
"FetchData_xfers_bucket0",
"FetchData_xfers_bucket1",
"FetchData_xfers_bucket2",
"FetchData_xfers_bucket3",
"FetchData_xfers_bucket4",
"FetchData_xfers_bucket5",
"FetchData_xfers_bucket6",
"FetchData_xfers_bucket7",
"FetchData_xfers_bucket8",
"StoreData_xfers",
"StoreData_xfers_ok",
"StoreData_xfers_sum",
"StoreData_xfers_sqr",
"StoreData_xfers_min",
"StoreData_xfers_max",
"StoreData_xfers_Kbytes_sum",
"StoreData_xfers_bytes_min",
"StoreData_xfers_bytes_max",
"StoreData_xfers_bucket0",
"StoreData_xfers_bucket1",
"StoreData_xfers_bucket2",
"StoreData_xfers_bucket3",
"StoreData_xfers_bucket4",
"StoreData_xfers_bucket5",
"StoreData_xfers_bucket6",
"StoreData_xfers_bucket7",
"StoreData_xfers_bucket8"
};

/* file server data classification */
/* Data is classified into sections and each section into one or more
groups. The integer after a section name specifies the number of groups
contained in it. The integers after a group name specify the starting and
ending positional indices to fs_varNames[]. Unimportant information
is placed at the end of the section. */

char *fs_categories[] = {
"PerfStats_section 5",
"VnodeCache_group 1 13",
"Directory_group 14 16",
"Rx_group 17 57",
"HostModule_group 58 65",
"misc_group 0 0",		/* numPerfCalls */
"RPCop_section 2",
"RPCopTimes_group 66 234",
"RPCopBytes_group 235 270"
};





/* Cache Manager variable names */

char *cm_varNames[] = {
"numPerfCalls",		/* Performance numbers for the cache manager */
"epoch",
"numCellsVisible",
"numCellsContacted",
"dlocalAccesses",
"vlocalAccesses",
"dremoteAccesses",
"vremoteAccesses",
"cacheNumEntries",
"cacheBlocksTotal",
"cacheBlocksInUse",
"cacheBlocksOrig",
"cacheMaxDirtyChunks",
"cacheCurrDirtyChunks",
"dcacheHits",
"vcacheHits",
"dcacheMisses",
"vcacheMisses",
"cacheFlushes",
"cacheFilesReused",
"vcacheXAllocs",
"dcacheXAllocs",
"bufAlloced",
"bufHits",
"bufMisses",
"bufFlushDirty",
"LargeBlocksActive",
"LargeBlocksAlloced",
"SmallBlocksActive",
"SmallBlocksAlloced",
"OutStandingMemUsage",
"OutStandingAllocs",
"CallBackAlloced",
"CallBackFlushes",
"srvRecords",
"srvNumBuckets",
"srvMaxChainLength",
"srvMaxChainLengthHWM",
"srvRecordsHWM",
"sysName_ID",
"fs_sc_numTtlRecords",	/* file server server up/down stats for same cell */
"fs_sc_numUpRecords",
"fs_sc_numDownRecords",
"fs_sc_sumOfRecordAges",
"fs_sc_ageOfYoungestRecord",
"fs_sc_ageOfOldestRecord",
"fs_sc_numDowntimeIncidents",
"fs_sc_numRecordsNeverDown",
"fs_sc_maxDowntimesInARecord",
"fs_sc_sumOfDowntimes",
"fs_sc_shortestDowntime",
"fs_sc_longestDowntime",
"fs_sc_down_0_10_min",
"fs_sc_down_10_30_min",
"fs_sc_down_half_1_hr",
"fs_sc_down_1_2_hr",
"fs_sc_down_2_4_hr",
"fs_sc_down_4_8_hr",
"fs_sc_down_more_8_hr",
"fs_sc_downDst_0",
"fs_sc_downDst_1",
"fs_sc_downDst_2_5",
"fs_sc_downDst_6_10",
"fs_sc_downDst_10_50",
"fs_sc_downDst_more_50",
"fs_oc_numTtlRecords",	/* file server server up/down stats for other cells */
"fs_oc_numUpRecords",
"fs_oc_numDownRecords",
"fs_oc_sumOfRecordAges",
"fs_oc_ageOfYoungestRecord",
"fs_oc_ageOfOldestRecord",
"fs_oc_numDowntimeIncidents",
"fs_oc_numRecordsNeverDown",
"fs_oc_maxDowntimesInARecord",
"fs_oc_sumOfDowntimes",
"fs_oc_shortestDowntime",
"fs_oc_longestDowntime",
"fs_oc_down_0_10_min",
"fs_oc_down_10_30_min",
"fs_oc_down_half_1_hr",
"fs_oc_down_1_2_hr",
"fs_oc_down_2_4_hr",
"fs_oc_down_4_8_hr",
"fs_oc_down_more_8_hr",
"fs_oc_downDst_0",
"fs_oc_downDst_1",
"fs_oc_downDst_2_5",
"fs_oc_downDst_6_10",
"fs_oc_downDst_10_50",
"fs_oc_downDst_more_50",
"vl_sc_numTtlRecords",	/* vl server up/down stats for same cell */
"vl_sc_numUpRecords",
"vl_sc_numDownRecords",
"vl_sc_sumOfRecordAges",
"vl_sc_ageOfYoungestRecord",
"vl_sc_ageOfOldestRecord",
"vl_sc_numDowntimeIncidents",
"vl_sc_numRecordsNeverDown",
"vl_sc_maxDowntimesInARecord",
"vl_sc_sumOfDowntimes",
"vl_sc_shortestDowntime",
"vl_sc_longestDowntime",
"vl_sc_down_0_10_min",
"vl_sc_down_10_30_min",
"vl_sc_down_half_1_hr",
"vl_sc_down_1_2_hr",
"vl_sc_down_2_4_hr",
"vl_sc_down_4_8_hr",
"vl_sc_down_more_8_hr",
"vl_sc_downDst_0",
"vl_sc_downDst_1",
"vl_sc_downDst_2_5",
"vl_sc_downDst_6_10",
"vl_sc_downDst_10_50",
"vl_sc_downDst_more_50",
"vl_oc_numTtlRecords",	/* vl server up/down stats for other cells */
"vl_oc_numUpRecords",
"vl_oc_numDownRecords",
"vl_oc_sumOfRecordAges",
"vl_oc_ageOfYoungestRecord",
"vl_oc_ageOfOldestRecord",
"vl_oc_numDowntimeIncidents",
"vl_oc_numRecordsNeverDown",
"vl_oc_maxDowntimesInARecord",
"vl_oc_sumOfDowntimes",
"vl_oc_shortestDowntime",
"vl_oc_longestDowntime",
"vl_oc_down_0_10_min",
"vl_oc_down_10_30_min",
"vl_oc_down_half_1_hr",
"vl_oc_down_1_2_hr",
"vl_oc_down_2_4_hr",
"vl_oc_down_4_8_hr",
"vl_oc_down_more_8_hr",
"vl_oc_downDst_0",
"vl_oc_downDst_1",
"vl_oc_downDst_2_5",
"vl_oc_downDst_6_10",
"vl_oc_downDst_10_50",
"vl_oc_downDst_more_50",
"FetchData_ops",		/* File Serevr RPC Operation timings */
"FetchData_ops_ok",
"FetchData_ops_sum",
"FetchData_ops_sqr",
"FetchData_ops_min",
"FetchData_ops_max",
"FetchACL_ops",
"FetchACL_ops_ok",
"FetchACL_ops_sum",
"FetchACL_ops_sqr",
"FetchACL_ops_min",
"FetchACL_ops_max",
"FetchStatus_ops",
"FetchStatus_ops_ok",
"FetchStatus_ops_sum",
"FetchStatus_ops_sqr",
"FetchStatus_ops_min",
"FetchStatus_ops_max",
"StoreData_ops",
"StoreData_ops_ok",
"StoreData_ops_sum",
"StoreData_ops_sqr",
"StoreData_ops_min",
"StoreData_ops_max",
"StoreACL_ops",
"StoreACL_ops_ok",
"StoreACL_ops_sum",
"StoreACL_ops_sqr",
"StoreACL_ops_min",
"StoreACL_ops_max",
"StoreStatus_ops",
"StoreStatus_ops_ok",
"StoreStatus_ops_sum",
"StoreStatus_ops_sqr",
"StoreStatus_ops_min",
"StoreStatus_ops_max",
"RemoveFile_ops",
"RemoveFile_ops_ok",
"RemoveFile_ops_sum",
"RemoveFile_ops_sqr",
"RemoveFile_ops_min",
"RemoveFile_ops_max",
"CreateFile_ops",
"CreateFile_ops_ok",
"CreateFile_ops_sum",
"CreateFile_ops_sqr",
"CreateFile_ops_min",
"CreateFile_ops_max",
"Rename_ops",
"Rename_ops_ok",
"Rename_ops_sum",
"Rename_ops_sqr",
"Rename_ops_min",
"Rename_ops_max",
"Symlink_ops",
"Symlink_ops_ok",
"Symlink_ops_sum",
"Symlink_ops_sqr",
"Symlink_ops_min",
"Symlink_ops_max",
"Link_ops",
"Link_ops_ok",
"Link_ops_sum",
"Link_ops_sqr",
"Link_ops_min",
"Link_ops_max",
"MakeDir_ops",
"MakeDir_ops_ok",
"MakeDir_ops_sum",
"MakeDir_ops_sqr",
"MakeDir_ops_min",
"MakeDir_ops_max",
"RemoveDir_ops",
"RemoveDir_ops_ok",
"RemoveDir_ops_sum",
"RemoveDir_ops_sqr",
"RemoveDir_ops_min",
"RemoveDir_ops_max",
"SetLock_ops",
"SetLock_ops_ok",
"SetLock_ops_sum",
"SetLock_ops_sqr",
"SetLock_ops_min",
"SetLock_ops_max",
"ExtendLock_ops",
"ExtendLock_ops_ok",
"ExtendLock_ops_sum",
"ExtendLock_ops_sqr",
"ExtendLock_ops_min",
"ExtendLock_ops_max",
"ReleaseLock_ops",
"ReleaseLock_ops_ok",
"ReleaseLock_ops_sum",
"ReleaseLock_ops_sqr",
"ReleaseLock_ops_min",
"ReleaseLock_ops_max",
"GetStatistics_ops",
"GetStatistics_ops_ok",
"GetStatistics_ops_sum",
"GetStatistics_ops_sqr",
"GetStatistics_ops_min",
"GetStatistics_ops_max",
"GiveUpCallbacks_ops",
"GiveUpCallbacks_ops_ok",
"GiveUpCallbacks_ops_sum",
"GiveUpCallbacks_ops_sqr",
"GiveUpCallbacks_ops_min",
"GiveUpCallbacks_ops_max",
"GetVolumeInfo_ops",
"GetVolumeInfo_ops_ok",
"GetVolumeInfo_ops_sum",
"GetVolumeInfo_ops_sqr",
"GetVolumeInfo_ops_min",
"GetVolumeInfo_ops_max",
"GetVolumeStatus_ops",
"GetVolumeStatus_ops_ok",
"GetVolumeStatus_ops_sum",
"GetVolumeStatus_ops_sqr",
"GetVolumeStatus_ops_min",
"GetVolumeStatus_ops_max",
"SetVolumeStatus_ops",
"SetVolumeStatus_ops_ok",
"SetVolumeStatus_ops_sum",
"SetVolumeStatus_ops_sqr",
"SetVolumeStatus_ops_min",
"SetVolumeStatus_ops_max",
"GetRootVolume_ops",
"GetRootVolume_ops_ok",
"GetRootVolume_ops_sum",
"GetRootVolume_ops_sqr",
"GetRootVolume_ops_min",
"GetRootVolume_ops_max",
"CheckToken_ops",
"CheckToken_ops_ok",
"CheckToken_ops_sum",
"CheckToken_ops_sqr",
"CheckToken_ops_min",
"CheckToken_ops_max",
"GetTime_ops",
"GetTime_ops_ok",
"GetTime_ops_sum",
"GetTime_ops_sqr",
"GetTime_ops_min",
"GetTime_ops_max",
"NGetVolumeInfo_ops",
"NGetVolumeInfo_ops_ok",
"NGetVolumeInfo_ops_sum",
"NGetVolumeInfo_ops_sqr",
"NGetVolumeInfo_ops_min",
"NGetVolumeInfo_ops_max",
"BulkStatus_ops",
"BulkStatus_ops_ok",
"BulkStatus_ops_sum",
"BulkStatus_ops_sqr",
"BulkStatus_ops_min",
"BulkStatus_ops_max",
"XStatsVersion_ops",
"XStatsVersion_ops_ok",
"XStatsVersion_ops_sum",
"XStatsVersion_ops_sqr",
"XStatsVersion_ops_min",
"XStatsVersion_ops_max",
"GetXStats_ops",
"GetXStats_ops_ok",
"GetXStats_ops_sum",
"GetXStats_ops_sqr",
"GetXStats_ops_min",
"GetXStats_ops_max",
"FetchData_srv_err", 	/* File Server RPC Error Info */
"FetchData_net_err",
"FetchData_prot_err_err",
"FetchData_vol_err",
"FetchData_busy_err",
"FetchData_other_err",
"FetchACL_srv_err",
"FetchACL_net_err",
"FetchACL_prot_err",
"FetchACL_vol_err",
"FetchACL_busy_err",
"FetchACL_other_err",
"FetchStatus_srv_err",
"FetchStatus_net_err",
"FetchStatus_prot_err",
"FetchStatus_vol_err",
"FetchStatus_busy_err",
"FetchStatus_other_err",
"StoreData_srv_err",
"StoreData_net_err",
"StoreData_prot_err",
"StoreData_vol_err",
"StoreData_busy_err",
"StoreData_other_err",
"StoreACL_srv_err",
"StoreACL_net_err",
"StoreACL_prot_err",
"StoreACL_vol_err",
"StoreACL_busy_err",
"StoreACL_other_err",
"StoreStatus_srv_err",
"StoreStatus_net_err",
"StoreStatus_prot_err",
"StoreStatus_vol_err",
"StoreStatus_busy_err",
"StoreStatus_other_err",
"RemoveFile_srv_err",
"RemoveFile_net_err",
"RemoveFile_prot_err",
"RemoveFile_vol_err",
"RemoveFile_busy_err",
"RemoveFile_other_err",
"CreateFile_srv_err",
"CreateFile_net_err",
"CreateFile_prot_err",
"CreateFile_vol_err",
"CreateFile_busy_err",
"CreateFile_other_err",
"Rename_srv_err",
"Rename_net_err",
"Rename_prot_err",
"Rename_vol_err",
"Rename_busy_err",
"Rename_other_err",
"Symlink_srv_err",
"Symlink_net_err",
"Symlink_prot_err",
"Symlink_vol_err",
"Symlink_busy_err",
"Symlink_other_err",
"Link_srv_err",
"Link_net_err",
"Link_prot_err",
"Link_vol_err",
"Link_busy_err",
"Link_other_err",
"MakeDir_srv_err",
"MakeDir_net_err",
"MakeDir_prot_err",
"MakeDir_vol_err",
"MakeDir_busy_err",
"MakeDir_other_err",
"RemoveDir_srv_err",
"RemoveDir_net_err",
"RemoveDir_prot_err",
"RemoveDir_vol_err",
"RemoveDir_busy_err",
"RemoveDir_other_err",
"SetLock_srv_err",
"SetLock_net_err",
"SetLock_prot_err",
"SetLock_vol_err",
"SetLock_busy_err",
"SetLock_other_err",
"ExtendLock_srv_err",
"ExtendLock_net_err",
"ExtendLock_prot_err",
"ExtendLock_vol_err",
"ExtendLock_busy_err",
"ExtendLock_other_err",
"ReleaseLock_srv_err",
"ReleaseLock_net_err",
"ReleaseLock_prot_err",
"ReleaseLock_vol_err",
"ReleaseLock_busy_err",
"ReleaseLock_other_err",
"GetStatistics_srv_err",
"GetStatistics_net_err",
"GetStatistics_prot_err",
"GetStatistics_vol_err",
"GetStatistics_busy_err",
"GetStatistics_other_err",
"GiveUpCallbacks_srv_err",
"GiveUpCallbacks_net_err",
"GiveUpCallbacks_prot_err",
"GiveUpCallbacks_vol_err",
"GiveUpCallbacks_busy_err",
"GiveUpCallbacks_other_err",
"GetVolumeInfo_srv_err",
"GetVolumeInfo_net_err",
"GetVolumeInfo_prot_err",
"GetVolumeInfo_vol_err",
"GetVolumeInfo_busy_err",
"GetVolumeInfo_other_err",
"GetVolumeStatus_srv_err",
"GetVolumeStatus_net_err",
"GetVolumeStatus_prot_err",
"GetVolumeStatus_vol_err",
"GetVolumeStatus_busy_err",
"GetVolumeStatus_other_err",
"SetVolumeStatus_srv_err",
"SetVolumeStatus_net_err",
"SetVolumeStatus_prot_err",
"SetVolumeStatus_vol_err",
"SetVolumeStatus_busy_err",
"SetVolumeStatus_other_err",
"GetRootVolume_srv_err",
"GetRootVolume_net_err",
"GetRootVolume_prot_err",
"GetRootVolume_vol_err",
"GetRootVolume_busy_err",
"GetRootVolume_other_err",
"CheckToken_srv_err",
"CheckToken_net_err",
"CheckToken_prot_err",
"CheckToken_vol_err",
"CheckToken_busy_err",
"CheckToken_other_err",
"GetTime_srv_err",
"GetTime_net_err",
"GetTime_prot_err",
"GetTime_vol_err",
"GetTime_busy_err",
"GetTime_other_err",
"NGetVolumeInfo_srv_err",
"NGetVolumeInfo_net_err",
"NGetVolumeInfo_prot_err",
"NGetVolumeInfo_vol_err",
"NGetVolumeInfo_busy_err",
"NGetVolumeInfo_other_err",
"BulkStatus_srv_err",
"BulkStatus_net_err",
"BulkStatus_prot_err",
"BulkStatus_vol_err",
"BulkStatus_busy_err",
"BulkStatus_other_err",
"XStatsVersion_srv_err",
"XStatsVersion_net_err",
"XStatsVersion_prot_err",
"XStatsVersion_vol_err",
"XStatsVersion_busy_err",
"XStatsVersion_other_err",
"GetXStats_srv_err",
"GetXStats_net_err",
"GetXStats_prot_err",
"GetXStats_vol_err",
"GetXStats_busy_err",
"GetXStats_other_err",
"FetchData_xfers", 	/* File Server RPC Transfer timings */
"FetchData_xfers_ok",
"FetchData_xfers_sum",
"FetchData_xfers_sqr",
"FetchData_xfers_min",
"FetchData_xfers_max",
"FetchData_Kbytes_sum",
"FetchData_bytes_min",
"FetchData_bytes_max",
"FetchData_bytes_bucket0",
"FetchData_bytes_bucket1",
"FetchData_bytes_bucket2",
"FetchData_bytes_bucket3",
"FetchData_bytes_bucket4",
"FetchData_bytes_bucket5",
"FetchData_bytes_bucket6",
"FetchData_bytes_bucket7",
"FetchData_bytes_bucket8",
"StoreData_xfers",
"StoreData_xfers_ok",
"StoreData_xfers_sum",
"StoreData_xfers_sqr",
"StoreData_xfers_min",
"StoreData_xfers_max",
"StoreData_Kbytes_sum",
"StoreData_bytes_min",
"StoreData_bytes_max",
"StoreData_bytes_bucket0",
"StoreData_bytes_bucket1",
"StoreData_bytes_bucket2",
"StoreData_bytes_bucket3",
"StoreData_bytes_bucket4",
"StoreData_bytes_bucket5",
"StoreData_bytes_bucket6",
"StoreData_bytes_bucket7",
"StoreData_bytes_bucket8",
"CallBack_ops", 		/* Cache Manager RPC Operation Timings */
"CallBack_ops_ok",
"CallBack_ops_sum",
"CallBack_ops_sqr",
"CallBack_ops_min",
"CallBack_ops_max",
"InitCallBackState_ops",
"InitCallBackState_ops_ok",
"InitCallBackState_ops_sum",
"InitCallBackState_ops_sqr",
"InitCallBackState_ops_min",
"InitCallBackState_ops_max",
"Probe_ops",
"Probe_ops_ok",
"Probe_ops_sum",
"Probe_ops_sqr",
"Probe_ops_min",
"Probe_ops_max",
"GetLock_ops",
"GetLock_ops_ok",
"GetLock_ops_sum",
"GetLock_ops_sqr",
"GetLock_ops_min",
"GetLock_ops_max",
"GetCE_ops",
"GetCE_ops_ok",
"GetCE_ops_sum",
"GetCE_ops_sqr",
"GetCE_ops_min",
"GetCE_ops_max",
"XStatsVersion_CM_ops",
"XStatsVersion_CM_ops_ok",
"XStatsVersion_CM_ops_sum",
"XStatsVersion_CM_ops_sqr",
"XStatsVersion_CM_ops_min",
"XStatsVersion_CM_ops_max",
"GetXStats_CM_ops",
"GetXStats_CM_ops_ok",
"GetXStats_CM_ops_sum",
"GetXStats_CM_ops_sqr",
"GetXStats_CM_ops_min",
"GetXStats_CM_ops_max",
"curr_PAGs", 		/* Authentication information for CM */
"curr_Records",
"curr_AuthRecords",
"curr_UnauthRecords",
"curr_MaxRecordsInPAG",
"curr_LongestChain",
"PAGCreations",
"TicketUpdates",
"HWM_PAGS",
"HWM_Records",
"HWM_MaxRecordsInPAG",
"HWM_LongestChain",
"unreplicatedRefs", 	/* [Un]replicated file accesses: */
"replicatedRefs",
"numReplicasAccessed",
"maxReplicasPerRef",
"refFirstReplicaOK"
};


/* Cache Manager data classification */
/* Data is classified into sections and each section into one or more
groups. The integer after a section name specifies the number of groups
contained in it. The integers after a group name specify the starting and
ending positional indices to fs_varNames[]. Unimportant information
is placed at the end of the section. */

char *cm_categories[] = {
"PerfStats_section 2",
"PerfStats_group 4 39",
"misc_group 0 3",
"Server_UpDown_section 4",
"FS_upDown_SC_group 40 64",
"FS_upDown_DC_group 65 89",
"VL_upDown_SC_group 90 114",
"VL_upDown_DC_group 115 139",
"RPCop_section 4",
"FS_RPCopTimes_group 140 307",
"FS_RPCopErrors_group 308 475",
"FS_RPCopBytes_group 476 511",
"CM_RPCopTimes_group 512 553",
"Auth_Access_section 2",
"Auth_Stats_group 554 565",
"Access_Stats_group 566 570"
/* "Author_Stats_group x y"   -   no information collected at present */
};
