package WordList::ZH::HSK5;

our $DATE = '2016-02-04'; # DATE
our $VERSION = '0.01'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("shortest_word_len",1,"num_words_contains_nonword_chars",0,"avg_word_len",1.88837567359507,"longest_word_len",4,"num_words_contains_whitespace",0,"num_words",1299,"num_words_contains_unicode",1299); # STATS

1;
# ABSTRACT: HSK (level 5 only) words

=pod

=encoding UTF-8

=head1 NAME

WordList::ZH::HSK5 - HSK (level 5 only) words

=head1 VERSION

This document describes version 0.01 of WordList::ZH::HSK5 (from Perl distribution WordList-ZH-HSK), released on 2016-02-04.

=head1 SYNOPSIS

 use WordList::ZH::HSK5;

 my $wl = WordList::ZH::HSK5->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

=head1 STATISTICS

 +----------------------------------+------------------+
 | key                              | value            |
 +----------------------------------+------------------+
 | avg_word_len                     | 1.88837567359507 |
 | longest_word_len                 | 4                |
 | num_words                        | 1299             |
 | num_words_contains_nonword_chars | 0                |
 | num_words_contains_unicode       | 1299             |
 | num_words_contains_whitespace    | 0                |
 | shortest_word_len                | 1                |
 +----------------------------------+------------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-ZH-HSK>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-ZH-HSK>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-ZH-HSK>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<WordList::ZH::HSK>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
一再
一律
一旦
一致
一辈子
万一
上当
下载
不如
不安
不得了
不断
不然
不耐烦
不要紧
不见得
不足
与其
丑
专家
专心
业余
业务
丝毫
丝绸
严肃
个人
个别
个性
中介
中心
中旬
临时
主人
主任
主动
主席
主张
主持
主观
主题
义务
乐器
乐观
乖
乙
书架
了不起
争取
争论
事先
事实
事物
交往
交换
交际
产品
产生
享受
亮
亲切
亲爱
亲自
人事
人口
人员
人才
人民币
人物
人生
人类
亿
从事
从前
从此
从而
代替
代表
以及
以来
价值
仿佛
企业
休闲
优势
优惠
优美
伙伴
会计
伟大
传播
传染
传统
传说
伤害
伸
似乎
似的
位于
位置
体会
体现
体贴
体验
何况
何必
作为
作品
作文
佩服
使劲儿
依然
便
促使
促进
保存
保持
保留
保险
信任
信号
修改
俱乐部
倒霉
借口
假如
假装
假设
健身
偶然
偷
傍晚
催
傻
元旦
兄弟
充分
充满
充电器
光临
光明
光滑
光盘
克
克服
兑换
兔子
全面
公主
公元
公寓
公布
公平
公开
关闭
其余
具体
具备
兼职
内科
内部
册
再三
冒险
写作
军事
农业
农村
农民
冠军
冰激凌
冲
决心
决赛
冷淡
冻
凭
出口
出席
出版
出示
出色
分别
分布
分手
分析
分配
切
划
列车
则
创造
初级
删除
利息
利润
利用
利益
到达
制作
制定
制度
制造
刺激
刻苦
前途
剪刀
力量
劝
办理
功能
动画片
劳动
劳驾
勇气
勤奋
勿
包含
包括
包裹
匆忙
化学
匹
升
华裔
单位
单元
单独
单纯
单调
博物馆
占
卡车
卧室
印刷
危害
厘米
原则
原料
去世
县
参与
参考
叉子
及格
双方
反复
反应
反映
反正
反而
发愁
发抖
发挥
发明
发票
发表
发言
发达
取消
受伤
叙述
口味
古代
古典
召开
可怕
可见
可靠
台阶
吃亏
各自
合作
合同
合影
合法
合理
名片
名牌
名胜古迹
后果
后背
吐
吓
否定
否认
吨
启发
吵
吵架
吸取
吸收
吹
吻
呆
告别
员工
周到
呼吸
命令
命运
和平
咨询
咬
哈
哪怕
哲学
唉
唯一
商业
商务
商品
善于
善良
喊
嗓子
嗯
嘉宾
因素
因而
团
围巾
围绕
固定
国庆节
国王
圆
圈
土地
土豆
在乎
在于
地位
地区
地毯
地理
地道
地震
均匀
坚决
坚强
坦率
培养
培训
基本
堆
墙
士兵
声调
壶
处理
复制
夏令营
外交
外公
多亏
多余
夜
大厦
大型
大方
大象
天真
天空
太太
太极拳
失业
失去
失眠
夸
夸张
夹子
奇迹
奋斗
套
女士
好奇
好客
如今
如何
妇女
妨碍
始终
姑姑
姑娘
委屈
姥姥
姿势
威胁
娱乐
娶
婚姻
婚礼
媒体
嫁
嫩
字幕
字母
存在
孝顺
学历
学术
学问
宁可
安慰
安装
完善
完整
完美
官
宝贝
宝贵
实习
实现
实用
实话
实践
实验
宠物
客观
宣传
宣布
宴会
家乡
家务
家庭
宽
宿舍
寂寞
密切
对待
对手
对方
对比
对象
寻找
导演
导致
寿命
射击
尊敬
小气
小麦
尺子
尽力
尽快
尽量
尾巴
居然
届
屋子
展开
展览
属于
岛屿
岸
工业
工人
工具
工厂
工程师
巧妙
巨大
差距
市场
布
常识
幅
干活儿
干燥
干脆
平
平均
平安
平常
平方
平等
平衡
平静
年代
年纪
幸亏
幸运
幻想
幼儿园
广场
广大
广泛
庆祝
应付
应用
废话
度过
延长
建立
建筑
建设
开发
开幕式
开放
开水
弱
强烈
强调
归纳
当地
当心
录取
录音
形势
形容
形式
形成
形状
形象
彩虹
影子
彻底
彼此
往返
征求
待遇
微笑
心理
心脏
必然
必要
忍不住
志愿者
念
忽然
忽视
怀孕
怀念
思想
思考
急忙
急诊
性质
怪不得
总之
总共
总理
总算
总统
总裁
恋爱
恢复
恨
恭喜
恶劣
悄悄
悠久
悲观
情景
情绪
惭愧
想念
想象
意义
意外
感受
感想
感激
愿望
慌张
戏剧
成人
成分
成就
成果
成熟
成立
成语
成长
戒
戒指
或许
战争
所
扇子
手套
手工
手指
手术
手续
打交道
打听
打喷嚏
打工
执照
扩大
扶
批
批准
承受
承担
承认
抄
把握
抓
抓紧
投入
投资
抢
报到
报告
报社
报道
披
抱怨
押金
抽屉
抽象
担任
拆
拍
拐弯
招待
拥抱
拥挤
拦
拼音
持续
挂号
指导
指挥
挑战
挡
挣
挥
振动
捐
损失
捡
据说
掌握
接待
接触
接近
控制
推广
推荐
推辞
措施
描写
提倡
提纲
提问
插
握手
搜索
搞
摄影
摆
摇
摔倒
摘
摩托车
摸
撕
撞
播放
操场
操心
支
支票
收据
收获
改善
改正
改进
改革
政府
政治
效率
敌人
敏感
救
救护车
教材
教练
教训
数
数据
数码
整个
整体
整齐
文件
文具
文字
文学
文明
斜
断
方
方式
方案
无奈
无所谓
无数
日历
日子
日常
日期
日用品
日程
时代
时刻
时尚
时差
时期
时髦
昆虫
明星
明显
明确
显得
显然
显示
晒
晕
智慧
暗
曾经
最初
有利
服装
朗读
朝
期待
期间
木头
未必
未来
本科
本质
本领
朵
机器
杀
权利
权力
极其
构成
果实
果然
枪
某
柜台
标志
标点
样式
核心
根
根本
格外
桃
桔子
梦想
梨
梳子
概念
概括
模仿
模特
模糊
欠
次要
欣赏
欧洲
歇
正
此外
步骤
武术
歪
比例
毕竟
毛病
气氛
汇率
池塘
汽油
沉默
沙滩
沙漠
沟通
油炸
治疗
法院
注册
洒
洞
活跃
派
流传
流泪
浅
浇
测验
浏览
浓
海关
海鲜
消化
消失
消极
消费
涨
淘气
淡
深刻
清淡
温暖
温柔
游览
湿润
滑
滚
满足
滴
漏
演讲
潮湿
激烈
火柴
灰
灰尘
灰心
灵活
灾害
炒
点心
烂
烫
热心
热烈
热爱
煤炭
照常
煮
熟练
熬夜
燃烧
爱心
爱惜
爱护
片
片面
牙齿
牛仔裤
物理
物质
特征
特殊
特色
状况
状态
犹豫
狡猾
独特
独立
狮子
猪
猴子
玉米
王子
玩具
现代
现实
现象
玻璃
珍惜
球迷
理由
理论
生产
生动
生长
用功
用途
甩
甲
电台
电池
疑问
疯狂
疲劳
疼爱
病毒
痒
痛快
痛苦
登记
的确
盆
盖
目前
目录
目标
直
相似
相关
相处
相对
相当
盼望
省略
眉毛
看不起
看望
真实
着凉
着火
睁
瞎
瞧
矛盾
石头
砍
破产
破坏
硬
硬件
确定
确认
碎
碰
祝福
神秘
神话
离婚
私人
种类
秘书
秘密
秩序
称
称呼
称赞
移动
移民
程序
程度
税
稳定
空闲
空间
突出
窄
窗帘
立刻
立即
竹子
等于
等待
答应
签
简历
简直
管子
类型
粗糙
粘贴
粮食
精力
精神
糊涂
糟糕
系
系统
系领带
紧急
紫
繁荣
纪录
纪律
纪念
纷纷
组
组合
组成
组织
细节
经典
经商
经营
结合
结实
结构
结论
结账
绕
绝对
统一
绳子
维修
综合
缓解
编辑
缩短
缺乏
网络
罚款
美术
群
翅膀
翻
老婆
老实
老板
老百姓
老鼠
耳环
耽误
联合
肌肉
股票
肥皂
肩膀
胃
胃口
胆小鬼
背
背景
胜利
胡同
胡说
胶水
胸
能干
能源
脑袋
脖子
腰
自从
自动
自愿
自由
自私
自觉
自豪
臭
至于
至今
舅舅
舍不得
舒适
良好
艰巨
艰苦
色彩
节省
花生
苗条
英俊
英雄
范围
营业
营养
落后
蔬菜
薄
虚心
蛇
蜜蜂
蝴蝶
血
行业
行为
行人
行动
补充
表情
表明
表现
表达
表面
被子
装
装修
装饰
要不
观察
观念
观点
规则
规律
规模
规矩
角度
角色
计算
讨价还价
训练
议论
记录
记忆
讲座
讲究
论文
讽刺
设备
设施
设计
证件
证据
评价
诊断
词汇
试卷
诗
诚恳
话题
询问
语气
说不定
说服
请求
课程
调整
调皮
谈判
谦虚
谨慎
豆腐
象征
象棋
豪华
贡献
财产
责备
账户
贷款
贸易
资料
资格
资源
资金
赔偿
赞成
赞美
赶快
赶紧
趁
超级
趋势
踩
蹲
身份
身材
躲藏
车厢
车库
转变
转告
轮流
软
软件
轻易
轻视
辅导
输入
辞职
辣椒
辩论
达到
迅速
过分
过敏
过期
迎接
运气
运用
运输
近代
进口
进步
违反
连忙
连续
迟早
迫切
追
追求
退
退休
退步
逃
逃避
透明
逐步
逐渐
递
逗
通常
造成
逻辑
道德
道理
遗憾
遵守
避免
部门
配合
酒吧
酱油
醉
醋
采取
采访
重复
重大
重量
金属
针对
钓
钢铁
铃
银
销售
锁
锅
键盘
长辈
长途
闪电
问候
闯
闻
阳台
阵
阶段
阻止
陆地
陆续
陌生
限制
除夕
除非
随手
随时
随身
隔壁
难免
难怪
集中
集体
集合
零件
零食
雷
雾
青
青少年
青春
非
靠
面临
面对
面积
鞭炮
顶
项
项目
项链
顿
预报
预订
预防
领域
领导
频道
颗
题目
风俗
风景
风格
风险
飘
食物
馒头
首
香肠
驾驶
骂
骨头
高档
高级
魅力
鲜艳
麦克风
黄金
鼓掌
鼓舞
鼠标
龙
