# ABSTRACT: A distributed database system
use warnings;
use strict;

package Prophet;
{
  $Prophet::VERSION = '0.751';
}

1;

__END__

=pod

=head1 NAME

Prophet - A distributed database system

=head1 VERSION

version 0.751

=head1 DESCRIPTION

Prophet is a distributed database system designed for small to medium scale
social database applications.  Our early targets include things such as bug
tracking.

=head2 Design goals

=over 4

=item *

Arbitrary record schema

=item *

Replication

=item *

Disconnected operation

=item *

Peer to peer synchronization

=back

=head2 Design constraints

=over

=item Scaling

We don't currently intend for the first implementation of Prophet to scale to
databases with millions of rows or hundreds of concurrent users. There's
nothing that makes the design infeasible, but the infrastructure necessary for
such a system will...needlessly hamstring it.

=back

=head1 AUTHORS

=over 4

=item *

Jesse Vincent <jesse@bestpractical.com>

=item *

Chia-Liang Kao <clkao@bestpractical.com>

=item *

Christine Spang <christine@spang.cc>

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2009 by Best Practical Solutions.

This is free software, licensed under:

  The MIT (X11) License

=head1 BUGS AND LIMITATIONS

You can make new bug reports, and view existing ones, through the
web interface at L<https://rt.cpan.org/Public/Dist/Display.html?Name=Prophet>.

=head1 CONTRIBUTORS

=over 4

=item *

Alex Vandiver <alexmv@bestpractical.com>

=item *

Casey West <casey@geeknest.com>

=item *

Cyril Brulebois <kibi@debian.org>

=item *

Florian Ragwitz <rafl@debian.org>

=item *

Ioan Rogers <ioanr@cpan.org>

=item *

Jonas Smedegaard <dr@jones.dk>

=item *

Kevin Falcone <falcone@bestpractical.com>

=item *

Lance Wicks <lw@judocoach.com>

=item *

Nelson Elhage <nelhage@mit.edu>

=item *

Pedro Melo <melo@simplicidade.org>

=item *

Rob Hoelz <rob@hoelz.ro>

=item *

Ruslan Zakirov <ruz@bestpractical.com>

=item *

Shawn M Moore <sartak@bestpractical.com>

=item *

Simon Wistow <simon@thegestalt.org>

=item *

Stephane Alnet <stephane@shimaore.net>

=item *

Unknown user <nobody@localhost>

=item *

Yanick Champoux <yanick@babyl.dyndns.org>

=item *

franck cuny <franck@lumberjaph.net>

=item *

robertkrimen <robertkrimen@gmail.com>

=item *

sunnavy <sunnavy@bestpractical.com>

=back

=cut
