
use strict;
use warnings;

use ExtUtils::MakeMaker;
use File::ShareDir::Install;

if ( -d 'share' ) {
  install_share 'share';
}

WriteMakefile(
    NAME           => 'Amazon::API',
    AUTHOR         => 'Rob Lauer <rlauer6@comcast.net>',
    VERSION_FROM   => 'lib/Amazon/API.pm',
    ABSTRACT       => 'AWS API base class',
    LICENSE        => 'perl',
    PL_FILES       => {},
    EXE_FILES      =>     []
,
    PREREQ_PM      => {
      'AWS::Signature4' => '1.02',
      'Amazon::Credentials' => '1.0.19',
      'Carp' => '1.26',
      'Class::Accessor' => '0.31',
      'Class::Accessor::Fast' => '0.31',
      'Data::Dumper' => '2.145',
      'Date::Format' => '2.24',
      'English' => '1.05',
      'HTTP::Request' => '6.00',
      'JSON::PP' => '2.97001',
      'LWP::UserAgent' => '6.36',
      'Scalar::Util' => '1.5',
      'Time::Local' => '1.2300',
      'XML::LibXML::Simple' => '1.01',
      'constant' => '1.33',
      'parent' => '0.225',
      'strict' => '1.07',
      'warnings' => '1.13'
    },
    TEST_REQUIRES  =>     {}
,
    META_MERGE =>     {
      "meta-spec"=>{
                       "version"=>2
                     },
      "provides"=>{
                      "Amazon::API"=>{
                                         "file"=>"lib/Amazon/API.pm",
                                         "version"=>"1.2.0"
                                       },
                      "Amazon::API::Error"=>{
                                                "file"=>"lib/Amazon/API/Error.pm",
                                                "version"=>"1.2.0"
                                              },
                      "Amazon::API::Signature4"=>{
                                                     "file"=>"lib/Amazon/API/Signature4.pm",
                                                     "version"=>"1.2.0"
                                                   }
                    },
      "resources"=>{
                       "bugtracker"=>{
                                         "mailto"=>"rlauer6\@comcast.net",
                                         "web"=>"http://github.com/rlauer6/perl-Amazon-API/issues"
                                       },
                       "homepage"=>"http://github.com/rlauer6/perl-Amazon-API",
                       "repository"=>{
                                         "type"=>"git",
                                         "url"=>"git://github.com/rlauer6/perl-Amazon-API.git",
                                         "web"=>"http://github.com/rlauer6/perl-Amazon-API"
                                       }
                     }
    }

);

package MY;

use File::ShareDir::Install qw( postamble );

