#!/usr/bin/perl -w

use warnings;
use strict;

####################################################################################
####################################################################################
##									
##  This is a working demonstration of how to use DBIx::XML::DataLoader  		
##									
##  This script demonstrates how to use the dbmode sqlloader (ie. dbmode=>"sqloader") 
##  This will create a data suitable for printing to a DAT file for the Oracle
##  application sqlldr
##  
## we expect upto five items in the response hash when we processxml
## {message} is the normal message output
## {dbmessage} is the information generated by the db module
## {suberrors} is the responses generated from any handlers that where run
## {dberrors} is any errors generated by the db module
## {sqlload} is returned when dbmode=sqlloader
##
####################################################################################
####################################################################################
####################################################################################


use DBIx::XML::DataLoader;
$| = 1;

####################################################################################
####################################################################################
####  Here the map and any db setting we want are passed to new and a new object is
####  returned
####################################################################################

my $mapper=DBIx::XML::DataLoader->new(dbmode=>"insert", dbprint=>"dbandprint", map=>"./maps/map1.xml");



#########
####	here I  read the contents of a directory
####	and the pass the xml docs found onto processxml
####	You could easily modify this to process just one 
####	xml document.
#############################################################

my (undef, $response)=$mapper->processxml(xml=>"./xml/people.xml");



################################################################################
################################################################################
####	here I am writting DAT files for sqlloader	
####	using the values returned in $response->{sqlload}
###############################################################################
##############################################################################

if($response !~ /HASH/){warn $!;}
# I just comment this out but the below shows how you
## can create a sqlloader file for Oracle
## just remove the if statement below and
## change dbmode to sqlloader
if(10 > 20){
my @sqlload=@{$response->{sqlload}};
LOAD: for my $load (@sqlload){
TABLE: for my $table (keys %{$load}){
if(!(stat("$table.DAT"))[0]){
open(DAT, ">$table.DAT")||die "could not open $table.DAT";
print DAT "
-- sqlldr control file created dynamically
		load data
		INFILE * 
		INTO TABLE $table\n";
		print DAT "FIELDS TERMINATED BY '::'\n"; 
		print DAT "(".(join ",\n", @{$load->{$table}->{cols}}).")\n";
		print DAT "\n\nBEGINDATA\n";
		close(DAT);
	} # end if table.DAT
	open(DAT, ">>$table.DAT");
	print DAT $load->{$table}->{values};
	close DAT;
	
} # end TABLE
} # end LOAD
} # end if

########################################################################
########################################################################
####								
####	 below I am printing select values in $response to the terminal
####
########################################################################

print $response->{message},"\n";
if($response->{dbmessage}){
print "Message from db.pm was:\n";
print $response->{dbmessage},"\n";}
if($response->{suberrors}){print "Sub Routine Error:", $response->{suberrors},"\n";}
if($response->{dberrors}){print "DB Error:", $response->{dberrors},"\n";}

if((!$response->{dberrors}) and (!$response->{suberrors})){
print "There were no errors generated from the database or the subroutines called by the map file\n"
."________________________________________________________________________________________________\n".
"\n\n";
}



__END__

