package Daje::Database::Model::Login;
use Mojo::Base 'Daje::Database::Model::Super::Users', -base, -signatures, -async_await;

# Autogenerated class Sun Feb  9 13:11:20 2025
# This class is generated once. Any over rides or special methods should be put here

# NAME
# ====
#
#      Daje::Database::Model::Login - It's the login class for users
#
#
# REQUIRES
# ========
#
# use Mojo::Base;
# use Daje::Database::Model::Super::Users;
#
# DESCRIPTION
# ===========
#
# Daje::Database::Model::Login is logging in users
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#
#

use Data::Dumper;
use Digest::SHA qw{sha512_base64};

our $VERSION = "0.01";

has 'pg';

sub login ($self, $userid, $password) {

    my $login_stmt = qq{
        SELECT users_pkey, userid, username, is_admin, companies_pkey, name,
            password, support
            FROM users, companies, companies_users
           WHERE companies_pkey = companies_fkey AND users_pkey = users_fkey
            AND userid = ? AND password = ? AND active = 1
    };


    my $result = $self->pg->db->query($login_stmt,($userid, $password));

    my $hash;
    $hash = $result->hash if $result->rows;
    say "Login " . Dumper($hash);
    return $hash;
}

sub check_creds ($self, $userid, $password) {

    my $check_stmt = qq{
        SELECT count(*) as exists
            FROM users, companies, users_companies
           WHERE companies_pkey = companies_fkey AND users_pkey = users_fkey
            AND userid = ? AND passwd = ? AND active = 1
    };

    my $result = $self->pg->db->query(
        $check_stmt,($userid, $password)
    )->hash->{exists};

    return $result;
}




1;


#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Database::Model::Login


=head1 DESCRIPTION

Autogenerated class Sun Feb  9 13:11:20 2025
This class is generated once. Any over rides or special methods should be put here


=head1 REQUIRES

L<Digest::SHA> 

L<Data::Dumper> 

L<Mojo::Base> 


=head1 METHODS

=head2 check_creds

 check_creds();

=head2 login

 login();


=cut

