use Test::More;
use Merge::CodeBlock ( unique_array => 1 );

my $one = 10;
my $two = 20;
my $three = 30;
my @sort = sort { $b <=> $a } $one, $two, $three;

my $highest = merge { $b <=> $a } $one, $two, $three;
is($highest, 30);
my $lowest = merge { $a <=> $b } $one, $two, $three;
is($lowest, 10);

my $array1 = [10, 20, 30];
my $array2 = [10, 20, 40];

my $m = merge {} $array1, $array2;
is_deeply($m, [10, 20, 30, 40]);

my $hash1 = { a => 10, b => 20, c => 30 };
my $hash2 = { a => 40, b => 20, d => 50 };

$m = merge { $a->{a} <=> $b->{a} } $hash1, $hash2;
is_deeply($m, { a => 10, b => 20, c => 30, d => 50 });

$m = merge { $b->{a} <=> $a->{a} } $hash1, $hash2;
is_deeply($m, { a => 40, b => 20, c => 30, d => 50 });

my $s1 = { a => 10, b => 20, c => 30, array => [30] };
my $s2 = { a => 40, b => 20, d => 50, array => [20] };
my $s3 = { a => 50, b => 20, d => 50, array => [10] };

$m = merge { $a->{a} <=> $b->{a} } $s1, $s2, $s3;

is_deeply($m, { a => 10, b => 20, c => 30, d => 50, array => [30, 10, 20] });

$m = merge { $b->{a} <=> $a->{a} } $s1, $s2, $s3;
is_deeply($m, { a => 50, b => 20, c => 30, d => 50, array => [10, 20, 30] });

done_testing();
