# This file was autogenerated.

=head1 NAME

hydrogen-curry-counter.t - unit tests for Hydrogen::Curry::Counter

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

=cut

use 5.008001;
use strict;
use warnings;
use Test2::V0 -target => "Hydrogen::Curry::Counter";

isa_ok( 'Hydrogen::Curry::Counter', 'Exporter::Tiny' );

my %EXPORTS = map +( $_ => 1 ), @Hydrogen::Curry::Counter::EXPORT_OK;

subtest 'curry_dec' => sub {
    ok exists(&Hydrogen::Curry::Counter::curry_dec), 'function exists';
    ok $EXPORTS{'curry_dec'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Counter::curry_dec( 0 );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_dec';
};

subtest 'curry_inc' => sub {
    ok exists(&Hydrogen::Curry::Counter::curry_inc), 'function exists';
    ok $EXPORTS{'curry_inc'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Counter::curry_inc( 0 );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_inc';
};

subtest 'curry_reset' => sub {
    ok exists(&Hydrogen::Curry::Counter::curry_reset), 'function exists';
    ok $EXPORTS{'curry_reset'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Counter::curry_reset( 0 );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_reset';
};

subtest 'curry_set' => sub {
    ok exists(&Hydrogen::Curry::Counter::curry_set), 'function exists';
    ok $EXPORTS{'curry_set'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Counter::curry_set( 0 );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_set';
};

done_testing; # :)
