package Dist::Zilla::Plugin::DualLife;
BEGIN {
  $Dist::Zilla::Plugin::DualLife::AUTHORITY = 'cpan:FLORA';
}
BEGIN {
  $Dist::Zilla::Plugin::DualLife::VERSION = '0.01';
}
# ABSTRACT: Distribute dual-life modules with Dist::Zilla

use Moose;
use List::AllUtils 'first';
use namespace::autoclean;

with 'Dist::Zilla::Role::InstallTool';


sub setup_installer {
    my ($self) = @_;

    my $makefile = first { $_->name eq 'Makefile.PL' } @{ $self->zilla->files };
    $self->log_fatal('No Makefile.PL. It needs to be provided by another plugin')
        unless $makefile;

    my $content = $makefile->content;

    my $dual_life_args = <<'EOC';
$WriteMakefileArgs{INSTALLDIRS} = 'perl'
    if $] >= 5.009005 && $] <= 5.011000;

EOC

    $content =~ s/(?=WriteMakefile\s*\()/$dual_life_args/
        or $self->log_fatal('Failed to insert INSTALLDIRS magic');

    $makefile->content($content);
}

__PACKAGE__->meta->make_immutable;

1;

__END__
=pod

=encoding utf-8

=head1 NAME

Dist::Zilla::Plugin::DualLife - Distribute dual-life modules with Dist::Zilla

=head1 SYNOPSIS

In your dist.ini:

  [DualLife]

=head1 DESCRIPTION

Dual-life modules, which are modules distributed both as part of the perl core
and on CPAN, sometimes need a little special treatment. This module tries
provide that for modules built with C<Dist::Zilla>.

Currently the only thing this module does is providing an C<INSTALLDIRS> option
to C<ExtUtils::MakeMaker>'s C<WriteMakefile> function, so dual-life modules will
be installed in the right section of C<@INC> depending on different versions of
perl.

As more things that need special handling for dual-life modules show up, this
module will try to address them as well.

The options added to your C<Makefile.PL> by this module are roughly equivalent
to:

    'INSTALLDIRS' => ($] >= 5.009005 && $] <= 5.011000 ? 'perl' : 'site'),

=head1 ACHTUNG!

=over 4

=item *

This module is a really B<gross> hack

To do the things it does properly, C<Dist::Zilla>'s C<MakeMaker> plugin would
first have to be reworked a lot. If and whenever that happens, this module will
be adapted accordingly and maybe stop being so horribly wrong.

=item *

Only C<ExtUtils::MakeMaker> is supported

If you decide to use an install tool other than C<ExtUtils::MakeMaker>, this
module will C<NOT> work. However, that's only because I happen to use
C<ExtUtils::MakeMaker> only. If you prefer using C<Module::Build> or something
else instead and want to use this plugin with it, I'd be very to apply patches
to make it work with those other install tools.

=item *

Only works with C<Makefile.PL>s generated by C<Dist::Zilla::Plugin::MakeMaker>

This module rewrites the contents of an existing C<Makefile.PL> to insert
additional options. The heuristics it currently uses for that depend on the
conventions currently used in C<Makefile.PL>s generated with
C<Dist::Zilla::Plugin::MakeMaker>. If those change, this module will
break. However, I'll do my best to update this plugin if that ever happens.

Hopefully we'll have a more extensible C<MakeMaker> plugin at some point, so all
these issues will go away.

=back

=for Pod::Coverage setup_installer

=head1 AUTHOR

Florian Ragwitz <rafl@debian.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2010 by Florian Ragwitz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

