#!/usr/bin/perl -w

BEGIN { unshift @INC, 'lib', '../lib'}
use Chart::Mountain;
use File::Temp 0.19;
my $samples = File::Temp->newdir();

print "1..1\n";

my $obj = new Chart::Mountain( 500, 400 );
my @data = (
    [
        '2006-06-01', '2006-06-02', '2006-06-03', '2006-06-04', '2006-06-05', '2006-06-06', '2006-06-07', '2006-06-08',
        '2006-06-09', '2006-06-10', '2006-06-11', '2006-06-12', '2006-06-13', '2006-06-14', '2006-06-15', '2006-06-16',
        '2006-06-17', '2006-06-18', '2006-06-19', '2006-06-20', '2006-06-21', '2006-06-22', '2006-06-23', '2006-06-24',
        '2006-06-25', '2006-06-26', '2006-06-27', '2006-06-28', '2006-06-29', '2006-06-30', '2006-07-01', '2006-07-02',
        '2006-07-03', '2006-07-04', '2006-07-05', '2006-07-06', '2006-07-07', '2006-07-08', '2006-07-09', '2006-07-10',
        '2006-07-11', '2006-07-12', '2006-07-13', '2006-07-14', '2006-07-15', '2006-07-16', '2006-07-17', '2006-07-18',
        '2006-07-19', '2006-07-20', '2006-07-21', '2006-07-22', '2006-07-23', '2006-07-24', '2006-07-25', '2006-07-26',
        '2006-07-27', '2006-07-28', '2006-07-29', '2006-07-30', '2006-07-31', '2006-08-01', '2006-08-02', '2006-08-03',
        '2006-08-04', '2006-08-05', '2006-08-06', '2006-08-07', '2006-08-08', '2006-08-09', '2006-08-10', '2006-08-11',
        '2006-08-12', '2006-08-13', '2006-08-14', '2006-08-15', '2006-08-16', '2006-08-17', '2006-08-18', '2006-08-19',
        '2006-08-20', '2006-08-21', '2006-08-22', '2006-08-23', '2006-08-24', '2006-08-25', '2006-08-26', '2006-08-27',
        '2006-08-28', '2006-08-29', '2006-08-30', '2006-08-31'
    ],
    [
        900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900,
        900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900,
        900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900,
        900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900,
        900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900, 900
    ],
    [
        150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 170, 170, 170, 170, 170, 170, 170, 170, 170, 170,
        180, 180, 180, 180, 180, 180, 180, 180, 180, 180, 190, 190, 190, 190, 190, 190, 190, 190, 190, 190,
        200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220,
        230, 300, 300, 300, 300, 300, 300, 300, 300, 300, 300, 320, 320, 320, 320, 320, 320, 320, 320, 320,
        320, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 350
    ],
    [
        10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
        20, 20, 20, 20, 20, 20, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
        25, 25, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 31,
        31, 31, 31, 31, 31, 31, 31, 31, 31, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 37
    ],
    [
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3,
        3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7, 7, 7,
        7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10
    ]
);

my @labels = ( 'NOT RUN', 'PASS', 'FAIL', 'OTHER' );

$obj->set(
    'precision'    => 0,
    'max_y_ticks'  => 10,
    'max_x_ticks'  => 10,
    'skip_x_ticks' => 5,
    'x_ticks'      => 'vertical',
    'x_label'      => 'Date',
    'y_label'      => 'Cumulative Results',
    'colors'       => {

        # not run: f2e5af
        'dataset0' => [ 0xf2, 0xe5, 0xaf ],

        # pass: a6f2a7
        'dataset1' => [ 0xa6, 0xf2, 0xa7 ],

        # fail: e8b2b2
        'dataset2' => [ 0xe8, 0xb2, 0xb2 ],

        # other: bcdaeb
        'dataset3' => [ 0xbc, 0xda, 0xeb ]
    },
    'legend_labels'   => \@labels,
    'grey_background' => 0,
);

$obj->png( "$samples/mountain_3.png", \@data );

print "ok 1\n";
exit(0);
