# Generated by default/object.tt
package Paws::AppConfig::HostedConfigurationVersionSummary;
  use Moose;
  has ApplicationId => (is => 'ro', isa => 'Str');
  has ConfigurationProfileId => (is => 'ro', isa => 'Str');
  has ContentType => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has VersionNumber => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppConfig::HostedConfigurationVersionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppConfig::HostedConfigurationVersionSummary object:

  $service_obj->Method(Att1 => { ApplicationId => $value, ..., VersionNumber => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppConfig::HostedConfigurationVersionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ApplicationId

=head1 DESCRIPTION

Information about the configuration.

=head1 ATTRIBUTES


=head2 ApplicationId => Str

The application ID.


=head2 ConfigurationProfileId => Str

The configuration profile ID.


=head2 ContentType => Str

A standard MIME type describing the format of the configuration
content. For more information, see Content-Type
(https://docs.aws.amazon.com/https:/www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).


=head2 Description => Str

A description of the configuration.


=head2 VersionNumber => Int

The configuration version.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppConfig>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

