# Generated by default/object.tt
package Paws::ApplicationAutoScaling::TargetTrackingScalingPolicyConfiguration;
  use Moose;
  has CustomizedMetricSpecification => (is => 'ro', isa => 'Paws::ApplicationAutoScaling::CustomizedMetricSpecification');
  has DisableScaleIn => (is => 'ro', isa => 'Bool');
  has PredefinedMetricSpecification => (is => 'ro', isa => 'Paws::ApplicationAutoScaling::PredefinedMetricSpecification');
  has ScaleInCooldown => (is => 'ro', isa => 'Int');
  has ScaleOutCooldown => (is => 'ro', isa => 'Int');
  has TargetValue => (is => 'ro', isa => 'Num', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationAutoScaling::TargetTrackingScalingPolicyConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationAutoScaling::TargetTrackingScalingPolicyConfiguration object:

  $service_obj->Method(Att1 => { CustomizedMetricSpecification => $value, ..., TargetValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationAutoScaling::TargetTrackingScalingPolicyConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->CustomizedMetricSpecification

=head1 DESCRIPTION

Represents a target tracking scaling policy configuration to use with
Application Auto Scaling.

=head1 ATTRIBUTES


=head2 CustomizedMetricSpecification => L<Paws::ApplicationAutoScaling::CustomizedMetricSpecification>

A customized metric. You can specify either a predefined metric or a
customized metric.


=head2 DisableScaleIn => Bool

Indicates whether scale in by the target tracking scaling policy is
disabled. If the value is C<true>, scale in is disabled and the target
tracking scaling policy won't remove capacity from the scalable target.
Otherwise, scale in is enabled and the target tracking scaling policy
can remove capacity from the scalable target. The default value is
C<false>.


=head2 PredefinedMetricSpecification => L<Paws::ApplicationAutoScaling::PredefinedMetricSpecification>

A predefined metric. You can specify either a predefined metric or a
customized metric.


=head2 ScaleInCooldown => Int

The amount of time, in seconds, after a scale-in activity completes
before another scale-in activity can start.

With the I<scale-in cooldown period>, the intention is to scale in
conservatively to protect your applicationE<rsquo>s availability, so
scale-in activities are blocked until the cooldown period has expired.
However, if another alarm triggers a scale-out activity during the
scale-in cooldown period, Application Auto Scaling scales out the
target immediately. In this case, the scale-in cooldown period stops
and doesn't complete.

Application Auto Scaling provides a default value of 300 for the
following scalable targets:

=over

=item *

ECS services

=item *

Spot Fleet requests

=item *

EMR clusters

=item *

AppStream 2.0 fleets

=item *

Aurora DB clusters

=item *

Amazon SageMaker endpoint variants

=item *

Custom resources

=back

For all other scalable targets, the default value is 0:

=over

=item *

DynamoDB tables

=item *

DynamoDB global secondary indexes

=item *

Amazon Comprehend document classification and entity recognizer
endpoints

=item *

Lambda provisioned concurrency

=item *

Amazon Keyspaces tables

=item *

Amazon MSK broker storage

=back



=head2 ScaleOutCooldown => Int

The amount of time, in seconds, to wait for a previous scale-out
activity to take effect.

With the I<scale-out cooldown period>, the intention is to continuously
(but not excessively) scale out. After Application Auto Scaling
successfully scales out using a target tracking scaling policy, it
starts to calculate the cooldown time. The scaling policy won't
increase the desired capacity again unless either a larger scale out is
triggered or the cooldown period ends. While the cooldown period is in
effect, the capacity added by the initiating scale-out activity is
calculated as part of the desired capacity for the next scale-out
activity.

Application Auto Scaling provides a default value of 300 for the
following scalable targets:

=over

=item *

ECS services

=item *

Spot Fleet requests

=item *

EMR clusters

=item *

AppStream 2.0 fleets

=item *

Aurora DB clusters

=item *

Amazon SageMaker endpoint variants

=item *

Custom resources

=back

For all other scalable targets, the default value is 0:

=over

=item *

DynamoDB tables

=item *

DynamoDB global secondary indexes

=item *

Amazon Comprehend document classification and entity recognizer
endpoints

=item *

Lambda provisioned concurrency

=item *

Amazon Keyspaces tables

=item *

Amazon MSK broker storage

=back



=head2 B<REQUIRED> TargetValue => Num

The target value for the metric. Although this property accepts numbers
of type Double, it won't accept values that are either too small or too
large. Values must be in the range of -2^360 to 2^360. The value must
be a valid number based on the choice of metric. For example, if the
metric is CPU utilization, then the target value is a percent value
that represents how much of the CPU can be used before scaling out.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationAutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

