# Generated by default/object.tt
package Paws::CostExplorer::Impact;
  use Moose;
  has MaxImpact => (is => 'ro', isa => 'Num', required => 1);
  has TotalImpact => (is => 'ro', isa => 'Num');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::Impact

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::Impact object:

  $service_obj->Method(Att1 => { MaxImpact => $value, ..., TotalImpact => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::Impact object:

  $result = $service_obj->Method(...);
  $result->Att1->MaxImpact

=head1 DESCRIPTION

The anomaly's dollar value.

=head1 ATTRIBUTES


=head2 B<REQUIRED> MaxImpact => Num

The maximum dollar value observed for an anomaly.


=head2 TotalImpact => Num

The cumulative dollar value observed for an anomaly.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

