# Generated by default/object.tt
package Paws::FSX::DataRepositoryConfiguration;
  use Moose;
  has AutoImportPolicy => (is => 'ro', isa => 'Str');
  has ExportPath => (is => 'ro', isa => 'Str');
  has FailureDetails => (is => 'ro', isa => 'Paws::FSX::DataRepositoryFailureDetails');
  has ImportedFileChunkSize => (is => 'ro', isa => 'Int');
  has ImportPath => (is => 'ro', isa => 'Str');
  has Lifecycle => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::FSX::DataRepositoryConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FSX::DataRepositoryConfiguration object:

  $service_obj->Method(Att1 => { AutoImportPolicy => $value, ..., Lifecycle => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FSX::DataRepositoryConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AutoImportPolicy

=head1 DESCRIPTION

The data repository configuration object for Lustre file systems
returned in the response of the C<CreateFileSystem> operation.

=head1 ATTRIBUTES


=head2 AutoImportPolicy => Str

Describes the file system's linked S3 data repository's
C<AutoImportPolicy>. The AutoImportPolicy configures how Amazon FSx
keeps your file and directory listings up to date as you add or modify
objects in your linked S3 bucket. C<AutoImportPolicy> can have the
following values:

=over

=item *

C<NONE> - (Default) AutoImport is off. Amazon FSx only updates file and
directory listings from the linked S3 bucket when the file system is
created. FSx does not update file and directory listings for any new or
changed objects after choosing this option.

=item *

C<NEW> - AutoImport is on. Amazon FSx automatically imports directory
listings of any new objects added to the linked S3 bucket that do not
currently exist in the FSx file system.

=item *

C<NEW_CHANGED> - AutoImport is on. Amazon FSx automatically imports
file and directory listings of any new objects added to the S3 bucket
and any existing objects that are changed in the S3 bucket after you
choose this option.

=back

For more information, see Automatically import updates from your S3
bucket
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html).


=head2 ExportPath => Str

The export path to the Amazon S3 bucket (and prefix) that you are using
to store new and changed Lustre file system files in S3.


=head2 FailureDetails => L<Paws::FSX::DataRepositoryFailureDetails>




=head2 ImportedFileChunkSize => Int

For files imported from a data repository, this value determines the
stripe count and maximum amount of data per file (in MiB) stored on a
single physical disk. The maximum number of disks that a single file
can be striped across is limited by the total number of disks that make
up the file system.

The default chunk size is 1,024 MiB (1 GiB) and can go as high as
512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.


=head2 ImportPath => Str

The import path to the Amazon S3 bucket (and optional prefix) that
you're using as the data repository for your FSx for Lustre file
system, for example C<s3://import-bucket/optional-prefix>. If a prefix
is specified after the Amazon S3 bucket name, only object keys with
that prefix are loaded into the file system.


=head2 Lifecycle => Str

Describes the state of the file system's S3 durable data repository, if
it is configured with an S3 repository. The lifecycle can have the
following values:

=over

=item *

C<CREATING> - The data repository configuration between the FSx file
system and the linked S3 data repository is being created. The data
repository is unavailable.

=item *

C<AVAILABLE> - The data repository is available for use.

=item *

C<MISCONFIGURED> - Amazon FSx cannot automatically import updates from
the S3 bucket until the data repository configuration is corrected. For
more information, see Troubleshooting a Misconfigured linked S3 bucket
(https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository).

=item *

C<UPDATING> - The data repository is undergoing a customer initiated
update and availability may be impacted.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FSX>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

