# Generated by default/object.tt
package Paws::NetworkFirewall::RuleGroupResponse;
  use Moose;
  has Capacity => (is => 'ro', isa => 'Int');
  has Description => (is => 'ro', isa => 'Str');
  has RuleGroupArn => (is => 'ro', isa => 'Str', required => 1);
  has RuleGroupId => (is => 'ro', isa => 'Str', required => 1);
  has RuleGroupName => (is => 'ro', isa => 'Str', required => 1);
  has RuleGroupStatus => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::NetworkFirewall::Tag]');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::RuleGroupResponse

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::RuleGroupResponse object:

  $service_obj->Method(Att1 => { Capacity => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::RuleGroupResponse object:

  $result = $service_obj->Method(...);
  $result->Att1->Capacity

=head1 DESCRIPTION

The high-level properties of a rule group. This, along with the
RuleGroup, define the rule group. You can retrieve all objects for a
rule group by calling DescribeRuleGroup.

=head1 ATTRIBUTES


=head2 Capacity => Int

The maximum operating resources that this rule group can use. Rule
group capacity is fixed at creation. When you update a rule group, you
are limited to this capacity. When you reference a rule group from a
firewall policy, Network Firewall reserves this capacity for the rule
group.

You can retrieve the capacity that would be required for a rule group
before you create the rule group by calling CreateRuleGroup with
C<DryRun> set to C<TRUE>.


=head2 Description => Str

A description of the rule group.


=head2 B<REQUIRED> RuleGroupArn => Str

The Amazon Resource Name (ARN) of the rule group.

If this response is for a create request that had C<DryRun> set to
C<TRUE>, then this ARN is a placeholder that isn't attached to a valid
resource.


=head2 B<REQUIRED> RuleGroupId => Str

The unique identifier for the rule group.


=head2 B<REQUIRED> RuleGroupName => Str

The descriptive name of the rule group. You can't change the name of a
rule group after you create it.


=head2 RuleGroupStatus => Str

Detailed information about the current status of a rule group.


=head2 Tags => ArrayRef[L<Paws::NetworkFirewall::Tag>]

The key:value pairs to associate with the resource.


=head2 Type => Str

Indicates whether the rule group is stateless or stateful. If the rule
group is stateless, it contains stateless rules. If it is stateful, it
contains stateful rules.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

