# Generated by default/object.tt
package Paws::StorageGateway::PoolInfo;
  use Moose;
  has PoolARN => (is => 'ro', isa => 'Str');
  has PoolName => (is => 'ro', isa => 'Str');
  has PoolStatus => (is => 'ro', isa => 'Str');
  has RetentionLockTimeInDays => (is => 'ro', isa => 'Int');
  has RetentionLockType => (is => 'ro', isa => 'Str');
  has StorageClass => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::StorageGateway::PoolInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::StorageGateway::PoolInfo object:

  $service_obj->Method(Att1 => { PoolARN => $value, ..., StorageClass => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::StorageGateway::PoolInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->PoolARN

=head1 DESCRIPTION

Describes a custom tape pool.

=head1 ATTRIBUTES


=head2 PoolARN => Str

The Amazon Resource Name (ARN) of the custom tape pool. Use the
ListTapePools operation to return a list of custom tape pools for your
account and AWS Region.


=head2 PoolName => Str

The name of the custom tape pool. C<PoolName> can use all ASCII
characters, except '/' and '\'.


=head2 PoolStatus => Str

Status of the custom tape pool. Pool can be C<ACTIVE> or C<DELETED>.


=head2 RetentionLockTimeInDays => Int

Tape retention lock time is set in days. Tape retention lock can be
enabled for up to 100 years (36,500 days).


=head2 RetentionLockType => Str

Tape retention lock type, which can be configured in two modes. When
configured in governance mode, AWS accounts with specific IAM
permissions are authorized to remove the tape retention lock from
archived virtual tapes. When configured in compliance mode, the tape
retention lock cannot be removed by any user, including the root AWS
account.


=head2 StorageClass => Str

The storage class that is associated with the custom pool. When you use
your backup application to eject the tape, the tape is archived
directly into the storage class (S3 Glacier or S3 Glacier Deep Archive)
that corresponds to the pool.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::StorageGateway>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

