# Generated by default/object.tt
package Paws::S3Control::ObjectLambdaConfiguration;
  use Moose;
  has AllowedFeatures => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'AllowedFeature', traits => ['NameInRequest']);
  has CloudWatchMetricsEnabled => (is => 'ro', isa => 'Bool');
  has SupportingAccessPoint => (is => 'ro', isa => 'Str', required => 1);
  has TransformationConfigurations => (is => 'ro', isa => 'ArrayRef[Paws::S3Control::ObjectLambdaTransformationConfiguration]', request_name => 'TransformationConfiguration', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3Control::ObjectLambdaConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3Control::ObjectLambdaConfiguration object:

  $service_obj->Method(Att1 => { AllowedFeatures => $value, ..., TransformationConfigurations => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3Control::ObjectLambdaConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AllowedFeatures

=head1 DESCRIPTION

A configuration used when creating an Object Lambda Access Point.

=head1 ATTRIBUTES


=head2 AllowedFeatures => ArrayRef[Str|Undef]

A container for allowed features. Valid inputs are C<GetObject-Range>
and C<GetObject-PartNumber>.


=head2 CloudWatchMetricsEnabled => Bool

A container for whether the CloudWatch metrics configuration is
enabled.


=head2 B<REQUIRED> SupportingAccessPoint => Str

Standard access point associated with the Object Lambda Access Point.


=head2 B<REQUIRED> TransformationConfigurations => ArrayRef[L<Paws::S3Control::ObjectLambdaTransformationConfiguration>]

A container for transformation configurations for an Object Lambda
Access Point.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3Control>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

