# Generated by default/object.tt
package Paws::LexModelsV2::LambdaCodeHook;
  use Moose;
  has CodeHookInterfaceVersion => (is => 'ro', isa => 'Str', request_name => 'codeHookInterfaceVersion', traits => ['NameInRequest'], required => 1);
  has LambdaARN => (is => 'ro', isa => 'Str', request_name => 'lambdaARN', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::LambdaCodeHook

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::LambdaCodeHook object:

  $service_obj->Method(Att1 => { CodeHookInterfaceVersion => $value, ..., LambdaARN => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::LambdaCodeHook object:

  $result = $service_obj->Method(...);
  $result->Att1->CodeHookInterfaceVersion

=head1 DESCRIPTION

Specifies a Lambda function that verifies requests to a bot or
fulfilles the user's request to a bot.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CodeHookInterfaceVersion => Str

The version of the request-response that you want Amazon Lex to use to
invoke your Lambda function.


=head2 B<REQUIRED> LambdaARN => Str

The Amazon Resource Name (ARN) of the Lambda function.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

