# Generated by default/object.tt
package Paws::SecurityHub::AwsS3BucketDetails;
  use Moose;
  has BucketLifecycleConfiguration => (is => 'ro', isa => 'Paws::SecurityHub::AwsS3BucketBucketLifecycleConfigurationDetails');
  has CreatedAt => (is => 'ro', isa => 'Str');
  has OwnerId => (is => 'ro', isa => 'Str');
  has OwnerName => (is => 'ro', isa => 'Str');
  has PublicAccessBlockConfiguration => (is => 'ro', isa => 'Paws::SecurityHub::AwsS3AccountPublicAccessBlockDetails');
  has ServerSideEncryptionConfiguration => (is => 'ro', isa => 'Paws::SecurityHub::AwsS3BucketServerSideEncryptionConfiguration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsS3BucketDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsS3BucketDetails object:

  $service_obj->Method(Att1 => { BucketLifecycleConfiguration => $value, ..., ServerSideEncryptionConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsS3BucketDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->BucketLifecycleConfiguration

=head1 DESCRIPTION

The details of an Amazon S3 bucket.

=head1 ATTRIBUTES


=head2 BucketLifecycleConfiguration => L<Paws::SecurityHub::AwsS3BucketBucketLifecycleConfigurationDetails>

The lifecycle configuration for objects in the S3 bucket.


=head2 CreatedAt => Str

Indicates when the S3 bucket was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 OwnerId => Str

The canonical user ID of the owner of the S3 bucket.


=head2 OwnerName => Str

The display name of the owner of the S3 bucket.


=head2 PublicAccessBlockConfiguration => L<Paws::SecurityHub::AwsS3AccountPublicAccessBlockDetails>

Provides information about the Amazon S3 Public Access Block
configuration for the S3 bucket.


=head2 ServerSideEncryptionConfiguration => L<Paws::SecurityHub::AwsS3BucketServerSideEncryptionConfiguration>

The encryption rules that are applied to the S3 bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

