# Generated by default/object.tt
package Paws::NetworkFirewall::PortRange;
  use Moose;
  has FromPort => (is => 'ro', isa => 'Int', required => 1);
  has ToPort => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::PortRange

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::PortRange object:

  $service_obj->Method(Att1 => { FromPort => $value, ..., ToPort => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::PortRange object:

  $result = $service_obj->Method(...);
  $result->Att1->FromPort

=head1 DESCRIPTION

A single port range specification. This is used for source and
destination port ranges in the stateless rule MatchAttributes,
C<SourcePorts>, and C<DestinationPorts> settings.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FromPort => Int

The lower limit of the port range. This must be less than or equal to
the C<ToPort> specification.


=head2 B<REQUIRED> ToPort => Int

The upper limit of the port range. This must be greater than or equal
to the C<FromPort> specification.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

