# Generated by default/object.tt
package Paws::Honeycode::TableDataImportJobMetadata;
  use Moose;
  has DataSource => (is => 'ro', isa => 'Paws::Honeycode::ImportDataSource', request_name => 'dataSource', traits => ['NameInRequest'], required => 1);
  has ImportOptions => (is => 'ro', isa => 'Paws::Honeycode::ImportOptions', request_name => 'importOptions', traits => ['NameInRequest'], required => 1);
  has Submitter => (is => 'ro', isa => 'Paws::Honeycode::ImportJobSubmitter', request_name => 'submitter', traits => ['NameInRequest'], required => 1);
  has SubmitTime => (is => 'ro', isa => 'Str', request_name => 'submitTime', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::TableDataImportJobMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::TableDataImportJobMetadata object:

  $service_obj->Method(Att1 => { DataSource => $value, ..., SubmitTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::TableDataImportJobMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->DataSource

=head1 DESCRIPTION

The metadata associated with the table data import job that was
submitted.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DataSource => L<Paws::Honeycode::ImportDataSource>

The source of the data that was submitted for import.


=head2 B<REQUIRED> ImportOptions => L<Paws::Honeycode::ImportOptions>

The options that was specified at the time of submitting the import
request.


=head2 B<REQUIRED> Submitter => L<Paws::Honeycode::ImportJobSubmitter>

Details about the submitter of the import request.


=head2 B<REQUIRED> SubmitTime => Str

The timestamp when the job was submitted for import.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

