package WebService::Mattermost::V4::API::Resource::Teams;

# ABSTRACT: Wrapped API methods for the teams API endpoints.

use Moo;

extends 'WebService::Mattermost::V4::API::Resource';

################################################################################

sub create {
    my $self = shift;
    my $args = shift;

    return $self->_single_view_post({
        parameters => $args,
        required   => [ qw(name display_name type) ],
    });
}

sub list {
    my $self = shift;
    my $args = shift;

    return $self->_get({
        view       => 'Team',
        parameters => $args,
    });
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Teams - Wrapped API methods for the teams API endpoints.

=head1 VERSION

version 0.31

=head1 DESCRIPTION

=head2 USAGE

    use WebService::Mattermost;

    my $mm = WebService::Mattermost->new({
        authenticate => 1,
        username     => 'me@somewhere.com',
        password     => 'hunter2',
        base_url     => 'https://my.mattermost.server.com/api/v4/',
    });

    my $resource = $mm->api->teams;

=head2 METHODS

=over 4

=item C<create()>

L<Create a team|https://api.mattermost.com/#tag/teams%2Fpaths%2F~1teams%2Fpost>

    my $response = $resource->create({
        # Required parameters:
        name         => '...',
        type         => 'O', # O for open, I for invite only
        display_name => '...',
    });

=item C<list()>

L<Get teams|https://api.mattermost.com/#tag/teams%2Fpaths%2F~1teams%2Fget>

    my $response = $resource->list({
        # Optional parameters:
        page     => 0,
        per_page => 60,
    });

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
