<?php
/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2009 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * Configuration file for the File Manager Connector for PHP.
 */

global $Config ;
$DWFCK_con_dbg = false;  
// SECURITY: You must explicitly enable this "connector". (Set it to "true").
// WARNING: don't just set "$Config['Enabled'] = true ;", you must be sure that only
//		authenticated users can access this file or use some kind of session checking.
$Config['Enabled'] = true ;



/** 

   PATHS
   This script will atempt to implement the two paths described below automatically.  
   But if that fails, here is what you must do.

   Two Paths Required:  absolute and relative.  Both must refer to the same directory.
   On a Windows System the Absolute Path is the complete path from the Drive Letter to the
   userfiles directory.

   The relative or UserfilesPath starts at the directory where you have your DokuWiki
   installed and refers to the data/media directory:  /<dokuwiki>/data/media/
   You fill in <dokuwiki> with the name of your own dokuwiki directory.  If <dokuwiki>
   is in a subdirectory, then your relative path must begin with that subdirectory.  In other
   words what you want here is the directory that would appear in the browser's url.  

   If your web site is http://my_website.org and dokuwiki is accesses as
               http://my_website.org/dokuwiki
  then your relative path is as above
              /dokuwiki/data/media/
  But if the web address is
              http://my_website.org/software/dokuwiki
  then your relative path is
              /software/dokuwiki/data/media 

   What you want is the paths to your dokuwiki data/media directory.

  On a Windows system:
  The Absolute Path uses the Windows style with back-slashes, while the relative path uses
  the Unix-style with forward slashes.  
  NOTE:  The PHP programming language requires two backslashes to represent a single backslash:
    'C:\\Program Files\\. . . . \\'

  Both paths must be enclosed in single quotes and both paths must end with slashes--a single
  forward slash in the relative path and a double backslash in the Windows.  And the relative
  path must begin with a single forward slash:
     Windows Absolute:  'C:\\Program Files\\. . . . \\'
     Linux/Unix Absolute:  /var/www/htdocs . . ./'

     Relative on all Systems:  '/. . /data/media/'

  The absolute path is assigned to  $Config['UserFilesAbsolutePath'] 
  The relative path is assigned to  $Config['UserFilesPath']
*/

/**
 Example absolute paths
   Example absolute On Windows System:
  $Config['UserFilesAbsolutePath'] = 'C:\\Program Files\\Apache Software Foundation\\Apache2.2\\htdocs\\dokuwiki\\data\\media\\';
 
  Example absolute on Unix/Linux system:
  $Config['UserFilesAbsolutePath'] = '/var/www/htdocs/dokuwiki/data/media/';

*/

/** 
 Example relative path
   This is the path to user files relative to the document root.
   This must use the Unix style path, even on a Windows system, i.e. single forward slashes
   $Config['UserFilesPath'] = '/dokuwiki/data/media/';

*/



$isWindows = DWFCK_isWinOS();
$useWinStyle = false;

if(!isset($Config['UserFilesAbsolutePath']) || !isset($Config['UserFilesPath'])) {
   if(isset($_COOKIE['FCKConnector']) && $_COOKIE['FCKConnector'] == 'WIN') {
      $useWinStyle = true;  
   }
   if($isWindows || $useWinStyle) {
    setupBasePathsWin();
    if($DWFCK_con_dbg) DWFCK_cfg_dbg('win_paths.txt');
   }
   else {
     setupBasePathsNix();
     if($DWFCK_con_dbg) DWFCK_cfg_dbg('nix_paths.txt');   
   }

  
}

setUpMediaPaths();

 

// Due to security issues with Apache modules, it is recommended to leave the
// following setting enabled.
$Config['ForceSingleExtension'] = true ;

// Perform additional checks for image files.
// If set to true, validate image size (using getimagesize).
$Config['SecureImageUploads'] = true;

// What the user can do with this connector.
$Config['ConfigAllowedCommands'] = array('QuickUpload', 'FileUpload', 'GetFolders', 'GetFoldersAndFiles', 'CreateFolder') ;

// Allowed Resource Types.
$Config['ConfigAllowedTypes'] = array('File', 'Image', 'Flash', 'Media') ;

// For security, HTML is allowed in the first Kb of data for files having the
// following extensions only.
$Config['HtmlExtensions'] = array("html", "htm", "xml", "xsd", "txt", "js") ;

// After file is uploaded, sometimes it is required to change its permissions
// so that it was possible to access it at the later time.
// If possible, it is recommended to set more restrictive permissions, like 0755.
// Set to 0 to disable this feature.
// Note: not needed on Windows-based servers.
$Config['ChmodOnUpload'] = 0777 ;

// See comments above.
// Used when creating folders that does not exist.
$Config['ChmodOnFolderCreate'] = 0777 ;


function setupBasePathsNix() {
  global $Config;
    $dir = dirname(__FILE__) ;
    $dir = preg_replace('/editor\/filemanager\/connectors\/.*/', 'userfiles/',$dir);
    $Config['UserFilesAbsolutePath'] = $dir;
    $document_root = $_SERVER['DOCUMENT_ROOT'];
    $relative_dir = str_replace($document_root, "", $dir);
    $Config['UserFilesPath'] = $relative_dir;
}

function setupBasePathsWin() {
  global $Config;
  global $isWindows;

    $data_media = $isWindows ? 'data\\media\\' : 'data/media/';
    $regex = $isWindows ? 'lib\plugins\fckg\fckeditor\editor\filemanager\connectors' : 'lib/plugins/fckg/fckeditor/editor/filemanager/connectors'; 
    $dir = dirname(__FILE__) ;   
       
    $regex = preg_quote($regex, '/');
    
    $dir = preg_replace('/'. $regex .'.*/', $data_media, $dir);

    $Config['UserFilesAbsolutePath'] = $dir;
     
    $base_url = getBaseURL();
    $Config['UserFilesPath'] =  $base_url . 'data/media/';

}


function setUpMediaPaths() {
  global $Config;
  global $isWindows;
  global $useWinStyle;
 
    $Config['AllowedExtensions']['File']	= array('7z', 'aiff', 'asf', 'avi', 'bmp', 'csv', 'doc', 'fla', 'flv', 'gif', 'gz', 'gzip', 'jpeg', 'jpg', 'mid', 'mov', 'mp3', 'mp4', 'mpc', 'mpeg', 'mpg', 'ods', 'odt', 'pdf', 'png', 'ppt', 'pxd', 'qt', 'ram', 'rar', 'rm', 'rmi', 'rmvb', 'rtf', 'sdc', 'sitd', 'swf', 'sxc', 'sxw', 'tar', 'tgz', 'tif', 'tiff', 'txt', 'vsd', 'wav', 'wma', 'wmv', 'xls', 'xml', 'zip') ;
    $Config['DeniedExtensions']['File']		= array() ;
    $Config['AllowedExtensions']['Image']	= array('bmp','gif','jpeg','jpg','png') ;
    $Config['DeniedExtensions']['Image']	= array() ;
    $Config['AllowedExtensions']['Flash']	= array('swf','flv') ;
    $Config['DeniedExtensions']['Flash']	= array() ;
    $Config['AllowedExtensions']['Media']	= array('aiff', 'asf', 'avi', 'bmp', 'fla', 'flv', 'gif', 'jpeg', 'jpg', 'mid', 'mov', 'mp3', 'mp4', 'mpc', 'mpeg', 'mpg', 'png', 'qt', 'ram', 'rm', 'rmi', 'rmvb', 'swf', 'tif', 'tiff', 'wav', 'wma', 'wmv') ;
    $Config['DeniedExtensions']['Media']	= array() ;

    $DWFCK_MediaTypes = array('File','Image', 'Flash','Media');    
    
      
    foreach($DWFCK_MediaTypes as $type) {     
        $dir_type = ($isWindows || $useWinStyle) ? '' : strtolower($type) . '/';
        $Config['FileTypesPath'][$type]		= $Config['UserFilesPath'] . $dir_type; 
        $Config['FileTypesAbsolutePath'][$type] = $Config['UserFilesAbsolutePath'] . $dir_type ;
        $Config['QuickUploadPath'][$type]		= $Config['UserFilesPath'] . $dir_type ;
        $Config['QuickUploadAbsolutePath'][$type]= $Config['UserFilesAbsolutePath'] . $dir_type;
    }
  
}

function getBaseURL(){
 
  if(substr($_SERVER['SCRIPT_NAME'],-4) == '.php'){
    $dir = dirname($_SERVER['SCRIPT_NAME']);
  }elseif(substr($_SERVER['PHP_SELF'],-4) == '.php'){
    $dir = dirname($_SERVER['PHP_SELF']);
  }elseif($_SERVER['DOCUMENT_ROOT'] && $_SERVER['SCRIPT_FILENAME']){
    $dir = preg_replace ('/^'.preg_quote($_SERVER['DOCUMENT_ROOT'],'/').'/','',
                         $_SERVER['SCRIPT_FILENAME']);
    $dir = dirname('/'.$dir);
  }else{
    $dir = '.'; //probably wrong
  }

  $dir = str_replace('\\','/',$dir);             // bugfix for weird WIN behaviour
  $dir = preg_replace('#//+#','/',"/$dir/");     // ensure leading and trailing slashes

  //handle script in lib/exe dir
  $dir = preg_replace('!lib/exe/$!','',$dir);

  //handle script in lib/plugins dir
  $dir = preg_replace('!lib/plugins/.*$!','',$dir);

  //finish here for relative URLs
  return $dir;
}

function DWFCK_isWinOS() {
  if(isset($_SERVER['WINDIR']) && $_SERVER['WINDIR']) {
      return true;
  }
  elseif(stristr(PHP_OS, 'WIN') && !DWFCK_is_OS(DARWIN)) {
     return true;
  }

  return false;
}


function DWFCK_is_OS($os) {
  $os = strtolower($os);
  $_OS = strtolower(PHP_OS);

  if($os == $_OS || stristr(PHP_OS, $os) || stristr($os.PHP_OS) ) {
        return true;
  }
  return false;
}

function DWFCK_cfg_dbg($fname) {
   global $Config;
  
   file_put_contents($fname, $Config['UserFilesAbsolutePath'] . "\r\n" . $Config['UserFilesPath'] . "\r\n");
}

?>
