package Net::Async::Spotify::Object::Generated::PrivateUser;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::PrivateUser - Package representing Spotify PrivateUser Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify PrivateUser Object attributes:

=over 4

=item country

Type:String
Description:The country of the user, as set in the user’s account profile. An ISO 3166-1 alpha-2 country code. This field is only available when the current user has granted access to the user-read-private scope.

=item display_name

Type:String
Description:The name displayed on the user’s profile. null if not available.

=item email

Type:String
Description:The user’s email address, as entered by the user when creating their account. Important! This email address is unverified; there is no proof that it actually belongs to the user. This field is only available when the current user has granted access to the user-read-email scope.

=item explicit_content

Type:ExplicitContentSettingsObject
Description:The user’s explicit content settings. This field is only available when the current user has granted access to the user-read-private scope.

=item external_urls

Type:ExternalUrlObject
Description:Known external URLs for this user.

=item followers

Type:FollowersObject
Description:Information about the followers of the user.

=item href

Type:String
Description:A link to the Web API endpoint for this user.

=item id

Type:String
Description:The Spotify user ID for the user.

=item images

Type:Array[ImageObject]
Description:The user’s profile image.

=item product

Type:String
Description:The user’s Spotify subscription level: “premium”, “free”, etc. (The subscription level “open” can be considered the same as “free”.) This field is only available when the current user has granted access to the user-read-private scope.

=item type

Type:String
Description:The object type: “user”

=item uri

Type:String
Description:The Spotify URI for the user.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        country => 'String',
        display_name => 'String',
        email => 'String',
        explicit_content => 'ExplicitContentSettingsObject',
        external_urls => 'ExternalUrlObject',
        followers => 'FollowersObject',
        href => 'String',
        id => 'String',
        images => 'Array[ImageObject]',
        product => 'String',
        type => 'String',
        uri => 'String',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
