# Generated by default/object.tt
package Paws::CodeBuild::BuildBatch;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has Artifacts => (is => 'ro', isa => 'Paws::CodeBuild::BuildArtifacts', request_name => 'artifacts', traits => ['NameInRequest']);
  has BuildBatchConfig => (is => 'ro', isa => 'Paws::CodeBuild::ProjectBuildBatchConfig', request_name => 'buildBatchConfig', traits => ['NameInRequest']);
  has BuildBatchNumber => (is => 'ro', isa => 'Int', request_name => 'buildBatchNumber', traits => ['NameInRequest']);
  has BuildBatchStatus => (is => 'ro', isa => 'Str', request_name => 'buildBatchStatus', traits => ['NameInRequest']);
  has BuildGroups => (is => 'ro', isa => 'ArrayRef[Paws::CodeBuild::BuildGroup]', request_name => 'buildGroups', traits => ['NameInRequest']);
  has BuildTimeoutInMinutes => (is => 'ro', isa => 'Int', request_name => 'buildTimeoutInMinutes', traits => ['NameInRequest']);
  has Cache => (is => 'ro', isa => 'Paws::CodeBuild::ProjectCache', request_name => 'cache', traits => ['NameInRequest']);
  has Complete => (is => 'ro', isa => 'Bool', request_name => 'complete', traits => ['NameInRequest']);
  has CurrentPhase => (is => 'ro', isa => 'Str', request_name => 'currentPhase', traits => ['NameInRequest']);
  has DebugSessionEnabled => (is => 'ro', isa => 'Bool', request_name => 'debugSessionEnabled', traits => ['NameInRequest']);
  has EncryptionKey => (is => 'ro', isa => 'Str', request_name => 'encryptionKey', traits => ['NameInRequest']);
  has EndTime => (is => 'ro', isa => 'Str', request_name => 'endTime', traits => ['NameInRequest']);
  has Environment => (is => 'ro', isa => 'Paws::CodeBuild::ProjectEnvironment', request_name => 'environment', traits => ['NameInRequest']);
  has FileSystemLocations => (is => 'ro', isa => 'ArrayRef[Paws::CodeBuild::ProjectFileSystemLocation]', request_name => 'fileSystemLocations', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Initiator => (is => 'ro', isa => 'Str', request_name => 'initiator', traits => ['NameInRequest']);
  has LogConfig => (is => 'ro', isa => 'Paws::CodeBuild::LogsConfig', request_name => 'logConfig', traits => ['NameInRequest']);
  has Phases => (is => 'ro', isa => 'ArrayRef[Paws::CodeBuild::BuildBatchPhase]', request_name => 'phases', traits => ['NameInRequest']);
  has ProjectName => (is => 'ro', isa => 'Str', request_name => 'projectName', traits => ['NameInRequest']);
  has QueuedTimeoutInMinutes => (is => 'ro', isa => 'Int', request_name => 'queuedTimeoutInMinutes', traits => ['NameInRequest']);
  has ResolvedSourceVersion => (is => 'ro', isa => 'Str', request_name => 'resolvedSourceVersion', traits => ['NameInRequest']);
  has SecondaryArtifacts => (is => 'ro', isa => 'ArrayRef[Paws::CodeBuild::BuildArtifacts]', request_name => 'secondaryArtifacts', traits => ['NameInRequest']);
  has SecondarySources => (is => 'ro', isa => 'ArrayRef[Paws::CodeBuild::ProjectSource]', request_name => 'secondarySources', traits => ['NameInRequest']);
  has SecondarySourceVersions => (is => 'ro', isa => 'ArrayRef[Paws::CodeBuild::ProjectSourceVersion]', request_name => 'secondarySourceVersions', traits => ['NameInRequest']);
  has ServiceRole => (is => 'ro', isa => 'Str', request_name => 'serviceRole', traits => ['NameInRequest']);
  has Source => (is => 'ro', isa => 'Paws::CodeBuild::ProjectSource', request_name => 'source', traits => ['NameInRequest']);
  has SourceVersion => (is => 'ro', isa => 'Str', request_name => 'sourceVersion', traits => ['NameInRequest']);
  has StartTime => (is => 'ro', isa => 'Str', request_name => 'startTime', traits => ['NameInRequest']);
  has VpcConfig => (is => 'ro', isa => 'Paws::CodeBuild::VpcConfig', request_name => 'vpcConfig', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeBuild::BuildBatch

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeBuild::BuildBatch object:

  $service_obj->Method(Att1 => { Arn => $value, ..., VpcConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeBuild::BuildBatch object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Contains information about a batch build.

=head1 ATTRIBUTES


=head2 Arn => Str

The ARN of the batch build.


=head2 Artifacts => L<Paws::CodeBuild::BuildArtifacts>

A C<BuildArtifacts> object the defines the build artifacts for this
batch build.


=head2 BuildBatchConfig => L<Paws::CodeBuild::ProjectBuildBatchConfig>




=head2 BuildBatchNumber => Int

The number of the batch build. For each project, the
C<buildBatchNumber> of its first batch build is C<1>. The
C<buildBatchNumber> of each subsequent batch build is incremented by
C<1>. If a batch build is deleted, the C<buildBatchNumber> of other
batch builds does not change.


=head2 BuildBatchStatus => Str

The status of the batch build.


=head2 BuildGroups => ArrayRef[L<Paws::CodeBuild::BuildGroup>]

An array of C<BuildGroup> objects that define the build groups for the
batch build.


=head2 BuildTimeoutInMinutes => Int

Specifies the maximum amount of time, in minutes, that the build in a
batch must be completed in.


=head2 Cache => L<Paws::CodeBuild::ProjectCache>




=head2 Complete => Bool

Indicates if the batch build is complete.


=head2 CurrentPhase => Str

The current phase of the batch build.


=head2 DebugSessionEnabled => Bool

Specifies if session debugging is enabled for this batch build. For
more information, see Viewing a running build in Session Manager
(https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html).
Batch session debugging is not supported for matrix batch builds.


=head2 EncryptionKey => Str

The Key Management Service customer master key (CMK) to be used for
encrypting the batch build output artifacts.

You can use a cross-account KMS key to encrypt the build output
artifacts if your service role has permission to that key.

You can specify either the Amazon Resource Name (ARN) of the CMK or, if
available, the CMK's alias (using the format
C<alias/E<lt>alias-nameE<gt>>).


=head2 EndTime => Str

The date and time that the batch build ended.


=head2 Environment => L<Paws::CodeBuild::ProjectEnvironment>




=head2 FileSystemLocations => ArrayRef[L<Paws::CodeBuild::ProjectFileSystemLocation>]

An array of C<ProjectFileSystemLocation> objects for the batch build
project. A C<ProjectFileSystemLocation> object specifies the
C<identifier>, C<location>, C<mountOptions>, C<mountPoint>, and C<type>
of a file system created using Amazon Elastic File System.


=head2 Id => Str

The identifier of the batch build.


=head2 Initiator => Str

The entity that started the batch build. Valid values include:

=over

=item *

If CodePipeline started the build, the pipeline's name (for example,
C<codepipeline/my-demo-pipeline>).

=item *

If an Identity and Access Management user started the build, the user's
name.

=item *

If the Jenkins plugin for CodeBuild started the build, the string
C<CodeBuild-Jenkins-Plugin>.

=back



=head2 LogConfig => L<Paws::CodeBuild::LogsConfig>




=head2 Phases => ArrayRef[L<Paws::CodeBuild::BuildBatchPhase>]

An array of C<BuildBatchPhase> objects the specify the phases of the
batch build.


=head2 ProjectName => Str

The name of the batch build project.


=head2 QueuedTimeoutInMinutes => Int

Specifies the amount of time, in minutes, that the batch build is
allowed to be queued before it times out.


=head2 ResolvedSourceVersion => Str

The identifier of the resolved version of this batch build's source
code.

=over

=item *

For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit
ID.

=item *

For CodePipeline, the source revision provided by CodePipeline.

=item *

For Amazon S3, this does not apply.

=back



=head2 SecondaryArtifacts => ArrayRef[L<Paws::CodeBuild::BuildArtifacts>]

An array of C<BuildArtifacts> objects the define the build artifacts
for this batch build.


=head2 SecondarySources => ArrayRef[L<Paws::CodeBuild::ProjectSource>]

An array of C<ProjectSource> objects that define the sources for the
batch build.


=head2 SecondarySourceVersions => ArrayRef[L<Paws::CodeBuild::ProjectSourceVersion>]

An array of C<ProjectSourceVersion> objects. Each
C<ProjectSourceVersion> must be one of:

=over

=item *

For CodeCommit: the commit ID, branch, or Git tag to use.

=item *

For GitHub: the commit ID, pull request ID, branch name, or tag name
that corresponds to the version of the source code you want to build.
If a pull request ID is specified, it must use the format
C<pr/pull-request-ID> (for example, C<pr/25>). If a branch name is
specified, the branch's HEAD commit ID is used. If not specified, the
default branch's HEAD commit ID is used.

=item *

For Bitbucket: the commit ID, branch name, or tag name that corresponds
to the version of the source code you want to build. If a branch name
is specified, the branch's HEAD commit ID is used. If not specified,
the default branch's HEAD commit ID is used.

=item *

For Amazon S3: the version ID of the object that represents the build
input ZIP file to use.

=back



=head2 ServiceRole => Str

The name of a service role used for builds in the batch.


=head2 Source => L<Paws::CodeBuild::ProjectSource>




=head2 SourceVersion => Str

The identifier of the version of the source code to be built.


=head2 StartTime => Str

The date and time that the batch build started.


=head2 VpcConfig => L<Paws::CodeBuild::VpcConfig>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeBuild>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

