# Generated by default/object.tt
package Paws::LexModelsV2::WaitAndContinueSpecification;
  use Moose;
  has ContinueResponse => (is => 'ro', isa => 'Paws::LexModelsV2::ResponseSpecification', request_name => 'continueResponse', traits => ['NameInRequest'], required => 1);
  has StillWaitingResponse => (is => 'ro', isa => 'Paws::LexModelsV2::StillWaitingResponseSpecification', request_name => 'stillWaitingResponse', traits => ['NameInRequest']);
  has WaitingResponse => (is => 'ro', isa => 'Paws::LexModelsV2::ResponseSpecification', request_name => 'waitingResponse', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::WaitAndContinueSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::WaitAndContinueSpecification object:

  $service_obj->Method(Att1 => { ContinueResponse => $value, ..., WaitingResponse => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::WaitAndContinueSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->ContinueResponse

=head1 DESCRIPTION

Specifies the prompts that Amazon Lex uses while a bot is waiting for
customer input.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ContinueResponse => L<Paws::LexModelsV2::ResponseSpecification>

The response that Amazon Lex sends to indicate that the bot is ready to
continue the conversation.


=head2 StillWaitingResponse => L<Paws::LexModelsV2::StillWaitingResponseSpecification>

A response that Amazon Lex sends periodically to the user to indicate
that the bot is still waiting for input from the user.


=head2 B<REQUIRED> WaitingResponse => L<Paws::LexModelsV2::ResponseSpecification>

The response that Amazon Lex sends to indicate that the bot is waiting
for the conversation to continue.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

