# Generated by default/object.tt
package Paws::ElastiCache::RegionalConfiguration;
  use Moose;
  has ReplicationGroupId => (is => 'ro', isa => 'Str', required => 1);
  has ReplicationGroupRegion => (is => 'ro', isa => 'Str', required => 1);
  has ReshardingConfiguration => (is => 'ro', isa => 'ArrayRef[Paws::ElastiCache::ReshardingConfiguration]', request_name => 'ReshardingConfiguration', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElastiCache::RegionalConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElastiCache::RegionalConfiguration object:

  $service_obj->Method(Att1 => { ReplicationGroupId => $value, ..., ReshardingConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElastiCache::RegionalConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ReplicationGroupId

=head1 DESCRIPTION

A list of the replication groups

=head1 ATTRIBUTES


=head2 B<REQUIRED> ReplicationGroupId => Str

The name of the secondary cluster


=head2 B<REQUIRED> ReplicationGroupRegion => Str

The AWS region where the cluster is stored


=head2 B<REQUIRED> ReshardingConfiguration => ArrayRef[L<Paws::ElastiCache::ReshardingConfiguration>]

A list of C<PreferredAvailabilityZones> objects that specifies the
configuration of a node group in the resharded cluster.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElastiCache>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

