package MyInterfaces::TestService::TestPort;
use strict;
use warnings;
use Class::Std::Fast::Storable;
use Scalar::Util qw(blessed);
use base qw(SOAP::WSDL::Client::Base);

# only load if it hasn't been loaded before
require MyTypemaps::TestService
    if not MyTypemaps::TestService->can('get_class');

sub START {
    $_[0]->set_proxy('http://localhost:81/soap-wsdl-test/person.pl') if not $_[2]->{proxy};
    $_[0]->set_class_resolver('MyTypemaps::TestService')
        if not $_[2]->{class_resolver};
}


# operating on @_ for performance
sub ListPerson {
    die "ListPerson must be called as object method (\$self is <$_[0]>)" if not blessed($_[0]);
    # late loading of required classes
    require MyElements::ListPersonResponse;
    return $_[0]->SUPER::call({
        operation => 'ListPerson',
        soap_action => 'http://www.example.org/benchmark/ListPerson',
        style => 'document',
        body => {
           'use' => 'literal',
            namespace => '',
            encodingStyle => '',
            parts => [qw( MyElements::ListPerson )],
        },
        header => {

        },
        headerfault => {

        },
        response => {
            header => {
                parts => [],
            },
            body => {
                parts => [ qw(MyElements::ListPersonResponse) ],
            }
        }
    }, $_[1], $_[2]);
}



1;



__END__

=pod

=head1 NAME


MyInterfaces::TestService::TestPort - SOAP Interface for the TestService Web Service

=head1 SYNOPSIS

 use MyInterfaces::TestService::TestPort;
 my $interface = MyInterfaces::TestService::TestPort->new();

 my $response;
 $response = $interface->ListPerson();



=head1 DESCRIPTION

SOAP Interface for the TestService web service
located at http://localhost:81/soap-wsdl-test/person.pl.

=head1 SERVICE TestService



=head2 Port TestPort



=head1 METHODS

=head2 General methods

=head3 new

Constructor.

All arguments are forwarded to L<SOAP::WSDL::Client|SOAP::WSDL::Client>.

=head2 SOAP Service methods

Method synopsis is displayed with hash refs as parameters.

The commented class names in the method's parameters denote that objects
of the corresponding class can be passed instead of the marked hash ref.

You may pass any combination of objects, hash and list refs to these
methods, as long as you meet the structure.



=head3 ListPerson



 $interface->ListPerson(  {
    in =>     { # MyTypes::Person
      PersonID =>       { # MyTypes::PersonID
        ID =>  $some_value, # int
      },
      Salutation =>  $some_value, # string
      Name =>  $some_value, # string
      GivenName =>  $some_value, # string
      DateOfBirth =>  $some_value, # date
      HomeAddress =>       { # MyTypes::Address
        Street =>  $some_value, # string
        ZIP =>  $some_value, # string
        City =>  $some_value, # string
        Country =>  $some_value, # string
        PhoneNumber => $some_value, # PhoneNumber
        MobilePhoneNumber => $some_value, # PhoneNumber
      },
      WorkAddress =>       { # MyTypes::Address
        Street =>  $some_value, # string
        ZIP =>  $some_value, # string
        City =>  $some_value, # string
        Country =>  $some_value, # string
        PhoneNumber => $some_value, # PhoneNumber
        MobilePhoneNumber => $some_value, # PhoneNumber
      },
      Contracts =>       { # MyTypes::ArrayOfContract
        Contract =>         { # MyTypes::Contract
          ContractID =>  $some_value, # long
          ContractName =>  $some_value, # string
        },
      },
    },
  },,
 );



=head1 AUTHOR

Generated by SOAP::WSDL on Mon Dec  3 22:20:49 2007

=pod